/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.Base64Variants;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParseException;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.privatefasterxml.jackson.core.exc.InputCoercionException;
import com.privatefasterxml.jackson.core.type.TypeReference;
import com.privatefasterxml.jackson.core.util.JacksonFeature;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.core.util.RequestPayload;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class JsonParser
implements Closeable,
Versioned {
    private static final int MIN_BYTE_I = -128;
    private static final int MAX_BYTE_I = 255;
    private static final int MIN_SHORT_I = Short.MIN_VALUE;
    private static final int MAX_SHORT_I = Short.MAX_VALUE;
    protected static final JacksonFeatureSet<StreamReadCapability> DEFAULT_READ_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamReadCapability.values());
    protected int _features;
    protected transient RequestPayload _requestPayload;

    public JsonParser() {
        this._features = JsonFactory.DEFAULT_PARSER_FEATURE_FLAGS;
    }

    public JsonParser(int n2) {
        this._features = n2;
    }

    public abstract ObjectCodec getCodec();

    public abstract void setCodec(ObjectCodec var1);

    public Object getInputSource() {
        return null;
    }

    public void setRequestPayloadOnError(RequestPayload requestPayload) {
        this._requestPayload = requestPayload;
    }

    public void setRequestPayloadOnError(byte[] object, String string) {
        if (object == null) {
            object = null;
        } else {
            RequestPayload requestPayload;
            RequestPayload requestPayload2 = requestPayload;
            requestPayload = new RequestPayload((byte[])object, string);
            object = requestPayload2;
        }
        this._requestPayload = object;
    }

    public void setRequestPayloadOnError(String object) {
        if (object == null) {
            object = null;
        } else {
            RequestPayload requestPayload;
            RequestPayload requestPayload2 = requestPayload;
            requestPayload = new RequestPayload((CharSequence)object);
            object = requestPayload2;
        }
        this._requestPayload = object;
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Parser of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public boolean canParseAsync() {
        return false;
    }

    public NonBlockingInputFeeder getNonBlockingInputFeeder() {
        return null;
    }

    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public abstract Version version();

    @Override
    public abstract void close();

    public abstract boolean isClosed();

    public abstract JsonStreamContext getParsingContext();

    public JsonLocation currentLocation() {
        return this.getCurrentLocation();
    }

    public JsonLocation currentTokenLocation() {
        return this.getTokenLocation();
    }

    public abstract JsonLocation getCurrentLocation();

    public abstract JsonLocation getTokenLocation();

    public Object currentValue() {
        return this.getCurrentValue();
    }

    public void assignCurrentValue(Object object) {
        this.setCurrentValue(object);
    }

    public Object getCurrentValue() {
        return (this = ((JsonParser)this).getParsingContext()) == null ? null : ((JsonStreamContext)this).getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        if ((this = ((JsonParser)this).getParsingContext()) != null) {
            ((JsonStreamContext)this).setCurrentValue(object);
        }
    }

    public int releaseBuffered(OutputStream outputStream) {
        return -1;
    }

    public int releaseBuffered(Writer writer) {
        return -1;
    }

    public JsonParser enable(Feature feature) {
        JsonParser jsonParser = this;
        jsonParser._features |= feature.getMask();
        return jsonParser;
    }

    public JsonParser disable(Feature feature) {
        JsonParser jsonParser = this;
        jsonParser._features &= ~feature.getMask();
        return jsonParser;
    }

    public JsonParser configure(Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public boolean isEnabled(Feature feature) {
        return feature.enabledIn(this._features);
    }

    public boolean isEnabled(StreamReadFeature streamReadFeature) {
        return streamReadFeature.mappedFeature().enabledIn(this._features);
    }

    public int getFeatureMask() {
        return this._features;
    }

    @Deprecated
    public JsonParser setFeatureMask(int n2) {
        this._features = n2;
        return this;
    }

    public JsonParser overrideStdFeatures(int n2, int n3) {
        JsonParser jsonParser = this;
        return jsonParser.setFeatureMask(jsonParser._features & ~n3 | n2 & n3);
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonParser overrideFormatFeatures(int n2, int n3) {
        return this;
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public boolean nextFieldName(SerializableString serializableString) {
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    public String nextFieldName() {
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    public String nextTextValue() {
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int n2) {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            n2 = this.getIntValue();
        }
        return n2;
    }

    public long nextLongValue(long l2) {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            l2 = this.getLongValue();
        }
        return l2;
    }

    public Boolean nextBooleanValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    public abstract JsonParser skipChildren();

    public void finishToken() {
    }

    public JsonToken currentToken() {
        return this.getCurrentToken();
    }

    public int currentTokenId() {
        return this.getCurrentTokenId();
    }

    public abstract JsonToken getCurrentToken();

    @Deprecated
    public abstract int getCurrentTokenId();

    public abstract boolean hasCurrentToken();

    public abstract boolean hasTokenId(int var1);

    public abstract boolean hasToken(JsonToken var1);

    public boolean isExpectedStartArrayToken() {
        return this.currentToken() == JsonToken.START_ARRAY;
    }

    public boolean isExpectedStartObjectToken() {
        return this.currentToken() == JsonToken.START_OBJECT;
    }

    public boolean isExpectedNumberIntToken() {
        return this.currentToken() == JsonToken.VALUE_NUMBER_INT;
    }

    public boolean isNaN() {
        return false;
    }

    public abstract void clearCurrentToken();

    public abstract JsonToken getLastClearedToken();

    public abstract void overrideCurrentName(String var1);

    public abstract String getCurrentName();

    public String currentName() {
        return this.getCurrentName();
    }

    public abstract String getText();

    public int getText(Writer writer) {
        if ((this = ((JsonParser)this).getText()) == null) {
            return 0;
        }
        writer.write((String)this);
        return ((String)this).length();
    }

    public abstract char[] getTextCharacters();

    public abstract int getTextLength();

    public abstract int getTextOffset();

    public abstract boolean hasTextCharacters();

    public abstract Number getNumberValue();

    public Number getNumberValueExact() {
        return this.getNumberValue();
    }

    public abstract NumberType getNumberType();

    public byte getByteValue() {
        int n2 = this.getIntValue();
        if (n2 >= -128 && n2 <= 255) {
            return (byte)n2;
        }
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = this.getText();
        String string = String.format("Numeric value (%s) out of range of Java byte", object);
        object = JsonToken.VALUE_NUMBER_INT;
        Class<Byte> clazz = Byte.TYPE;
        throw new InputCoercionException(this, string, (JsonToken)((Object)object), clazz);
    }

    public short getShortValue() {
        int n2 = this.getIntValue();
        if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
            return (short)n2;
        }
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = this.getText();
        String string = String.format("Numeric value (%s) out of range of Java short", object);
        object = JsonToken.VALUE_NUMBER_INT;
        Class<Short> clazz = Short.TYPE;
        throw new InputCoercionException(this, string, (JsonToken)((Object)object), clazz);
    }

    public abstract int getIntValue();

    public abstract long getLongValue();

    public abstract BigInteger getBigIntegerValue();

    public abstract float getFloatValue();

    public abstract double getDoubleValue();

    public abstract BigDecimal getDecimalValue();

    public boolean getBooleanValue() {
        JsonToken jsonToken = objectArray3.currentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = jsonToken;
        throw new JsonParseException((JsonParser)objectArray, String.format("Current token (%s) not of boolean type", objectArray3)).withRequestPayload(objectArray3._requestPayload);
    }

    public Object getEmbeddedObject() {
        return null;
    }

    public abstract byte[] getBinaryValue(Base64Variant var1);

    public byte[] getBinaryValue() {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public int readBinaryValue(OutputStream outputStream) {
        return this.readBinaryValue(Base64Variants.getDefaultVariant(), outputStream);
    }

    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        this._reportUnsupportedOperation();
        return 0;
    }

    public int getValueAsInt() {
        return this.getValueAsInt(0);
    }

    public int getValueAsInt(int n2) {
        return n2;
    }

    public long getValueAsLong() {
        return this.getValueAsLong(0L);
    }

    public long getValueAsLong(long l2) {
        return l2;
    }

    public double getValueAsDouble() {
        return this.getValueAsDouble(0.0);
    }

    public double getValueAsDouble(double d2) {
        return d2;
    }

    public boolean getValueAsBoolean() {
        return this.getValueAsBoolean(false);
    }

    public boolean getValueAsBoolean(boolean bl) {
        return bl;
    }

    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    public abstract String getValueAsString(String var1);

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public Object getObjectId() {
        return null;
    }

    public Object getTypeId() {
        return null;
    }

    public <T> T readValueAs(Class<T> clazz) {
        return this._codec().readValue(this, clazz);
    }

    public <T> T readValueAs(TypeReference<?> typeReference) {
        return (T)this._codec().readValue(this, typeReference);
    }

    public <T> Iterator<T> readValuesAs(Class<T> clazz) {
        return this._codec().readValues(this, clazz);
    }

    public <T> Iterator<T> readValuesAs(TypeReference<T> typeReference) {
        return this._codec().readValues(this, typeReference);
    }

    public <T extends TreeNode> T readValueAsTree() {
        return this._codec().readTree(this);
    }

    public ObjectCodec _codec() {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec != null) {
            return objectCodec;
        }
        throw new IllegalStateException("No ObjectCodec defined for parser, needed for deserialization");
    }

    public JsonParseException _constructError(String string) {
        return new JsonParseException(this, string).withRequestPayload(this._requestPayload);
    }

    public void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by parser of type ".concat(this.getClass().getName()));
    }

    public JsonParseException _constructReadException(String string) {
        return this._constructError(string);
    }

    public JsonParseException _constructReadException(String string, Object object) {
        return this._constructReadException(String.format(string, object));
    }

    public JsonParseException _constructReadException(String string, Object object, Object object2) {
        return this._constructReadException(String.format(string, object, object2));
    }

    public JsonParseException _constructReadException(String string, Object object, Object object2, Object object3) {
        return this._constructReadException(String.format(string, object, object2, object3));
    }

    public JsonParseException _constructReadException(String string, Throwable throwable) {
        JsonParseException jsonParseException;
        JsonParseException jsonParseException2 = jsonParseException;
        jsonParseException = new JsonParseException((JsonParser)((Object)requestPayload), string, throwable);
        RequestPayload requestPayload = ((JsonParser)((Object)requestPayload))._requestPayload;
        if (requestPayload != null) {
            jsonParseException2 = jsonParseException2.withRequestPayload(requestPayload);
        }
        return jsonParseException2;
    }

    public static enum Feature {
        AUTO_CLOSE_SOURCE(true),
        ALLOW_COMMENTS(false),
        ALLOW_YAML_COMMENTS(false),
        ALLOW_UNQUOTED_FIELD_NAMES(false),
        ALLOW_SINGLE_QUOTES(false),
        ALLOW_UNQUOTED_CONTROL_CHARS(false),
        ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER(false),
        ALLOW_NUMERIC_LEADING_ZEROS(false),
        ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS(false),
        ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS(false),
        ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS(false),
        ALLOW_NON_NUMERIC_NUMBERS(false),
        ALLOW_MISSING_VALUES(false),
        ALLOW_TRAILING_COMMA(false),
        STRICT_DUPLICATE_DETECTION(false),
        IGNORE_UNDEFINED(false),
        INCLUDE_SOURCE_IN_LOCATION(true),
        USE_FAST_DOUBLE_PARSER(false);

        private final boolean _defaultState;
        private final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl) {
            Feature feature = this;
            feature._mask = 1 << feature.ordinal();
            this._defaultState = bl;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int n2) {
            return (n2 & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }

    public static enum NumberType {
        INT,
        LONG,
        BIG_INTEGER,
        FLOAT,
        DOUBLE,
        BIG_DECIMAL;

    }
}

