/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.b;
import com.privatefasterxml.jackson.core.c;
import com.privatefasterxml.jackson.core.d;
import com.privatefasterxml.jackson.core.io.NumberInput;
import java.io.Serializable;

public class JsonPointer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR = '/';
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final int _asStringOffset;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;
    protected int _hashCode;

    public JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = null;
        this._matchingElementIndex = -1;
        this._asString = "";
        this._asStringOffset = 0;
    }

    public JsonPointer(String string, int n2, String string2, JsonPointer jsonPointer) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = JsonPointer._parseIndex(string2);
    }

    public JsonPointer(String string, int n2, String string2, int n3, JsonPointer jsonPointer) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = n3;
    }

    public static JsonPointer compile(String string) {
        if (string != null && string.length() != 0) {
            if (string.charAt(0) == '/') {
                return JsonPointer._parseTail(string);
            }
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string + "\"");
        }
        return EMPTY;
    }

    public static JsonPointer valueOf(String string) {
        return JsonPointer.compile(string);
    }

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer forPath(JsonStreamContext object, boolean bl) {
        StringBuilder stringBuilder;
        if (object == null) {
            return EMPTY;
        }
        if (!(((JsonStreamContext)object).hasPathSegment() || bl && ((JsonStreamContext)object).inRoot() && ((JsonStreamContext)object).hasCurrentIndex())) {
            object = ((JsonStreamContext)object).getParent();
        }
        Object object2 = null;
        int n2 = 0;
        while (object != null) {
            c c2;
            if (((JsonStreamContext)object).inObject()) {
                c c3;
                String string = ((JsonStreamContext)object).getCurrentName();
                if (string == null) {
                    string = "";
                }
                n2 = string.length() + 2 + n2;
                c2 = c3;
                c3 = new c((c)object2, string, -1);
                object2 = c2;
            } else if (((JsonStreamContext)object).inArray() || bl) {
                c c4;
                int n3 = ((JsonStreamContext)object).getCurrentIndex();
                n2 += 6;
                c2 = c4;
                c4 = new c((c)object2, null, n3);
                object2 = c2;
            }
            object = ((JsonStreamContext)object).getParent();
        }
        if (object2 == null) {
            return EMPTY;
        }
        object = stringBuilder;
        stringBuilder = new StringBuilder(n2);
        Object object3 = null;
        c c5 = object2;
        object2 = object3;
        object3 = c5;
        while (object3 != null) {
            ((c)object3).d = ((StringBuilder)object).length();
            ((StringBuilder)object).append('/');
            object2 = ((c)object3).b;
            if (object2 != null) {
                JsonPointer._appendEscaped((StringBuilder)object, (String)object2);
            } else {
                ((StringBuilder)object).append(((c)object3).c);
            }
            Object object4 = object2 = ((c)object3).a;
            object2 = object3;
            object3 = object4;
        }
        object = ((StringBuilder)object).toString();
        object3 = EMPTY;
        while (object2 != null) {
            JsonPointer jsonPointer;
            String string = ((c)object2).b;
            if (string != null) {
                JsonPointer jsonPointer2;
                jsonPointer = jsonPointer2;
                jsonPointer2 = new JsonPointer((String)object, ((c)object2).d, string, (JsonPointer)object3);
                object3 = jsonPointer;
            } else {
                JsonPointer jsonPointer3;
                int n4 = ((c)object2).c;
                jsonPointer = jsonPointer3;
                int n5 = ((c)object2).d;
                String string2 = String.valueOf(n4);
                jsonPointer3 = new JsonPointer((String)object, n5, string2, n4, (JsonPointer)object3);
                object3 = jsonPointer;
            }
            object2 = ((c)object2).e;
        }
        return object3;
    }

    private static void _appendEscaped(StringBuilder stringBuilder, String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/') {
                stringBuilder.append("~1");
                continue;
            }
            if (c2 == '~') {
                stringBuilder.append("~0");
                continue;
            }
            stringBuilder.append(c2);
        }
    }

    private final boolean _compare(String string, int n2, String string2, int n3) {
        int n4 = string.length();
        if (n4 - n2 != string2.length() - n3) {
            return false;
        }
        while (n2 < n4) {
            if (string.charAt(n2++) == string2.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    private static final int _parseIndex(String string) {
        int n2 = string.length();
        if (n2 != 0 && n2 <= 10) {
            int n3 = string.charAt(0);
            if (n3 <= 48) {
                return n2 == 1 && n3 == 48 ? 0 : -1;
            }
            if (n3 > 57) {
                return -1;
            }
            for (n3 = 1; n3 < n2; ++n3) {
                char c2 = string.charAt(n3);
                if (c2 <= '9' && c2 >= '0') {
                    continue;
                }
                return -1;
            }
            if (n2 == 10 && NumberInput.parseLong(string) > Integer.MAX_VALUE) {
                return -1;
            }
            return NumberInput.parseInt(string);
        }
        return -1;
    }

    public static JsonPointer _parseTail(String string) {
        b b2 = null;
        int n2 = 1;
        int n3 = string.length();
        int n4 = 0;
        int n5 = n2;
        n2 = n4;
        n4 = n5;
        while (n4 < n3) {
            b b3;
            StringBuilder stringBuilder;
            char c2 = string.charAt(n4);
            if (c2 == '/') {
                b b4;
                b b5 = b4;
                b4 = new b(b2, n2, string.substring(n2 + 1, n4));
                int n6 = n2 = n4 + 1;
                b2 = b5;
                n2 = n4;
                n4 = n6;
                continue;
            }
            if (c2 != '~' || ++n4 >= n3) continue;
            CharSequence charSequence = stringBuilder;
            stringBuilder = new StringBuilder(32);
            n4 = JsonPointer._extractEscapedSegment(string, n2 + 1, n4, charSequence);
            charSequence = charSequence.toString();
            if (n4 < 0) {
                return JsonPointer._buildPath(string, n2, (String)charSequence, b2);
            }
            b b6 = b3;
            b3 = new b(b2, n2, (String)charSequence);
            int n7 = n2 = n4 + 1;
            b2 = b6;
            n2 = n4;
            n4 = n7;
        }
        return JsonPointer._buildPath(string, n2, string.substring(n2 + 1), b2);
    }

    private static JsonPointer _buildPath(String string, int n2, String string2, b object) {
        JsonPointer jsonPointer;
        JsonPointer jsonPointer2 = jsonPointer;
        JsonPointer jsonPointer3 = EMPTY;
        jsonPointer = new JsonPointer(string, n2, string2, jsonPointer3);
        while (object != null) {
            JsonPointer jsonPointer4;
            b b2 = object;
            JsonPointer jsonPointer5 = jsonPointer4;
            b b3 = object;
            int n3 = b3.b;
            object = b3.c;
            jsonPointer4 = new JsonPointer(string, n3, (String)object, jsonPointer2);
            object = b2.a;
            jsonPointer2 = jsonPointer5;
        }
        return jsonPointer2;
    }

    public static int _extractEscapedSegment(String string, int n2, int n3, StringBuilder stringBuilder) {
        int n4 = string.length();
        int n5 = n3 - 1;
        if (n5 - n2 > 0) {
            stringBuilder.append(string, n2, n5);
        }
        int n6 = n3;
        n2 = n6 + 1;
        JsonPointer._appendEscape(stringBuilder, string.charAt(n6));
        while (n2 < n4) {
            char c2 = string.charAt(n2);
            n3 = c2;
            if (c2 == '/') {
                return n2;
            }
            n5 = n2 + 1;
            if (n3 == 126 && n5 < n4) {
                n2 += 2;
                JsonPointer._appendEscape(stringBuilder, string.charAt(n5));
                continue;
            }
            stringBuilder.append((char)n3);
            n2 = n5;
        }
        return -1;
    }

    private static void _appendEscape(StringBuilder stringBuilder, char c2) {
        if (c2 == '0') {
            c2 = (char)126;
        } else if (c2 == '1') {
            c2 = (char)47;
        } else {
            stringBuilder.append('~');
        }
        stringBuilder.append(c2);
    }

    private Object writeReplace() {
        return new d(this.toString());
    }

    public int length() {
        return this._asString.length() - this._asStringOffset;
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer jsonPointer;
        if (jsonPointer2 == EMPTY) {
            return null;
        }
        while ((jsonPointer = jsonPointer2._nextSegment) != EMPTY) {
            JsonPointer jsonPointer2 = jsonPointer;
        }
        return jsonPointer2;
    }

    public JsonPointer append(JsonPointer jsonPointer) {
        JsonPointer jsonPointer2 = EMPTY;
        if (object == jsonPointer2) {
            return jsonPointer;
        }
        if (jsonPointer == jsonPointer2) {
            return object;
        }
        Object object = ((JsonPointer)object)._asString;
        if (((String)object).endsWith("/")) {
            Object object2 = object;
            object = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        return JsonPointer.compile((String)object + jsonPointer._asString);
    }

    public JsonPointer appendProperty(String string) {
        if (string != null && !string.isEmpty()) {
            if (string.charAt(0) != '/') {
                string = "/".concat(string);
            }
            if (((String)(object2 = ((JsonPointer)object2)._asString)).endsWith("/")) {
                Object object = object2;
                Object object2 = ((String)object).substring(0, ((String)object).length() - 1);
            }
            return JsonPointer.compile((String)object2 + string);
        }
        return object2;
    }

    public JsonPointer appendIndex(int n2) {
        if (n2 >= 0) {
            Object object = ((JsonPointer)object)._asString;
            if (((String)object).endsWith("/")) {
                Object object2 = object;
                object = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            return JsonPointer.compile((String)object + '/' + n2);
        }
        throw new IllegalArgumentException("Negative index cannot be appended");
    }

    public boolean matchesProperty(String string) {
        return this._nextSegment != null && this._matchingPropertyName.equals(string);
    }

    public JsonPointer matchProperty(String string) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(string)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int n2) {
        return n2 == this._matchingElementIndex && n2 >= 0;
    }

    public JsonPointer matchElement(int n2) {
        if (n2 == this._matchingElementIndex && n2 >= 0) {
            return this._nextSegment;
        }
        return null;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer jsonPointer = this._head;
        if (jsonPointer == null) {
            if (this != EMPTY) {
                jsonPointer = this._constructHead();
            }
            this._head = jsonPointer;
        }
        return jsonPointer;
    }

    public String toString() {
        int n2 = this._asStringOffset;
        if (n2 <= 0) {
            return this._asString;
        }
        return this._asString.substring(n2);
    }

    public int hashCode() {
        int n2 = this._hashCode;
        if (n2 == 0) {
            n2 = this.toString().hashCode();
            if (n2 == 0) {
                n2 = -1;
            }
            this._hashCode = n2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == string) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        JsonPointer jsonPointer = string;
        JsonPointer jsonPointer2 = (JsonPointer)object;
        JsonPointer jsonPointer3 = string;
        String string = jsonPointer3._asString;
        int n2 = jsonPointer3._asStringOffset;
        String string2 = jsonPointer2._asString;
        int n3 = jsonPointer2._asStringOffset;
        return jsonPointer._compare(string, n2, string2, n3);
    }

    public JsonPointer _constructHead() {
        JsonPointer jsonPointer = ((JsonPointer)((Object)string3)).last();
        if (jsonPointer == string3) {
            return EMPTY;
        }
        JsonPointer jsonPointer2 = string3;
        int n2 = jsonPointer.length();
        JsonPointer jsonPointer3 = jsonPointer2._nextSegment;
        String string = jsonPointer2.toString();
        JsonPointer jsonPointer4 = string3;
        String string2 = string;
        String string3 = string2.substring(0, string2.length() - n2);
        String string4 = jsonPointer4._matchingPropertyName;
        int n3 = jsonPointer4._matchingElementIndex;
        jsonPointer = jsonPointer3._constructHead(n2, jsonPointer);
        return new JsonPointer(string3, 0, string4, n3, jsonPointer);
    }

    public JsonPointer _constructHead(int n2, JsonPointer jsonPointer) {
        if (string3 == jsonPointer) {
            return EMPTY;
        }
        JsonPointer jsonPointer2 = string3;
        JsonPointer jsonPointer3 = jsonPointer2._nextSegment;
        String string = jsonPointer2.toString();
        JsonPointer jsonPointer4 = string3;
        String string2 = string;
        String string3 = string2.substring(0, string2.length() - n2);
        String string4 = jsonPointer4._matchingPropertyName;
        int n3 = jsonPointer4._matchingElementIndex;
        jsonPointer = jsonPointer3._constructHead(n2, jsonPointer);
        return new JsonPointer(string3, 0, string4, n3, jsonPointer);
    }
}

