/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonPointer;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.ContentReference;

public abstract class JsonStreamContext {
    public static final int TYPE_ROOT = 0;
    public static final int TYPE_ARRAY = 1;
    public static final int TYPE_OBJECT = 2;
    protected int _type;
    protected int _index;

    public JsonStreamContext() {
    }

    public JsonStreamContext(JsonStreamContext jsonStreamContext) {
        this._type = jsonStreamContext._type;
        this._index = jsonStreamContext._index;
    }

    public JsonStreamContext(int n2, int n3) {
        this._type = n2;
        this._index = n3;
    }

    public abstract JsonStreamContext getParent();

    public final boolean inArray() {
        return this._type == 1;
    }

    public final boolean inRoot() {
        return this._type == 0;
    }

    public final boolean inObject() {
        return this._type == 2;
    }

    @Deprecated
    public final String getTypeDesc() {
        int n2 = this._type;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return "?";
                }
                return "OBJECT";
            }
            return "ARRAY";
        }
        return "ROOT";
    }

    public String typeDesc() {
        int n2 = this._type;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return "?";
                }
                return "Object";
            }
            return "Array";
        }
        return "root";
    }

    public final int getEntryCount() {
        return this._index + 1;
    }

    public final int getCurrentIndex() {
        int n2 = this._index;
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public boolean hasCurrentIndex() {
        return this._index >= 0;
    }

    public boolean hasPathSegment() {
        int n2 = this._type;
        if (n2 == 2) {
            return this.hasCurrentName();
        }
        if (n2 == 1) {
            return this.hasCurrentIndex();
        }
        return false;
    }

    public abstract String getCurrentName();

    public boolean hasCurrentName() {
        return this.getCurrentName() != null;
    }

    public Object getCurrentValue() {
        return null;
    }

    public void setCurrentValue(Object object) {
    }

    public JsonPointer pathAsPointer() {
        return JsonPointer.forPath(this, false);
    }

    public JsonPointer pathAsPointer(boolean bl) {
        return JsonPointer.forPath(this, bl);
    }

    public JsonLocation startLocation(ContentReference contentReference) {
        return JsonLocation.NA;
    }

    @Deprecated
    public JsonLocation getStartLocation(Object object) {
        return JsonLocation.NA;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(64);
        int n2 = ((JsonStreamContext)((Object)string))._type;
        if (n2 != 0) {
            if (n2 != 1) {
                stringBuilder2.append('{');
                String string = ((JsonStreamContext)((Object)string)).getCurrentName();
                if (string != null) {
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder3.append('\"');
                    CharTypes.appendQuoted(stringBuilder3, string);
                    stringBuilder3.append('\"');
                } else {
                    stringBuilder2.append('?');
                }
                stringBuilder2.append('}');
            } else {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder2.append('[');
                stringBuilder4.append(((JsonStreamContext)((Object)string)).getCurrentIndex());
                stringBuilder4.append(']');
            }
        } else {
            stringBuilder2.append("/");
        }
        return stringBuilder2.toString();
    }
}

