/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.StreamReadFeature;
import com.privatefasterxml.jackson.core.StreamWriteFeature;
import com.privatefasterxml.jackson.core.io.InputDecorator;
import com.privatefasterxml.jackson.core.io.OutputDecorator;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.core.json.JsonWriteFeature;

public abstract class TSFBuilder<F extends JsonFactory, B extends TSFBuilder<F, B>> {
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory.Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    protected int _factoryFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;

    public TSFBuilder() {
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._streamReadFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._streamWriteFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._inputDecorator = null;
        this._outputDecorator = null;
    }

    public TSFBuilder(JsonFactory jsonFactory) {
        JsonFactory jsonFactory2 = jsonFactory;
        int n2 = jsonFactory2._factoryFeatures;
        int n3 = jsonFactory2._parserFeatures;
        int n4 = jsonFactory2._generatorFeatures;
        this(n2, n3, n4);
    }

    public TSFBuilder(int n2, int n3, int n4) {
        this._factoryFeatures = n2;
        this._streamReadFeatures = n3;
        this._streamWriteFeatures = n4;
    }

    private B _failNonJSON(Object object) {
        throw new IllegalArgumentException("Feature " + object.getClass().getName() + "#" + object.toString() + " not supported for non-JSON backend");
    }

    public int factoryFeaturesMask() {
        return this._factoryFeatures;
    }

    public int streamReadFeatures() {
        return this._streamReadFeatures;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public InputDecorator inputDecorator() {
        return this._inputDecorator;
    }

    public OutputDecorator outputDecorator() {
        return this._outputDecorator;
    }

    public B enable(JsonFactory.Feature feature) {
        TSFBuilder tSFBuilder = this;
        tSFBuilder._factoryFeatures |= feature.getMask();
        return tSFBuilder._this();
    }

    public B disable(JsonFactory.Feature feature) {
        TSFBuilder tSFBuilder = this;
        tSFBuilder._factoryFeatures &= ~feature.getMask();
        return tSFBuilder._this();
    }

    public B configure(JsonFactory.Feature feature, boolean bl) {
        return bl ? this.enable(feature) : this.disable(feature);
    }

    public B enable(StreamReadFeature streamReadFeature) {
        TSFBuilder tSFBuilder = this;
        tSFBuilder._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        return tSFBuilder._this();
    }

    public B enable(StreamReadFeature streamReadFeature, StreamReadFeature ... streamReadFeatureArray) {
        this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        for (StreamReadFeature streamReadFeature2 : streamReadFeatureArray) {
            this._streamReadFeatures |= streamReadFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeature) {
        TSFBuilder tSFBuilder = this;
        tSFBuilder._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        return tSFBuilder._this();
    }

    public B disable(StreamReadFeature streamReadFeature, StreamReadFeature ... streamReadFeatureArray) {
        this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        for (StreamReadFeature streamReadFeature2 : streamReadFeatureArray) {
            this._streamReadFeatures &= ~streamReadFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature streamReadFeature, boolean bl) {
        return bl ? this.enable(streamReadFeature) : this.disable(streamReadFeature);
    }

    public B enable(StreamWriteFeature streamWriteFeature) {
        TSFBuilder tSFBuilder = this;
        tSFBuilder._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        return tSFBuilder._this();
    }

    public B enable(StreamWriteFeature streamWriteFeature, StreamWriteFeature ... streamWriteFeatureArray) {
        this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        for (StreamWriteFeature streamWriteFeature2 : streamWriteFeatureArray) {
            this._streamWriteFeatures |= streamWriteFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature) {
        TSFBuilder tSFBuilder = this;
        tSFBuilder._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        return tSFBuilder._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature, StreamWriteFeature ... streamWriteFeatureArray) {
        this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        for (StreamWriteFeature streamWriteFeature2 : streamWriteFeatureArray) {
            this._streamWriteFeatures &= ~streamWriteFeature2.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature streamWriteFeature, boolean bl) {
        return bl ? this.enable(streamWriteFeature) : this.disable(streamWriteFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B configure(JsonReadFeature jsonReadFeature, boolean bl) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B enable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B enable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B configure(JsonWriteFeature jsonWriteFeature, boolean bl) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B inputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this._this();
    }

    public B outputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this._this();
    }

    public abstract F build();

    public final B _this() {
        return (B)this;
    }

    public void _legacyEnable(JsonParser.Feature feature) {
        if (feature != null) {
            this._streamReadFeatures |= feature.getMask();
        }
    }

    public void _legacyDisable(JsonParser.Feature feature) {
        if (feature != null) {
            this._streamReadFeatures &= ~feature.getMask();
        }
    }

    public void _legacyEnable(JsonGenerator.Feature feature) {
        if (feature != null) {
            this._streamWriteFeatures |= feature.getMask();
        }
    }

    public void _legacyDisable(JsonGenerator.Feature feature) {
        if (feature != null) {
            this._streamWriteFeatures &= ~feature.getMask();
        }
    }
}

