/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonEncoding;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.Versioned;
import com.privatefasterxml.jackson.core.io.DataOutputAsStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;

public abstract class TokenStreamFactory
implements Versioned,
Serializable {
    private static final long serialVersionUID = 2L;

    public abstract boolean requiresPropertyOrdering();

    public abstract boolean canHandleBinaryNatively();

    public abstract boolean canParseAsync();

    public abstract Class<? extends FormatFeature> getFormatReadFeatureType();

    public abstract Class<? extends FormatFeature> getFormatWriteFeatureType();

    public abstract boolean canUseSchema(FormatSchema var1);

    public abstract String getFormatName();

    public abstract boolean isEnabled(JsonParser.Feature var1);

    public abstract boolean isEnabled(JsonGenerator.Feature var1);

    public abstract int getParserFeatures();

    public abstract int getGeneratorFeatures();

    public abstract int getFormatParserFeatures();

    public abstract int getFormatGeneratorFeatures();

    public abstract JsonParser createParser(byte[] var1);

    public abstract JsonParser createParser(byte[] var1, int var2, int var3);

    public abstract JsonParser createParser(char[] var1);

    public abstract JsonParser createParser(char[] var1, int var2, int var3);

    public abstract JsonParser createParser(DataInput var1);

    public abstract JsonParser createParser(File var1);

    public abstract JsonParser createParser(InputStream var1);

    public abstract JsonParser createParser(Reader var1);

    public abstract JsonParser createParser(String var1);

    public abstract JsonParser createParser(URL var1);

    public abstract JsonParser createNonBlockingByteArrayParser();

    public abstract JsonParser createNonBlockingByteBufferParser();

    public abstract JsonGenerator createGenerator(DataOutput var1, JsonEncoding var2);

    public abstract JsonGenerator createGenerator(DataOutput var1);

    public abstract JsonGenerator createGenerator(File var1, JsonEncoding var2);

    public abstract JsonGenerator createGenerator(OutputStream var1);

    public abstract JsonGenerator createGenerator(OutputStream var1, JsonEncoding var2);

    public abstract JsonGenerator createGenerator(Writer var1);

    public OutputStream _createDataOutputWrapper(DataOutput dataOutput) {
        return new DataOutputAsStream(dataOutput);
    }

    public InputStream _optimizedStreamFromURL(URL uRL) {
        if ("file".equals(uRL.getProtocol()) && ((this = uRL.getHost()) == null || ((String)this).length() == 0) && uRL.getPath().indexOf(37) < 0) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }

    public InputStream _fileInputStream(File file) {
        return new FileInputStream(file);
    }

    public OutputStream _fileOutputStream(File file) {
        return new FileOutputStream(file);
    }

    public void _checkRangeBoundsForByteArray(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (byArray == null) {
            objectArray3._reportRangeError("Invalid `byte[]` argument: `null`");
        }
        if ((n2 | n3 | (n5 = n2 + n3) | (n4 = byArray.length) - n5) < 0) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n2;
            objectArray3[1] = n3;
            objectArray2[2] = n4;
            objectArray._reportRangeError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `byte[]` of length %d", objectArray3));
        }
    }

    public void _checkRangeBoundsForCharArray(char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        if (cArray == null) {
            objectArray3._reportRangeError("Invalid `char[]` argument: `null`");
        }
        if ((n2 | n3 | (n5 = n2 + n3) | (n4 = cArray.length) - n5) < 0) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n2;
            objectArray3[1] = n3;
            objectArray2[2] = n4;
            objectArray._reportRangeError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `char[]` of length %d", objectArray3));
        }
    }

    public <T> T _reportRangeError(String string) {
        throw new IllegalArgumentException(string);
    }
}

