/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Version UNKNOWN_VERSION = new Version(0, 0, 0, null, null, null);
    protected final int _majorVersion;
    protected final int _minorVersion;
    protected final int _patchLevel;
    protected final String _groupId;
    protected final String _artifactId;
    protected final String _snapshotInfo;

    @Deprecated
    public Version(int n2, int n3, int n4, String string) {
        this(n2, n3, n4, string, null, null);
    }

    public Version(int n2, int n3, int n4, String string, String string2, String string3) {
        this._majorVersion = n2;
        this._minorVersion = n3;
        this._patchLevel = n4;
        this._snapshotInfo = string;
        if (string2 == null) {
            string2 = "";
        }
        this._groupId = string2;
        if (string3 == null) {
            string3 = "";
        }
        this._artifactId = string3;
    }

    public static Version unknownVersion() {
        return UNKNOWN_VERSION;
    }

    public boolean isUnknownVersion() {
        return this == UNKNOWN_VERSION;
    }

    public boolean isSnapshot() {
        String string = ((Version)((Object)string))._snapshotInfo;
        return string != null && string.length() > 0;
    }

    @Deprecated
    public boolean isUknownVersion() {
        return this.isUnknownVersion();
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getPatchLevel() {
        return this._patchLevel;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public String getArtifactId() {
        return this._artifactId;
    }

    public String toFullString() {
        return this._groupId + '/' + this._artifactId + '/' + this.toString();
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder2.append(this._majorVersion).append('.');
        stringBuilder2.append(this._minorVersion).append('.');
        stringBuilder.append(this._patchLevel);
        if (this.isSnapshot()) {
            stringBuilder2.append('-').append(this._snapshotInfo);
        }
        return stringBuilder2.toString();
    }

    public int hashCode() {
        return this._artifactId.hashCode() ^ this._groupId.hashCode() + this._majorVersion - this._minorVersion + this._patchLevel;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (Version)object;
        return ((Version)object)._majorVersion == this._majorVersion && ((Version)object)._minorVersion == this._minorVersion && ((Version)object)._patchLevel == this._patchLevel && ((Version)object)._artifactId.equals(this._artifactId) && ((Version)object)._groupId.equals(this._groupId);
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n2 = this._groupId.compareTo(version._groupId);
        if (n2 == 0 && (n2 = this._artifactId.compareTo(version._artifactId)) == 0 && (n2 = this._majorVersion - version._majorVersion) == 0 && (n2 = this._minorVersion - version._minorVersion) == 0) {
            n2 = this._patchLevel - version._patchLevel;
        }
        return n2;
    }
}

