/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.base;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.TreeNode;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.json.DupDetector;
import com.privatefasterxml.jackson.core.json.JsonWriteContext;
import com.privatefasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.InputStream;
import java.math.BigDecimal;

public abstract class GeneratorBase
extends JsonGenerator {
    public static final int SURR1_FIRST = 55296;
    public static final int SURR1_LAST = 56319;
    public static final int SURR2_FIRST = 56320;
    public static final int SURR2_LAST = 57343;
    protected static final int DERIVED_FEATURES_MASK = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.getMask() | JsonGenerator.Feature.ESCAPE_NON_ASCII.getMask() | JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.getMask();
    protected static final String WRITE_BINARY = "write a binary value";
    protected static final String WRITE_BOOLEAN = "write a boolean value";
    protected static final String WRITE_NULL = "write a null";
    protected static final String WRITE_NUMBER = "write a number";
    protected static final String WRITE_RAW = "write a raw (unencoded) value";
    protected static final String WRITE_STRING = "write a string";
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected ObjectCodec _objectCodec;
    protected int _features;
    protected boolean _cfgNumbersAsStrings;
    protected JsonWriteContext _writeContext;
    protected boolean _closed;

    public GeneratorBase(int n2, ObjectCodec object) {
        this._features = n2;
        this._objectCodec = object;
        object = JsonWriteContext.createRootContext(JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? DupDetector.rootDetector(this) : null);
        GeneratorBase generatorBase = this;
        generatorBase._writeContext = object;
        generatorBase._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n2);
    }

    public GeneratorBase(int n2, ObjectCodec objectCodec, JsonWriteContext jsonWriteContext) {
        GeneratorBase generatorBase = this;
        this._features = n2;
        this._objectCodec = objectCodec;
        generatorBase._writeContext = jsonWriteContext;
        generatorBase._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n2);
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    @Override
    public Object getCurrentValue() {
        return this._writeContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        JsonWriteContext jsonWriteContext = ((GeneratorBase)((Object)jsonWriteContext))._writeContext;
        if (jsonWriteContext != null) {
            jsonWriteContext.setCurrentValue(object);
        }
    }

    @Override
    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._features & feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._features;
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        int n2 = feature.getMask();
        this._features |= n2;
        if ((n2 & DERIVED_FEATURES_MASK) != 0) {
            if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
                this._cfgNumbersAsStrings = true;
            } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
                this.setHighestNonEscapedChar(127);
            } else if (feature == JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION && this._writeContext.getDupDetector() == null) {
                this._writeContext = this._writeContext.withDupDetector(DupDetector.rootDetector(this));
            }
        }
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        int n2 = feature.getMask();
        this._features &= ~n2;
        if ((n2 & DERIVED_FEATURES_MASK) != 0) {
            if (feature == JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS) {
                this._cfgNumbersAsStrings = false;
            } else if (feature == JsonGenerator.Feature.ESCAPE_NON_ASCII) {
                this.setHighestNonEscapedChar(0);
            } else if (feature == JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION) {
                this._writeContext = this._writeContext.withDupDetector(null);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n2) {
        int n3 = n2 ^ this._features;
        this._features = n2;
        if (n3 != 0) {
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        if ((n3 = n4 ^ (n2 = n4 & ~n3 | n2 & n3)) != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    public void _checkStdFeatureChanges(int n2, int n3) {
        if ((n3 & DERIVED_FEATURES_MASK) == 0) {
            return;
        }
        this._cfgNumbersAsStrings = JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS.enabledIn(n2);
        JsonGenerator.Feature feature = JsonGenerator.Feature.ESCAPE_NON_ASCII;
        if (feature.enabledIn(n3)) {
            if (feature.enabledIn(n2)) {
                this.setHighestNonEscapedChar(127);
            } else {
                this.setHighestNonEscapedChar(0);
            }
        }
        if ((feature = JsonGenerator.Feature.STRICT_DUPLICATE_DETECTION).enabledIn(n3)) {
            if (feature.enabledIn(n2)) {
                if (this._writeContext.getDupDetector() == null) {
                    this._writeContext = this._writeContext.withDupDetector(DupDetector.rootDetector(this));
                }
            } else {
                this._writeContext = this._writeContext.withDupDetector(null);
            }
        }
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        if (this.getPrettyPrinter() != null) {
            return this;
        }
        GeneratorBase generatorBase = this;
        return generatorBase.setPrettyPrinter(generatorBase._constructDefaultPrettyPrinter());
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public void writeStartObject(Object object) {
        this.writeStartObject();
        if (object != null) {
            this.setCurrentValue(object);
        }
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this.writeFieldName(serializableString.getValue());
    }

    @Override
    public void writeString(SerializableString serializableString) {
        this.writeString(serializableString.getValue());
    }

    @Override
    public void writeRawValue(String string) {
        GeneratorBase generatorBase = this;
        generatorBase._verifyValueWrite("write raw value");
        generatorBase.writeRaw(string);
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        GeneratorBase generatorBase = this;
        generatorBase._verifyValueWrite("write raw value");
        generatorBase.writeRaw(string, n2, n3);
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        GeneratorBase generatorBase = this;
        generatorBase._verifyValueWrite("write raw value");
        generatorBase.writeRaw(cArray, n2, n3);
    }

    @Override
    public void writeRawValue(SerializableString serializableString) {
        GeneratorBase generatorBase = this;
        generatorBase._verifyValueWrite("write raw value");
        generatorBase.writeRaw(serializableString);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        this._reportUnsupportedOperation();
        return 0;
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
        } else {
            ObjectCodec objectCodec = this._objectCodec;
            if (objectCodec != null) {
                objectCodec.writeValue(this, object);
                return;
            }
            this._writeSimpleObject(object);
        }
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        block4: {
            block3: {
                block2: {
                    if (treeNode != null) break block2;
                    this.writeNull();
                    break block3;
                }
                ObjectCodec objectCodec = this._objectCodec;
                if (objectCodec == null) break block4;
                objectCodec.writeValue(this, treeNode);
            }
            return;
        }
        throw new IllegalStateException("No ObjectCodec defined");
    }

    @Override
    public abstract void flush();

    @Override
    public void close() {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    public abstract void _releaseBuffers();

    public abstract void _verifyValueWrite(String var1);

    public PrettyPrinter _constructDefaultPrettyPrinter() {
        return new DefaultPrettyPrinter();
    }

    public String _asString(BigDecimal bigDecimal) {
        if (JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(objectArray3._features)) {
            int n2 = bigDecimal.scale();
            if (n2 < -9999 || n2 > 9999) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[3];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = n2;
                objectArray2[1] = 9999;
                objectArray2[2] = 9999;
                objectArray._reportError(String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", objectArray3));
            }
            return bigDecimal.toPlainString();
        }
        return bigDecimal.toString();
    }

    public final int _decodeSurrogate(int n2, int n3) {
        if (n3 < 56320 || n3 > 57343) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n2;
            objectArray2[1] = n3;
            objectArray._reportError(String.format("Incomplete surrogate pair: first char 0x%04X, second 0x%04X", objectArray3));
        }
        int n4 = (n2 - 55296 << 10) + 65536;
        return n3 - 56320 + n4;
    }

    public void _checkRangeBoundsForByteArray(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (byArray == null) {
            objectArray3._reportError("Invalid `byte[]` argument: `null`");
        }
        if ((n2 | n3 | (n5 = n2 + n3) | (n4 = byArray.length) - n5) < 0) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n2;
            objectArray3[1] = n3;
            objectArray2[2] = n4;
            objectArray._reportError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `byte[]` of length %d", objectArray3));
        }
    }

    public void _checkRangeBoundsForCharArray(char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        if (cArray == null) {
            objectArray3._reportError("Invalid `char[]` argument: `null`");
        }
        if ((n2 | n3 | (n5 = n2 + n3) | (n4 = cArray.length) - n5) < 0) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n2;
            objectArray3[1] = n3;
            objectArray2[2] = n4;
            objectArray._reportError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `char[]` of length %d", objectArray3));
        }
    }

    public void _checkRangeBoundsForString(String string, int n2, int n3) {
        int n4;
        int n5;
        if (string == null) {
            objectArray3._reportError("Invalid `String` argument: `null`");
        }
        if ((n2 | n3 | (n5 = n2 + n3) | (n4 = string.length()) - n5) < 0) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = n2;
            objectArray3[1] = n3;
            objectArray2[2] = n4;
            objectArray._reportError(String.format("Invalid 'offset' (%d) and/or 'len' (%d) arguments for `String` of length %d", objectArray3));
        }
    }
}

