/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.base;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.core.json.DupDetector;
import com.privatefasterxml.jackson.core.json.JsonReadContext;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class ParserBase
extends ParserMinimalBase {
    protected static final JacksonFeatureSet<StreamReadCapability> JSON_READ_CAPABILITIES = JsonParser.DEFAULT_READ_CAPABILITIES;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected JsonReadContext _parsingContext;
    protected JsonToken _nextToken;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected ByteArrayBuilder _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected float _numberFloat;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected String _numberString;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    public ParserBase(IOContext iOContext, int n2) {
        super(n2);
        this._ioContext = iOContext;
        this._textBuffer = iOContext.constructTextBuffer();
        this._parsingContext = JsonReadContext.createRootContext(JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? DupDetector.rootDetector(this) : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _parseSlowFloat(int n2) {
        StringBuilder stringBuilder;
        NumberFormatException numberFormatException2;
        if (n2 == 16) {
            try {
                this._numberBigDecimal = null;
                this._numberString = this._textBuffer.contentsAsString();
                this._numTypesValid = 16;
                return;
            }
            catch (NumberFormatException numberFormatException2) {}
        } else {
            if (n2 == 32) {
                this._numberFloat = this._textBuffer.contentsAsFloat(this.isEnabled(JsonParser.Feature.USE_FAST_DOUBLE_PARSER));
                this._numTypesValid = 32;
                return;
            }
            this._numberDouble = this._textBuffer.contentsAsDouble(this.isEnabled(JsonParser.Feature.USE_FAST_DOUBLE_PARSER));
            this._numTypesValid = 8;
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        ParserBase parserBase = this;
        stringBuilder2("Malformed numeric value (");
        this._wrapError(stringBuilder.append(parserBase._longNumberDesc(parserBase._textBuffer.contentsAsString())).append(")").toString(), numberFormatException2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _parseSlowInt(int n2) {
        StringBuilder stringBuilder;
        NumberFormatException numberFormatException2;
        String string;
        block7: {
            boolean bl;
            int n3;
            char[] cArray;
            int n4;
            block6: {
                ParserBase parserBase = this;
                string = parserBase._textBuffer.contentsAsString();
                try {
                    n4 = parserBase._intLength;
                    cArray = parserBase._textBuffer.getTextBuffer();
                    n3 = parserBase._textBuffer.getTextOffset();
                    bl = parserBase._numberNegative;
                    if (!bl) break block6;
                    ++n3;
                }
                catch (NumberFormatException numberFormatException2) {
                    break block7;
                }
            }
            if (NumberInput.inLongRange(cArray, n3, n4, bl)) {
                ParserBase parserBase = this;
                parserBase._numberLong = Long.parseLong(string);
                parserBase._numTypesValid = 2;
                return;
            }
            if (n2 == 1 || n2 == 2) {
                this._reportTooLongIntegral(n2, string);
            }
            if (n2 != 8 && n2 != 32) {
                ParserBase parserBase = this;
                parserBase._numberBigInt = null;
                parserBase._numberString = string;
                parserBase._numTypesValid = 4;
                return;
            }
            ParserBase parserBase = this;
            parserBase._numberDouble = NumberInput.parseDouble(string, this.isEnabled(JsonParser.Feature.USE_FAST_DOUBLE_PARSER));
            parserBase._numTypesValid = 8;
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("Malformed numeric value (");
        this._wrapError(stringBuilder.append(this._longNumberDesc(string)).append(")").toString(), numberFormatException2);
    }

    public static int[] growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, nArray.length + n2);
    }

    @Override
    public Version version() {
        return new Version(2, 14, 1, "applitools", "com.privatefasterxml", "artifact identification not set");
    }

    @Override
    public Object getCurrentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public JsonParser enable(JsonParser.Feature feature) {
        this._features |= feature.getMask();
        if (feature == JsonParser.Feature.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(DupDetector.rootDetector(this));
        }
        return this;
    }

    @Override
    public JsonParser disable(JsonParser.Feature feature) {
        this._features &= ~feature.getMask();
        if (feature == JsonParser.Feature.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    @Deprecated
    public JsonParser setFeatureMask(int n2) {
        int n3 = this._features ^ n2;
        if (n3 != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public JsonParser overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        if ((n3 = n4 ^ (n2 = n4 & ~n3 | n2 & n3)) != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    public void _checkStdFeatureChanges(int n2, int n3) {
        if ((n3 & (n3 = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.getMask())) != 0 && (n2 & n3) != 0) {
            this._parsingContext = this._parsingContext.getDupDetector() == null ? this._parsingContext.withDupDetector(DupDetector.rootDetector(this)) : this._parsingContext.withDupDetector(null);
        }
    }

    @Override
    public String getCurrentName() {
        Object object = this._currToken;
        if ((object == JsonToken.START_OBJECT || object == JsonToken.START_ARRAY) && (object = this._parsingContext.getParent()) != null) {
            return ((JsonReadContext)object).getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        ParserBase parserBase = object;
        Object object = parserBase._parsingContext;
        JsonToken jsonToken = parserBase._currToken;
        if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY) {
            object = ((JsonReadContext)object).getParent();
        }
        try {
            ((JsonReadContext)object).setCurrentName(string);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            ParserBase parserBase = this;
            parserBase._inputPtr = Math.max(parserBase._inputPtr, this._inputEnd);
            parserBase._closed = true;
            try {
                parserBase._closeInput();
                parserBase._releaseBuffers();
            }
            catch (Throwable throwable) {
                this._releaseBuffers();
                throw throwable;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public JsonReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public JsonLocation getTokenLocation() {
        ParserBase parserBase = contentReference;
        ContentReference contentReference = parserBase._contentReference();
        long l2 = parserBase.getTokenCharacterOffset();
        int n2 = parserBase.getTokenLineNr();
        int n3 = parserBase.getTokenColumnNr();
        return new JsonLocation(contentReference, -1L, l2, n2, n3);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        ParserBase parserBase = this;
        ContentReference contentReference = parserBase._contentReference();
        long l2 = parserBase._currInputProcessed + (long)this._inputPtr;
        int n3 = parserBase._currInputRow;
        return new JsonLocation(contentReference, -1L, l2, n3, n2);
    }

    @Override
    public boolean hasTextCharacters() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return true;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            ParserBase parserBase = this;
            ByteArrayBuilder byteArrayBuilder = parserBase._getByteArrayBuilder();
            parserBase._decodeBase64(parserBase.getText(), byteArrayBuilder, base64Variant);
            parserBase._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n2 = this._tokenInputCol;
        if (n2 >= 0) {
            ++n2;
        }
        return n2;
    }

    public abstract void _closeInput();

    public void _releaseBuffers() {
        ParserBase parserBase = this;
        parserBase._textBuffer.releaseBuffers();
        char[] cArray = parserBase._nameCopyBuffer;
        if (parserBase._nameCopyBuffer != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    public void _handleEOF() {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = this._parsingContext.startLocation(this._contentReference());
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", objectArray2), null);
        }
    }

    public final int _eofAsNextChar() {
        this._handleEOF();
        return -1;
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        ByteArrayBuilder byteArrayBuilder = this._byteArrayBuilder;
        if (byteArrayBuilder == null) {
            ByteArrayBuilder byteArrayBuilder2;
            byteArrayBuilder = byteArrayBuilder2;
            byteArrayBuilder2 = new ByteArrayBuilder();
            this._byteArrayBuilder = byteArrayBuilder;
        } else {
            byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    public final JsonToken reset(boolean bl, int n2, int n3, int n4) {
        if (n3 < 1 && n4 < 1) {
            return this.resetInt(bl, n2);
        }
        return this.resetFloat(bl, n2, n3, n4);
    }

    public final JsonToken resetInt(boolean bl, int n2) {
        ParserBase parserBase = this;
        this._numberNegative = bl;
        parserBase._intLength = n2;
        parserBase._fractLength = 0;
        parserBase._expLength = 0;
        parserBase._numTypesValid = 0;
        return JsonToken.VALUE_NUMBER_INT;
    }

    public final JsonToken resetFloat(boolean bl, int n2, int n3, int n4) {
        ParserBase parserBase = this;
        this._numberNegative = bl;
        this._intLength = n2;
        this._fractLength = n3;
        parserBase._expLength = n4;
        parserBase._numTypesValid = 0;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    public final JsonToken resetAsNaN(String string, double d2) {
        ParserBase parserBase = this;
        this._textBuffer.resetWithString(string);
        parserBase._numberDouble = d2;
        parserBase._numTypesValid = 8;
        return JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() {
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT && (this._numTypesValid & 8) != 0) {
            double d2 = this._numberDouble;
            return Double.isNaN(d2) || Double.isInfinite(d2);
        }
        return false;
    }

    @Override
    public Number getNumberValue() {
        int n2;
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            n2 = this._numTypesValid;
            if ((n2 & 1) != 0) {
                return this._numberInt;
            }
            if ((n2 & 2) != 0) {
                return this._numberLong;
            }
            if ((n2 & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (((n2 = this._numTypesValid) & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((n2 & 0x20) != 0) {
            return Float.valueOf(this._numberFloat);
        }
        if ((n2 & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public Number getNumberValueExact() {
        int n2;
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if (((n2 = this._numTypesValid) & 1) != 0) {
                return this._numberInt;
            }
            if ((n2 & 2) != 0) {
                return this._numberLong;
            }
            if ((n2 & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._numTypesValid == 0) {
            this._parseNumericValue(16);
        }
        if (((n2 = this._numTypesValid) & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((n2 & 0x20) != 0) {
            return Float.valueOf(this._numberFloat);
        }
        if ((n2 & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public JsonParser.NumberType getNumberType() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            int n2 = this._numTypesValid;
            if ((n2 & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((n2 & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        int n3 = this._numTypesValid;
        if ((n3 & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        if ((n3 & 0x20) != 0) {
            return JsonParser.NumberType.FLOAT;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public int getIntValue() {
        int n2 = this._numTypesValid;
        if ((n2 & 1) == 0) {
            if (n2 == 0) {
                return this._parseIntValue();
            }
            if ((n2 & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() {
        int n2 = this._numTypesValid;
        if ((n2 & 2) == 0) {
            if (n2 == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        int n2 = this._numTypesValid;
        if ((n2 & 4) == 0) {
            if (n2 == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._getBigInteger();
    }

    @Override
    public float getFloatValue() {
        int n2 = this._numTypesValid;
        if ((n2 & 0x20) == 0) {
            if (n2 == 0) {
                this._parseNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._numberFloat;
    }

    @Override
    public double getDoubleValue() {
        int n2 = this._numTypesValid;
        if ((n2 & 8) == 0) {
            if (n2 == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() {
        int n2 = this._numTypesValid;
        if ((n2 & 0x10) == 0) {
            if (n2 == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._getBigDecimal();
    }

    public void _parseNumericValue(int n2) {
        JsonToken jsonToken;
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if ((jsonToken = this._currToken) == JsonToken.VALUE_NUMBER_INT) {
            int n3 = this._intLength;
            if (n3 <= 9) {
                this._numberInt = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = this._textBuffer.contentsAsLong(this._numberNegative);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            ParserBase parserBase = this;
                            parserBase._numberInt = (int)l2;
                            parserBase._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        ParserBase parserBase = this;
                        parserBase._numberInt = (int)l2;
                        parserBase._numTypesValid = 1;
                        return;
                    }
                }
                ParserBase parserBase = this;
                parserBase._numberLong = l2;
                parserBase._numTypesValid = 2;
                return;
            }
            this._parseSlowInt(n2);
            return;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n2);
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)jsonToken);
    }

    public int _parseIntValue() {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT && this._intLength <= 9) {
            int n2 = this._textBuffer.contentsAsInt(this._numberNegative);
            ParserBase parserBase = this;
            parserBase._numberInt = n2;
            parserBase._numTypesValid = 1;
            return n2;
        }
        ParserBase parserBase = this;
        parserBase._parseNumericValue(1);
        if ((parserBase._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    public void _reportTooLongIntegral(int n2, String string) {
        if (n2 == 1) {
            this.reportOverflowInt(string);
        } else {
            this.reportOverflowLong(string);
        }
    }

    public void convertNumberToInt() {
        int n2 = this._numTypesValid;
        if ((n2 & 2) != 0) {
            long l2 = this._numberLong;
            int n3 = (int)l2;
            if ((long)n3 != l2) {
                ParserBase parserBase = this;
                String string = parserBase.getText();
                parserBase.reportOverflowInt(string, parserBase.currentToken());
            }
            this._numberInt = n3;
        } else if ((n2 & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (ParserMinimalBase.BI_MIN_INT.compareTo(bigInteger) > 0 || ParserMinimalBase.BI_MAX_INT.compareTo(bigInteger) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = bigInteger.intValue();
        } else if ((n2 & 8) != 0) {
            double d2 = this._numberDouble;
            if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((n2 & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (ParserMinimalBase.BD_MIN_INT.compareTo(bigDecimal) > 0 || ParserMinimalBase.BD_MAX_INT.compareTo(bigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = bigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    public void convertNumberToLong() {
        int n2 = this._numTypesValid;
        if ((n2 & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((n2 & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (ParserMinimalBase.BI_MIN_LONG.compareTo(bigInteger) > 0 || ParserMinimalBase.BI_MAX_LONG.compareTo(bigInteger) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = bigInteger.longValue();
        } else if ((n2 & 8) != 0) {
            double d2 = this._numberDouble;
            if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((n2 & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (ParserMinimalBase.BD_MIN_LONG.compareTo(bigDecimal) > 0 || ParserMinimalBase.BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = bigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    public void convertNumberToBigInteger() {
        int n2 = this._numTypesValid;
        if ((n2 & 0x10) != 0) {
            this._numberBigInt = this._getBigDecimal().toBigInteger();
        } else if ((n2 & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((n2 & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((n2 & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    public void convertNumberToDouble() {
        int n2 = this._numTypesValid;
        if ((n2 & 0x10) != 0) {
            this._numberDouble = this._getBigDecimal().doubleValue();
        } else if ((n2 & 4) != 0) {
            this._numberDouble = this._getBigInteger().doubleValue();
        } else if ((n2 & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((n2 & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else if ((n2 & 0x20) != 0) {
            this._numberDouble = this._numberFloat;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    public void convertNumberToFloat() {
        int n2 = this._numTypesValid;
        if ((n2 & 0x10) != 0) {
            this._numberFloat = this._getBigDecimal().floatValue();
        } else if ((n2 & 4) != 0) {
            this._numberFloat = this._getBigInteger().floatValue();
        } else if ((n2 & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((n2 & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else if ((n2 & 8) != 0) {
            this._numberFloat = (float)this._numberDouble;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    public void convertNumberToBigDecimal() {
        int n2 = this._numTypesValid;
        if ((n2 & 8) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this.getText());
        } else if ((n2 & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._getBigInteger());
        } else if ((n2 & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((n2 & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    public BigInteger _getBigInteger() {
        Object object = this._numberBigInt;
        if (object != null) {
            return object;
        }
        object = this._numberString;
        if (object != null) {
            object = NumberInput.parseBigInteger((String)object);
            ParserBase parserBase = this;
            parserBase._numberBigInt = object;
            parserBase._numberString = null;
            return object;
        }
        throw new IllegalStateException("cannot get BigInteger from current parser state");
    }

    public BigDecimal _getBigDecimal() {
        Object object = this._numberBigDecimal;
        if (object != null) {
            return object;
        }
        object = this._numberString;
        if (object != null) {
            object = NumberInput.parseBigDecimal((String)object);
            ParserBase parserBase = this;
            parserBase._numberBigDecimal = object;
            parserBase._numberString = null;
            return object;
        }
        throw new IllegalStateException("cannot get BigDecimal from current parser state");
    }

    public void _reportMismatchedEndMarker(int n2, char c2) {
        ParserBase parserBase = this;
        JsonReadContext jsonReadContext = parserBase.getParsingContext();
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = Character.valueOf((char)n2);
        objectArray2[1] = Character.valueOf(c2);
        objectArray2[2] = jsonReadContext.typeDesc();
        objectArray[3] = jsonReadContext.startLocation(this._contentReference());
        parserBase._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", objectArray2));
    }

    public char _handleUnrecognizedCharacterEscape(char c2) {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c2;
        }
        if (c2 == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return c2;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c2));
        return c2;
    }

    public void _throwUnquotedSpace(int n2, String string) {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n2 > 32) {
            char c2 = (char)n2;
            this._reportError("Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c2) + "): has to be escaped using backslash to be included in " + string);
        }
    }

    public String _validJsonTokenList() {
        return this._validJsonValueList();
    }

    public String _validJsonValueList() {
        if (this.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
            return "(JSON String, Number (or 'NaN'/'INF'/'+INF'), Array, Object or token 'null', 'true' or 'false')";
        }
        return "(JSON String, Number, Array, Object or token 'null', 'true' or 'false')";
    }

    public char _decodeEscaped() {
        throw new UnsupportedOperationException();
    }

    public final int _decodeBase64Escape(Base64Variant base64Variant, int n2, int n3) {
        if (n2 == 92) {
            char c2 = this._decodeEscaped();
            n2 = c2;
            if (c2 <= ' ' && n3 == 0) {
                return -1;
            }
            int n4 = base64Variant.decodeBase64Char(n2);
            if (n4 < 0 && n4 != -2) {
                throw this.reportInvalidBase64Char(base64Variant, n2, n3);
            }
            return n4;
        }
        throw this.reportInvalidBase64Char(base64Variant, n2, n3);
    }

    public final int _decodeBase64Escape(Base64Variant base64Variant, char c2, int n2) {
        if (c2 == '\\') {
            c2 = this._decodeEscaped();
            if (c2 <= ' ' && n2 == 0) {
                return -1;
            }
            int n3 = base64Variant.decodeBase64Char(c2);
            if (n3 < 0 && (n3 != -2 || n2 < 2)) {
                throw this.reportInvalidBase64Char(base64Variant, c2, n2);
            }
            return n3;
        }
        throw this.reportInvalidBase64Char(base64Variant, c2, n2);
    }

    public IllegalArgumentException reportInvalidBase64Char(Base64Variant base64Variant, int n2, int n3) {
        return this.reportInvalidBase64Char(base64Variant, n2, n3, null);
    }

    public IllegalArgumentException reportInvalidBase64Char(Base64Variant base64Variant, int n2, int n3, String string) {
        Object object;
        if (n2 <= 32) {
            Object[] objectArray = new Object[2];
            object = objectArray;
            object[0] = Integer.toHexString(n2);
            objectArray[1] = n3 + 1;
            object = String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", object);
        } else {
            object = base64Variant.usesPaddingChar(n2) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n3 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (Character.isDefined(n2) && !Character.isISOControl(n2) ? "Illegal character '" + (char)n2 + "' (code 0x" + Integer.toHexString(n2) + ") in base64 content" : "Illegal character (code 0x" + Integer.toHexString(n2) + ") in base64 content");
        }
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new IllegalArgumentException((String)object);
    }

    public void _handleBase64MissingPadding(Base64Variant base64Variant) {
        this._reportError(base64Variant.missingPaddingMessage());
    }

    @Deprecated
    public Object _getSourceReference() {
        if (JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference().getRawContent();
        }
        return null;
    }

    public ContentReference _contentReference() {
        if (JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference();
        }
        return ContentReference.unknown();
    }

    @Deprecated
    public void loadMoreGuaranteed() {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Deprecated
    public boolean loadMore() {
        return false;
    }

    public void _finishString() {
    }
}

