/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.base;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonParseException;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.exc.InputCoercionException;
import com.privatefasterxml.jackson.core.io.JsonEOFException;
import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_APOS = 39;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_ASTERISK = 42;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_HASH = 35;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final int INT_PERIOD = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected static final char CHAR_NULL = '\u0000';
    protected static final byte[] NO_BYTES;
    protected static final int[] NO_INTS;
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    protected static final int NR_FLOAT = 32;
    protected static final BigInteger BI_MIN_INT;
    protected static final BigInteger BI_MAX_INT;
    protected static final BigInteger BI_MIN_LONG;
    protected static final BigInteger BI_MAX_LONG;
    protected static final BigDecimal BD_MIN_LONG;
    protected static final BigDecimal BD_MAX_LONG;
    protected static final BigDecimal BD_MIN_INT;
    protected static final BigDecimal BD_MAX_INT;
    protected static final long MIN_INT_L = Integer.MIN_VALUE;
    protected static final long MAX_INT_L = Integer.MAX_VALUE;
    protected static final double MIN_LONG_D = -9.223372036854776E18;
    protected static final double MAX_LONG_D = 9.223372036854776E18;
    protected static final double MIN_INT_D = -2.147483648E9;
    protected static final double MAX_INT_D = 2.147483647E9;
    protected static final int MAX_ERROR_TOKEN_LENGTH = 256;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    public ParserMinimalBase() {
    }

    public ParserMinimalBase(int n2) {
        super(n2);
    }

    public static final String _getCharDesc(int n2) {
        char c2 = (char)n2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + n2 + ")";
        }
        if (n2 > 255) {
            return "'" + c2 + "' (code " + n2 + " / 0x" + Integer.toHexString(n2) + ")";
        }
        return "'" + c2 + "' (code " + n2 + ")";
    }

    @Deprecated
    public static byte[] _asciiBytes(String string) {
        String string2 = string;
        byte[] byArray = new byte[string2.length()];
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    @Deprecated
    public static String _ascii(byte[] byArray) {
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        NO_BYTES = new byte[0];
        NO_INTS = new int[0];
        BI_MIN_INT = bigInteger4 = BigInteger.valueOf(Integer.MIN_VALUE);
        BI_MAX_INT = bigInteger3 = BigInteger.valueOf(Integer.MAX_VALUE);
        BI_MIN_LONG = bigInteger2 = BigInteger.valueOf(Long.MIN_VALUE);
        BI_MAX_LONG = bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
        BD_MIN_LONG = new BigDecimal(bigInteger2);
        BD_MAX_LONG = new BigDecimal(bigInteger);
        BD_MIN_INT = new BigDecimal(bigInteger4);
        BD_MAX_INT = new BigDecimal(bigInteger3);
    }

    @Override
    public abstract JsonToken nextToken();

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public int currentTokenId() {
        Object object = object._currToken;
        return object == null ? 0 : ((JsonToken)((Object)object)).id();
    }

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    @Deprecated
    public int getCurrentTokenId() {
        Object object = object._currToken;
        return object == null ? 0 : ((JsonToken)((Object)object)).id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n2) {
        Object object = object._currToken;
        if (object == null) {
            return n2 == 0;
        }
        return ((JsonToken)((Object)object)).id() == n2;
    }

    @Override
    public boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public boolean isExpectedNumberIntToken() {
        return this._currToken == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonToken nextValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken2;
            if ((jsonToken2 = this.nextToken()) == null) {
                ParserMinimalBase parserMinimalBase = this;
                parserMinimalBase._handleEOF();
                return parserMinimalBase;
            }
            if (jsonToken2.isStructStart()) {
                ++n2;
                continue;
            }
            if (jsonToken2.isStructEnd()) {
                if ((n2 += -1) != 0) continue;
                return this;
            }
            if (jsonToken2 != JsonToken.NOT_AVAILABLE) continue;
            ParserMinimalBase parserMinimalBase = this;
            parserMinimalBase._reportError("Not enough content available for `skipChildren()`: non-blocking parser? (%s)", parserMinimalBase.getClass().getName());
        }
    }

    public abstract void _handleEOF();

    @Override
    public abstract String getCurrentName();

    @Override
    public abstract void close();

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public void clearCurrentToken() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            ParserMinimalBase parserMinimalBase = this;
            parserMinimalBase._lastClearedToken = jsonToken;
            parserMinimalBase._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText();

    @Override
    public abstract char[] getTextCharacters();

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength();

    @Override
    public abstract int getTextOffset();

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1);

    @Override
    public boolean getValueAsBoolean(boolean bl) {
        Object object = ((ParserMinimalBase)object2)._currToken;
        if (object != null) {
            switch (object.id()) {
                default: {
                    break;
                }
                case 12: {
                    Object object2 = ((JsonParser)object2).getEmbeddedObject();
                    if (!(object2 instanceof Boolean)) break;
                    return (Boolean)object2;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 9: {
                    return true;
                }
                case 7: {
                    return ((JsonParser)object2).getIntValue() != 0;
                }
                case 6: {
                    object = ((ParserMinimalBase)object2).getText().trim();
                    if ("true".equals(object)) {
                        return true;
                    }
                    if ("false".equals(object)) {
                        return false;
                    }
                    if (!((ParserMinimalBase)object2)._hasTextualNull((String)object)) break;
                    return false;
                }
            }
        }
        return bl;
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getValueAsInt(0);
        }
        return this.getIntValue();
    }

    @Override
    public int getValueAsInt(int n2) {
        JsonToken jsonToken = ((ParserMinimalBase)object)._currToken;
        if (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT) {
            if (jsonToken != null) {
                switch (jsonToken.id()) {
                    default: {
                        break;
                    }
                    case 12: {
                        Object object = ((JsonParser)object).getEmbeddedObject();
                        if (!(object instanceof Number)) break;
                        return ((Number)object).intValue();
                    }
                    case 11: {
                        return 0;
                    }
                    case 10: {
                        return 0;
                    }
                    case 9: {
                        return 1;
                    }
                    case 6: {
                        ParserMinimalBase parserMinimalBase = object;
                        Object object = parserMinimalBase.getText();
                        if (parserMinimalBase._hasTextualNull((String)object)) {
                            return 0;
                        }
                        return NumberInput.parseAsInt((String)object, n2);
                    }
                }
            }
            return n2;
        }
        return ((JsonParser)object).getIntValue();
    }

    @Override
    public long getValueAsLong() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getValueAsLong(0L);
        }
        return this.getLongValue();
    }

    @Override
    public long getValueAsLong(long l2) {
        JsonToken jsonToken = ((ParserMinimalBase)object)._currToken;
        if (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT) {
            if (jsonToken != null) {
                switch (jsonToken.id()) {
                    default: {
                        break;
                    }
                    case 12: {
                        Object object = ((JsonParser)object).getEmbeddedObject();
                        if (!(object instanceof Number)) break;
                        return ((Number)object).longValue();
                    }
                    case 10: 
                    case 11: {
                        return 0L;
                    }
                    case 9: {
                        return 1L;
                    }
                    case 6: {
                        ParserMinimalBase parserMinimalBase = object;
                        Object object = parserMinimalBase.getText();
                        if (parserMinimalBase._hasTextualNull((String)object)) {
                            return 0L;
                        }
                        return NumberInput.parseAsLong((String)object, l2);
                    }
                }
            }
            return l2;
        }
        return ((JsonParser)object).getLongValue();
    }

    @Override
    public double getValueAsDouble(double d2) {
        JsonToken jsonToken = ((ParserMinimalBase)object)._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                default: {
                    break;
                }
                case 12: {
                    Object object = ((JsonParser)object).getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 9: {
                    return 1.0;
                }
                case 7: 
                case 8: {
                    return ((JsonParser)object).getDoubleValue();
                }
                case 6: {
                    ParserMinimalBase parserMinimalBase = object;
                    Object object = parserMinimalBase.getText();
                    if (parserMinimalBase._hasTextualNull((String)object)) {
                        return 0.0;
                    }
                    return NumberInput.parseAsDouble((String)object, d2);
                }
            }
        }
        return d2;
    }

    @Override
    public String getValueAsString() {
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        if (jsonToken != null && jsonToken != JsonToken.VALUE_NULL && jsonToken.isScalarValue()) {
            return this.getText();
        }
        return string;
    }

    public void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) {
        try {
            base64Variant.decode(string, byteArrayBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._reportError(illegalArgumentException.getMessage());
        }
    }

    public boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    public <T> T _reportUnexpectedNumberChar(int n2, String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ParserMinimalBase._getCharDesc(n2);
        String string2 = String.format("Unexpected character (%s) in numeric value", objectArray2);
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
        return null;
    }

    @Deprecated
    public void reportUnexpectedNumberChar(int n2, String string) {
        this._reportUnexpectedNumberChar(n2, string);
    }

    public void reportInvalidNumber(String string) {
        this._reportError("Invalid numeric value: " + string);
    }

    public void reportOverflowInt() {
        ParserMinimalBase parserMinimalBase = this;
        parserMinimalBase.reportOverflowInt(parserMinimalBase.getText());
    }

    public void reportOverflowInt(String string) {
        ParserMinimalBase parserMinimalBase = this;
        parserMinimalBase.reportOverflowInt(string, parserMinimalBase.currentToken());
    }

    public void reportOverflowInt(String object, JsonToken jsonToken) {
        ParserMinimalBase parserMinimalBase = string;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ((ParserMinimalBase)((Object)string))._longIntegerDesc((String)object);
        objectArray[1] = Integer.MIN_VALUE;
        objectArray[2] = Integer.MAX_VALUE;
        String string = String.format("Numeric value (%s) out of range of int (%d - %s)", objectArray2);
        object = Integer.TYPE;
        parserMinimalBase._reportInputCoercion(string, jsonToken, (Class<?>)object);
    }

    public void reportOverflowLong() {
        ParserMinimalBase parserMinimalBase = this;
        parserMinimalBase.reportOverflowLong(parserMinimalBase.getText());
    }

    public void reportOverflowLong(String string) {
        ParserMinimalBase parserMinimalBase = this;
        parserMinimalBase.reportOverflowLong(string, parserMinimalBase.currentToken());
    }

    public void reportOverflowLong(String object, JsonToken jsonToken) {
        ParserMinimalBase parserMinimalBase = string;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ((ParserMinimalBase)((Object)string))._longIntegerDesc((String)object);
        objectArray[1] = Long.MIN_VALUE;
        objectArray[2] = Long.MAX_VALUE;
        String string = String.format("Numeric value (%s) out of range of long (%d - %s)", objectArray2);
        object = Long.TYPE;
        parserMinimalBase._reportInputCoercion(string, jsonToken, (Class<?>)object);
    }

    public void _reportInputCoercion(String string, JsonToken jsonToken, Class<?> clazz) {
        throw new InputCoercionException((JsonParser)this, string, jsonToken, clazz);
    }

    public String _longIntegerDesc(String objectArray) {
        int n2 = objectArray.length();
        if (n2 < 1000) {
            return objectArray;
        }
        if (objectArray.startsWith("-")) {
            --n2;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n2;
        return String.format("[Integer with %d digits]", objectArray);
    }

    public String _longNumberDesc(String objectArray) {
        int n2 = objectArray.length();
        if (n2 < 1000) {
            return objectArray;
        }
        if (objectArray.startsWith("-")) {
            --n2;
        }
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = n2;
        return String.format("[number with %d characters]", objectArray);
    }

    public void _reportUnexpectedChar(int n2, String string) {
        if (n2 < 0) {
            this._reportInvalidEOF();
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ParserMinimalBase._getCharDesc(n2);
        String string2 = String.format("Unexpected character (%s)", objectArray2);
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    public void _reportInvalidEOF() {
        ParserMinimalBase parserMinimalBase = string;
        String string = " in " + (Object)((Object)((ParserMinimalBase)((Object)string))._currToken);
        parserMinimalBase._reportInvalidEOF(string, parserMinimalBase._currToken);
    }

    public void _reportInvalidEOFInValue(JsonToken jsonToken) {
        String string = jsonToken == JsonToken.VALUE_STRING ? " in a String value" : (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT ? " in a value" : " in a Number value");
        this._reportInvalidEOF(string, jsonToken);
    }

    public void _reportInvalidEOF(String string, JsonToken jsonToken) {
        throw new JsonEOFException((JsonParser)this, jsonToken, "Unexpected end-of-input" + string);
    }

    @Deprecated
    public void _reportInvalidEOFInValue() {
        this._reportInvalidEOF(" in a value");
    }

    @Deprecated
    public void _reportInvalidEOF(String string) {
        throw new JsonEOFException((JsonParser)this, null, "Unexpected end-of-input" + string);
    }

    public void _reportMissingRootWS(int n2) {
        this._reportUnexpectedChar(n2, "Expected space separating root-level values");
    }

    public void _throwInvalidSpace(int n2) {
        char c2 = (char)n2;
        this._reportError("Illegal character (" + ParserMinimalBase._getCharDesc(c2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens");
    }

    public final void _reportError(String string) {
        throw this._constructError(string);
    }

    public final void _reportError(String string, Object object) {
        throw this._constructError(String.format(string, object));
    }

    public final void _reportError(String string, Object object, Object object2) {
        throw this._constructError(String.format(string, object, object2));
    }

    public final void _wrapError(String string, Throwable throwable) {
        throw this._constructError(string, throwable);
    }

    public final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    public final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException((JsonParser)this, string, throwable);
    }
}

