/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.exc;

import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonProcessingException;
import com.privatefasterxml.jackson.core.util.RequestPayload;
import java.io.Serializable;

public abstract class StreamReadException
extends JsonProcessingException {
    static final long serialVersionUID = 2L;
    protected transient JsonParser _processor;
    protected RequestPayload _requestPayload;

    public StreamReadException(JsonParser jsonParser, String string) {
        JsonLocation jsonLocation = jsonParser == null ? null : jsonParser.getCurrentLocation();
        super(string, jsonLocation);
        this._processor = jsonParser;
    }

    public StreamReadException(JsonParser jsonParser, String string, Throwable throwable) {
        JsonLocation jsonLocation = jsonParser == null ? null : jsonParser.getCurrentLocation();
        super(string, jsonLocation, throwable);
        this._processor = jsonParser;
    }

    public StreamReadException(JsonParser jsonParser, String string, JsonLocation jsonLocation) {
        super(string, jsonLocation, null);
        this._processor = jsonParser;
    }

    public StreamReadException(JsonParser jsonParser, String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
        this._processor = jsonParser;
    }

    public StreamReadException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public abstract StreamReadException withParser(JsonParser var1);

    public abstract StreamReadException withRequestPayload(RequestPayload var1);

    @Override
    public JsonParser getProcessor() {
        return this._processor;
    }

    public RequestPayload getRequestPayload() {
        return this._requestPayload;
    }

    public String getRequestPayloadAsString() {
        Serializable serializable = ((StreamReadException)serializable)._requestPayload;
        return serializable != null ? ((RequestPayload)serializable).toString() : null;
    }

    @Override
    public String getMessage() {
        StreamReadException streamReadException = this;
        String string = super.getMessage();
        if (streamReadException._requestPayload != null) {
            string = string + "\nRequest payload : " + this._requestPayload.toString();
        }
        return string;
    }
}

