/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.filter;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.filter.TokenFilter;

public class TokenFilterContext
extends JsonStreamContext {
    protected final TokenFilterContext _parent;
    protected TokenFilterContext _child;
    protected String _currentName;
    protected TokenFilter _filter;
    protected boolean _startHandled;
    protected boolean _needToHandleName;

    public TokenFilterContext(int n2, TokenFilterContext tokenFilterContext, TokenFilter tokenFilter, boolean bl) {
        this._type = n2;
        this._parent = tokenFilterContext;
        this._filter = tokenFilter;
        this._index = -1;
        this._startHandled = bl;
        this._needToHandleName = false;
    }

    public static TokenFilterContext createRootContext(TokenFilter tokenFilter) {
        return new TokenFilterContext(0, null, tokenFilter, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _writePath(JsonGenerator jsonGenerator) {
        Object object = this._filter;
        if (object == null) return;
        if (object == TokenFilter.INCLUDE_ALL) {
            return;
        }
        object = this._parent;
        if (object != null) {
            super._writePath(jsonGenerator);
        }
        if (this._startHandled) {
            if (!this._needToHandleName) return;
        } else {
            this._startHandled = true;
            int n2 = this._type;
            if (n2 != 2) {
                if (n2 != 1) return;
                jsonGenerator.writeStartArray();
                return;
            }
            jsonGenerator.writeStartObject();
            if (!this._needToHandleName) return;
        }
        this._needToHandleName = false;
        jsonGenerator.writeFieldName(this._currentName);
    }

    public TokenFilterContext reset(int n2, TokenFilter tokenFilter, boolean bl) {
        this._type = n2;
        this._filter = tokenFilter;
        this._index = -1;
        this._currentName = null;
        this._startHandled = bl;
        this._needToHandleName = false;
        return this;
    }

    public TokenFilterContext createChildArrayContext(TokenFilter tokenFilter, boolean bl) {
        TokenFilterContext tokenFilterContext = this._child;
        if (tokenFilterContext == null) {
            TokenFilterContext tokenFilterContext2;
            tokenFilterContext = tokenFilterContext2;
            tokenFilterContext(1, this, tokenFilter, bl);
            this._child = tokenFilterContext;
            return tokenFilterContext2;
        }
        return tokenFilterContext.reset(1, tokenFilter, bl);
    }

    public TokenFilterContext createChildObjectContext(TokenFilter tokenFilter, boolean bl) {
        TokenFilterContext tokenFilterContext = this._child;
        if (tokenFilterContext == null) {
            TokenFilterContext tokenFilterContext2;
            tokenFilterContext = tokenFilterContext2;
            tokenFilterContext(2, this, tokenFilter, bl);
            this._child = tokenFilterContext;
            return tokenFilterContext2;
        }
        return tokenFilterContext.reset(2, tokenFilter, bl);
    }

    public TokenFilter setFieldName(String string) {
        this._currentName = string;
        this._needToHandleName = true;
        return this._filter;
    }

    public TokenFilter checkValue(TokenFilter tokenFilter) {
        int n2;
        int n3 = this._type;
        if (n3 == 2) {
            return tokenFilter;
        }
        this._index = n2 = this._index + 1;
        if (n3 == 1) {
            return tokenFilter.includeElement(n2);
        }
        return tokenFilter.includeRootValue(n2);
    }

    public void ensureFieldNameWritten(JsonGenerator jsonGenerator) {
        if (this._needToHandleName) {
            this._needToHandleName = false;
            jsonGenerator.writeFieldName(this._currentName);
        }
    }

    public void writePath(JsonGenerator jsonGenerator) {
        Object object = this._filter;
        if (object != null && object != TokenFilter.INCLUDE_ALL) {
            object = this._parent;
            if (object != null) {
                super._writePath(jsonGenerator);
            }
            if (this._startHandled) {
                if (this._needToHandleName) {
                    jsonGenerator.writeFieldName(this._currentName);
                }
            } else {
                this._startHandled = true;
                int n2 = this._type;
                if (n2 == 2) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeFieldName(this._currentName);
                } else if (n2 == 1) {
                    jsonGenerator.writeStartArray();
                }
            }
            return;
        }
    }

    public TokenFilterContext closeArray(JsonGenerator object) {
        if (this._startHandled) {
            ((JsonGenerator)object).writeEndArray();
        } else {
            Object object2 = this._filter;
            if (object2 != null && object2 != TokenFilter.INCLUDE_ALL && ((TokenFilter)object2).includeEmptyArray(this.hasCurrentIndex())) {
                object2 = this._parent;
                if (object2 != null) {
                    super._writePath((JsonGenerator)object);
                }
                Object object3 = object;
                ((JsonGenerator)object3).writeStartArray();
                ((JsonGenerator)object3).writeEndArray();
            }
        }
        object = this._filter;
        if (object != null && object != TokenFilter.INCLUDE_ALL) {
            ((TokenFilter)object).filterFinishArray();
        }
        return this._parent;
    }

    public TokenFilterContext closeObject(JsonGenerator object) {
        if (this._startHandled) {
            ((JsonGenerator)object).writeEndObject();
        } else {
            Object object2 = this._filter;
            if (object2 != null && object2 != TokenFilter.INCLUDE_ALL && ((TokenFilter)object2).includeEmptyObject(this.hasCurrentName())) {
                object2 = this._parent;
                if (object2 != null) {
                    super._writePath((JsonGenerator)object);
                }
                Object object3 = object;
                ((JsonGenerator)object3).writeStartObject();
                ((JsonGenerator)object3).writeEndObject();
            }
        }
        object = this._filter;
        if (object != null && object != TokenFilter.INCLUDE_ALL) {
            ((TokenFilter)object).filterFinishObject();
        }
        return this._parent;
    }

    public void skipParentChecks() {
        this._filter = null;
        TokenFilterContext tokenFilterContext = this._parent;
        while (tokenFilterContext != null) {
            this._parent._filter = null;
            tokenFilterContext = tokenFilterContext._parent;
        }
    }

    @Override
    public Object getCurrentValue() {
        return null;
    }

    @Override
    public void setCurrentValue(Object object) {
    }

    @Override
    public final TokenFilterContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    public TokenFilter getFilter() {
        return this._filter;
    }

    public boolean isStartHandled() {
        return this._startHandled;
    }

    public JsonToken nextTokenToRead() {
        if (!this._startHandled) {
            this._startHandled = true;
            if (this._type == 2) {
                return JsonToken.START_OBJECT;
            }
            return JsonToken.START_ARRAY;
        }
        if (this._needToHandleName && this._type == 2) {
            this._needToHandleName = false;
            return JsonToken.FIELD_NAME;
        }
        return null;
    }

    public TokenFilterContext findChildOf(TokenFilterContext tokenFilterContext) {
        TokenFilterContext tokenFilterContext2 = tokenFilterContext3._parent;
        if (tokenFilterContext2 == tokenFilterContext) {
            return tokenFilterContext3;
        }
        while (tokenFilterContext2 != null) {
            TokenFilterContext tokenFilterContext3 = tokenFilterContext2._parent;
            if (tokenFilterContext3 == tokenFilterContext) {
                return tokenFilterContext2;
            }
            tokenFilterContext2 = tokenFilterContext3;
        }
        return null;
    }

    public void appendDesc(StringBuilder stringBuilder) {
        int n2;
        TokenFilterContext tokenFilterContext = this._parent;
        if (tokenFilterContext != null) {
            tokenFilterContext.appendDesc(stringBuilder);
        }
        if ((n2 = this._type) == 2) {
            stringBuilder.append('{');
            if (this._currentName != null) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder.append('\"');
                stringBuilder2.append(this._currentName);
                stringBuilder2.append('\"');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append('}');
        } else if (n2 == 1) {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder.append('[');
            stringBuilder3.append(this.getCurrentIndex());
            stringBuilder3.append(']');
        } else {
            stringBuilder.append("/");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        TokenFilterContext tokenFilterContext = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        tokenFilterContext.appendDesc(new StringBuilder(64));
        return stringBuilder2.toString();
    }
}

