/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.format;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.format.DataFormatMatcher;
import com.privatefasterxml.jackson.core.format.InputAccessor;
import com.privatefasterxml.jackson.core.format.MatchStrength;
import java.io.InputStream;
import java.util.Collection;

public class DataFormatDetector {
    public static final int DEFAULT_MAX_INPUT_LOOKAHEAD = 64;
    protected final JsonFactory[] _detectors;
    protected final MatchStrength _optimalMatch;
    protected final MatchStrength _minimalMatch;
    protected final int _maxInputLookahead;

    public DataFormatDetector(JsonFactory ... jsonFactoryArray) {
        DataFormatDetector dataFormatDetector = object;
        Object object = MatchStrength.WEAK_MATCH;
        dataFormatDetector(jsonFactoryArray, MatchStrength.SOLID_MATCH, (MatchStrength)((Object)object), 64);
    }

    public DataFormatDetector(Collection<JsonFactory> collection) {
        this(collection.toArray(new JsonFactory[0]));
    }

    private DataFormatDetector(JsonFactory[] jsonFactoryArray, MatchStrength matchStrength, MatchStrength matchStrength2, int n2) {
        this._detectors = jsonFactoryArray;
        this._optimalMatch = matchStrength;
        this._minimalMatch = matchStrength2;
        this._maxInputLookahead = n2;
    }

    private DataFormatMatcher _findFormat(InputAccessor.Std std) {
        JsonFactory jsonFactory = null;
        Enum enum_ = null;
        JsonFactory[] jsonFactoryArray = this._detectors;
        int n2 = this._detectors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonFactory jsonFactory2 = jsonFactoryArray[i2];
            std.reset();
            MatchStrength matchStrength = jsonFactory2.hasFormat(std);
            if (matchStrength == null || matchStrength.ordinal() < this._minimalMatch.ordinal() || jsonFactory != null && enum_.ordinal() >= matchStrength.ordinal()) continue;
            if (matchStrength.ordinal() >= this._optimalMatch.ordinal()) {
                enum_ = matchStrength;
                jsonFactory = jsonFactory2;
                break;
            }
            enum_ = matchStrength;
            jsonFactory = jsonFactory2;
        }
        return std.createMatcher(jsonFactory, (MatchStrength)enum_);
    }

    public DataFormatDetector withOptimalMatch(MatchStrength matchStrength) {
        if (matchStrength == jsonFactoryArray._optimalMatch) {
            return jsonFactoryArray;
        }
        JsonFactory[] jsonFactoryArray = jsonFactoryArray._detectors;
        MatchStrength matchStrength2 = jsonFactoryArray._minimalMatch;
        int n2 = jsonFactoryArray._maxInputLookahead;
        return new DataFormatDetector(jsonFactoryArray, matchStrength, matchStrength2, n2);
    }

    public DataFormatDetector withMinimalMatch(MatchStrength matchStrength) {
        if (matchStrength == jsonFactoryArray._minimalMatch) {
            return jsonFactoryArray;
        }
        JsonFactory[] jsonFactoryArray = jsonFactoryArray._detectors;
        MatchStrength matchStrength2 = jsonFactoryArray._optimalMatch;
        int n2 = jsonFactoryArray._maxInputLookahead;
        return new DataFormatDetector(jsonFactoryArray, matchStrength2, matchStrength, n2);
    }

    public DataFormatDetector withMaxInputLookahead(int n2) {
        if (n2 == jsonFactoryArray._maxInputLookahead) {
            return jsonFactoryArray;
        }
        JsonFactory[] jsonFactoryArray = jsonFactoryArray._detectors;
        MatchStrength matchStrength = jsonFactoryArray._optimalMatch;
        MatchStrength matchStrength2 = jsonFactoryArray._minimalMatch;
        return new DataFormatDetector(jsonFactoryArray, matchStrength, matchStrength2, n2);
    }

    public DataFormatMatcher findFormat(InputStream inputStream) {
        return this._findFormat(new InputAccessor.Std(inputStream, new byte[this._maxInputLookahead]));
    }

    public DataFormatMatcher findFormat(byte[] byArray) {
        return this._findFormat(new InputAccessor.Std(byArray));
    }

    public DataFormatMatcher findFormat(byte[] byArray, int n2, int n3) {
        return this._findFormat(new InputAccessor.Std(byArray, n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("[");
        JsonFactory[] jsonFactoryArray = this._detectors;
        int n2 = this._detectors.length;
        if (n2 > 0) {
            stringBuilder2.append(jsonFactoryArray[0].getFormatName());
            for (int i2 = 1; i2 < n2; ++i2) {
                stringBuilder2.append(", ");
                stringBuilder2.append(this._detectors[i2].getFormatName());
            }
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(']');
        return stringBuilder3.toString();
    }
}

