/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.format;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.format.MatchStrength;
import com.privatefasterxml.jackson.core.io.MergedStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DataFormatMatcher {
    protected final InputStream _originalStream;
    protected final byte[] _bufferedData;
    protected final int _bufferedStart;
    protected final int _bufferedLength;
    protected final JsonFactory _match;
    protected final MatchStrength _matchStrength;

    public DataFormatMatcher(InputStream objectArray, byte[] byArray, int n2, int n3, JsonFactory jsonFactory, MatchStrength matchStrength) {
        this._originalStream = objectArray;
        this._bufferedData = byArray;
        this._bufferedStart = n2;
        this._bufferedLength = n3;
        this._match = jsonFactory;
        this._matchStrength = matchStrength;
        if ((n2 | n3) >= 0 && n2 + n3 <= byArray.length) {
            return;
        }
        Object[] objectArray2 = new Object[3];
        objectArray = objectArray2;
        objectArray[0] = n2;
        objectArray[1] = n3;
        objectArray2[2] = byArray.length;
        throw new IllegalArgumentException(String.format("Illegal start/length (%d/%d) wrt input array of %d bytes", objectArray));
    }

    public boolean hasMatch() {
        return this._match != null;
    }

    public MatchStrength getMatchStrength() {
        Object object = object._matchStrength;
        if (object == null) {
            object = MatchStrength.INCONCLUSIVE;
        }
        return object;
    }

    public JsonFactory getMatch() {
        return this._match;
    }

    public String getMatchedFormatName() {
        return this.hasMatch() ? this.getMatch().getFormatName() : null;
    }

    public JsonParser createParserWithMatch() {
        JsonFactory jsonFactory = ((DataFormatMatcher)object)._match;
        if (jsonFactory == null) {
            return null;
        }
        if (((DataFormatMatcher)object)._originalStream == null) {
            DataFormatMatcher dataFormatMatcher = object;
            Object object = dataFormatMatcher._bufferedData;
            int n2 = dataFormatMatcher._bufferedStart;
            int n3 = dataFormatMatcher._bufferedLength;
            return jsonFactory.createParser((byte[])object, n2, n3);
        }
        return jsonFactory.createParser(((DataFormatMatcher)object).getDataStream());
    }

    public InputStream getDataStream() {
        Object object;
        if (((DataFormatMatcher)object)._originalStream == null) {
            DataFormatMatcher dataFormatMatcher = object;
            object = dataFormatMatcher._bufferedData;
            int n2 = dataFormatMatcher._bufferedStart;
            int n3 = dataFormatMatcher._bufferedLength;
            return new ByteArrayInputStream((byte[])object, n2, n3);
        }
        DataFormatMatcher dataFormatMatcher = object;
        object = dataFormatMatcher._originalStream;
        byte[] byArray = dataFormatMatcher._bufferedData;
        int n4 = dataFormatMatcher._bufferedStart;
        int n5 = dataFormatMatcher._bufferedLength;
        return new MergedStream(null, (InputStream)object, byArray, n4, n5);
    }
}

