/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.format;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.format.DataFormatMatcher;
import com.privatefasterxml.jackson.core.format.MatchStrength;
import java.io.EOFException;
import java.io.InputStream;

public interface InputAccessor {
    public boolean hasMoreBytes();

    public byte nextByte();

    public void reset();

    public static class Std
    implements InputAccessor {
        protected final InputStream _in;
        protected final byte[] _buffer;
        protected final int _bufferedStart;
        protected int _bufferedEnd;
        protected int _ptr;

        public Std(InputStream inputStream, byte[] byArray) {
            this._in = inputStream;
            this._buffer = byArray;
            this._bufferedStart = 0;
            this._ptr = 0;
            this._bufferedEnd = 0;
        }

        public Std(byte[] byArray) {
            int n2 = byArray.length;
            this(byArray, 0, n2);
        }

        public Std(byte[] byArray, int n2, int n3) {
            this._in = null;
            this._buffer = byArray;
            this._ptr = n2;
            this._bufferedStart = n2;
            this._bufferedEnd = n2 + n3;
        }

        @Override
        public boolean hasMoreBytes() {
            int n2 = this._ptr;
            if (n2 < this._bufferedEnd) {
                return true;
            }
            InputStream inputStream = this._in;
            if (inputStream == null) {
                return false;
            }
            byte[] byArray = this._buffer;
            int n3 = this._buffer.length - n2;
            if (n3 < 1) {
                return false;
            }
            if ((n2 = inputStream.read(byArray, n2, n3)) <= 0) {
                return false;
            }
            this._bufferedEnd += n2;
            return true;
        }

        @Override
        public byte nextByte() {
            if (this._ptr >= this._bufferedEnd && !this.hasMoreBytes()) {
                throw new EOFException("Failed auto-detect: could not read more than " + this._ptr + " bytes (max buffer size: " + this._buffer.length + ")");
            }
            int n2 = this._ptr;
            this._ptr = n2 + 1;
            return this._buffer[n2];
        }

        @Override
        public void reset() {
            this._ptr = this._bufferedStart;
        }

        public DataFormatMatcher createMatcher(JsonFactory jsonFactory, MatchStrength matchStrength) {
            Std std = this;
            InputStream inputStream = std._in;
            byte[] byArray = std._buffer;
            int n2 = std._bufferedStart;
            int n3 = this._bufferedEnd - n2;
            return new DataFormatMatcher(inputStream, byArray, n2, n3, jsonFactory, matchStrength);
        }
    }
}

