/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import java.math.BigDecimal;
import java.util.Arrays;

public final class BigDecimalParser {
    private static final int MAX_CHARS_TO_REPORT = 1000;

    private BigDecimalParser() {
    }

    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        String string;
        if (n3 >= 500) return BigDecimalParser.parseBigDecimal(cArray, n2, n3, n3 / 10);
        try {
            return new BigDecimal(cArray, n2, n3);
        }
        catch (NumberFormatException runtimeException) {
        }
        catch (ArithmeticException runtimeException) {}
        String string2 = runtimeException.getMessage();
        if (string2 == null) {
            string2 = "Not a valid number representation";
        }
        if (n3 <= 1000) {
            String string3;
            string = string3;
            string3 = new String(cArray, n2, n3);
            throw new NumberFormatException("Value \"" + string + "\" can not be represented as `java.math.BigDecimal`, reason: " + string2);
        }
        string = new String(Arrays.copyOfRange(cArray, n2, 1000)) + "(truncated, full length is " + cArray.length + " chars)";
        throw new NumberFormatException("Value \"" + string + "\" can not be represented as `java.math.BigDecimal`, reason: " + string2);
    }

    public static BigDecimal parse(char[] cArray) {
        return BigDecimalParser.parse(cArray, 0, cArray.length);
    }

    /*
     * Unable to fully structure code
     */
    private static BigDecimal parseBigDecimal(char[] var0, int var1_2, int var2_3, int var3_4) {
        var4_5 = 0;
        var5_6 = 0;
        var6_7 = 0;
        var7_8 = -1;
        var8_9 = -1;
        var9_10 = 0;
        var2_3 = var1_2 + var2_3;
        v0 = var7_8;
        v1 = var9_10;
        v2 = var4_5;
        var7_8 = var6_7;
        var4_5 = var1_2;
        var6_7 = var5_6;
        var5_6 = v2;
        var9_10 = var8_9;
        var10_11 = v1;
        var8_9 = v0;
        while (var1_2 < var2_3) {
            block24: {
                block16: {
                    block17: {
                        block23: {
                            block18: {
                                block22: {
                                    block19: {
                                        block21: {
                                            block20: {
                                                var11_12 = var0[var1_2];
                                                if (var11_12 == '+') break block17;
                                                if (var11_12 == 'E' || var11_12 == 'e') break block18;
                                                if (var11_12 == '-') break block19;
                                                if (var11_12 == '.') break block20;
                                                if (var9_10 >= 0 && var8_9 == -1) {
                                                    ++var10_11;
                                                }
                                                break block16;
                                            }
                                            if (var9_10 >= 0) break block21;
                                            var9_10 = var1_2;
                                            break block16;
                                        }
                                        throw new NumberFormatException("Multiple decimal points");
                                    }
                                    if (var8_9 >= 0) {
                                        if (var6_7 == 0) {
                                            while (true) {
                                                var6_7 = 1;
                                                break block16;
                                                break;
                                            }
                                        }
                                        throw new NumberFormatException("Multiple signs in exponent");
                                    }
                                    if (var5_6 != 0) break block22;
                                    var4_5 = 1;
                                    var5_6 = 1;
                                    var7_8 = var1_2 + 1;
                                    v3 = var4_5;
                                    v4 = var7_8;
                                    var7_8 = var5_6;
                                    var4_5 = v4;
                                    var5_6 = v3;
                                    break block16;
                                }
                                throw new NumberFormatException("Multiple signs in number");
                            }
                            if (var8_9 >= 0) break block23;
                            var8_9 = var1_2;
                            break block16;
                        }
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    if (var8_9 >= 0) {
                        if (var6_7 == 0) ** continue;
                        throw new NumberFormatException("Multiple signs in exponent");
                    }
                    if (var5_6 != 0) break block24;
                    var4_5 = 1;
                    var5_6 = var1_2 + 1;
                    v5 = var4_5;
                    var4_5 = var5_6;
                    var5_6 = v5;
                }
                ++var1_2;
                continue;
            }
            throw new NumberFormatException("Multiple signs in number");
        }
        var1_2 = 0;
        if (var8_9 >= 0) {
            v6 = var8_9;
            var1_2 = v6 + 1;
            var1_2 = Integer.parseInt(new String((char[])var0, var1_2, var2_3 - v6 - 1));
            var10_11 = BigDecimalParser.adjustScale(var10_11, var1_2);
            var2_3 = var8_9;
        }
        if (var9_10 >= 0) {
            v7 = BigDecimalParser.toBigDecimalRec((char[])var0, var4_5, var9_10 - var4_5, var1_2, var3_4);
            v8 = var1_2;
            var0_1 = var2_3 - var9_10 - 1;
            var1_2 = var9_10 + 1;
            var2_3 = v8 - var0_1;
            var0 = v7.add(BigDecimalParser.toBigDecimalRec((char[])var0, var1_2, var0_1, var2_3, var3_4));
        } else {
            var0 = BigDecimalParser.toBigDecimalRec((char[])var0, var4_5, var2_3 - var4_5, var1_2, var3_4);
        }
        if (var10_11 != 0) {
            var0 = var0.setScale(var10_11);
        }
        if (var7_8 != 0) {
            var0 = var0.negate();
        }
        return var0;
    }

    private static int adjustScale(int n2, long l2) {
        StringBuilder stringBuilder;
        long l3 = (long)n2 - l2;
        if (l3 <= Integer.MAX_VALUE && l3 >= Integer.MIN_VALUE) {
            return (int)l3;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("Scale out of range: ");
        throw new NumberFormatException(stringBuilder.append(l3).append(" while adjusting scale ").append(n2).append(" to exponent ").append(l2).toString());
    }

    private static BigDecimal toBigDecimalRec(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n3 > n5) {
            int n6 = n3;
            int n7 = n6 / 2;
            int n8 = n2 + n7;
            return BigDecimalParser.toBigDecimalRec(cArray, n2, n7, n4 + n6 - n7, n5).add(BigDecimalParser.toBigDecimalRec(cArray, n8, n3 - n7, n4, n5));
        }
        return n3 == 0 ? BigDecimal.ZERO : new BigDecimal(cArray, n2, n3).movePointRight(n4);
    }
}

