/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.a;
import java.util.Arrays;

public final class CharTypes {
    protected static final char[] HC;
    protected static final char[] HClower;
    protected static final byte[] HB;
    protected static final byte[] HBlower;
    protected static final int[] sInputCodes;
    protected static final int[] sInputCodesUTF8;
    protected static final int[] sInputCodesJsNames;
    protected static final int[] sInputCodesUtf8JsNames;
    protected static final int[] sInputCodesComment;
    protected static final int[] sInputCodesWS;
    protected static final int[] sOutputEscapes128;
    protected static final int[] sHexValues;

    public static int[] getInputCodeLatin1() {
        return sInputCodes;
    }

    public static int[] getInputCodeUtf8() {
        return sInputCodesUTF8;
    }

    public static int[] getInputCodeLatin1JsNames() {
        return sInputCodesJsNames;
    }

    public static int[] getInputCodeUtf8JsNames() {
        return sInputCodesUtf8JsNames;
    }

    public static int[] getInputCodeComment() {
        return sInputCodesComment;
    }

    public static int[] getInputCodeWS() {
        return sInputCodesWS;
    }

    public static int[] get7BitOutputEscapes() {
        return sOutputEscapes128;
    }

    public static int[] get7BitOutputEscapes(int n2) {
        if (n2 == 34) {
            return sOutputEscapes128;
        }
        return a.b.a(n2);
    }

    public static int charToHex(int n2) {
        return sHexValues[n2 & 0xFF];
    }

    public static char hexToChar(int n2) {
        return HC[n2];
    }

    public static void appendQuoted(StringBuilder stringBuilder, String string) {
        int[] nArray = sOutputEscapes128;
        int n2 = sOutputEscapes128.length;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < n2 && nArray[c2] != 0) {
                stringBuilder.append('\\');
                int n4 = nArray[c2];
                if (n4 < 0) {
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2.append('u');
                    stringBuilder2.append('0');
                    stringBuilder2.append('0');
                    char[] cArray = HC;
                    stringBuilder.append(cArray[c2 >> 4]);
                    stringBuilder2.append(HC[c2 & 0xF]);
                    continue;
                }
                stringBuilder.append((char)n4);
                continue;
            }
            stringBuilder.append(c2);
        }
    }

    @Deprecated
    public static char[] copyHexChars() {
        return CharTypes.copyHexChars(true);
    }

    public static char[] copyHexChars(boolean bl) {
        return bl ? (char[])HC.clone() : (char[])HClower.clone();
    }

    @Deprecated
    public static byte[] copyHexBytes() {
        return CharTypes.copyHexBytes(true);
    }

    public static byte[] copyHexBytes(boolean bl) {
        return bl ? (byte[])HB.clone() : (byte[])HBlower.clone();
    }

    static {
        int n2;
        int n3;
        int n4;
        HC = "0123456789ABCDEF".toCharArray();
        HClower = "0123456789abcdef".toCharArray();
        int n5 = HC.length;
        HB = new byte[n5];
        HBlower = new byte[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            CharTypes.HB[n4] = (byte)HC[n4];
            CharTypes.HBlower[n4] = (byte)HClower[n4];
        }
        int[] nArray = new int[256];
        for (n4 = 0; n4 < 32; ++n4) {
            nArray[n4] = -1;
        }
        int[] nArray2 = nArray;
        nArray2[34] = 1;
        nArray2[92] = 1;
        sInputCodes = nArray2;
        int n6 = nArray2.length;
        int[] nArray3 = new int[n6];
        System.arraycopy(nArray, 0, nArray3, 0, n6);
        for (n6 = 128; n6 < 256; ++n6) {
            int n7 = (n6 & 0xE0) == 192 ? 2 : ((n6 & 0xF0) == 224 ? 3 : ((n6 & 0xF8) == 240 ? 4 : -1));
            nArray3[n6] = n7;
        }
        sInputCodesUTF8 = nArray3;
        int[] nArray4 = new int[256];
        Arrays.fill(nArray4, -1);
        for (int i2 = 33; i2 < 256; ++i2) {
            if (!Character.isJavaIdentifierPart((char)i2)) continue;
            nArray4[i2] = 0;
        }
        int[] nArray5 = nArray4;
        int[] nArray6 = nArray4;
        nArray5[64] = 0;
        nArray6[35] = 0;
        nArray5[42] = 0;
        nArray6[45] = 0;
        nArray5[43] = 0;
        sInputCodesJsNames = nArray6;
        int[] nArray7 = new int[256];
        System.arraycopy(nArray4, 0, nArray7, 0, 256);
        Arrays.fill(nArray7, 128, 128, 0);
        sInputCodesUtf8JsNames = nArray7;
        int[] nArray8 = new int[256];
        nArray4 = nArray8;
        nArray7 = sInputCodesUTF8;
        System.arraycopy(sInputCodesUTF8, 128, nArray4, 128, 128);
        Arrays.fill(nArray8, 0, 32, -1);
        nArray8[9] = 0;
        nArray8[10] = 10;
        nArray8[13] = 13;
        nArray8[42] = 42;
        sInputCodesComment = nArray8;
        int[] nArray9 = new int[256];
        nArray4 = nArray9;
        System.arraycopy(nArray7, 128, nArray4, 128, 128);
        Arrays.fill(nArray9, 0, 32, -1);
        nArray9[32] = 1;
        nArray9[9] = 1;
        nArray9[10] = 10;
        nArray9[13] = 13;
        nArray9[47] = 47;
        nArray9[35] = 35;
        sInputCodesWS = nArray9;
        nArray4 = new int[128];
        for (n3 = 0; n3 < 32; ++n3) {
            nArray4[n3] = -1;
        }
        int[] nArray10 = nArray4;
        int[] nArray11 = nArray4;
        nArray10[34] = 34;
        nArray11[92] = 92;
        nArray10[8] = 98;
        nArray11[9] = 116;
        nArray10[12] = 102;
        nArray11[10] = 110;
        nArray10[13] = 114;
        sOutputEscapes128 = nArray11;
        sHexValues = new int[256];
        Arrays.fill(sHexValues, -1);
        for (n2 = 0; n2 < 10; ++n2) {
            CharTypes.sHexValues[n2 + 48] = n2;
        }
        for (n2 = 0; n2 < 6; ++n2) {
            CharTypes.sHexValues[n2 + 97] = n3 = n2 + 10;
            CharTypes.sHexValues[n2 + 65] = n3;
        }
    }
}

