/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.JsonEncoding;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.util.BufferRecycler;
import com.privatefasterxml.jackson.core.util.TextBuffer;

public class IOContext {
    protected final ContentReference _contentReference;
    @Deprecated
    protected final Object _sourceRef;
    protected JsonEncoding _encoding;
    protected final boolean _managedResource;
    protected final BufferRecycler _bufferRecycler;
    protected byte[] _readIOBuffer;
    protected byte[] _writeEncodingBuffer;
    protected byte[] _base64Buffer;
    protected char[] _tokenCBuffer;
    protected char[] _concatCBuffer;
    protected char[] _nameCopyBuffer;

    public IOContext(BufferRecycler bufferRecycler, ContentReference contentReference, boolean bl) {
        this._bufferRecycler = bufferRecycler;
        this._contentReference = contentReference;
        this._sourceRef = contentReference.getRawContent();
        this._managedResource = bl;
    }

    @Deprecated
    public IOContext(BufferRecycler bufferRecycler, Object object, boolean bl) {
        this(bufferRecycler, ContentReference.rawReference(object), bl);
    }

    private IllegalArgumentException wrongBuf() {
        return new IllegalArgumentException("Trying to release buffer smaller than original");
    }

    public void setEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
    }

    public IOContext withEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
        return this;
    }

    public JsonEncoding getEncoding() {
        return this._encoding;
    }

    public boolean isResourceManaged() {
        return this._managedResource;
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    @Deprecated
    public Object getSourceReference() {
        return this._sourceRef;
    }

    public TextBuffer constructTextBuffer() {
        return new TextBuffer(this._bufferRecycler);
    }

    public byte[] allocReadIOBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._readIOBuffer);
        this._readIOBuffer = iOContext._bufferRecycler.allocByteBuffer(0);
        return this._readIOBuffer;
    }

    public byte[] allocReadIOBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._readIOBuffer);
        this._readIOBuffer = iOContext._bufferRecycler.allocByteBuffer(0, n2);
        return this._readIOBuffer;
    }

    public byte[] allocWriteEncodingBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._writeEncodingBuffer);
        this._writeEncodingBuffer = iOContext._bufferRecycler.allocByteBuffer(1);
        return this._writeEncodingBuffer;
    }

    public byte[] allocWriteEncodingBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._writeEncodingBuffer);
        this._writeEncodingBuffer = iOContext._bufferRecycler.allocByteBuffer(1, n2);
        return this._writeEncodingBuffer;
    }

    public byte[] allocBase64Buffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._base64Buffer);
        this._base64Buffer = iOContext._bufferRecycler.allocByteBuffer(3);
        return this._base64Buffer;
    }

    public byte[] allocBase64Buffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._base64Buffer);
        this._base64Buffer = iOContext._bufferRecycler.allocByteBuffer(3, n2);
        return this._base64Buffer;
    }

    public char[] allocTokenBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._tokenCBuffer);
        this._tokenCBuffer = iOContext._bufferRecycler.allocCharBuffer(0);
        return this._tokenCBuffer;
    }

    public char[] allocTokenBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._tokenCBuffer);
        this._tokenCBuffer = iOContext._bufferRecycler.allocCharBuffer(0, n2);
        return this._tokenCBuffer;
    }

    public char[] allocConcatBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._concatCBuffer);
        this._concatCBuffer = iOContext._bufferRecycler.allocCharBuffer(1);
        return this._concatCBuffer;
    }

    public char[] allocNameCopyBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._nameCopyBuffer);
        this._nameCopyBuffer = iOContext._bufferRecycler.allocCharBuffer(3, n2);
        return this._nameCopyBuffer;
    }

    public void releaseReadIOBuffer(byte[] byArray) {
        if (byArray != null) {
            IOContext iOContext = this;
            iOContext._verifyRelease(byArray, this._readIOBuffer);
            iOContext._readIOBuffer = null;
            iOContext._bufferRecycler.releaseByteBuffer(0, byArray);
        }
    }

    public void releaseWriteEncodingBuffer(byte[] byArray) {
        if (byArray != null) {
            IOContext iOContext = this;
            iOContext._verifyRelease(byArray, this._writeEncodingBuffer);
            iOContext._writeEncodingBuffer = null;
            iOContext._bufferRecycler.releaseByteBuffer(1, byArray);
        }
    }

    public void releaseBase64Buffer(byte[] byArray) {
        if (byArray != null) {
            IOContext iOContext = this;
            iOContext._verifyRelease(byArray, this._base64Buffer);
            iOContext._base64Buffer = null;
            iOContext._bufferRecycler.releaseByteBuffer(3, byArray);
        }
    }

    public void releaseTokenBuffer(char[] cArray) {
        if (cArray != null) {
            IOContext iOContext = this;
            iOContext._verifyRelease(cArray, this._tokenCBuffer);
            iOContext._tokenCBuffer = null;
            iOContext._bufferRecycler.releaseCharBuffer(0, cArray);
        }
    }

    public void releaseConcatBuffer(char[] cArray) {
        if (cArray != null) {
            IOContext iOContext = this;
            iOContext._verifyRelease(cArray, this._concatCBuffer);
            iOContext._concatCBuffer = null;
            iOContext._bufferRecycler.releaseCharBuffer(1, cArray);
        }
    }

    public void releaseNameCopyBuffer(char[] cArray) {
        if (cArray != null) {
            IOContext iOContext = this;
            iOContext._verifyRelease(cArray, this._nameCopyBuffer);
            iOContext._nameCopyBuffer = null;
            iOContext._bufferRecycler.releaseCharBuffer(3, cArray);
        }
    }

    public final void _verifyAlloc(Object object) {
        if (object == null) {
            return;
        }
        throw new IllegalStateException("Trying to call same allocXxx() method second time");
    }

    public final void _verifyRelease(byte[] byArray, byte[] byArray2) {
        if (byArray != byArray2 && byArray.length < byArray2.length) {
            throw this.wrongBuf();
        }
    }

    public final void _verifyRelease(char[] cArray, char[] cArray2) {
        if (cArray != cArray2 && cArray.length < cArray2.length) {
            throw this.wrongBuf();
        }
    }
}

