/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.UTF8Writer;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.TextBuffer;
import java.util.Arrays;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars(true);
    private static final byte[] HB = CharTypes.copyHexBytes(true);
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    static final int MIN_CHAR_BUFFER_SIZE = 16;
    static final int MAX_CHAR_BUFFER_SIZE = 32000;
    static final int MIN_BYTE_BUFFER_SIZE = 24;
    static final int MAX_BYTE_BUFFER_SIZE = 32000;
    private static final JsonStringEncoder instance = new JsonStringEncoder();

    public static JsonStringEncoder getInstance() {
        return instance;
    }

    private char[] _qbuf() {
        char[] cArray = new char[6];
        cArray[0] = 92;
        cArray[2] = 48;
        cArray[3] = 48;
        return cArray;
    }

    private int _appendNumeric(int n2, char[] cArray) {
        cArray[1] = 117;
        Object object = HC;
        cArray[4] = (char)object[n2 >> 4];
        cArray[5] = HC[n2 & 0xF];
        return 6;
    }

    private int _appendNamed(int n2, char[] cArray) {
        cArray[1] = (char)n2;
        return 2;
    }

    private int _appendByte(int n2, int n3, ByteArrayBuilder byteArrayBuilder, int n4) {
        ByteArrayBuilder byteArrayBuilder2 = byteArrayBuilder;
        byteArrayBuilder2.setCurrentSegmentLength(n4);
        byteArrayBuilder2.append(92);
        if (n3 < 0) {
            byteArrayBuilder.append(117);
            if (n2 > 255) {
                int n5 = n2 >> 8;
                byte[] byArray = HB;
                byteArrayBuilder.append(byArray[n2 >> 12]);
                byteArrayBuilder.append(HB[n5 & 0xF]);
                n2 &= 0xFF;
            } else {
                ByteArrayBuilder byteArrayBuilder3 = byteArrayBuilder;
                byteArrayBuilder3.append(48);
                byteArrayBuilder3.append(48);
            }
            byte[] byArray = HB;
            byteArrayBuilder.append(byArray[n2 >> 4]);
            byteArrayBuilder.append(HB[n2 & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n3);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private static int _convert(int n2, int n3) {
        if (n3 >= 56320 && n3 <= 57343) {
            n2 = (n2 - 55296 << 10) + 65536;
            return n3 - 56320 + n2;
        }
        throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3) + "; illegal combination");
    }

    private static void _illegal(int n2) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(n2));
    }

    public static int _initialCharBufSize(int n2) {
        return Math.min(Math.max(16, Math.min((n2 >> 3) + 6, 1000) + n2), 32000);
    }

    public static int _initialByteBufSize(int n2) {
        return Math.min(Math.max(24, n2 + 6 + (n2 >> 1)), 32000);
    }

    public char[] quoteAsString(String string) {
        int n2 = string.length();
        char[] cArray = new char[JsonStringEncoder._initialCharBufSize(n2)];
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n3 = nArray.length;
        int n4 = 0;
        TextBuffer textBuffer = null;
        int n5 = 0;
        char[] cArray2 = null;
        block0: while (n4 < n2) {
            while (true) {
                int n6;
                int n7;
                if ((n7 = string.charAt(n4)) < n3 && nArray[n7] != 0) {
                    if (cArray2 == null) {
                        cArray2 = this._qbuf();
                    }
                    n7 = n4 + 1;
                    char c2 = string.charAt(n4);
                    n4 = c2;
                    n6 = nArray[c2];
                    n4 = n6 < 0 ? this._appendNumeric(n4, cArray2) : this._appendNamed(n6, cArray2);
                    n6 = n5 + n4;
                    if (n6 > cArray.length) {
                        n6 = cArray.length - n5;
                        if (n6 > 0) {
                            System.arraycopy(cArray2, 0, cArray, n5, n6);
                        }
                        if (textBuffer == null) {
                            textBuffer = TextBuffer.fromInitial(cArray);
                        }
                        cArray = textBuffer.finishCurrentSegment();
                        System.arraycopy(cArray2, n6, cArray, 0, n4 -= n6);
                        n5 = n4;
                    } else {
                        System.arraycopy(cArray2, 0, cArray, n5, n4);
                        n5 = n6;
                    }
                    n4 = n7;
                    continue block0;
                }
                if (n5 >= cArray.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(cArray);
                    }
                    cArray = textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                n6 = n5 + 1;
                cArray[n5] = n7;
                if (++n4 >= n2) {
                    n5 = n6;
                    break block0;
                }
                n5 = n6;
            }
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(cArray, 0, n5);
        }
        TextBuffer textBuffer2 = textBuffer;
        textBuffer2.setCurrentLength(n5);
        return textBuffer2.contentsAsArray();
    }

    public char[] quoteAsString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return this.quoteAsString((String)charSequence);
        }
        TextBuffer textBuffer = null;
        int n2 = charSequence.length();
        char[] cArray = new char[JsonStringEncoder._initialCharBufSize(n2)];
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        char[] cArray2 = null;
        block0: while (n4 < n2) {
            while (true) {
                int n6;
                int n7;
                if ((n7 = charSequence.charAt(n4)) < n3 && nArray[n7] != 0) {
                    if (cArray2 == null) {
                        cArray2 = this._qbuf();
                    }
                    n7 = n4 + 1;
                    char c2 = charSequence.charAt(n4);
                    n4 = c2;
                    n6 = nArray[c2];
                    n4 = n6 < 0 ? this._appendNumeric(n4, cArray2) : this._appendNamed(n6, cArray2);
                    n6 = n5 + n4;
                    if (n6 > cArray.length) {
                        n6 = cArray.length - n5;
                        if (n6 > 0) {
                            System.arraycopy(cArray2, 0, cArray, n5, n6);
                        }
                        if (textBuffer == null) {
                            textBuffer = TextBuffer.fromInitial(cArray);
                        }
                        cArray = textBuffer.finishCurrentSegment();
                        System.arraycopy(cArray2, n6, cArray, 0, n4 -= n6);
                        n5 = n4;
                    } else {
                        System.arraycopy(cArray2, 0, cArray, n5, n4);
                        n5 = n6;
                    }
                    n4 = n7;
                    continue block0;
                }
                if (n5 >= cArray.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(cArray);
                    }
                    cArray = textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                n6 = n5 + 1;
                cArray[n5] = n7;
                if (++n4 >= n2) {
                    n5 = n6;
                    break block0;
                }
                n5 = n6;
            }
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(cArray, 0, n5);
        }
        TextBuffer textBuffer2 = textBuffer;
        textBuffer2.setCurrentLength(n5);
        return textBuffer2.contentsAsArray();
    }

    public void quoteAsString(CharSequence charSequence, StringBuilder stringBuilder) {
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = charSequence.length();
        char[] cArray = null;
        block0: while (n3 < n4) {
            do {
                int n5;
                if ((n5 = charSequence.charAt(n3)) < n2 && nArray[n5] != 0) {
                    if (cArray == null) {
                        cArray = this._qbuf();
                    }
                    n5 = n3 + 1;
                    char c2 = charSequence.charAt(n3);
                    n3 = c2;
                    int n6 = nArray[c2];
                    n3 = n6 < 0 ? this._appendNumeric(n3, cArray) : this._appendNamed(n6, cArray);
                    stringBuilder.append(cArray, 0, n3);
                    n3 = n5;
                    continue block0;
                }
                stringBuilder.append((char)n5);
            } while (++n3 < n4);
        }
    }

    public byte[] quoteAsUTF8(String string) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        Object[] objectArray = new byte[JsonStringEncoder._initialByteBufSize(n3)];
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n2 < n3) {
            int n5;
            int n6;
            Object[] objectArray2 = CharTypes.get7BitOutputEscapes();
            while ((n6 = string.charAt(n2)) <= 127 && objectArray2[n6] == 0) {
                if (n4 >= objectArray.length) {
                    int n7;
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(objectArray, n4);
                    }
                    byte[] byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = n7 = 0;
                    objectArray = byArray;
                }
                int n8 = n6;
                n6 = n4 + 1;
                objectArray[n4] = (byte)n8;
                if (++n2 >= n3) {
                    n4 = n6;
                    break block0;
                }
                n4 = n6;
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(objectArray, n4);
            }
            if (n4 >= objectArray.length) {
                objectArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            n6 = n2 + 1;
            char c2 = string.charAt(n2);
            if (c2 <= '\u007f') {
                n4 = this._appendByte(c2, objectArray2[c2], byteArrayBuilder, n4);
                objectArray = byteArrayBuilder.getCurrentSegment();
                n2 = n6;
                continue;
            }
            if (c2 <= '\u07ff') {
                n2 = n4 + 1;
                objectArray[n4] = (byte)(c2 >> 6 | 0xC0);
                n5 = n4 = c2 & 0x3F | 0x80;
                n4 = n6;
                objectArray2 = objectArray;
            } else if (c2 >= '\ud800' && c2 <= '\udfff') {
                if (c2 > '\udbff') {
                    JsonStringEncoder._illegal(c2);
                }
                if (n6 >= n3) {
                    JsonStringEncoder._illegal(c2);
                }
                n2 += 2;
                int n9 = JsonStringEncoder._convert(c2, string.charAt(n6));
                if (n9 > 0x10FFFF) {
                    JsonStringEncoder._illegal(n9);
                }
                n6 = n4 + 1;
                objectArray[n4] = (byte)(n9 >> 18 | 0xF0);
                if (n6 >= objectArray.length) {
                    objectArray = byteArrayBuilder.finishCurrentSegment();
                    n6 = 0;
                }
                n4 = n6 + 1;
                objectArray[n6] = (byte)(n9 >> 12 & 0x3F | 0x80);
                if (n4 >= objectArray.length) {
                    int n10;
                    byte[] byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = n10 = 0;
                    objectArray = byArray;
                }
                objectArray[n4++] = (byte)(n9 >> 6 & 0x3F | 0x80);
                n9 = n9 & 0x3F | 0x80;
                int n11 = n4;
                n5 = n9;
                n4 = n2;
                objectArray2 = objectArray;
                n2 = n11;
            } else {
                n2 = n4 + 1;
                objectArray[n4] = (byte)(c2 >> 12 | 0xE0);
                if (n2 >= objectArray.length) {
                    objectArray = byteArrayBuilder.finishCurrentSegment();
                    n2 = 0;
                }
                objectArray[n2++] = (byte)(c2 >> 6 & 0x3F | 0x80);
                n5 = n4 = c2 & 0x3F | 0x80;
                n4 = n6;
                objectArray2 = objectArray;
            }
            if (n2 >= objectArray2.length) {
                int n12;
                byte[] byArray = byteArrayBuilder.finishCurrentSegment();
                n2 = n12 = 0;
                objectArray2 = byArray;
            }
            int n13 = n5;
            n5 = n2 + 1;
            objectArray2[n2] = (byte)n13;
            int n14 = n4;
            objectArray = objectArray2;
            n4 = n5;
            n2 = n14;
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(objectArray, 0, n4);
        }
        return byteArrayBuilder.completeAndCoalesce(n4);
    }

    public byte[] encodeAsUTF8(String string) {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        int n5 = JsonStringEncoder._initialByteBufSize(n3);
        byte[] byArray = new byte[n5];
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n2 < n3) {
            int n6;
            int n7;
            byte[] byArray2;
            int n8 = n2 + 1;
            n2 = string.charAt(n2);
            while (n2 <= 127) {
                if (n4 >= n5) {
                    int n9;
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
                    }
                    byte[] byArray3 = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray3.length;
                    n4 = n9 = 0;
                    byArray = byArray3;
                }
                int n10 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)n10;
                if (n8 >= n3) {
                    n4 = n2;
                    break block0;
                }
                n4 = n8 + 1;
                int n11 = n8 = (int)string.charAt(n8);
                n8 = n4;
                n4 = n2;
                n2 = n11;
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            if (n2 < 2048) {
                byArray[n4++] = (byte)(n2 >> 6 | 0xC0);
                int n12 = n4;
                n4 = n2;
                byArray2 = byArray;
                n2 = n8;
                n7 = n5;
                n5 = n12;
            } else if (n2 >= 55296 && n2 <= 57343) {
                if (n2 > 56319) {
                    JsonStringEncoder._illegal(n2);
                }
                if (n8 >= n3) {
                    JsonStringEncoder._illegal(n2);
                }
                int n13 = n2;
                int n14 = n8;
                n2 = n14 + 1;
                n8 = JsonStringEncoder._convert(n13, string.charAt(n14));
                if (n8 > 0x10FFFF) {
                    JsonStringEncoder._illegal(n8);
                }
                n6 = n4 + 1;
                byArray[n4] = (byte)(n8 >> 18 | 0xF0);
                if (n6 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n6 = 0;
                }
                n4 = n6 + 1;
                byArray[n6] = (byte)(n8 >> 12 & 0x3F | 0x80);
                if (n4 >= n5) {
                    int n15;
                    byte[] byArray4 = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray4.length;
                    n4 = n15 = 0;
                    byArray = byArray4;
                }
                byArray[n4++] = (byte)(n8 >> 6 & 0x3F | 0x80);
                int n16 = n4;
                n4 = n8;
                byArray2 = byArray;
                n7 = n5;
                n5 = n16;
            } else {
                n6 = n4 + 1;
                byArray[n4] = (byte)(n2 >> 12 | 0xE0);
                if (n6 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n6 = 0;
                }
                n4 = n6 + 1;
                byArray[n6] = (byte)(n2 >> 6 & 0x3F | 0x80);
                int n17 = n4;
                n4 = n2;
                byArray2 = byArray;
                n2 = n8;
                n7 = n5;
                n5 = n17;
            }
            if (n5 >= n7) {
                int n18;
                byte[] byArray5 = byteArrayBuilder.finishCurrentSegment();
                n7 = byArray5.length;
                n5 = n18 = 0;
                byArray2 = byArray5;
            }
            int n19 = n4;
            n4 = n5 + 1;
            byArray2[n5] = (byte)(n19 & 0x3F | 0x80);
            n5 = n7;
            byArray = byArray2;
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n4);
        }
        return byteArrayBuilder.completeAndCoalesce(n4);
    }

    public byte[] encodeAsUTF8(CharSequence charSequence) {
        int n2 = 0;
        int n3 = charSequence.length();
        int n4 = 0;
        int n5 = JsonStringEncoder._initialByteBufSize(n3);
        byte[] byArray = new byte[n5];
        ByteArrayBuilder byteArrayBuilder = null;
        block0: while (n2 < n3) {
            int n6;
            int n7;
            byte[] byArray2;
            int n8 = n2 + 1;
            n2 = charSequence.charAt(n2);
            while (n2 <= 127) {
                if (n4 >= n5) {
                    int n9;
                    if (byteArrayBuilder == null) {
                        byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
                    }
                    byte[] byArray3 = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray3.length;
                    n4 = n9 = 0;
                    byArray = byArray3;
                }
                int n10 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)n10;
                if (n8 >= n3) {
                    n4 = n2;
                    break block0;
                }
                n4 = n8 + 1;
                int n11 = n8 = (int)charSequence.charAt(n8);
                n8 = n4;
                n4 = n2;
                n2 = n11;
            }
            if (byteArrayBuilder == null) {
                byteArrayBuilder = ByteArrayBuilder.fromInitial(byArray, n4);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            if (n2 < 2048) {
                byArray[n4++] = (byte)(n2 >> 6 | 0xC0);
                int n12 = n4;
                n4 = n2;
                byArray2 = byArray;
                n2 = n8;
                n7 = n5;
                n5 = n12;
            } else if (n2 >= 55296 && n2 <= 57343) {
                if (n2 > 56319) {
                    JsonStringEncoder._illegal(n2);
                }
                if (n8 >= n3) {
                    JsonStringEncoder._illegal(n2);
                }
                int n13 = n2;
                int n14 = n8;
                n2 = n14 + 1;
                n8 = JsonStringEncoder._convert(n13, charSequence.charAt(n14));
                if (n8 > 0x10FFFF) {
                    JsonStringEncoder._illegal(n8);
                }
                n6 = n4 + 1;
                byArray[n4] = (byte)(n8 >> 18 | 0xF0);
                if (n6 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n6 = 0;
                }
                n4 = n6 + 1;
                byArray[n6] = (byte)(n8 >> 12 & 0x3F | 0x80);
                if (n4 >= n5) {
                    int n15;
                    byte[] byArray4 = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray4.length;
                    n4 = n15 = 0;
                    byArray = byArray4;
                }
                byArray[n4++] = (byte)(n8 >> 6 & 0x3F | 0x80);
                int n16 = n4;
                n4 = n8;
                byArray2 = byArray;
                n7 = n5;
                n5 = n16;
            } else {
                n6 = n4 + 1;
                byArray[n4] = (byte)(n2 >> 12 | 0xE0);
                if (n6 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n6 = 0;
                }
                n4 = n6 + 1;
                byArray[n6] = (byte)(n2 >> 6 & 0x3F | 0x80);
                int n17 = n4;
                n4 = n2;
                byArray2 = byArray;
                n2 = n8;
                n7 = n5;
                n5 = n17;
            }
            if (n5 >= n7) {
                int n18;
                byte[] byArray5 = byteArrayBuilder.finishCurrentSegment();
                n7 = byArray5.length;
                n5 = n18 = 0;
                byArray2 = byArray5;
            }
            int n19 = n4;
            n4 = n5 + 1;
            byArray2[n5] = (byte)(n19 & 0x3F | 0x80);
            n5 = n7;
            byArray = byArray2;
        }
        if (byteArrayBuilder == null) {
            return Arrays.copyOfRange(byArray, 0, n4);
        }
        return byteArrayBuilder.completeAndCoalesce(n4);
    }
}

