/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.IOContext;
import java.io.InputStream;

public final class MergedStream
extends InputStream {
    private final IOContext _ctxt;
    private final InputStream _in;
    private byte[] _b;
    private int _ptr;
    private final int _end;

    public MergedStream(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3) {
        this._ctxt = iOContext;
        this._in = inputStream;
        this._b = byArray;
        this._ptr = n2;
        this._end = n3;
    }

    private void _free() {
        byte[] byArray = ((MergedStream)((Object)iOContext))._b;
        if (((MergedStream)((Object)iOContext))._b != null) {
            ((MergedStream)((Object)iOContext))._b = null;
            IOContext iOContext = ((MergedStream)((Object)iOContext))._ctxt;
            if (iOContext != null) {
                iOContext.releaseReadIOBuffer(byArray);
            }
        }
    }

    @Override
    public int available() {
        if (this._b != null) {
            return this._end - this._ptr;
        }
        return this._in.available();
    }

    @Override
    public void close() {
        MergedStream mergedStream = this;
        mergedStream._free();
        mergedStream._in.close();
    }

    @Override
    public synchronized void mark(int n2) {
        if (this._b == null) {
            this._in.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this._b == null && this._in.markSupported();
    }

    @Override
    public int read() {
        byte[] byArray = this._b;
        if (this._b != null) {
            int n2;
            int n3 = this._ptr;
            this._ptr = n2 = n3 + 1;
            int n4 = byArray[n3] & 0xFF;
            if (n2 >= this._end) {
                this._free();
            }
            return n4;
        }
        return this._in.read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this._b;
        if (this._b != null) {
            int n4;
            int n5 = this._ptr;
            int n6 = this._end - n5;
            if (n3 > n6) {
                n3 = n6;
            }
            System.arraycopy(byArray2, n5, byArray, n2, n3);
            this._ptr = n4 = this._ptr + n3;
            if (n4 >= this._end) {
                this._free();
            }
            return n3;
        }
        return this._in.read(byArray, n2, n3);
    }

    @Override
    public synchronized void reset() {
        if (this._b == null) {
            this._in.reset();
        }
    }

    @Override
    public long skip(long l2) {
        long l3 = 0L;
        if (this._b != null) {
            int n2 = this._ptr;
            long l4 = this._end - n2;
            if (l4 > l2) {
                this._ptr = n2 + (int)l2;
                return l2;
            }
            this._free();
            l2 -= l4;
            l3 = l4;
        }
        if (l2 > 0L) {
            l3 = this._in.skip(l2) + l3;
        }
        return l3;
    }
}

