/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.BigDecimalParser;
import com.privatefasterxml.jackson.core.io.doubleparser.FastDoubleParser;
import com.privatefasterxml.jackson.core.io.doubleparser.FastFloatParser;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberInput {
    private static final int LARGE_INT_SIZE = 1250;
    @Deprecated
    public static final String NASTY_SMALL_DOUBLE = "2.2250738585072012e-308";
    static final long L_BILLION = 1000000000L;
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);

    public static int parseInt(char[] cArray, int n2, int n3) {
        if (n3 > 0 && cArray[n2] == '+') {
            ++n2;
        }
        int n4 = --n3;
        n3 = cArray[n2 + n3 - 1] - 48;
        switch (n4) {
            default: {
                break;
            }
            case 9: {
                n3 = (cArray[n2++] - 48) * 100000000 + n3;
            }
            case 8: {
                n3 = (cArray[n2++] - 48) * 10000000 + n3;
            }
            case 7: {
                n3 = (cArray[n2++] - 48) * 1000000 + n3;
            }
            case 6: {
                n3 = (cArray[n2++] - 48) * 100000 + n3;
            }
            case 5: {
                n3 = (cArray[n2++] - 48) * 10000 + n3;
            }
            case 4: {
                n3 = (cArray[n2++] - 48) * 1000 + n3;
            }
            case 3: {
                n3 = (cArray[n2++] - 48) * 100 + n3;
            }
            case 2: {
                n3 = (cArray[n2] - 48) * 10 + n3;
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseInt(String string) {
        int n2 = string.charAt(0);
        int n3 = string.length();
        boolean bl = n2 == 45;
        int n4 = 1;
        if (bl) {
            if (n3 == 1) return Integer.parseInt(string);
            if (n3 > 10) return Integer.parseInt(string);
            n2 = 2;
            int n5 = n4 = (int)string.charAt(n4);
            n4 = n2;
            n2 = n5;
        } else if (n3 > 9) {
            return Integer.parseInt(string);
        }
        if (n2 > 57) return Integer.parseInt(string);
        if (n2 < 48) return Integer.parseInt(string);
        n2 -= 48;
        if (n4 < n3) {
            int n6 = n4 + 1;
            char c2 = string.charAt(n4);
            if (c2 > '9') return Integer.parseInt(string);
            if (c2 < '0') return Integer.parseInt(string);
            n2 *= 10;
            n2 = c2 - 48 + n2;
            if (n6 < n3) {
                n4 += 2;
                char c3 = string.charAt(n6);
                n6 = c3;
                if (c3 > '9') return Integer.parseInt(string);
                if (n6 < 48) return Integer.parseInt(string);
                n2 *= 10;
                n2 = n6 - 48 + n2;
                if (n4 < n3) {
                    while (true) {
                        n6 = n4 + 1;
                        char c4 = string.charAt(n4);
                        n4 = c4;
                        if (c4 > '9') return Integer.parseInt(string);
                        if (n4 < 48) return Integer.parseInt(string);
                        n2 *= 10;
                        n2 = n4 - 48 + n2;
                        if (n6 >= n3) break;
                        n4 = n6;
                    }
                }
            }
        }
        if (!bl) return n2;
        return -n2;
    }

    public static long parseLong(char[] cArray, int n2, int n3) {
        return (long)NumberInput.parseInt(cArray, n2, n3 -= 9) * 1000000000L + (long)NumberInput.parseInt(cArray, n2 + n3, 9);
    }

    public static long parseLong(String string) {
        if (string.length() <= 9) {
            return NumberInput.parseInt(string);
        }
        return Long.parseLong(string);
    }

    public static boolean inLongRange(char[] cArray, int n2, int n3, boolean bl) {
        String string = bl ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int n4 = string.length();
        if (n3 < n4) {
            return true;
        }
        if (n3 > n4) {
            return false;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = cArray[n2 + n3] - string.charAt(n3);
            if (n5 == 0) continue;
            return n5 < 0;
        }
        return true;
    }

    public static boolean inLongRange(String string, boolean bl) {
        String string2 = bl ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int n2 = string2.length();
        int n3 = string.length();
        if (n3 < n2) {
            return true;
        }
        if (n3 > n2) {
            return false;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = string.charAt(n3) - string2.charAt(n3);
            if (n4 == 0) continue;
            return n4 < 0;
        }
        return true;
    }

    public static int parseAsInt(String string, int n2) {
        if (string == null) {
            return n2;
        }
        int n3 = (string = string.trim()).length();
        if (n3 == 0) {
            return n2;
        }
        int n4 = 0;
        char c2 = string.charAt(0);
        if (c2 == '+') {
            string = string.substring(1);
            n3 = string.length();
        } else if (c2 == '-') {
            n4 = 1;
        }
        while (n4 < n3) {
            c2 = string.charAt(n4);
            if (c2 <= '9' && c2 >= '0') {
                ++n4;
                continue;
            }
            try {
                return (int)NumberInput.parseDouble(string, true);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static long parseAsLong(String string, long l2) {
        if (string == null) {
            return l2;
        }
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return l2;
        }
        int n3 = 0;
        char c2 = string.charAt(0);
        if (c2 == '+') {
            string = string.substring(1);
            n2 = string.length();
        } else if (c2 == '-') {
            n3 = 1;
        }
        while (n3 < n2) {
            c2 = string.charAt(n3);
            if (c2 <= '9' && c2 >= '0') {
                ++n3;
                continue;
            }
            try {
                return (long)NumberInput.parseDouble(string, true);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public static double parseAsDouble(String string, double d2) {
        return NumberInput.parseAsDouble(string, d2, false);
    }

    public static double parseAsDouble(String string, double d2, boolean bl) {
        if (string == null) {
            return d2;
        }
        if ((string = string.trim()).length() == 0) {
            return d2;
        }
        try {
            return NumberInput.parseDouble(string, bl);
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public static double parseDouble(String string) {
        return NumberInput.parseDouble(string, false);
    }

    public static double parseDouble(String string, boolean bl) {
        return bl ? FastDoubleParser.parseDouble(string) : Double.parseDouble(string);
    }

    public static float parseFloat(String string) {
        return NumberInput.parseFloat(string, false);
    }

    public static float parseFloat(String string, boolean bl) {
        return bl ? FastFloatParser.parseFloat(string) : Float.parseFloat(string);
    }

    public static BigDecimal parseBigDecimal(String string) {
        return BigDecimalParser.parse(string);
    }

    public static BigDecimal parseBigDecimal(char[] cArray, int n2, int n3) {
        return BigDecimalParser.parse(cArray, n2, n3);
    }

    public static BigDecimal parseBigDecimal(char[] cArray) {
        return BigDecimalParser.parse(cArray);
    }

    public static BigInteger parseBigInteger(String string) {
        if (string.length() > 1250) {
            return BigDecimalParser.parse(string).toBigInteger();
        }
        return new BigInteger(string);
    }
}

