/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.schubfach.DoubleToDecimal;
import com.privatefasterxml.jackson.core.io.schubfach.FloatToDecimal;

public final class NumberOutput {
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long BILLION_L = 1000000000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_INT = String.valueOf(Integer.MIN_VALUE);
    static final String SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
    private static final int[] TRIPLET_TO_CHARS = new int[1000];
    private static final String[] sSmallIntStrs;
    private static final String[] sSmallIntStrs2;

    public static int outputInt(int n2, char[] cArray, int n3) {
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberOutput._outputSmallestI(cArray, n3);
            }
            int n4 = n2;
            n2 = n3 + 1;
            cArray[n3] = 45;
            int n5 = n3 = -n4;
            n3 = n2;
            n2 = n5;
        }
        if (n2 < MILLION) {
            if (n2 < 1000) {
                if (n2 < 10) {
                    cArray[n3] = (char)(n2 + 48);
                    return n3 + 1;
                }
                return NumberOutput._leading3(n2, cArray, n3);
            }
            int n6 = n2;
            n2 = n6 / 1000;
            return NumberOutput._full3(n6 - n2 * 1000, cArray, NumberOutput._leading3(n2, cArray, n3));
        }
        int n7 = BILLION;
        if (n2 >= n7) {
            if ((n2 -= n7) >= n7) {
                n2 -= n7;
                n7 = n3 + 1;
                cArray[n3] = 50;
            } else {
                n7 = n3 + 1;
                cArray[n3] = 49;
            }
            return NumberOutput._outputFullBillion(n2, cArray, n7);
        }
        int n8 = n2;
        int n9 = n8 / 1000;
        int n10 = n2 = n9;
        n2 = n10 / 1000;
        return NumberOutput._full3(n8 - n9 * 1000, cArray, NumberOutput._full3(n10 - n2 * 1000, cArray, NumberOutput._leading3(n2, cArray, n3)));
    }

    public static int outputInt(int n2, byte[] byArray, int n3) {
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberOutput._outputSmallestI(byArray, n3);
            }
            int n4 = n2;
            n2 = n3 + 1;
            byArray[n3] = 45;
            int n5 = n3 = -n4;
            n3 = n2;
            n2 = n5;
        }
        if (n2 < MILLION) {
            if (n2 < 1000) {
                if (n2 < 10) {
                    int n6 = n2;
                    n2 = n3 + 1;
                    byArray[n3] = (byte)(n6 + 48);
                } else {
                    n2 = NumberOutput._leading3(n2, byArray, n3);
                }
            } else {
                int n7 = n2;
                n2 = n7 / 1000;
                n2 = NumberOutput._full3(n7 - n2 * 1000, byArray, NumberOutput._leading3(n2, byArray, n3));
            }
            return n2;
        }
        int n8 = BILLION;
        if (n2 >= n8) {
            if ((n2 -= n8) >= n8) {
                n2 -= n8;
                n8 = n3 + 1;
                byArray[n3] = 50;
            } else {
                n8 = n3 + 1;
                byArray[n3] = 49;
            }
            return NumberOutput._outputFullBillion(n2, byArray, n8);
        }
        int n9 = n2;
        int n10 = n9 / 1000;
        int n11 = n2 = n10;
        n2 = n11 / 1000;
        return NumberOutput._full3(n9 - n10 * 1000, byArray, NumberOutput._full3(n11 - n2 * 1000, byArray, NumberOutput._leading3(n2, byArray, n3)));
    }

    public static int outputLong(long l2, char[] cArray, int n2) {
        long l3;
        if (l2 < 0L) {
            if (l2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l2, cArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                return NumberOutput._outputSmallestL(cArray, n2);
            }
            int n3 = n2 + 1;
            cArray[n2] = 45;
            l3 = -l2;
            n2 = n3;
            l2 = l3;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l2, cArray, n2);
        }
        l3 = BILLION_L;
        long l4 = l2 / l3;
        l2 -= l4 * l3;
        if (l4 < l3) {
            n2 = NumberOutput._outputUptoBillion((int)l4, cArray, n2);
        } else {
            long l5 = l4;
            l4 = l5 / l3;
            n2 = NumberOutput._leading3((int)l4, cArray, n2);
            n2 = NumberOutput._outputFullBillion((int)(l5 - l4 * l3), cArray, n2);
        }
        return NumberOutput._outputFullBillion((int)l2, cArray, n2);
    }

    public static int outputLong(long l2, byte[] byArray, int n2) {
        long l3;
        if (l2 < 0L) {
            if (l2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l2, byArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                return NumberOutput._outputSmallestL(byArray, n2);
            }
            int n3 = n2 + 1;
            byArray[n2] = 45;
            l3 = -l2;
            n2 = n3;
            l2 = l3;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l2, byArray, n2);
        }
        l3 = BILLION_L;
        long l4 = l2 / l3;
        l2 -= l4 * l3;
        if (l4 < l3) {
            n2 = NumberOutput._outputUptoBillion((int)l4, byArray, n2);
        } else {
            long l5 = l4;
            l4 = l5 / l3;
            n2 = NumberOutput._leading3((int)l4, byArray, n2);
            n2 = NumberOutput._outputFullBillion((int)(l5 - l4 * l3), byArray, n2);
        }
        return NumberOutput._outputFullBillion((int)l2, byArray, n2);
    }

    public static String toString(int n2) {
        String[] stringArray = sSmallIntStrs;
        if (n2 < sSmallIntStrs.length) {
            if (n2 >= 0) {
                return stringArray[n2];
            }
            int n3 = -n2 - 1;
            String[] stringArray2 = sSmallIntStrs2;
            if (n3 < sSmallIntStrs2.length) {
                return stringArray2[n3];
            }
        }
        return Integer.toString(n2);
    }

    public static String toString(long l2) {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)l2);
        }
        return Long.toString(l2);
    }

    public static String toString(double d2) {
        return NumberOutput.toString(d2, false);
    }

    public static String toString(double d2, boolean bl) {
        return bl ? DoubleToDecimal.toString(d2) : Double.toString(d2);
    }

    public static String toString(float f2) {
        return NumberOutput.toString(f2, false);
    }

    public static String toString(float f2, boolean bl) {
        return bl ? FloatToDecimal.toString(f2) : Float.toString(f2);
    }

    public static boolean notFinite(double d2) {
        return Double.isNaN(d2) || Double.isInfinite(d2);
    }

    public static boolean notFinite(float f2) {
        return Float.isNaN(f2) || Float.isInfinite(f2);
    }

    private static int _outputUptoBillion(int n2, char[] cArray, int n3) {
        if (n2 < MILLION) {
            if (n2 < 1000) {
                return NumberOutput._leading3(n2, cArray, n3);
            }
            int n4 = n2;
            n2 = n4 / 1000;
            return NumberOutput._outputUptoMillion(cArray, n3, n2, n4 - n2 * 1000);
        }
        int n5 = n2 / 1000;
        n2 -= n5 * 1000;
        int n6 = n5 / 1000;
        int n7 = n3;
        n3 = n5 - n6 * 1000;
        int n8 = NumberOutput._leading3(n6, cArray, n7);
        n5 = n8;
        int[] nArray = TRIPLET_TO_CHARS;
        int n9 = n2;
        int n10 = nArray[n3];
        int n11 = n2 = n10;
        int n12 = n2;
        n2 = n5 + 1;
        cArray[n5] = (char)(n12 >> 16);
        n3 = n5 + 2;
        cArray[n2] = (char)(n11 >> 8 & 0x7F);
        n2 = n5 + 3;
        cArray[n3] = (char)(n10 & 0x7F);
        n3 = TRIPLET_TO_CHARS[n9];
        int n13 = n2;
        n2 = n5 + 4;
        cArray[n13] = (char)(n3 >> 16);
        cArray[n2] = (char)(n3 >> 8 & 0x7F);
        cArray[n5 += 5] = (char)(n3 & 0x7F);
        return n8 + 6;
    }

    private static int _outputFullBillion(int n2, char[] cArray, int n3) {
        int n4 = n3;
        int n5 = n2 / 1000;
        int n6 = n5 / 1000;
        int[] nArray = TRIPLET_TO_CHARS;
        int n7 = n2 -= n5 * 1000;
        int n8 = n5;
        int n9 = nArray[n6];
        int n10 = n2 = n9;
        int n11 = n2;
        n2 = n3 + 1;
        cArray[n3] = (char)(n11 >> 16);
        n5 = n3 + 2;
        cArray[n2] = (char)(n10 >> 8 & 0x7F);
        n2 = n3 + 3;
        cArray[n5] = (char)(n9 & 0x7F);
        int n12 = nArray[n8 - n6 * 1000];
        int n13 = n5 = n12;
        int n14 = n2;
        n2 = n3 + 4;
        cArray[n14] = (char)(n5 >> 16);
        n5 = n3 + 5;
        cArray[n2] = (char)(n13 >> 8 & 0x7F);
        n2 = n3 + 6;
        cArray[n5] = (char)(n12 & 0x7F);
        n5 = TRIPLET_TO_CHARS[n7];
        int n15 = n2;
        n2 = n3 + 7;
        cArray[n15] = (char)(n5 >> 16);
        cArray[n2] = (char)(n5 >> 8 & 0x7F);
        cArray[n3 += 8] = (char)(n5 & 0x7F);
        return n4 + 9;
    }

    private static int _outputUptoBillion(int n2, byte[] byArray, int n3) {
        if (n2 < MILLION) {
            if (n2 < 1000) {
                return NumberOutput._leading3(n2, byArray, n3);
            }
            int n4 = n2;
            n2 = n4 / 1000;
            return NumberOutput._outputUptoMillion(byArray, n3, n2, n4 - n2 * 1000);
        }
        int n5 = n2 / 1000;
        n2 -= n5 * 1000;
        int n6 = n5 / 1000;
        int n7 = n3;
        n3 = n5 - n6 * 1000;
        int n8 = NumberOutput._leading3(n6, byArray, n7);
        n5 = n8;
        int[] nArray = TRIPLET_TO_CHARS;
        int n9 = n2;
        int n10 = nArray[n3];
        int n11 = n2 = n10;
        int n12 = n2;
        n2 = n5 + 1;
        byArray[n5] = (byte)(n12 >> 16);
        n3 = n5 + 2;
        byArray[n2] = (byte)(n11 >> 8);
        n2 = n5 + 3;
        byArray[n3] = (byte)n10;
        n3 = TRIPLET_TO_CHARS[n9];
        int n13 = n2;
        n2 = n5 + 4;
        byArray[n13] = (byte)(n3 >> 16);
        byArray[n2] = (byte)(n3 >> 8);
        byArray[n5 += 5] = (byte)n3;
        return n8 + 6;
    }

    private static int _outputFullBillion(int n2, byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n2 / 1000;
        int n6 = n5 / 1000;
        int n7 = n5 - n6 * 1000;
        int[] nArray = TRIPLET_TO_CHARS;
        int n8 = n2 -= n5 * 1000;
        int n9 = nArray[n6];
        int n10 = n2 = n9;
        int n11 = n2;
        n2 = n3 + 1;
        byArray[n3] = (byte)(n11 >> 16);
        n6 = n3 + 2;
        byArray[n2] = (byte)(n10 >> 8);
        n2 = n3 + 3;
        byArray[n6] = (byte)n9;
        int n12 = nArray[n7];
        int n13 = n6 = n12;
        int n14 = n2;
        n2 = n3 + 4;
        byArray[n14] = (byte)(n6 >> 16);
        n6 = n3 + 5;
        byArray[n2] = (byte)(n13 >> 8);
        n2 = n3 + 6;
        byArray[n6] = (byte)n12;
        n6 = TRIPLET_TO_CHARS[n8];
        int n15 = n2;
        n2 = n3 + 7;
        byArray[n15] = (byte)(n6 >> 16);
        byArray[n2] = (byte)(n6 >> 8);
        byArray[n3 += 8] = (byte)n6;
        return n4 + 9;
    }

    private static int _outputUptoMillion(char[] cArray, int n2, int n3, int n4) {
        int[] nArray = TRIPLET_TO_CHARS;
        int n5 = TRIPLET_TO_CHARS[n3];
        if (n3 > 9) {
            if (n3 > 99) {
                cArray[n2++] = (char)(n5 >> 16);
            }
            cArray[n2++] = (char)(n5 >> 8 & 0x7F);
        }
        int n6 = n2;
        n3 = n2 + 1;
        cArray[n2] = (char)(n5 & 0x7F);
        n4 = nArray[n4];
        int n7 = n3;
        n3 = n2 + 2;
        cArray[n7] = (char)(n4 >> 16);
        cArray[n3] = (char)(n4 >> 8 & 0x7F);
        cArray[n2 += 3] = (char)(n4 & 0x7F);
        return n6 + 4;
    }

    private static int _outputUptoMillion(byte[] byArray, int n2, int n3, int n4) {
        int[] nArray = TRIPLET_TO_CHARS;
        int n5 = TRIPLET_TO_CHARS[n3];
        if (n3 > 9) {
            if (n3 > 99) {
                byArray[n2++] = (byte)(n5 >> 16);
            }
            byArray[n2++] = (byte)(n5 >> 8);
        }
        int n6 = n2;
        n3 = n2 + 1;
        byArray[n2] = (byte)n5;
        n4 = nArray[n4];
        int n7 = n3;
        n3 = n2 + 2;
        byArray[n7] = (byte)(n4 >> 16);
        byArray[n3] = (byte)(n4 >> 8);
        byArray[n2 += 3] = (byte)n4;
        return n6 + 4;
    }

    private static int _leading3(int n2, char[] cArray, int n3) {
        int n4 = TRIPLET_TO_CHARS[n2];
        if (n2 > 9) {
            if (n2 > 99) {
                cArray[n3++] = (char)(n4 >> 16);
            }
            cArray[n3++] = (char)(n4 >> 8 & 0x7F);
        }
        cArray[n3] = (char)(n4 & 0x7F);
        return n3 + 1;
    }

    private static int _leading3(int n2, byte[] byArray, int n3) {
        int n4 = TRIPLET_TO_CHARS[n2];
        if (n2 > 9) {
            if (n2 > 99) {
                byArray[n3++] = (byte)(n4 >> 16);
            }
            byArray[n3++] = (byte)(n4 >> 8);
        }
        byArray[n3] = (byte)n4;
        return n3 + 1;
    }

    private static int _full3(int n2, char[] cArray, int n3) {
        int n4 = n3;
        n2 = TRIPLET_TO_CHARS[n2];
        int n5 = n3 + 1;
        cArray[n3] = (char)(n2 >> 16);
        cArray[n5] = (char)(n2 >> 8 & 0x7F);
        cArray[n3 += 2] = (char)(n2 & 0x7F);
        return n4 + 3;
    }

    private static int _full3(int n2, byte[] byArray, int n3) {
        int n4 = n3;
        n2 = TRIPLET_TO_CHARS[n2];
        int n5 = n3 + 1;
        byArray[n3] = (byte)(n2 >> 16);
        byArray[n5] = (byte)(n2 >> 8);
        byArray[n3 += 2] = (byte)n2;
        return n4 + 3;
    }

    private static int _outputSmallestL(char[] cArray, int n2) {
        String string = SMALLEST_LONG;
        int n3 = string.length();
        string.getChars(0, n3, cArray, n2);
        return n3 + n2;
    }

    private static int _outputSmallestL(byte[] byArray, int n2) {
        int n3 = SMALLEST_LONG.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2++] = (byte)SMALLEST_LONG.charAt(i2);
        }
        return n2;
    }

    private static int _outputSmallestI(char[] cArray, int n2) {
        String string = SMALLEST_INT;
        int n3 = string.length();
        string.getChars(0, n3, cArray, n2);
        return n3 + n2;
    }

    private static int _outputSmallestI(byte[] byArray, int n2) {
        int n3 = SMALLEST_INT.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2++] = (byte)SMALLEST_INT.charAt(i2);
        }
        return n2;
    }

    static {
        int n2 = 0;
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int i3 = 0; i3 < 10; ++i3) {
                for (int i4 = 0; i4 < 10; ++i4) {
                    int n3 = i2 + 48 << 16 | i3 + 48 << 8 | i4 + 48;
                    NumberOutput.TRIPLET_TO_CHARS[n2++] = n3;
                }
            }
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

