/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF32Reader
extends Reader {
    protected static final int LAST_VALID_UNICODE_CHAR = 0x10FFFF;
    protected static final char NC = '\u0000';
    protected final IOContext _context;
    protected InputStream _in;
    protected byte[] _buffer;
    protected int _ptr;
    protected int _length;
    protected final boolean _bigEndian;
    protected char _surrogate = '\u0000';
    protected int _charCount;
    protected int _byteCount;
    protected final boolean _managedBuffers;
    protected char[] _tmpBuf;

    public UTF32Reader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl) {
        this._context = iOContext;
        this._in = inputStream;
        this._buffer = byArray;
        this._ptr = n2;
        this._length = n3;
        this._bigEndian = bl;
        boolean bl2 = inputStream != null;
        this._managedBuffers = bl2;
    }

    private void reportUnexpectedEOF(int n2, int n3) {
        UTF32Reader uTF32Reader = this;
        int n4 = uTF32Reader._byteCount + n2;
        int n5 = uTF32Reader._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n2 + ", needed " + n3 + ", at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportInvalid(int n2, int n3, String string) {
        UTF32Reader uTF32Reader = this;
        int n4 = uTF32Reader._byteCount + this._ptr - 1;
        n3 = uTF32Reader._charCount + n3;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n2) + string + " at char #" + n3 + ", byte #" + n4 + ")");
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean loadMore(int n2) {
        InputStream inputStream = this._in;
        if (inputStream == null) return false;
        byte[] byArray = this._buffer;
        if (this._buffer == null) {
            return false;
        }
        this._byteCount = this._length - n2 + this._byteCount;
        if (n2 > 0) {
            int n3 = this._ptr;
            if (n3 > 0) {
                System.arraycopy(byArray, n3, byArray, 0, n2);
                this._ptr = 0;
            }
        } else {
            this._ptr = 0;
            n2 = inputStream.read(byArray);
            if (n2 < 1) {
                this._length = 0;
                if (n2 < 0) {
                    if (!this._managedBuffers) return false;
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
        }
        this._length = n2;
        while ((n2 = this._length) < 4) {
            if ((n2 = this._in.read(this._buffer, n2, this._buffer.length - n2)) < 1) {
                if (n2 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length += n2;
        }
        return true;
    }

    private void freeBuffers() {
        byte[] byArray = ((UTF32Reader)((Object)iOContext))._buffer;
        if (((UTF32Reader)((Object)iOContext))._buffer != null) {
            ((UTF32Reader)((Object)iOContext))._buffer = null;
            IOContext iOContext = ((UTF32Reader)((Object)iOContext))._context;
            if (iOContext != null) {
                iOContext.releaseReadIOBuffer(byArray);
            }
        }
    }

    private void reportBounds(char[] cArray, int n2, int n3) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray2[1] = n3;
        objectArray[2] = cArray.length;
        throw new ArrayIndexOutOfBoundsException(String.format("read(buf,%d,%d), cbuf[%d]", objectArray2));
    }

    private void reportStrangeStream() {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }

    @Override
    public void close() {
        InputStream inputStream = this._in;
        if (inputStream != null) {
            this._in = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() {
        if (this._tmpBuf == null) {
            this._tmpBuf = new char[1];
        }
        UTF32Reader uTF32Reader = this;
        if (uTF32Reader.read(uTF32Reader._tmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuf[0];
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        if (this._buffer == null) {
            return -1;
        }
        if (n3 < 1) {
            return n3;
        }
        if (n2 < 0 || n2 + n3 > cArray.length) {
            this.reportBounds(cArray, n2, n3);
        }
        n3 += n2;
        int n6 = this._surrogate;
        if (n6 != 0) {
            n5 = n2 + 1;
            cArray[n2] = n6;
            this._surrogate = '\u0000';
        } else {
            n6 = this._length - this._ptr;
            if (n6 < 4 && !this.loadMore(n6)) {
                if (n6 == 0) {
                    return -1;
                }
                UTF32Reader uTF32Reader = this;
                uTF32Reader.reportUnexpectedEOF(uTF32Reader._length - this._ptr, 4);
            }
            n5 = n2;
        }
        n6 = this._length - 4;
        while (n5 < n3 && (n4 = this._ptr) <= n6) {
            int n7;
            int n8;
            if (this._bigEndian) {
                byte[] byArray = this._buffer;
                n8 = byArray[n4] << 8 | byArray[n4 + 1] & 0xFF;
                n7 = (this._buffer[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
            } else {
                byte[] byArray = this._buffer;
                n8 = byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8;
                int n9 = n7 = this._buffer[n4 + 2] & 0xFF | byArray[n4 + 3] << 8;
                n7 = n8;
                n8 = n9;
            }
            this._ptr = n4 + 4;
            if (n8 != 0) {
                int n10 = n8 & 0xFFFF;
                n4 = n10 - 1 << 16 | n7;
                if (n10 > 16) {
                    Object[] objectArray = new Object[1];
                    Object object = objectArray;
                    objectArray[0] = 0x10FFFF;
                    object = String.format(" (above 0x%08x)", object);
                    this.reportInvalid(n4, n5 - n2, (String)object);
                }
                n7 = n5 + 1;
                cArray[n5] = (char)((n4 >> 10) + 55296);
                n5 = n4 & 0x3FF | 0xDC00;
                if (n7 >= n3) {
                    this._surrogate = (char)n4;
                    n5 = n7;
                    break;
                }
                int n11 = n7;
                n7 = n5;
                n5 = n11;
            }
            n4 = n5 + 1;
            cArray[n5] = (char)n7;
            n5 = n4;
        }
        int n12 = n5 - n2;
        this._charCount += n12;
        return n12;
    }
}

