/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io;

import com.privatefasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8Writer
extends Writer {
    static final int SURR1_FIRST = 55296;
    static final int SURR1_LAST = 56319;
    static final int SURR2_FIRST = 56320;
    static final int SURR2_LAST = 57343;
    private final IOContext _context;
    private OutputStream _out;
    private byte[] _outBuffer;
    private final int _outBufferEnd;
    private int _outPtr;
    private int _surrogate;

    public UTF8Writer(IOContext iOContext, OutputStream outputStream) {
        UTF8Writer uTF8Writer = object;
        ((UTF8Writer)object)._context = iOContext;
        ((UTF8Writer)object)._out = outputStream;
        byte[] byArray = iOContext.allocWriteEncodingBuffer();
        Object object = byArray;
        uTF8Writer._outBuffer = byArray;
        uTF8Writer._outBufferEnd = ((Object)object).length - 4;
        uTF8Writer._outPtr = 0;
    }

    public static void illegalSurrogate(int n2) {
        throw new IOException(UTF8Writer.illegalSurrogateDesc(n2));
    }

    public static String illegalSurrogateDesc(int n2) {
        if (n2 > 0x10FFFF) {
            return "Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 4627";
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                return "Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")";
            }
            return "Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")";
        }
        return "Illegal character point (0x" + Integer.toHexString(n2) + ") to output";
    }

    @Override
    public Writer append(char c2) {
        UTF8Writer uTF8Writer = this;
        uTF8Writer.write(c2);
        return uTF8Writer;
    }

    @Override
    public void close() {
        OutputStream outputStream = this._out;
        if (outputStream != null) {
            int n2 = this._outPtr;
            if (n2 > 0) {
                outputStream.write(this._outBuffer, 0, n2);
                this._outPtr = 0;
            }
            UTF8Writer uTF8Writer = this;
            outputStream = uTF8Writer._out;
            uTF8Writer._out = null;
            byte[] byArray = uTF8Writer._outBuffer;
            if (uTF8Writer._outBuffer != null) {
                this._outBuffer = null;
                this._context.releaseWriteEncodingBuffer(byArray);
            }
            outputStream.close();
            int n3 = this._surrogate;
            this._surrogate = 0;
            if (n3 > 0) {
                UTF8Writer.illegalSurrogate(n3);
            }
        }
    }

    @Override
    public void flush() {
        OutputStream outputStream = this._out;
        if (outputStream != null) {
            int n2 = this._outPtr;
            if (n2 > 0) {
                outputStream.write(this._outBuffer, 0, n2);
                this._outPtr = 0;
            }
            this._out.flush();
        }
    }

    @Override
    public void write(char[] cArray) {
        int n2 = cArray.length;
        this.write(cArray, 0, n2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(char[] var1_1, int var2_2, int var3_3) {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1[var2_2]);
            }
            return;
        }
        if (this._surrogate > 0) {
            v0 = this;
            v0.write(v0.convertSurrogate(var1_1[var2_2++]));
        }
        v1 = --var3_3;
        v2 = this;
        var3_3 = v2._outPtr;
        var4_4 = v2._outBuffer;
        var5_5 = v2._outBufferEnd;
        var6_6 = v1 + var2_2;
        block0: while (var2_2 < var6_6) {
            if (var3_3 >= var5_5) {
                this._out.write(var4_4, 0, var3_3);
                var3_3 = 0;
            }
            var7_7 = var2_2 + 1;
            if ((var2_2 = var1_1[var2_2]) >= 128) ** GOTO lbl40
            v3 = var2_2;
            var2_2 = var3_3 + 1;
            var4_4[var3_3] = (byte)v3;
            var3_3 = var6_6 - var7_7;
            var8_8 = var5_5 - var2_2;
            if (var3_3 > var8_8) {
                var3_3 = var8_8;
            }
            var8_8 = var3_3 + var7_7;
            var3_3 = var2_2;
            var2_2 = var7_7;
            while (var2_2 < var8_8) {
                var7_7 = var2_2 + 1;
                if ((var2_2 = var1_1[var2_2]) >= 128) {
                } else {
                    v4 = var2_2;
                    var2_2 = var3_3 + 1;
                    var4_4[var3_3] = (byte)v4;
                    var3_3 = var2_2;
                    var2_2 = var7_7;
                    continue;
                }
lbl40:
                // 2 sources

                v5 = var3_3;
                var3_3 = var7_7;
                var7_7 = v5;
                if (var2_2 < 2048) {
                    v6 = var2_2;
                    v7 = var2_2;
                    var2_2 = var7_7 + 1;
                    var4_4[var7_7] = (byte)(v7 >> 6 | 192);
                    var4_4[var2_2] = (byte)(v6 & 63 | 128);
                    v8 = var3_3;
                    var3_3 = var7_7 += 2;
                    var2_2 = v8;
                    continue block0;
                }
                if (var2_2 >= 55296 && var2_2 <= 57343) {
                    if (var2_2 > 56319) {
                        this._outPtr = var7_7;
                        UTF8Writer.illegalSurrogate(var2_2);
                    }
                    this._surrogate = var2_2;
                    if (var3_3 >= var6_6) {
                        var3_3 = var7_7;
                        break block0;
                    }
                    v9 = var3_3;
                    var2_2 = v9 + 1;
                    var3_3 = this.convertSurrogate(var1_1[v9]);
                    if (var3_3 > 0x10FFFF) {
                        this._outPtr = var7_7;
                        UTF8Writer.illegalSurrogate(var3_3);
                    }
                    v10 = var3_3;
                    v11 = var3_3;
                    v12 = var3_3;
                    v13 = var3_3;
                    var3_3 = var7_7 + 1;
                    var4_4[var7_7] = (byte)(v13 >> 18 | 240);
                    var8_8 = var7_7 + 2;
                    var4_4[var3_3] = (byte)(v12 >> 12 & 63 | 128);
                    var3_3 = var7_7 + 3;
                    var4_4[var8_8] = (byte)(v11 >> 6 & 63 | 128);
                    var4_4[var3_3] = (byte)(v10 & 63 | 128);
                    var3_3 = var7_7 += 4;
                    continue block0;
                }
                v14 = var2_2;
                v15 = var2_2;
                v16 = var2_2;
                var2_2 = var7_7 + 1;
                var4_4[var7_7] = (byte)(v16 >> 12 | 224);
                var8_8 = var7_7 + 2;
                var4_4[var2_2] = (byte)(v15 >> 6 & 63 | 128);
                var2_2 = var7_7 + 3;
                var4_4[var8_8] = (byte)(v14 & 63 | 128);
                v17 = var3_3;
                var3_3 = var2_2;
                var2_2 = v17;
                continue block0;
            }
        }
        this._outPtr = var3_3;
    }

    @Override
    public void write(int n2) {
        if (this._surrogate > 0) {
            n2 = this.convertSurrogate(n2);
        } else if (n2 >= 55296 && n2 <= 57343) {
            if (n2 > 56319) {
                UTF8Writer.illegalSurrogate(n2);
            }
            this._surrogate = n2;
            return;
        }
        int n3 = this._outPtr;
        if (n3 >= this._outBufferEnd) {
            this._out.write(this._outBuffer, 0, n3);
            this._outPtr = 0;
        }
        if (n2 < 128) {
            int n4 = this._outPtr;
            this._outPtr = n4 + 1;
            this._outBuffer[n4] = (byte)n2;
        } else {
            n3 = this._outPtr;
            if (n2 < 2048) {
                int n5 = n2;
                n2 = n3 + 1;
                this._outBuffer[n3] = (byte)(n5 >> 6 | 0xC0);
                n3 += 2;
                this._outBuffer[n2] = (byte)(n2 & 0x3F | 0x80);
            } else if (n2 <= 65535) {
                byte[] byArray = this._outBuffer;
                int n6 = n2;
                int n7 = n2;
                int n8 = n2;
                n2 = n3 + 1;
                byArray[n3] = (byte)(n8 >> 12 | 0xE0);
                int n9 = n3 + 2;
                byArray[n2] = (byte)(n7 >> 6 & 0x3F | 0x80);
                n3 += 3;
                this._outBuffer[n9] = (byte)(n6 & 0x3F | 0x80);
            } else {
                if (n2 > 0x10FFFF) {
                    UTF8Writer.illegalSurrogate(n2);
                }
                byte[] byArray = this._outBuffer;
                int n10 = n2;
                int n11 = n2;
                int n12 = n2;
                int n13 = n2;
                n2 = n3 + 1;
                byArray[n3] = (byte)(n13 >> 18 | 0xF0);
                int n14 = n3 + 2;
                byArray[n2] = (byte)(n12 >> 12 & 0x3F | 0x80);
                n2 = n3 + 3;
                byArray[n14] = (byte)(n11 >> 6 & 0x3F | 0x80);
                n3 += 4;
                this._outBuffer[n2] = (byte)(n10 & 0x3F | 0x80);
            }
            this._outPtr = n3;
        }
    }

    @Override
    public void write(String string) {
        int n2 = string.length();
        this.write(string, 0, n2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(String var1_1, int var2_2, int var3_3) {
        if (var3_3 < 2) {
            if (var3_3 == 1) {
                this.write(var1_1.charAt(var2_2));
            }
            return;
        }
        if (this._surrogate > 0) {
            v0 = this;
            v0.write(v0.convertSurrogate(var1_1.charAt(var2_2++)));
        }
        v1 = --var3_3;
        v2 = this;
        var3_3 = v2._outPtr;
        var4_4 = v2._outBuffer;
        var5_5 = v2._outBufferEnd;
        var6_6 = v1 + var2_2;
        block0: while (var2_2 < var6_6) {
            if (var3_3 >= var5_5) {
                this._out.write(var4_4, 0, var3_3);
                var3_3 = 0;
            }
            var7_7 = var2_2 + 1;
            v3 = var1_1.charAt(var2_2);
            var2_2 = v3;
            if (v3 >= '\u0080') ** GOTO lbl44
            v4 = var2_2;
            var2_2 = var3_3 + 1;
            var4_4[var3_3] = (byte)v4;
            var3_3 = var6_6 - var7_7;
            var8_8 = var5_5 - var2_2;
            if (var3_3 > var8_8) {
                var3_3 = var8_8;
            }
            var8_8 = var3_3 + var7_7;
            var3_3 = var2_2;
            var2_2 = var7_7;
            while (var2_2 < var8_8) {
                var7_7 = var2_2 + 1;
                v5 = var1_1.charAt(var2_2);
                var2_2 = v5;
                if (v5 >= '\u0080') {
                } else {
                    v6 = var2_2;
                    var2_2 = var3_3 + 1;
                    var4_4[var3_3] = (byte)v6;
                    var3_3 = var2_2;
                    var2_2 = var7_7;
                    continue;
                }
lbl44:
                // 2 sources

                v7 = var3_3;
                var3_3 = var7_7;
                var7_7 = v7;
                if (var2_2 < 2048) {
                    v8 = var2_2;
                    v9 = var2_2;
                    var2_2 = var7_7 + 1;
                    var4_4[var7_7] = (byte)(v9 >> 6 | 192);
                    var4_4[var2_2] = (byte)(v8 & 63 | 128);
                    v10 = var3_3;
                    var3_3 = var7_7 += 2;
                    var2_2 = v10;
                    continue block0;
                }
                if (var2_2 >= 55296 && var2_2 <= 57343) {
                    if (var2_2 > 56319) {
                        this._outPtr = var7_7;
                        UTF8Writer.illegalSurrogate(var2_2);
                    }
                    this._surrogate = var2_2;
                    if (var3_3 >= var6_6) {
                        var3_3 = var7_7;
                        break block0;
                    }
                    v11 = var3_3;
                    var2_2 = v11 + 1;
                    var3_3 = this.convertSurrogate(var1_1.charAt(v11));
                    if (var3_3 > 0x10FFFF) {
                        this._outPtr = var7_7;
                        UTF8Writer.illegalSurrogate(var3_3);
                    }
                    v12 = var3_3;
                    v13 = var3_3;
                    v14 = var3_3;
                    v15 = var3_3;
                    var3_3 = var7_7 + 1;
                    var4_4[var7_7] = (byte)(v15 >> 18 | 240);
                    var8_8 = var7_7 + 2;
                    var4_4[var3_3] = (byte)(v14 >> 12 & 63 | 128);
                    var3_3 = var7_7 + 3;
                    var4_4[var8_8] = (byte)(v13 >> 6 & 63 | 128);
                    var4_4[var3_3] = (byte)(v12 & 63 | 128);
                    var3_3 = var7_7 += 4;
                    continue block0;
                }
                v16 = var2_2;
                v17 = var2_2;
                v18 = var2_2;
                var2_2 = var7_7 + 1;
                var4_4[var7_7] = (byte)(v18 >> 12 | 224);
                var8_8 = var7_7 + 2;
                var4_4[var2_2] = (byte)(v17 >> 6 & 63 | 128);
                var2_2 = var7_7 + 3;
                var4_4[var8_8] = (byte)(v16 & 63 | 128);
                v19 = var3_3;
                var3_3 = var2_2;
                var2_2 = v19;
                continue block0;
            }
        }
        this._outPtr = var3_3;
    }

    public int convertSurrogate(int n2) {
        int n3 = this._surrogate;
        this._surrogate = 0;
        if (n2 >= 56320 && n2 <= 57343) {
            n3 = (n3 - 55296 << 10) + 65536;
            return n2 - 56320 + n3;
        }
        throw new IOException("Broken surrogate pair: first char 0x" + Integer.toHexString(n3) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
    }
}

