/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io.schubfach;

import com.privatefasterxml.jackson.core.io.schubfach.a;

public final class DoubleToDecimal {
    static final int P = 53;
    private static final int W = 11;
    static final int Q_MIN = -1074;
    static final int Q_MAX = 971;
    static final int E_MIN = -323;
    static final int E_MAX = 309;
    static final long C_TINY = 3L;
    static final int K_MIN = -324;
    static final int K_MAX = 292;
    static final int H = 17;
    private static final long C_MIN = 0x10000000000000L;
    private static final int BQ_MASK = 2047;
    private static final long T_MASK = 0xFFFFFFFFFFFFFL;
    private static final long MASK_63 = Long.MAX_VALUE;
    private static final int MASK_28 = 0xFFFFFFF;
    private static final int NON_SPECIAL = 0;
    private static final int PLUS_ZERO = 1;
    private static final int MINUS_ZERO = 2;
    private static final int PLUS_INF = 3;
    private static final int MINUS_INF = 4;
    private static final int NAN = 5;
    private static final ThreadLocal<DoubleToDecimal> threadLocal = ThreadLocal.withInitial(DoubleToDecimal::new);
    public final int MAX_CHARS;
    private final byte[] bytes = new byte[24];
    private final char[] chars = new char[24];
    private int index;

    private DoubleToDecimal() {
        this.MAX_CHARS = 24;
    }

    public static String toString(double d2) {
        return DoubleToDecimal.threadLocalInstance().toDecimalString(d2);
    }

    public static Appendable appendTo(double d2, Appendable appendable) {
        return DoubleToDecimal.threadLocalInstance().appendDecimalTo(d2, appendable);
    }

    private static DoubleToDecimal threadLocalInstance() {
        return threadLocal.get();
    }

    private String toDecimalString(double d2) {
        switch (this.toDecimal(d2)) {
            default: {
                return "NaN";
            }
            case 4: {
                return "-Infinity";
            }
            case 3: {
                return "Infinity";
            }
            case 2: {
                return "-0.0";
            }
            case 1: {
                return "0.0";
            }
            case 0: 
        }
        return this.charsToString();
    }

    private Appendable appendDecimalTo(double d2, Appendable appendable) {
        int n2;
        int n3;
        switch (this.toDecimal(d2)) {
            default: {
                return appendable.append("NaN");
            }
            case 4: {
                return appendable.append("-Infinity");
            }
            case 3: {
                return appendable.append("Infinity");
            }
            case 2: {
                return appendable.append("-0.0");
            }
            case 1: {
                return appendable.append("0.0");
            }
            case 0: 
        }
        for (n3 = 0; n3 <= (n2 = this.index); ++n3) {
            this.chars[n3] = (char)this.bytes[n3];
        }
        if (appendable instanceof StringBuilder) {
            return ((StringBuilder)appendable).append(this.chars, 0, n2 + 1);
        }
        if (appendable instanceof StringBuffer) {
            return ((StringBuffer)appendable).append(this.chars, 0, n2 + 1);
        }
        for (n3 = 0; n3 <= this.index; ++n3) {
            appendable.append(this.chars[n3]);
        }
        return appendable;
    }

    private int toDecimal(double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        long l3 = l2 & 0xFFFFFFFFFFFFFL;
        int n2 = (int)(l2 >>> 52) & 0x7FF;
        if (n2 < 2047) {
            this.index = -1;
            if (l2 < 0L) {
                this.append(45);
            }
            if (n2 != 0) {
                long l4;
                int n3 = 1075 - n2;
                int n4 = n3 > 0 ? 1 : 0;
                if ((n4 & (n2 = n3 < 53 ? 1 : 0)) != 0 && (l4 = (l3 |= 0x10000000000000L) >> n3) << n3 == l3) {
                    return this.toChars(l4, 0);
                }
                return this.toDecimal(-n3, l3, 0);
            }
            if (l3 != 0L) {
                int n5;
                if (l3 < 3L) {
                    long l5 = l3 * 10L;
                    n5 = this.toDecimal(-1074, l5, -1);
                } else {
                    n5 = this.toDecimal(-1074, l3, 0);
                }
                return n5;
            }
            return l2 == 0L ? 1 : 2;
        }
        if (l3 != 0L) {
            return 5;
        }
        return l2 > 0L ? 3 : 4;
    }

    private int toDecimal(int n2, long l2, int n3) {
        long l3;
        boolean bl;
        long l4;
        int n4;
        long l5;
        long l6;
        boolean bl2;
        long l7 = l2;
        int n5 = (int)l7 & 1;
        long l8 = l7 << 2;
        long l9 = l8 + 2L;
        int n6 = l7 != 0x10000000000000L ? 1 : 0;
        if (n6 | (bl2 = n2 == -1074)) {
            l6 = l8 - 2L;
            n6 = (int)((long)n2 * 661971961083L >> 41);
        } else {
            l6 = l8 - 1L;
            n6 = (int)((long)n2 * 661971961083L + -274743187321L >> 41);
        }
        n2 = (int)((long)(-n6) * 913124641741L >> 38) + n2 + 2;
        long[] lArray = a.b;
        int n7 = n6 - -324 << 1;
        long l10 = a.b[n7];
        long l11 = l8;
        l8 = lArray[n7 | 1];
        long l12 = l11 << n2;
        l12 = DoubleToDecimal.rop(l10, l8, l12);
        long l13 = l8;
        l8 = DoubleToDecimal.rop(l10, l8, l6 << n2);
        l9 = DoubleToDecimal.rop(l10, l13, l9 << n2);
        l6 = l12 >> 2;
        if (l6 >= 100L && (n2 = l8 + (l5 = (long)n5) <= (l10 = a.a(l6, 1844674407370955168L) * 10L) << 2 ? 1 : 0) != (n4 = ((l4 = l10 + 10L) << 2) + l5 <= l9 ? 1 : 0)) {
            if (n2 == 0) {
                l10 = l4;
            }
            return this.toChars(l10, n6);
        }
        boolean bl3 = l8 + (l8 = (long)n5) <= l6 << 2;
        if (bl3 != (bl = ((l3 = l6 + 1L) << 2) + l8 <= l9)) {
            if (!bl3) {
                l6 = l3;
            }
            return this.toChars(l6, n6 + n3);
        }
        long l14 = l12 - (l6 + l3 << 1);
        if (l14 >= 0L && (l14 != 0L || (l6 & 1L) != 0L)) {
            l6 = l3;
        }
        return this.toChars(l6, n6 + n3);
    }

    private static long rop(long l2, long l3, long l4) {
        long l5 = l2;
        long l6 = l2;
        l2 = a.a(l3, l4);
        l3 = l6 * l4;
        l2 = (l3 >>> 1) + l2;
        return a.a(l5, l4) + (l2 >>> 63) | (l2 & Long.MAX_VALUE) + Long.MAX_VALUE >>> 63;
    }

    private int toChars(long l2, int n2) {
        long l3 = l2;
        int n3 = (int)((long)(64 - Long.numberOfLeadingZeros(l3)) * 661971961083L >> 41);
        long[] lArray = a.a;
        if (l3 >= a.a[n3]) {
            ++n3;
        }
        long l4 = a.a(l2 *= lArray[17 - n3], 193428131138340668L) >>> 20;
        int n4 = (int)(l2 - l4 * 100000000L);
        int n5 = (int)(l4 * 1441151881L >>> 57);
        int n6 = (int)(l4 - (long)(n5 * 100000000));
        if ((n2 += n3) > 0 && n2 <= 7) {
            return this.toChars1(n5, n6, n4, n2);
        }
        if (-3 < n2 && n2 <= 0) {
            return this.toChars2(n5, n6, n4, n2);
        }
        return this.toChars3(n5, n6, n4, n2);
    }

    private int toChars1(int n2, int n3, int n4, int n5) {
        DoubleToDecimal doubleToDecimal = this;
        doubleToDecimal.appendDigit(n2);
        n2 = doubleToDecimal.y(n3);
        for (n3 = 1; n3 < n5; ++n3) {
            int n6 = n2 * 10;
            this.appendDigit(n6 >>> 28);
            n2 = n6 & 0xFFFFFFF;
        }
        this.append(46);
        while (n3 <= 8) {
            int n7 = n2 * 10;
            this.appendDigit(n7 >>> 28);
            n2 = n7 & 0xFFFFFFF;
            ++n3;
        }
        this.lowDigits(n4);
        return 0;
    }

    private int toChars2(int n2, int n3, int n4, int n5) {
        DoubleToDecimal doubleToDecimal = this;
        doubleToDecimal.appendDigit(0);
        doubleToDecimal.append(46);
        while (n5 < 0) {
            this.appendDigit(0);
            ++n5;
        }
        DoubleToDecimal doubleToDecimal2 = this;
        doubleToDecimal2.appendDigit(n2);
        doubleToDecimal2.append8Digits(n3);
        doubleToDecimal2.lowDigits(n4);
        return 0;
    }

    private int toChars3(int n2, int n3, int n4, int n5) {
        DoubleToDecimal doubleToDecimal = this;
        doubleToDecimal.appendDigit(n2);
        doubleToDecimal.append(46);
        this.append8Digits(n3);
        this.lowDigits(n4);
        this.exponent(n5 - 1);
        return 0;
    }

    private void lowDigits(int n2) {
        if (n2 != 0) {
            this.append8Digits(n2);
        }
        this.removeTrailingZeroes();
    }

    private void append8Digits(int n2) {
        n2 = this.y(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = n2 * 10;
            this.appendDigit(n3 >>> 28);
            n2 = n3 & 0xFFFFFFF;
        }
    }

    private void removeTrailingZeroes() {
        int n2;
        byte by;
        while ((by = this.bytes[n2 = this.index]) == 48) {
            this.index = n2 - 1;
        }
        if (by == 46) {
            this.index = n2 + 1;
        }
    }

    private int y(int n2) {
        return (int)(a.a((long)(n2 + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void exponent(int n2) {
        this.append(69);
        if (n2 < 0) {
            this.append(45);
            n2 = -n2;
        }
        if (n2 < 10) {
            this.appendDigit(n2);
            return;
        }
        if (n2 >= 100) {
            int n3 = n2;
            int n4 = n3 * 1311 >>> 17;
            this.appendDigit(n4);
            n2 = n3 - n4 * 100;
        }
        int n5 = n2;
        int n6 = n5 * 103 >>> 10;
        this.appendDigit(n6);
        this.appendDigit(n5 - n6 * 10);
    }

    private void append(int n2) {
        int n3;
        this.index = n3 = this.index + 1;
        this.bytes[n3] = (byte)n2;
    }

    private void appendDigit(int n2) {
        int n3;
        this.index = n3 = this.index + 1;
        this.bytes[n3] = (byte)(n2 + 48);
    }

    private String charsToString() {
        int n2 = this.index + 1;
        return new String(this.bytes, 0, 0, n2);
    }
}

