/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.io.schubfach;

import com.privatefasterxml.jackson.core.io.schubfach.a;

public final class FloatToDecimal {
    static final int P = 24;
    private static final int W = 8;
    static final int Q_MIN = -149;
    static final int Q_MAX = 104;
    static final int E_MIN = -44;
    static final int E_MAX = 39;
    static final int C_TINY = 8;
    static final int K_MIN = -45;
    static final int K_MAX = 31;
    static final int H = 9;
    private static final int C_MIN = 0x800000;
    private static final int BQ_MASK = 255;
    private static final int T_MASK = 0x7FFFFF;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final int MASK_28 = 0xFFFFFFF;
    private static final int NON_SPECIAL = 0;
    private static final int PLUS_ZERO = 1;
    private static final int MINUS_ZERO = 2;
    private static final int PLUS_INF = 3;
    private static final int MINUS_INF = 4;
    private static final int NAN = 5;
    private static final ThreadLocal<FloatToDecimal> threadLocal = ThreadLocal.withInitial(FloatToDecimal::new);
    public final int MAX_CHARS;
    private final byte[] bytes = new byte[15];
    private final char[] chars = new char[15];
    private int index;

    private FloatToDecimal() {
        this.MAX_CHARS = 15;
    }

    public static String toString(float f2) {
        return FloatToDecimal.threadLocalInstance().toDecimalString(f2);
    }

    public static Appendable appendTo(float f2, Appendable appendable) {
        return FloatToDecimal.threadLocalInstance().appendDecimalTo(f2, appendable);
    }

    private static FloatToDecimal threadLocalInstance() {
        return threadLocal.get();
    }

    private String toDecimalString(float f2) {
        switch (this.toDecimal(f2)) {
            default: {
                return "NaN";
            }
            case 4: {
                return "-Infinity";
            }
            case 3: {
                return "Infinity";
            }
            case 2: {
                return "-0.0";
            }
            case 1: {
                return "0.0";
            }
            case 0: 
        }
        return this.charsToString();
    }

    private Appendable appendDecimalTo(float f2, Appendable appendable) {
        int n2;
        int n3;
        switch (this.toDecimal(f2)) {
            default: {
                return appendable.append("NaN");
            }
            case 4: {
                return appendable.append("-Infinity");
            }
            case 3: {
                return appendable.append("Infinity");
            }
            case 2: {
                return appendable.append("-0.0");
            }
            case 1: {
                return appendable.append("0.0");
            }
            case 0: 
        }
        for (n3 = 0; n3 <= (n2 = this.index); ++n3) {
            this.chars[n3] = (char)this.bytes[n3];
        }
        if (appendable instanceof StringBuilder) {
            return ((StringBuilder)appendable).append(this.chars, 0, n2 + 1);
        }
        if (appendable instanceof StringBuffer) {
            return ((StringBuffer)appendable).append(this.chars, 0, n2 + 1);
        }
        for (n3 = 0; n3 <= this.index; ++n3) {
            appendable.append(this.chars[n3]);
        }
        return appendable;
    }

    private int toDecimal(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        int n3 = n2 & 0x7FFFFF;
        int n4 = n2 >>> 23 & 0xFF;
        if (n4 < 255) {
            this.index = -1;
            if (n2 < 0) {
                this.append(45);
            }
            if (n4 != 0) {
                n2 = 150 - n4;
                n4 = n2 > 0 ? 1 : 0;
                int n5 = n2 < 24 ? 1 : 0;
                if ((n4 & n5) != 0 && (n4 = (n3 |= 0x800000) >> n2) << n2 == n3) {
                    return this.toChars(n4, 0);
                }
                return this.toDecimal(-n2, n3, 0);
            }
            if (n3 != 0) {
                return n3 < 8 ? this.toDecimal(-149, n3 * 10, -1) : this.toDecimal(-149, n3, 0);
            }
            return n2 == 0 ? 1 : 2;
        }
        if (n3 != 0) {
            return 5;
        }
        return n2 > 0 ? 3 : 4;
    }

    private int toDecimal(int n2, int n3, int n4) {
        int n5;
        boolean bl;
        int n6;
        int n7;
        long l2;
        boolean bl2;
        int n8 = n3;
        n3 = n8 & 1;
        long l3 = n8 << 2;
        long l4 = l3 + 2L;
        boolean bl3 = n8 != 0x800000;
        if (bl3 | (bl2 = n2 == -149)) {
            l2 = l3 - 2L;
            n7 = (int)((long)n2 * 661971961083L >> 41);
        } else {
            l2 = l3 - 1L;
            n7 = (int)((long)n2 * 661971961083L + -274743187321L >> 41);
        }
        n2 = (int)((long)(-n7) * 913124641741L >> 38) + n2 + 33;
        long l5 = a.b[n7 - -324 << 1] + 1L;
        int n9 = FloatToDecimal.rop(l5, l3 << n2);
        int n10 = n2;
        n2 = FloatToDecimal.rop(l5, l2 << n2);
        int n11 = FloatToDecimal.rop(l5, l4 << n10);
        int n12 = n9 >> 2;
        if (n12 >= 100 && (bl2 = n2 + n3 <= (n6 = (int)((long)n12 * 0x66666667L >>> 34) * 10) << 2) != (bl = ((n5 = n6 + 10) << 2) + n3 <= n11)) {
            if (!bl2) {
                n6 = n5;
            }
            return this.toChars(n6, n7);
        }
        n6 = n2 + n3 <= n12 << 2 ? 1 : 0;
        if (n6 != (n3 = ((n2 = n12 + 1) << 2) + n3 <= n11 ? 1 : 0)) {
            if (n6 == 0) {
                n12 = n2;
            }
            return this.toChars(n12, n7 + n4);
        }
        n3 = n9 - (n12 + n2 << 1);
        if (n3 >= 0 && (n3 != 0 || (n12 & 1) != 0)) {
            n12 = n2;
        }
        return this.toChars(n12, n7 + n4);
    }

    private static int rop(long l2, long l3) {
        l2 = a.a(l2, l3);
        return (int)(l2 >>> 31 | (l2 & 0xFFFFFFFFL) + 0xFFFFFFFFL >>> 32);
    }

    private int toChars(int n2, int n3) {
        int n4 = n2;
        n2 = (int)((long)(32 - Integer.numberOfLeadingZeros(n4)) * 661971961083L >> 41);
        long l2 = n4;
        long[] lArray = a.a;
        if (l2 >= a.a[n2]) {
            // empty if block
        }
        int n5 = ++n2;
        n2 = (int)(l2 * lArray[9 - n2]);
        int n6 = n2;
        n2 = (int)((long)n6 * 1441151881L >>> 57);
        int n7 = n6 - n2 * 100000000;
        if ((n3 += n5) > 0 && n3 <= 7) {
            return this.toChars1(n2, n7, n3);
        }
        if (-3 < n3 && n3 <= 0) {
            return this.toChars2(n2, n7, n3);
        }
        return this.toChars3(n2, n7, n3);
    }

    private int toChars1(int n2, int n3, int n4) {
        FloatToDecimal floatToDecimal = this;
        floatToDecimal.appendDigit(n2);
        n2 = floatToDecimal.y(n3);
        for (n3 = 1; n3 < n4; ++n3) {
            int n5 = n2 * 10;
            this.appendDigit(n5 >>> 28);
            n2 = n5 & 0xFFFFFFF;
        }
        this.append(46);
        while (n3 <= 8) {
            int n6 = n2 * 10;
            this.appendDigit(n6 >>> 28);
            n2 = n6 & 0xFFFFFFF;
            ++n3;
        }
        this.removeTrailingZeroes();
        return 0;
    }

    private int toChars2(int n2, int n3, int n4) {
        FloatToDecimal floatToDecimal = this;
        floatToDecimal.appendDigit(0);
        floatToDecimal.append(46);
        while (n4 < 0) {
            this.appendDigit(0);
            ++n4;
        }
        FloatToDecimal floatToDecimal2 = this;
        floatToDecimal2.appendDigit(n2);
        floatToDecimal2.append8Digits(n3);
        floatToDecimal2.removeTrailingZeroes();
        return 0;
    }

    private int toChars3(int n2, int n3, int n4) {
        FloatToDecimal floatToDecimal = this;
        FloatToDecimal floatToDecimal2 = this;
        floatToDecimal2.appendDigit(n2);
        floatToDecimal2.append(46);
        floatToDecimal.append8Digits(n3);
        floatToDecimal.removeTrailingZeroes();
        this.exponent(n4 - 1);
        return 0;
    }

    private void append8Digits(int n2) {
        n2 = this.y(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = n2 * 10;
            this.appendDigit(n3 >>> 28);
            n2 = n3 & 0xFFFFFFF;
        }
    }

    private void removeTrailingZeroes() {
        int n2;
        byte by;
        while ((by = this.bytes[n2 = this.index]) == 48) {
            this.index = n2 - 1;
        }
        if (by == 46) {
            this.index = n2 + 1;
        }
    }

    private int y(int n2) {
        return (int)(a.a((long)(n2 + 1) << 28, 193428131138340668L) >>> 20) - 1;
    }

    private void exponent(int n2) {
        this.append(69);
        if (n2 < 0) {
            this.append(45);
            n2 = -n2;
        }
        if (n2 < 10) {
            this.appendDigit(n2);
            return;
        }
        int n3 = n2;
        int n4 = n3 * 103 >>> 10;
        this.appendDigit(n4);
        this.appendDigit(n3 - n4 * 10);
    }

    private void append(int n2) {
        int n3;
        this.index = n3 = this.index + 1;
        this.bytes[n3] = (byte)n2;
    }

    private void appendDigit(int n2) {
        int n3;
        this.index = n3 = this.index + 1;
        this.bytes[n3] = (byte)(n2 + 48);
    }

    private String charsToString() {
        int n2 = this.index + 1;
        return new String(this.bytes, 0, 0, n2);
    }
}

