/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.JsonEncoding;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.format.InputAccessor;
import com.privatefasterxml.jackson.core.format.MatchStrength;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.io.MergedStream;
import com.privatefasterxml.jackson.core.io.UTF32Reader;
import com.privatefasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.privatefasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.privatefasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ByteSourceJsonBootstrapper {
    public static final byte UTF8_BOM_1 = -17;
    public static final byte UTF8_BOM_2 = -69;
    public static final byte UTF8_BOM_3 = -65;
    private final IOContext _context;
    private final InputStream _in;
    private final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    private boolean _bigEndian;
    private int _bytesPerChar;

    public ByteSourceJsonBootstrapper(IOContext iOContext, InputStream inputStream) {
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper = this;
        this._bigEndian = true;
        this._context = iOContext;
        this._in = inputStream;
        byteSourceJsonBootstrapper._inputBuffer = iOContext.allocReadIOBuffer();
        byteSourceJsonBootstrapper._inputPtr = 0;
        byteSourceJsonBootstrapper._inputEnd = 0;
        byteSourceJsonBootstrapper._bufferRecyclable = true;
    }

    public ByteSourceJsonBootstrapper(IOContext iOContext, byte[] byArray, int n2, int n3) {
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper = this;
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper2 = this;
        this._bigEndian = true;
        byteSourceJsonBootstrapper2._context = iOContext;
        byteSourceJsonBootstrapper2._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        byteSourceJsonBootstrapper._inputEnd = n2 + n3;
        byteSourceJsonBootstrapper._bufferRecyclable = false;
    }

    public static int skipUTF8BOM(DataInput dataInput) {
        int n2 = dataInput.readUnsignedByte();
        if (n2 != 239) {
            return n2;
        }
        n2 = dataInput.readUnsignedByte();
        if (n2 == 187) {
            n2 = dataInput.readUnsignedByte();
            if (n2 == 191) {
                return dataInput.readUnsignedByte();
            }
            throw new IOException("Unexpected byte 0x" + Integer.toHexString(n2) + " following 0xEF 0xBB; should get 0xBF as part of UTF-8 BOM");
        }
        throw new IOException("Unexpected byte 0x" + Integer.toHexString(n2) + " following 0xEF; should get 0xBB as part of UTF-8 BOM");
    }

    public static MatchStrength hasJSONFormat(InputAccessor inputAccessor) {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        int n2 = inputAccessor.nextByte();
        if (n2 == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            n2 = inputAccessor.nextByte();
        }
        if ((n2 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor, (byte)n2)) < 0) {
            return MatchStrength.INCONCLUSIVE;
        }
        if (n2 == 123) {
            int n3 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n3 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n3 != 34 && n3 != 125) {
                return MatchStrength.NO_MATCH;
            }
            return MatchStrength.SOLID_MATCH;
        }
        if (n2 == 91) {
            int n4 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n4 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n4 != 93 && n4 != 91) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.SOLID_MATCH;
        }
        MatchStrength matchStrength = MatchStrength.WEAK_MATCH;
        if (n2 == 34) {
            return matchStrength;
        }
        if (n2 <= 57 && n2 >= 48) {
            return matchStrength;
        }
        if (n2 == 45) {
            int n5 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n5 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n5 > 57 || n5 < 48) {
                matchStrength = MatchStrength.NO_MATCH;
            }
            return matchStrength;
        }
        if (n2 == 110) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "ull", matchStrength);
        }
        if (n2 == 116) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "rue", matchStrength);
        }
        if (n2 == 102) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "alse", matchStrength);
        }
        return MatchStrength.NO_MATCH;
    }

    private static MatchStrength tryMatch(InputAccessor inputAccessor, String string, MatchStrength matchStrength) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() == string.charAt(i2)) continue;
            return MatchStrength.NO_MATCH;
        }
        return matchStrength;
    }

    private static int skipSpace(InputAccessor inputAccessor) {
        if (!inputAccessor.hasMoreBytes()) {
            return -1;
        }
        InputAccessor inputAccessor2 = inputAccessor;
        return ByteSourceJsonBootstrapper.skipSpace(inputAccessor2, inputAccessor2.nextByte());
    }

    private static int skipSpace(InputAccessor inputAccessor, byte by) {
        while (true) {
            int n2 = by & 0xFF;
            by = (byte)n2;
            if (n2 != 32 && by != 13 && by != 10 && by != 9) {
                return by;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by = inputAccessor.nextByte();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleBOM(int n2) {
        if (n2 != -16842752) {
            if (n2 == -131072) {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            if (n2 == 65279) {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            if (n2 == 65534) {
                this.reportWeirdUCS4("2143");
            }
        } else {
            this.reportWeirdUCS4("3412");
        }
        int n3 = n2 >>> 16;
        if (n3 == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n3 == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n2 >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int n2) {
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (n2 >> 8 != 0) break block2;
                            this._bigEndian = true;
                            break block3;
                        }
                        if ((n2 & 0xFFFFFF) != 0) break block4;
                        this._bigEndian = false;
                        break block3;
                    }
                    if ((n2 & 0xFF00FFFF) != 0) break block5;
                    this.reportWeirdUCS4("3412");
                    break block3;
                }
                if ((n2 & 0xFFFF00FF) != 0) break block6;
                this.reportWeirdUCS4("2143");
            }
            this._bytesPerChar = 4;
            return true;
        }
        return false;
    }

    private boolean checkUTF16(int n2) {
        block4: {
            block3: {
                block2: {
                    if ((n2 & 0xFF00) != 0) break block2;
                    this._bigEndian = true;
                    break block3;
                }
                if ((n2 & 0xFF) != 0) break block4;
                this._bigEndian = false;
            }
            this._bytesPerChar = 2;
            return true;
        }
        return false;
    }

    private void reportWeirdUCS4(String string) {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    /*
     * Unable to fully structure code
     */
    public JsonEncoding detectEncoding() {
        block5: {
            block3: {
                block4: {
                    block2: {
                        if (!this.ensureLoaded(4)) break block2;
                        v0 = this;
                        var2_6 = this._inputPtr;
                        var1_1 = v0._inputBuffer;
                        var1_2 = v0._inputBuffer[var2_6] << 24 | (var1_1[var2_6 + 1] & 255) << 16 | (var1_1[var2_6 + 2] & 255) << 8 | var1_1[var2_6 + 3] & 255;
                        if (!v0.handleBOM(var1_2) && !this.checkUTF32(var1_2) && !this.checkUTF16(var1_2 >>> 16)) break block3;
                        break block4;
                    }
                    if (!this.ensureLoaded(2)) break block3;
                    v1 = this;
                    var2_7 = this._inputPtr;
                    var1_3 = v1._inputBuffer;
                    if (!v1.checkUTF16((v1._inputBuffer[var2_7] & 255) << 8 | var1_3[var2_7 + 1] & 255)) break block3;
                }
                if ((var1_4 = this._bytesPerChar) == 1) break block3;
                if (var1_4 == 2) ** GOTO lbl21
                if (var1_4 == 4) {
                    var1_5 = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
                } else {
                    throw new RuntimeException("Internal error");
lbl21:
                    // 1 sources

                    var1_5 = this._bigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
                }
                break block5;
            }
            var1_5 = JsonEncoding.UTF8;
        }
        this._context.setEncoding(var1_5);
        return var1_5;
    }

    public Reader constructReader() {
        Object object;
        Object object2 = ((ByteSourceJsonBootstrapper)object)._context.getEncoding();
        int n2 = object2.bits();
        if (n2 != 8 && n2 != 16) {
            if (n2 == 32) {
                ByteSourceJsonBootstrapper byteSourceJsonBootstrapper = object;
                object = byteSourceJsonBootstrapper._context;
                object2 = byteSourceJsonBootstrapper._in;
                byte[] byArray = byteSourceJsonBootstrapper._inputBuffer;
                int n3 = byteSourceJsonBootstrapper._inputPtr;
                int n4 = byteSourceJsonBootstrapper._inputEnd;
                Object object3 = object;
                boolean bl = ((IOContext)object3).getEncoding().isBigEndian();
                return new UTF32Reader((IOContext)object3, (InputStream)object2, byArray, n3, n4, bl);
            }
            throw new RuntimeException("Internal error");
        }
        InputStream inputStream = ((ByteSourceJsonBootstrapper)object)._in;
        if (inputStream == null) {
            ByteArrayInputStream byteArrayInputStream;
            inputStream = byteArrayInputStream;
            ByteSourceJsonBootstrapper byteSourceJsonBootstrapper = object;
            object = byteSourceJsonBootstrapper._inputBuffer;
            int n5 = byteSourceJsonBootstrapper._inputPtr;
            int n6 = byteSourceJsonBootstrapper._inputEnd;
            byteArrayInputStream = new ByteArrayInputStream((byte[])object, n5, n6);
        } else if (((ByteSourceJsonBootstrapper)object)._inputPtr < ((ByteSourceJsonBootstrapper)object)._inputEnd) {
            MergedStream mergedStream;
            MergedStream mergedStream2 = mergedStream;
            Object object4 = object;
            object = ((ByteSourceJsonBootstrapper)object4)._context;
            byte[] byArray = ((ByteSourceJsonBootstrapper)object4)._inputBuffer;
            int n7 = ((ByteSourceJsonBootstrapper)object4)._inputPtr;
            int n8 = ((ByteSourceJsonBootstrapper)object4)._inputEnd;
            mergedStream = new MergedStream((IOContext)object, inputStream, byArray, n7, n8);
            inputStream = mergedStream2;
        }
        return new InputStreamReader(inputStream, object2.getJavaName());
    }

    public JsonParser constructParser(int n2, ObjectCodec objectCodec, ByteQuadsCanonicalizer object, CharsToNameCanonicalizer object2, int n3) {
        Object object3;
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper = object3;
        int n4 = byteSourceJsonBootstrapper._inputPtr;
        n4 = ((ByteSourceJsonBootstrapper)object3)._inputPtr - n4;
        if (byteSourceJsonBootstrapper.detectEncoding() == JsonEncoding.UTF8 && JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n3)) {
            object = ((ByteQuadsCanonicalizer)object).makeChild(n3);
            Object object4 = object3;
            object3 = ((ByteSourceJsonBootstrapper)object4)._context;
            object2 = ((ByteSourceJsonBootstrapper)object4)._in;
            byte[] byArray = ((ByteSourceJsonBootstrapper)object4)._inputBuffer;
            int n5 = ((ByteSourceJsonBootstrapper)object4)._inputPtr;
            int n6 = ((ByteSourceJsonBootstrapper)object4)._inputEnd;
            boolean bl = ((ByteSourceJsonBootstrapper)object4)._bufferRecyclable;
            return new UTF8StreamJsonParser((IOContext)object3, n2, (InputStream)object2, objectCodec, (ByteQuadsCanonicalizer)object, byArray, n5, n6, n4, bl);
        }
        ByteSourceJsonBootstrapper byteSourceJsonBootstrapper2 = object3;
        object3 = byteSourceJsonBootstrapper2._context;
        object = byteSourceJsonBootstrapper2.constructReader();
        object2 = ((CharsToNameCanonicalizer)object2).makeChild(n3);
        return new ReaderBasedJsonParser((IOContext)object3, n2, (Reader)object, objectCodec, (CharsToNameCanonicalizer)object2);
    }

    public boolean ensureLoaded(int n2) {
        int n3;
        for (int i2 = this._inputEnd - this._inputPtr; i2 < n2; i2 += n3) {
            Object object = this._in;
            if (object == null) {
                n3 = -1;
            } else {
                InputStream inputStream = object;
                ByteSourceJsonBootstrapper byteSourceJsonBootstrapper = this;
                object = byteSourceJsonBootstrapper._inputBuffer;
                int n4 = byteSourceJsonBootstrapper._inputEnd;
                Object object2 = object;
                n3 = inputStream.read((byte[])object2, n4, ((Object)object2).length - n4);
            }
            if (n3 < 1) {
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }
}

