/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamWriteCapability;
import com.privatefasterxml.jackson.core.Version;
import com.privatefasterxml.jackson.core.base.GeneratorBase;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.core.util.VersionUtil;

public abstract class JsonGeneratorImpl
extends GeneratorBase {
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected static final JacksonFeatureSet<StreamWriteCapability> JSON_WRITE_CAPABILITIES = JsonGenerator.DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    protected final IOContext _ioContext;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    protected boolean _cfgUnqNames;
    protected boolean _cfgWriteHexUppercase;

    public JsonGeneratorImpl(IOContext iOContext, int n2, ObjectCodec objectCodec) {
        super(n2, objectCodec);
        this._ioContext = iOContext;
        if (JsonGenerator.Feature.ESCAPE_NON_ASCII.enabledIn(n2)) {
            this._maximumNonEscapedChar = 127;
        }
        JsonGeneratorImpl jsonGeneratorImpl = this;
        jsonGeneratorImpl._cfgWriteHexUppercase = JsonGenerator.Feature.WRITE_HEX_UPPER_CASE.enabledIn(n2);
        jsonGeneratorImpl._cfgUnqNames = JsonGenerator.Feature.QUOTE_FIELD_NAMES.enabledIn(n2) ^ true;
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        super.enable(feature);
        if (feature == JsonGenerator.Feature.QUOTE_FIELD_NAMES) {
            this._cfgUnqNames = false;
        } else if (feature == JsonGenerator.Feature.WRITE_HEX_UPPER_CASE) {
            this._cfgWriteHexUppercase = true;
        }
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        super.disable(feature);
        if (feature == JsonGenerator.Feature.QUOTE_FIELD_NAMES) {
            this._cfgUnqNames = true;
        } else if (feature == JsonGenerator.Feature.WRITE_HEX_UPPER_CASE) {
            this._cfgWriteHexUppercase = false;
        }
        return this;
    }

    @Override
    public void _checkStdFeatureChanges(int n2, int n3) {
        super._checkStdFeatureChanges(n2, n3);
        this._cfgUnqNames = JsonGenerator.Feature.QUOTE_FIELD_NAMES.enabledIn(n2) ^ true;
        this._cfgWriteHexUppercase = JsonGenerator.Feature.WRITE_HEX_UPPER_CASE.enabledIn(n2);
    }

    @Override
    public JsonGenerator setHighestNonEscapedChar(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this._maximumNonEscapedChar = n2;
        return this;
    }

    @Override
    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    @Override
    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        this._outputEscapes = characterEscapes == null ? sOutputEscapes : characterEscapes.getEscapeCodesForAscii();
        return this;
    }

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    @Override
    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        this._rootValueSeparator = serializableString;
        return this;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return JSON_WRITE_CAPABILITIES;
    }

    public void _verifyPrettyValueWrite(String string, int n2) {
        switch (n2) {
            default: {
                this._throwInternal();
                break;
            }
            case 5: {
                this._reportCantWriteValueExpectName(string);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
            }
        }
    }

    public void _reportCantWriteValueExpectName(String string) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string;
        objectArray[1] = this._writeContext.typeDesc();
        this._reportError(String.format("Can not %s, expecting field name (context: %s)", objectArray2));
    }
}

