/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParseException;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.json.DupDetector;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected DupDetector _dups;
    protected JsonReadContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected int _lineNr;
    protected int _columnNr;

    public JsonReadContext(JsonReadContext jsonReadContext, DupDetector dupDetector, int n2, int n3, int n4) {
        this._parent = jsonReadContext;
        this._dups = dupDetector;
        this._type = n2;
        this._lineNr = n3;
        this._columnNr = n4;
        this._index = -1;
    }

    public static JsonReadContext createRootContext(int n2, int n3, DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, n2, n3);
    }

    public static JsonReadContext createRootContext(DupDetector dupDetector) {
        return new JsonReadContext(null, dupDetector, 0, 1, 0);
    }

    private void _checkDup(DupDetector object, String string) {
        if (((DupDetector)object).isDup(string)) {
            Object object2 = ((DupDetector)object).getSource();
            object2 = object2 instanceof JsonParser ? (JsonParser)object2 : null;
            Object object3 = object;
            ((JsonParseException)object3)((JsonParser)object2, "Duplicate field '" + string + "'");
            throw object3;
        }
    }

    public void reset(int n2, int n3, int n4) {
        ((JsonStreamContext)((Object)dupDetector))._type = n2;
        ((JsonStreamContext)((Object)dupDetector))._index = -1;
        ((JsonReadContext)((Object)dupDetector))._lineNr = n3;
        ((JsonReadContext)((Object)dupDetector))._columnNr = n4;
        ((JsonReadContext)((Object)dupDetector))._currentName = null;
        ((JsonReadContext)((Object)dupDetector))._currentValue = null;
        DupDetector dupDetector = ((JsonReadContext)((Object)dupDetector))._dups;
        if (dupDetector != null) {
            dupDetector.reset();
        }
    }

    public JsonReadContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    public JsonReadContext createChildArrayContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            DupDetector dupDetector = this._dups;
            dupDetector = dupDetector == null ? null : dupDetector.child();
            this._child = jsonReadContext = new JsonReadContext(this, dupDetector, 1, n2, n3);
        } else {
            jsonReadContext.reset(1, n2, n3);
        }
        return jsonReadContext;
    }

    public JsonReadContext createChildObjectContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            DupDetector dupDetector = this._dups;
            dupDetector = dupDetector == null ? null : dupDetector.child();
            this._child = jsonReadContext = new JsonReadContext(this, dupDetector, 2, n2, n3);
            return jsonReadContext;
        }
        JsonReadContext jsonReadContext2 = jsonReadContext;
        jsonReadContext2.reset(2, n2, n3);
        return jsonReadContext2;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    @Override
    public JsonReadContext getParent() {
        return this._parent;
    }

    @Override
    public JsonLocation startLocation(ContentReference contentReference) {
        JsonReadContext jsonReadContext = this;
        int n2 = jsonReadContext._lineNr;
        int n3 = jsonReadContext._columnNr;
        return new JsonLocation(contentReference, -1L, n2, n3);
    }

    @Override
    @Deprecated
    public JsonLocation getStartLocation(Object object) {
        return this.startLocation(ContentReference.rawReference(object));
    }

    public JsonReadContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean expectComma() {
        int n2;
        JsonReadContext jsonReadContext = this;
        jsonReadContext._index = n2 = jsonReadContext._index + 1;
        return jsonReadContext._type != 0 && n2 > 0;
    }

    public void setCurrentName(String string) {
        this._currentName = string;
        DupDetector dupDetector = this._dups;
        if (dupDetector != null) {
            this._checkDup(dupDetector, string);
        }
    }
}

