/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.JsonParser;

public final class JsonReadFeature
extends Enum<JsonReadFeature>
implements FormatFeature {
    public static final /* enum */ JsonReadFeature ALLOW_JAVA_COMMENTS;
    public static final /* enum */ JsonReadFeature ALLOW_YAML_COMMENTS;
    public static final /* enum */ JsonReadFeature ALLOW_SINGLE_QUOTES;
    public static final /* enum */ JsonReadFeature ALLOW_UNQUOTED_FIELD_NAMES;
    public static final /* enum */ JsonReadFeature ALLOW_UNESCAPED_CONTROL_CHARS;
    public static final /* enum */ JsonReadFeature ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER;
    public static final /* enum */ JsonReadFeature ALLOW_LEADING_ZEROS_FOR_NUMBERS;
    public static final /* enum */ JsonReadFeature ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS;
    public static final /* enum */ JsonReadFeature ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS;
    public static final /* enum */ JsonReadFeature ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS;
    public static final /* enum */ JsonReadFeature ALLOW_NON_NUMERIC_NUMBERS;
    public static final /* enum */ JsonReadFeature ALLOW_MISSING_VALUES;
    public static final /* enum */ JsonReadFeature ALLOW_TRAILING_COMMA;
    private static final /* synthetic */ JsonReadFeature[] $VALUES;
    private final boolean _defaultState;
    private final int _mask;
    private final JsonParser.Feature _mappedFeature;

    public static JsonReadFeature[] values() {
        return (JsonReadFeature[])$VALUES.clone();
    }

    public static JsonReadFeature valueOf(String string) {
        return Enum.valueOf(JsonReadFeature.class, string);
    }

    public static int collectDefaults() {
        int n2 = 0;
        for (JsonReadFeature jsonReadFeature : JsonReadFeature.values()) {
            if (!jsonReadFeature.enabledByDefault()) continue;
            n2 |= jsonReadFeature.getMask();
        }
        return n2;
    }

    private JsonReadFeature(boolean bl, JsonParser.Feature feature) {
        this._defaultState = bl;
        this._mask = 1 << this.ordinal();
        this._mappedFeature = feature;
    }

    private static /* synthetic */ JsonReadFeature[] $values() {
        return new JsonReadFeature[]{ALLOW_JAVA_COMMENTS, ALLOW_YAML_COMMENTS, ALLOW_SINGLE_QUOTES, ALLOW_UNQUOTED_FIELD_NAMES, ALLOW_UNESCAPED_CONTROL_CHARS, ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, ALLOW_LEADING_ZEROS_FOR_NUMBERS, ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS, ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS, ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS, ALLOW_NON_NUMERIC_NUMBERS, ALLOW_MISSING_VALUES, ALLOW_TRAILING_COMMA};
    }

    static {
        JsonParser.Feature feature = JsonParser.Feature.ALLOW_COMMENTS;
        ALLOW_JAVA_COMMENTS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_YAML_COMMENTS;
        ALLOW_YAML_COMMENTS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_SINGLE_QUOTES;
        ALLOW_SINGLE_QUOTES = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES;
        ALLOW_UNQUOTED_FIELD_NAMES = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS;
        ALLOW_UNESCAPED_CONTROL_CHARS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER;
        ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS;
        ALLOW_LEADING_ZEROS_FOR_NUMBERS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS;
        ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS;
        ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS;
        ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS;
        ALLOW_NON_NUMERIC_NUMBERS = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_MISSING_VALUES;
        ALLOW_MISSING_VALUES = new JsonReadFeature(false, feature);
        feature = JsonParser.Feature.ALLOW_TRAILING_COMMA;
        ALLOW_TRAILING_COMMA = new JsonReadFeature(false, feature);
        $VALUES = JsonReadFeature.$values();
    }

    @Override
    public boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public int getMask() {
        return this._mask;
    }

    @Override
    public boolean enabledIn(int n2) {
        return (n2 & this._mask) != 0;
    }

    public JsonParser.Feature mappedFeature() {
        return this._mappedFeature;
    }
}

