/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.base.ParserBase;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class ReaderBasedJsonParser
extends ParserBase {
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_NON_NUM_NUMBERS = JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete;
    protected long _nameStartOffset;
    protected int _nameStartRow;
    protected int _nameStartCol;

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer, char[] cArray, int n3, int n4, boolean bl) {
        super(iOContext, n2);
        this._reader = reader;
        this._objectCodec = objectCodec;
        this._inputBuffer = cArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._currInputRowStart = n3;
        this._currInputProcessed = -n3;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = bl;
    }

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        ReaderBasedJsonParser readerBasedJsonParser = this;
        ReaderBasedJsonParser readerBasedJsonParser2 = this;
        super(iOContext, n2);
        this._reader = reader;
        readerBasedJsonParser2._inputBuffer = iOContext.allocTokenBuffer();
        readerBasedJsonParser2._inputPtr = 0;
        readerBasedJsonParser2._inputEnd = 0;
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        readerBasedJsonParser._hashSeed = charsToNameCanonicalizer.hashSeed();
        readerBasedJsonParser._bufferRecyclable = true;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            int n2 = readerBasedJsonParser._tokenInputRow;
            this._parsingContext = this._parsingContext.createChildArrayContext(n2, readerBasedJsonParser._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            int n3 = readerBasedJsonParser._tokenInputRow;
            this._parsingContext = this._parsingContext.createChildObjectContext(n3, readerBasedJsonParser._tokenInputCol);
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _isNextTokenNameYes(int n2) {
        JsonToken jsonToken;
        block8: {
            block9: {
                block10: {
                    block11: {
                        block12: {
                            block13: {
                                block14: {
                                    block15: {
                                        this._currToken = JsonToken.FIELD_NAME;
                                        this._updateLocation();
                                        if (n2 == 34) break block9;
                                        if (n2 == 43) break block10;
                                        if (n2 == 91) break block11;
                                        if (n2 == 102) break block12;
                                        if (n2 == 110) break block13;
                                        if (n2 == 116) break block14;
                                        if (n2 == 123) break block15;
                                        if (n2 != 45) {
                                            if (n2 != 46) {
                                                switch (n2) {
                                                    default: {
                                                        jsonToken = this._handleOddValue(n2);
                                                        break;
                                                    }
                                                    case 48: 
                                                    case 49: 
                                                    case 50: 
                                                    case 51: 
                                                    case 52: 
                                                    case 53: 
                                                    case 54: 
                                                    case 55: 
                                                    case 56: 
                                                    case 57: {
                                                        jsonToken = this._parseUnsignedNumber(n2);
                                                        break;
                                                    }
                                                }
                                                break block8;
                                            } else {
                                                jsonToken = this._parseFloatThatStartsWithPeriod(false);
                                            }
                                            break block8;
                                        } else {
                                            jsonToken = this._parseSignedNumber(true);
                                        }
                                        break block8;
                                    }
                                    jsonToken = JsonToken.START_OBJECT;
                                    break block8;
                                }
                                this._matchToken("true", 1);
                                jsonToken = JsonToken.VALUE_TRUE;
                                break block8;
                            }
                            this._matchToken("null", 1);
                            jsonToken = JsonToken.VALUE_NULL;
                            break block8;
                        }
                        this._matchToken("false", 1);
                        jsonToken = JsonToken.VALUE_FALSE;
                        break block8;
                    }
                    jsonToken = JsonToken.START_ARRAY;
                    break block8;
                }
                if (this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    this._nextToken = this._parseSignedNumber(false);
                    return;
                }
                this._nextToken = this._handleOddValue(n2);
                return;
            }
            this._tokenIncomplete = true;
            jsonToken = JsonToken.VALUE_STRING;
        }
        this._nextToken = jsonToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JsonToken _nextTokenNotInObject(int n2) {
        JsonToken jsonToken;
        block9: {
            block10: {
                block11: {
                    block12: {
                        block13: {
                            block14: {
                                block8: {
                                    if (n2 != 34) break block8;
                                    this._tokenIncomplete = true;
                                    jsonToken = JsonToken.VALUE_STRING;
                                    break block9;
                                }
                                if (n2 == 91) break block10;
                                if (n2 == 102) break block11;
                                if (n2 == 110) break block12;
                                if (n2 == 116) break block13;
                                if (n2 == 123) break block14;
                                block0 : switch (n2) {
                                    default: {
                                        switch (n2) {
                                            default: {
                                                break block0;
                                            }
                                            case 48: 
                                            case 49: 
                                            case 50: 
                                            case 51: 
                                            case 52: 
                                            case 53: 
                                            case 54: 
                                            case 55: 
                                            case 56: 
                                            case 57: 
                                        }
                                        jsonToken = this._parseUnsignedNumber(n2);
                                        break block9;
                                    }
                                    case 46: {
                                        jsonToken = this._parseFloatThatStartsWithPeriod(false);
                                        break block9;
                                    }
                                    case 45: {
                                        jsonToken = this._parseSignedNumber(true);
                                        break block9;
                                    }
                                    case 44: {
                                        if (this._parsingContext.inRoot() || (this._features & FEAT_MASK_ALLOW_MISSING) == 0) break;
                                        --this._inputPtr;
                                        jsonToken = JsonToken.VALUE_NULL;
                                        break block9;
                                    }
                                }
                                jsonToken = this._handleOddValue(n2);
                                break block9;
                            }
                            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                            jsonToken = JsonToken.START_OBJECT;
                            break block9;
                        }
                        this._matchToken("true", 1);
                        jsonToken = JsonToken.VALUE_TRUE;
                        break block9;
                    }
                    this._matchToken("null", 1);
                    jsonToken = JsonToken.VALUE_NULL;
                    break block9;
                }
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break block9;
            }
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            jsonToken = JsonToken.START_ARRAY;
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    private final JsonToken _parseFloat(int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = this._inputEnd;
        int n7 = 0;
        if (n2 == 46) {
            while (true) {
                if (n4 >= n6) {
                    return this._parseNumber2(bl, n3);
                }
                if ((n2 = this._inputBuffer[n4++]) < 48 || n2 > 57) break;
                ++n7;
            }
            if (n7 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n2, "Decimal point not followed by a digit");
            }
        }
        int n8 = 0;
        if (n2 == 101 || n2 == 69) {
            if (n4 >= n6) {
                this._inputPtr = n3;
                return this._parseNumber2(bl, n3);
            }
            char[] cArray = this._inputBuffer;
            int n9 = n4 + 1;
            int n10 = this._inputBuffer[n4];
            if (n10 != 45 && n10 != 43) {
                n4 = n9;
                n2 = n10;
            } else {
                if (n9 >= n6) {
                    this._inputPtr = n3;
                    return this._parseNumber2(bl, n3);
                }
                n2 = n4 + 2;
                int n11 = n4 = cArray[n9];
                n4 = n2;
                n2 = n11;
            }
            while (n2 <= 57 && n2 >= 48) {
                ++n8;
                if (n4 >= n6) {
                    this._inputPtr = n3;
                    return this._parseNumber2(bl, n3);
                }
                int n12 = n4;
                n2 = n12 + 1;
                int n13 = n4 = this._inputBuffer[n12];
                n4 = n2;
                n2 = n13;
            }
            if (n8 == 0) {
                this._reportUnexpectedNumberChar(n2, "Exponent indicator not followed by a digit");
            }
        }
        this._inputPtr = n4 += -1;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n2);
        }
        n2 = n4 - n3;
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n2);
        return this.resetFloat(bl, n5, n7, n8);
    }

    private final JsonToken _parseSignedNumber(boolean bl) {
        int n2;
        int n3 = this._inputPtr;
        int n4 = bl ? n3 - 1 : n3;
        int n5 = this._inputEnd;
        if (n3 >= n5) {
            return this._parseNumber2(bl, n4);
        }
        if ((n2 = this._inputBuffer[n3++]) <= 57 && n2 >= 48) {
            char c2;
            int n6;
            if (n2 == 48) {
                return this._parseNumber2(bl, n4);
            }
            n2 = 1;
            while (true) {
                if (n3 >= n5) {
                    return this._parseNumber2(bl, n4);
                }
                int n7 = n3;
                n6 = n7 + 1;
                c2 = this._inputBuffer[n7];
                if (c2 < '0' || c2 > '9') break;
                ++n2;
                n3 = n6;
            }
            if (c2 != '.' && c2 != 'e' && c2 != 'E') {
                this._inputPtr = n3;
                if (this._parsingContext.inRoot()) {
                    this._verifyRootSpace(c2);
                }
                int n8 = n3 - n4;
                this._textBuffer.resetWithShared(this._inputBuffer, n4, n8);
                return this.resetInt(bl, n2);
            }
            this._inputPtr = n6;
            return this._parseFloat(c2, n4, n6, bl, n2);
        }
        this._inputPtr = n3;
        if (n2 == 46) {
            return this._parseFloatThatStartsWithPeriod(bl);
        }
        return this._handleInvalidNumberStart(n2, bl, true);
    }

    private final JsonToken _parseNumber2(boolean bl, int n2) {
        int n3;
        int n4;
        if (bl) {
            ++n2;
        }
        this._inputPtr = n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        if (bl) {
            n4 = 1;
            cArray[n5] = 45;
            n5 = n4;
        }
        n4 = 0;
        int n6 = this._inputPtr;
        if (n6 < this._inputEnd) {
            int n7 = n6;
            this._inputPtr = n7 + 1;
            n6 = this._inputBuffer[n7];
        } else {
            JsonToken jsonToken = JsonToken.VALUE_NUMBER_INT;
            n6 = this.getNextChar("No digit following minus sign", jsonToken);
        }
        if (n6 == 48) {
            n6 = this._verifyNoLeadingZeroes();
        }
        boolean bl2 = false;
        while (n6 >= 48 && n6 <= 57) {
            ++n4;
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n5 = 0;
            }
            cArray[n5++] = n6;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                n6 = 0;
                bl2 = true;
                break;
            }
            n6 = this._inputBuffer[this._inputPtr++];
        }
        if (n4 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleInvalidNumberStart(n6, bl);
        }
        int n8 = -1;
        if (n6 == 46) {
            n8 = 0;
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n5 = 0;
            }
            n3 = n5 + 1;
            cArray[n5] = n6;
            n5 = n3;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((n6 = this._inputBuffer[this._inputPtr++]) < 48 || n6 > 57) break;
                ++n8;
                if (n5 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                n3 = n5 + 1;
                cArray[n5] = n6;
                n5 = n3;
            }
            if (n8 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n6, "Decimal point not followed by a digit");
            }
        }
        n3 = -1;
        if (n6 == 101 || n6 == 69) {
            n3 = 0;
            if (n5 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n5 = 0;
            }
            cArray[n5++] = n6;
            n6 = this._inputPtr;
            if (n6 < this._inputEnd) {
                int n9 = n6;
                this._inputPtr = n9 + 1;
                n6 = this._inputBuffer[n9];
            } else {
                JsonToken jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                n6 = this.getNextChar("expected a digit for number exponent", jsonToken);
            }
            if (n6 == 45 || n6 == 43) {
                if (n5 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                cArray[n5++] = n6;
                n6 = this._inputPtr;
                if (n6 < this._inputEnd) {
                    int n10 = n6;
                    this._inputPtr = n10 + 1;
                    n6 = this._inputBuffer[n10];
                } else {
                    JsonToken jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                    n6 = this.getNextChar("expected a digit for number exponent", jsonToken);
                }
            }
            while (n6 <= 57 && n6 >= 48) {
                ++n3;
                if (n5 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                cArray[n5++] = n6;
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    bl2 = true;
                    break;
                }
                n6 = this._inputBuffer[this._inputPtr++];
            }
            if (n3 == 0) {
                this._reportUnexpectedNumberChar(n6, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(n6);
            }
        }
        this._textBuffer.setCurrentLength(n5);
        if (n8 < 0 && n3 < 0) {
            return this.resetInt(bl, n4);
        }
        return this.resetFloat(bl, n4, n8, n3);
    }

    private final char _verifyNoLeadingZeroes() {
        int n2 = this._inputPtr;
        if (n2 < this._inputEnd && ((n2 = this._inputBuffer[n2]) < 48 || n2 > 57)) {
            return '0';
        }
        return this._verifyNLZ2();
    }

    private char _verifyNLZ2() {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return '0';
        }
        int n2 = this._inputBuffer[this._inputPtr];
        if (n2 >= 48 && n2 <= 57) {
            if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
                this.reportInvalidNumber("Leading zeroes not allowed");
            }
            ++this._inputPtr;
            if (n2 == 48) {
                while (this._inputPtr < this._inputEnd || this._loadMore()) {
                    n2 = this._inputPtr;
                    int n3 = this._inputBuffer[n2];
                    if (n3 >= 48 && n3 <= 57) {
                        this._inputPtr = n2 + 1;
                        if (n3 != 48) {
                            n2 = n3;
                            break;
                        }
                        n2 = n3;
                        continue;
                    }
                    return '0';
                }
            }
            return (char)n2;
        }
        return '0';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void _verifyRootSpace(int n2) {
        int n3;
        int n4 = this._inputPtr;
        this._inputPtr = n3 = n4 + 1;
        if (n2 == 9) return;
        if (n2 != 10) {
            if (n2 != 13) {
                if (n2 == 32) return;
                this._reportMissingRootWS(n2);
                return;
            }
            this._inputPtr = n4;
            return;
        }
        ++this._currInputRow;
        this._currInputRowStart = n3;
    }

    private String _parseName2(int n2, int n3, int n4) {
        ReaderBasedJsonParser readerBasedJsonParser = object;
        readerBasedJsonParser._textBuffer.resetWithShared(((ReaderBasedJsonParser)object)._inputBuffer, n2, ((ParserBase)object)._inputPtr - n2);
        char[] cArray = readerBasedJsonParser._textBuffer.getCurrentSegment();
        int n5 = readerBasedJsonParser._textBuffer.getCurrentSegmentSize();
        while (true) {
            if (((ParserBase)object)._inputPtr >= ((ParserBase)object)._inputEnd && !((ReaderBasedJsonParser)object)._loadMore()) {
                ((ParserMinimalBase)object)._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
            }
            int n6 = ((ParserBase)object)._inputPtr;
            ((ParserBase)object)._inputPtr = n6 + 1;
            if ((n6 = ((ReaderBasedJsonParser)object)._inputBuffer[n6]) <= 92) {
                if (n6 == 92) {
                    n6 = ((ReaderBasedJsonParser)object)._decodeEscaped();
                } else if (n6 <= n4) {
                    if (n6 == n4) {
                        ReaderBasedJsonParser readerBasedJsonParser2 = object;
                        readerBasedJsonParser2._textBuffer.setCurrentLength(n5);
                        TextBuffer textBuffer = readerBasedJsonParser2._textBuffer;
                        Object object = textBuffer.getTextBuffer();
                        int n7 = textBuffer.getTextOffset();
                        n4 = textBuffer.size();
                        return readerBasedJsonParser2._symbols.findSymbol((char[])object, n7, n4, n3);
                    }
                    if (n6 < 32) {
                        ((ParserBase)object)._throwUnquotedSpace(n6, "name");
                    }
                }
            }
            n3 = n3 * 33 + n6;
            int n8 = n5 + 1;
            cArray[n5] = n6;
            if (n8 >= cArray.length) {
                cArray = ((ParserBase)object)._textBuffer.finishCurrentSegment();
                n5 = 0;
                continue;
            }
            n5 = n8;
        }
    }

    private String _handleOddName2(int n2, int n3, int[] nArray) {
        ReaderBasedJsonParser readerBasedJsonParser = object;
        readerBasedJsonParser._textBuffer.resetWithShared(((ReaderBasedJsonParser)object)._inputBuffer, n2, ((ParserBase)object)._inputPtr - n2);
        char[] cArray = readerBasedJsonParser._textBuffer.getCurrentSegment();
        int n4 = readerBasedJsonParser._textBuffer.getCurrentSegmentSize();
        int n5 = nArray.length;
        while (true) {
            char c2;
            if (((ParserBase)object)._inputPtr >= ((ParserBase)object)._inputEnd && !((ReaderBasedJsonParser)object)._loadMore() || ((c2 = ((ReaderBasedJsonParser)object)._inputBuffer[((ParserBase)object)._inputPtr]) < n5 ? nArray[c2] != 0 : !Character.isJavaIdentifierPart(c2))) {
                ReaderBasedJsonParser readerBasedJsonParser2 = object;
                readerBasedJsonParser2._textBuffer.setCurrentLength(n4);
                TextBuffer textBuffer = readerBasedJsonParser2._textBuffer;
                Object object = textBuffer.getTextBuffer();
                int n6 = textBuffer.getTextOffset();
                int n7 = textBuffer.size();
                return readerBasedJsonParser2._symbols.findSymbol((char[])object, n6, n7, n3);
            }
            ++((ParserBase)object)._inputPtr;
            n3 = n3 * 33 + c2;
            int n8 = n4 + 1;
            cArray[n4] = c2;
            if (n8 >= cArray.length) {
                cArray = ((ParserBase)object)._textBuffer.finishCurrentSegment();
                n4 = 0;
                continue;
            }
            n4 = n8;
        }
    }

    private final int _skipColon() {
        int n2 = this._inputPtr;
        if (n2 + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        char[] cArray = this._inputBuffer;
        int n3 = this._inputBuffer[n2];
        if (n3 == 58) {
            this._inputPtr = n3 = n2 + 1;
            if ((n3 = cArray[n3]) > 32) {
                if (n3 != 47 && n3 != 35) {
                    this._inputPtr = n2 + 2;
                    return n3;
                }
                return this._skipColon2(true);
            }
            if (n3 == 32 || n3 == 9) {
                int n4;
                this._inputPtr = n4 = n2 + 2;
                if ((n4 = cArray[n4]) > 32) {
                    if (n4 != 47 && n4 != 35) {
                        this._inputPtr = n2 + 3;
                        return n4;
                    }
                    return this._skipColon2(true);
                }
            }
            return this._skipColon2(true);
        }
        if (n3 == 32 || n3 == 9) {
            this._inputPtr = ++n2;
            n3 = cArray[n2];
        }
        if (n3 == 58) {
            n2 = this._inputPtr;
            this._inputPtr = n3 = n2 + 1;
            if ((n3 = cArray[n3]) > 32) {
                if (n3 != 47 && n3 != 35) {
                    this._inputPtr = n2 + 2;
                    return n3;
                }
                return this._skipColon2(true);
            }
            if (n3 == 32 || n3 == 9) {
                int n5;
                this._inputPtr = n5 = n2 + 2;
                if ((n5 = cArray[n5]) > 32) {
                    if (n5 != 47 && n5 != 35) {
                        this._inputPtr = n2 + 3;
                        return n5;
                    }
                    return this._skipColon2(true);
                }
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private final int _skipColon2(boolean bl) {
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(" within/between " + this._parsingContext.typeDesc() + " entries", null);
                return -1;
            }
            int n3 = this._inputPtr;
            this._inputPtr = n2 = n3 + 1;
            if ((n3 = this._inputBuffer[n3]) > 32) {
                if (n3 == 47) {
                    this._skipComment();
                    continue;
                }
                if (n3 == 35 && this._skipYAMLComment()) continue;
                if (bl) {
                    return n3;
                }
                if (n3 != 58) {
                    this._reportUnexpectedChar(n3, "was expecting a colon to separate field name and value");
                }
                bl = true;
                continue;
            }
            if (n3 >= 32) continue;
            if (n3 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = n2;
                continue;
            }
            if (n3 == 13) {
                this._skipCR();
                continue;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int _skipColonFast(int var1_1) {
        block11: {
            block12: {
                var2_2 = this._inputBuffer;
                var3_5 = var1_1 + 1;
                var4_6 = this._inputBuffer[var1_1];
                if (var4_6 == 58) {
                    var4_6 = var1_1 + 2;
                    if ((var3_5 = var2_2[var3_5]) > 32) {
                        if (var3_5 != 47 && var3_5 != 35) {
                            this._inputPtr = var4_6;
                            return var3_5;
                        }
                    } else if (var3_5 == 32 || var3_5 == 9) {
                        var1_1 += 3;
                        var2_3 = var2_2[var4_6];
                        if (var2_3 > ' ' && var2_3 != '/' && var2_3 != '#') {
                            this._inputPtr = var1_1;
                            return var2_3;
                        }
                        var4_6 = var1_1;
                    }
                    this._inputPtr = var4_6 - 1;
                    return this._skipColon2(true);
                }
                if (var4_6 == 32 || var4_6 == 9) {
                    var4_6 = var2_2[var3_5];
                    var3_5 = var1_1 += 2;
                }
                if ((var1_1 = var4_6 == 58 ? 1 : 0) == 0) break block11;
                var4_6 = var3_5 + 1;
                var5_7 = var2_2[var3_5];
                if (var5_7 <= ' ') break block12;
                if (var5_7 != '/' && var5_7 != '#') {
                    this._inputPtr = var4_6;
                    return var5_7;
                }
                ** GOTO lbl-1000
            }
            if (var5_7 != ' ' && var5_7 != '\t') lbl-1000:
            // 2 sources

            {
                var3_5 = var4_6;
            } else {
                var3_5 += 2;
                var2_4 = var2_2[var4_6];
                if (var2_4 > ' ' && var2_4 != '/' && var2_4 != '#') {
                    this._inputPtr = var3_5;
                    return var2_4;
                }
            }
        }
        this._inputPtr = var3_5 - 1;
        return this._skipColon2((boolean)var1_1);
    }

    private final int _skipComma(int n2) {
        if (n2 != 44) {
            this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries");
        }
        while ((n2 = this._inputPtr) < this._inputEnd) {
            int n3;
            this._inputPtr = n3 = n2 + 1;
            char c2 = this._inputBuffer[n2];
            if (c2 > ' ') {
                if (c2 != '/' && c2 != '#') {
                    return c2;
                }
                this._inputPtr = n2;
                return this._skipAfterComma2();
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = n3;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this._skipAfterComma2();
    }

    private final int _skipAfterComma2() {
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.typeDesc() + " entries");
            }
            int n3 = this._inputPtr;
            this._inputPtr = n2 = n3 + 1;
            if ((n3 = this._inputBuffer[n3]) > 32) {
                if (n3 == 47) {
                    this._skipComment();
                    continue;
                }
                if (n3 == 35 && this._skipYAMLComment()) continue;
                return n3;
            }
            if (n3 >= 32) continue;
            if (n3 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = n2;
                continue;
            }
            if (n3 == 13) {
                this._skipCR();
                continue;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int _skipWSOrEnd() {
        block10: {
            block9: {
                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                    return this._eofAsNextChar();
                }
                var1_1 = this._inputPtr;
                this._inputPtr = var2_2 = var1_1 + 1;
                var3_3 = this._inputBuffer[var1_1];
                if (var3_3 > ' ') {
                    if (var3_3 != '/' && var3_3 != '#') {
                        return var3_3;
                    }
                    this._inputPtr = var1_1;
                    return this._skipWSOrEnd2();
                }
                if (var3_3 == ' ') ** GOTO lbl26
                if (var3_3 != '\n') break block9;
                while (true) {
                    ++this._currInputRow;
                    this._currInputRowStart = var2_2;
                    ** GOTO lbl26
                    break;
                }
            }
            if (var3_3 != '\r') break block10;
            while (true) {
                this._skipCR();
                ** GOTO lbl26
                break;
            }
        }
        if (var3_3 == '\t') ** GOTO lbl26
        block2: while (true) {
            this._throwInvalidSpace(var3_3);
            while ((var1_1 = this._inputPtr) < this._inputEnd) {
                v0 = var1_1;
                this._inputPtr = var2_2 = v0 + 1;
                var3_3 = this._inputBuffer[v0];
                if (var3_3 > ' ') {
                    if (var3_3 != '/' && var3_3 != '#') {
                        return var3_3;
                    }
                    this._inputPtr = var1_1;
                    return this._skipWSOrEnd2();
                }
                if (var3_3 == ' ') continue;
                if (var3_3 == '\n') ** continue;
                if (var3_3 == '\r') ** continue;
                if (var3_3 == '\t') continue;
                continue block2;
            }
            break;
        }
        return this._skipWSOrEnd2();
    }

    private int _skipWSOrEnd2() {
        while (this._inputPtr < this._inputEnd || this._loadMore()) {
            int n2;
            int n3 = this._inputPtr;
            this._inputPtr = n2 = n3 + 1;
            if ((n3 = this._inputBuffer[n3]) > 32) {
                if (n3 == 47) {
                    this._skipComment();
                    continue;
                }
                if (n3 == 35 && this._skipYAMLComment()) continue;
                return n3;
            }
            if (n3 == 32) continue;
            if (n3 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = n2;
                continue;
            }
            if (n3 == 13) {
                this._skipCR();
                continue;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
        return this._eofAsNextChar();
    }

    private void _skipComment() {
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in a comment", null);
        }
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        if ((n2 = this._inputBuffer[n2]) == 47) {
            this._skipLine();
        } else if (n2 == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
        }
    }

    private void _skipCComment() {
        while (true) {
            int n2;
            int n3;
            block7: {
                block8: {
                    block6: {
                        if (this._inputPtr >= this._inputEnd && !this._loadMore()) break block6;
                        n3 = this._inputPtr;
                        this._inputPtr = n2 = n3 + 1;
                        if ((n3 = this._inputBuffer[n3]) > 42) continue;
                        if (n3 != 42) break block7;
                        if (n2 < this._inputEnd || this._loadMore()) break block8;
                    }
                    this._reportInvalidEOF(" in a comment", null);
                    return;
                }
                n3 = this._inputPtr;
                if (this._inputBuffer[n3] != '/') continue;
                this._inputPtr = n3 + 1;
                return;
            }
            if (n3 >= 32) continue;
            if (n3 == 10) {
                ++this._currInputRow;
                this._currInputRowStart = n2;
                continue;
            }
            if (n3 == 13) {
                this._skipCR();
                continue;
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
    }

    private boolean _skipYAMLComment() {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private void _skipLine() {
        while (true) {
            int n2;
            block5: {
                block3: {
                    block4: {
                        int n3;
                        if (this._inputPtr >= this._inputEnd && !this._loadMore()) break block3;
                        n2 = this._inputPtr;
                        this._inputPtr = n3 = n2 + 1;
                        if ((n2 = this._inputBuffer[n2]) >= 32) continue;
                        if (n2 != 10) break block4;
                        ++this._currInputRow;
                        this._currInputRowStart = n3;
                        break block3;
                    }
                    if (n2 != 13) break block5;
                    this._skipCR();
                }
                return;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
    }

    private final void _matchTrue() {
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n2] == 'r' && cArray[n2 + 1] == 'u' && cArray[n2 + 2] == 'e' && ((c2 = cArray[n2 += 3]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n2;
                return;
            }
        }
        this._matchToken("true", 1);
    }

    private final void _matchFalse() {
        int n2 = this._inputPtr;
        if (n2 + 4 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n2] == 'a' && cArray[n2 + 1] == 'l' && cArray[n2 + 2] == 's' && cArray[n2 + 3] == 'e' && ((c2 = cArray[n2 += 4]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n2;
                return;
            }
        }
        this._matchToken("false", 1);
    }

    private final void _matchNull() {
        int n2 = this._inputPtr;
        if (n2 + 3 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n2] == 'u' && cArray[n2 + 1] == 'l' && cArray[n2 + 2] == 'l' && ((c2 = cArray[n2 += 3]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n2;
                return;
            }
        }
        this._matchToken("null", 1);
    }

    private final void _matchToken2(String string, int n2) {
        int n3;
        int n4 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this._loadMore() || this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            this._inputPtr = n3 = this._inputPtr + 1;
        } while (++n2 < n4);
        if (n3 >= this._inputEnd && !this._loadMore()) {
            return;
        }
        n4 = this._inputBuffer[this._inputPtr];
        if (n4 >= 48 && n4 != 93 && n4 != 125) {
            this._checkMatchEnd(string, n2, n4);
        }
    }

    private final void _checkMatchEnd(String string, int n2, int n3) {
        if (Character.isJavaIdentifierPart((char)n3)) {
            this._reportInvalidToken(string.substring(0, n2));
        }
    }

    private final void _updateLocation() {
        int n2 = this._inputPtr;
        ReaderBasedJsonParser readerBasedJsonParser = this;
        readerBasedJsonParser._tokenInputTotal = readerBasedJsonParser._currInputProcessed + (long)n2;
        readerBasedJsonParser._tokenInputRow = readerBasedJsonParser._currInputRow;
        this._tokenInputCol = n2 - readerBasedJsonParser._currInputRowStart;
    }

    private final void _updateNameLocation() {
        int n2 = this._inputPtr;
        ReaderBasedJsonParser readerBasedJsonParser = this;
        readerBasedJsonParser._nameStartOffset = n2;
        readerBasedJsonParser._nameStartRow = readerBasedJsonParser._currInputRow;
        this._nameStartCol = n2 - readerBasedJsonParser._currInputRowStart;
    }

    private void _closeScope(int n2) {
        if (n2 == 93) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            readerBasedJsonParser._updateLocation();
            if (!readerBasedJsonParser._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n2 == 125) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            readerBasedJsonParser._updateLocation();
            if (!readerBasedJsonParser._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return ParserBase.JSON_READ_CAPABILITIES;
    }

    @Override
    public int releaseBuffered(Writer writer) {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd - n2;
        if (n3 < 1) {
            return 0;
        }
        this._inputPtr = n2 + n3;
        writer.write(this._inputBuffer, n2, n3);
        return n3;
    }

    @Override
    public Object getInputSource() {
        return this._reader;
    }

    @Deprecated
    public char getNextChar(String string) {
        return this.getNextChar(string, null);
    }

    public char getNextChar(String string, JsonToken jsonToken) {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(string, jsonToken);
        }
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return this._inputBuffer[n2];
    }

    @Override
    public void _closeInput() {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    @Override
    public void _releaseBuffers() {
        ReaderBasedJsonParser readerBasedJsonParser = this;
        super._releaseBuffers();
        readerBasedJsonParser._symbols.release();
        if (readerBasedJsonParser._bufferRecyclable) {
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                this._inputBuffer = null;
                this._ioContext.releaseTokenBuffer(cArray);
            }
        }
    }

    public void _loadMoreGuaranteed() {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    public boolean _loadMore() {
        Object object = this._reader;
        if (object != null) {
            int n2 = this._inputBuffer.length;
            int n3 = ((Reader)object).read((char[])(object = (Object)this._inputBuffer), 0, n2);
            if (n3 > 0) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n4 = readerBasedJsonParser._inputEnd;
                long l2 = n4;
                readerBasedJsonParser._currInputProcessed += l2;
                readerBasedJsonParser._currInputRowStart -= n4;
                readerBasedJsonParser._nameStartOffset -= l2;
                readerBasedJsonParser._inputPtr = 0;
                this._inputEnd = n3;
                return true;
            }
            this._closeInput();
            if (n3 == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    @Override
    public final String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    @Override
    public int getText(Writer writer) {
        Object object;
        JsonToken jsonToken = ((ParserMinimalBase)object)._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (((ReaderBasedJsonParser)object)._tokenIncomplete) {
                ((ReaderBasedJsonParser)object)._tokenIncomplete = false;
                ((ReaderBasedJsonParser)object)._finishString();
            }
            return ((ParserBase)object)._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            object = ((ParserBase)object)._parsingContext.getCurrentName();
            writer.write((String)object);
            return ((String)object).length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return ((ParserBase)object)._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            object = cArray;
            writer.write(cArray);
            return ((Object)object).length;
        }
        return 0;
    }

    @Override
    public final String getValueAsString() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public final String getValueAsString(String string) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    public final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            default: {
                return jsonToken.asString();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
            case 5: 
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public final char[] getTextCharacters() {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                default: {
                    return this._currToken.asCharArray();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
                case 5: 
            }
            if (!this._nameCopied) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                object = readerBasedJsonParser._parsingContext.getCurrentName();
                int n2 = ((String)object).length();
                char[] cArray = readerBasedJsonParser._nameCopyBuffer;
                if (readerBasedJsonParser._nameCopyBuffer == null) {
                    this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                } else if (cArray.length < n2) {
                    this._nameCopyBuffer = new char[n2];
                }
                JsonToken jsonToken = object;
                object = this._nameCopyBuffer;
                ((String)((Object)jsonToken)).getChars(0, n2, (char[])object, 0);
                this._nameCopied = true;
            }
            return this._nameCopyBuffer;
        }
        return null;
    }

    @Override
    public final int getTextLength() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                default: {
                    return this._currToken.asCharArray().length;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
                case 5: 
            }
            return this._parsingContext.getCurrentName().length();
        }
        return 0;
    }

    @Override
    public final int getTextOffset() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                default: {
                    break;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_EMBEDDED_OBJECT) {
            byte[] byArray = this._binaryValue;
            if (this._binaryValue != null) {
                return byArray;
            }
        }
        if (object != JsonToken.VALUE_STRING) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
                this._tokenIncomplete = false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
        } else if (this._binaryValue == null) {
            ReaderBasedJsonParser readerBasedJsonParser = this;
            object = readerBasedJsonParser._getByteArrayBuilder();
            readerBasedJsonParser._decodeBase64(readerBasedJsonParser.getText(), (ByteArrayBuilder)object, base64Variant);
            readerBasedJsonParser._binaryValue = ((ByteArrayBuilder)object).toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant object, OutputStream outputStream) {
        if (((ReaderBasedJsonParser)object2)._tokenIncomplete && ((ParserMinimalBase)object2)._currToken == JsonToken.VALUE_STRING) {
            int n2;
            Base64Variant base64Variant = object;
            object = ((ParserBase)object2)._ioContext.allocBase64Buffer();
            try {
                n2 = ((ReaderBasedJsonParser)object2)._readBinary(base64Variant, outputStream, (byte[])object);
                ((ParserBase)object2)._ioContext.releaseBase64Buffer((byte[])object);
            }
            catch (Throwable throwable) {
                ((ParserBase)object2)._ioContext.releaseBase64Buffer((byte[])object);
                throw throwable;
            }
            return n2;
        }
        byte[] byArray = ((ReaderBasedJsonParser)object2).getBinaryValue((Base64Variant)object);
        Object object2 = byArray;
        outputStream.write(byArray);
        return ((Object)object2).length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int _readBinary(Base64Variant base64Variant, OutputStream object, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            int n7;
            block23: {
                block24: {
                    block25: {
                        block18: {
                            block22: {
                                block19: {
                                    block20: {
                                        block21: {
                                            block17: {
                                                if (this._inputPtr >= this._inputEnd) {
                                                    this._loadMoreGuaranteed();
                                                }
                                                if ((n7 = this._inputBuffer[this._inputPtr++]) <= 32) continue;
                                                n6 = base64Variant.decodeBase64Char((char)n7);
                                                if (n6 >= 0) break block17;
                                                if (n7 != 34) {
                                                    n6 = this._decodeBase64Escape(base64Variant, (char)n7, 0);
                                                    if (n6 < 0) continue;
                                                }
                                                break block18;
                                            }
                                            if (n2 > n3) {
                                                n4 += n2;
                                                ((OutputStream)object).write(byArray, 0, n2);
                                                n2 = 0;
                                            }
                                            if (this._inputPtr >= this._inputEnd) {
                                                this._loadMoreGuaranteed();
                                            }
                                            if ((n5 = base64Variant.decodeBase64Char((char)(n7 = this._inputBuffer[this._inputPtr++]))) < 0) {
                                                n5 = this._decodeBase64Escape(base64Variant, (char)n7, 1);
                                            }
                                            n7 = n6 << 6 | n5;
                                            if (this._inputPtr >= this._inputEnd) {
                                                this._loadMoreGuaranteed();
                                            }
                                            if ((n5 = base64Variant.decodeBase64Char((char)(n6 = this._inputBuffer[this._inputPtr++]))) >= 0) break block19;
                                            if (n5 == -2) break block20;
                                            if (n6 != 34) break block21;
                                            byArray[n2++] = (byte)(n7 >> 4);
                                            if (!base64Variant.usesPadding()) break block18;
                                            break block22;
                                        }
                                        n5 = this._decodeBase64Escape(base64Variant, (char)n6, 2);
                                    }
                                    if (n5 == -2) {
                                        if (this._inputPtr >= this._inputEnd) {
                                            this._loadMoreGuaranteed();
                                        }
                                        if (!base64Variant.usesPaddingChar((char)(n6 = this._inputBuffer[this._inputPtr++])) && this._decodeBase64Escape(base64Variant, (char)n6, 3) != -2) {
                                            object = "expected padding character '" + base64Variant.getPaddingChar() + "'";
                                            throw this.reportInvalidBase64Char(base64Variant, n6, 3, (String)object);
                                        }
                                        byArray[n2++] = (byte)(n7 >> 4);
                                        continue;
                                    }
                                }
                                n7 = n7 << 6 | n5;
                                if (this._inputPtr >= this._inputEnd) {
                                    this._loadMoreGuaranteed();
                                }
                                if ((n5 = base64Variant.decodeBase64Char((char)(n6 = this._inputBuffer[this._inputPtr++]))) >= 0) break block23;
                                if (n5 == -2) break block24;
                                if (n6 != 34) break block25;
                                n3 = n2 + 1;
                                byArray[n2] = (byte)(n7 >> 10);
                                n2 += 2;
                                byArray[n3] = (byte)(n7 >> 2);
                                if (!base64Variant.usesPadding()) break block18;
                            }
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        this._tokenIncomplete = false;
                        if (n2 > 0) {
                            n4 += n2;
                            ((OutputStream)object).write(byArray, 0, n2);
                        }
                        return n4;
                    }
                    n5 = this._decodeBase64Escape(base64Variant, (char)n6, 3);
                }
                if (n5 == -2) {
                    int n8 = n7 >> 2;
                    int n9 = n7;
                    n7 = n2 + 1;
                    byArray[n2] = (byte)(n9 >> 10);
                    n2 += 2;
                    byArray[n7] = (byte)n8;
                    continue;
                }
            }
            int n10 = n7 << 6 | n5;
            int n11 = n7 = n10;
            int n12 = n7;
            n7 = n2 + 1;
            byArray[n2] = (byte)(n12 >> 16);
            n6 = n2 + 2;
            byArray[n7] = (byte)(n11 >> 8);
            n2 += 3;
            byArray[n6] = (byte)n10;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final JsonToken nextToken() {
        block17: {
            block26: {
                block18: {
                    block19: {
                        block20: {
                            block21: {
                                block22: {
                                    block23: {
                                        block24: {
                                            block25: {
                                                var1_1 = JsonToken.FIELD_NAME;
                                                if (this._currToken == var1_1) {
                                                    return this._nextAfterName();
                                                }
                                                this._numTypesValid = 0;
                                                if (this._tokenIncomplete) {
                                                    this._skipString();
                                                }
                                                if ((var2_2 = this._skipWSOrEnd()) < 0) {
                                                    this.close();
                                                    this._currToken = null;
                                                    return null;
                                                }
                                                this._binaryValue = null;
                                                if (var2_2 == 93 || var2_2 == 125) break block17;
                                                if (this._parsingContext.expectComma()) {
                                                    var2_2 = this._skipComma(var2_2);
                                                    if ((this._features & ReaderBasedJsonParser.FEAT_MASK_TRAILING_COMMA) != 0 && (var2_2 == 93 || var2_2 == 125)) {
                                                        this._closeScope(var2_2);
                                                        return this._currToken;
                                                    }
                                                }
                                                if (var3_4 = this._parsingContext.inObject()) {
                                                    this._updateNameLocation();
                                                    var2_3 = var2_2 == 34 ? this._parseName() : this._handleOddName(var2_2);
                                                    this._parsingContext.setCurrentName(var2_3);
                                                    this._currToken = var1_1;
                                                    var2_2 = this._skipColon();
                                                }
                                                this._updateLocation();
                                                if (var2_2 == 34) break block18;
                                                if (var2_2 == 43) break block19;
                                                if (var2_2 == 91) break block20;
                                                if (var2_2 == 102) break block21;
                                                if (var2_2 == 110) break block22;
                                                if (var2_2 == 116) break block23;
                                                if (var2_2 == 123) break block24;
                                                if (var2_2 == 125) break block25;
                                                if (var2_2 != 45) {
                                                    if (var2_2 != 46) {
                                                        block0 : switch (var2_2) {
                                                            default: lbl-1000:
                                                            // 2 sources

                                                            {
                                                                while (true) {
                                                                    var1_1 = this._handleOddValue(var2_2);
                                                                    break block0;
                                                                    break;
                                                                }
                                                            }
                                                            case 48: 
                                                            case 49: 
                                                            case 50: 
                                                            case 51: 
                                                            case 52: 
                                                            case 53: 
                                                            case 54: 
                                                            case 55: 
                                                            case 56: 
                                                            case 57: {
                                                                var1_1 = this._parseUnsignedNumber(var2_2);
                                                                break;
                                                            }
                                                        }
                                                    } else {
                                                        var1_1 = this._parseFloatThatStartsWithPeriod(false);
                                                    }
                                                } else {
                                                    var1_1 = this._parseSignedNumber(true);
                                                }
                                                break block26;
                                            }
                                            this._reportUnexpectedChar(var2_2, "expected a value");
                                            break block23;
                                        }
                                        if (!var3_4) {
                                            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                                        }
                                        var1_1 = JsonToken.START_OBJECT;
                                        break block26;
                                    }
                                    this._matchTrue();
                                    var1_1 = JsonToken.VALUE_TRUE;
                                    break block26;
                                }
                                this._matchNull();
                                var1_1 = JsonToken.VALUE_NULL;
                                break block26;
                            }
                            this._matchFalse();
                            var1_1 = JsonToken.VALUE_FALSE;
                            break block26;
                        }
                        if (!var3_4) {
                            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                        }
                        var1_1 = JsonToken.START_ARRAY;
                        break block26;
                    }
                    ** while (!this.isEnabled((JsonParser.Feature)JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()))
lbl75:
                    // 1 sources

                    var1_1 = this._parseSignedNumber(false);
                    break block26;
                }
                this._tokenIncomplete = true;
                var1_1 = JsonToken.VALUE_STRING;
            }
            if (var3_4) {
                this._nextToken = var1_1;
                return this._currToken;
            }
            this._currToken = var1_1;
            return var1_1;
        }
        this._closeScope(var2_2);
        return this._currToken;
    }

    @Override
    public void finishToken() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    @Override
    public boolean nextFieldName(SerializableString object) {
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._binaryValue = null;
        if (n2 != 93 && n2 != 125) {
            char[] cArray;
            int n3;
            int n4;
            if (this._parsingContext.expectComma()) {
                n2 = this._skipComma(n2);
                if ((this._features & FEAT_MASK_TRAILING_COMMA) != 0 && (n2 == 93 || n2 == 125)) {
                    this._closeScope(n2);
                    return false;
                }
            }
            if (!this._parsingContext.inObject()) {
                this._updateLocation();
                this._nextTokenNotInObject(n2);
                return false;
            }
            this._updateNameLocation();
            if (n2 == 34 && (n4 = this._inputPtr) + (n3 = (cArray = object.asQuotedChars()).length) + 4 < this._inputEnd && this._inputBuffer[n3 = n4 + n3] == '\"') {
                int n5 = 0;
                while (true) {
                    if (n4 == n3) {
                        this._parsingContext.setCurrentName(object.getValue());
                        this._isNextTokenNameYes(this._skipColonFast(n4 + 1));
                        return true;
                    }
                    if (cArray[n5] != this._inputBuffer[n4]) break;
                    ++n5;
                    ++n4;
                }
            }
            object = object.getValue();
            return this._isNextTokenNameMaybe(n2, (String)object);
        }
        this._closeScope(n2);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String nextFieldName() {
        this._numTypesValid = 0;
        var1_1 = JsonToken.FIELD_NAME;
        if (this._currToken == var1_1) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((var2_4 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        if (var2_4 != 93 && var2_4 != 125) {
            if (this._parsingContext.expectComma()) {
                var2_4 = this._skipComma(var2_4);
                if ((this._features & ReaderBasedJsonParser.FEAT_MASK_TRAILING_COMMA) != 0 && (var2_4 == 93 || var2_4 == 125)) {
                    this._closeScope(var2_4);
                    return null;
                }
            }
            if (!this._parsingContext.inObject()) {
                this._updateLocation();
                this._nextTokenNotInObject(var2_4);
                return null;
            }
            this._updateNameLocation();
            var2_5 = var2_4 == 34 ? this._parseName() : this._handleOddName(var2_4);
            this._parsingContext.setCurrentName(var2_5);
            this._currToken = var1_1;
            var1_2 = this._skipColon();
            this._updateLocation();
            if (var1_2 == 34) {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return var2_5;
            }
            if (var1_2 != 43) {
                if (var1_2 != 91) {
                    if (var1_2 != 102) {
                        if (var1_2 != 110) {
                            if (var1_2 != 116) {
                                if (var1_2 != 123) {
                                    if (var1_2 != 45) {
                                        if (var1_2 != 46) {
                                            block0 : switch (var1_2) {
                                                default: {
                                                    while (true) {
                                                        var1_3 = this._handleOddValue(var1_2);
                                                        break block0;
                                                        break;
                                                    }
                                                }
                                                case 48: 
                                                case 49: 
                                                case 50: 
                                                case 51: 
                                                case 52: 
                                                case 53: 
                                                case 54: 
                                                case 55: 
                                                case 56: 
                                                case 57: {
                                                    var1_3 = this._parseUnsignedNumber(var1_2);
                                                    break;
                                                }
                                            }
                                        } else {
                                            var1_3 = this._parseFloatThatStartsWithPeriod(false);
                                        }
                                    } else {
                                        var1_3 = this._parseSignedNumber(true);
                                    }
                                } else {
                                    var1_3 = JsonToken.START_OBJECT;
                                }
                            } else {
                                this._matchTrue();
                                var1_3 = JsonToken.VALUE_TRUE;
                            }
                        } else {
                            this._matchNull();
                            var1_3 = JsonToken.VALUE_NULL;
                        }
                    } else {
                        this._matchFalse();
                        var1_3 = JsonToken.VALUE_FALSE;
                    }
                } else {
                    var1_3 = JsonToken.START_ARRAY;
                }
            } else {
                if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) ** continue;
                var1_3 = this._parseSignedNumber(false);
            }
            this._nextToken = var1_3;
            return var2_5;
        }
        this._closeScope(var2_4);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean _isNextTokenNameMaybe(int var1_1, String var2_3) {
        var1_2 = var1_1 == 34 ? this._parseName() : this._handleOddName(var1_1);
        v0 = this;
        v0._parsingContext.setCurrentName(var1_2);
        v0._currToken = JsonToken.FIELD_NAME;
        var3_4 = v0._skipColon();
        this._updateLocation();
        if (var3_4 == 34) {
            v1 = this;
            v1._tokenIncomplete = true;
            v1._nextToken = JsonToken.VALUE_STRING;
            return var2_3.equals(var1_2);
        }
        if (var3_4 != 43) {
            if (var3_4 != 91) {
                if (var3_4 != 102) {
                    if (var3_4 != 110) {
                        if (var3_4 != 116) {
                            if (var3_4 != 123) {
                                if (var3_4 != 45) {
                                    if (var3_4 != 46) {
                                        block0 : switch (var3_4) {
                                            default: {
                                                while (true) {
                                                    var3_5 = this._handleOddValue(var3_4);
                                                    break block0;
                                                    break;
                                                }
                                            }
                                            case 48: 
                                            case 49: 
                                            case 50: 
                                            case 51: 
                                            case 52: 
                                            case 53: 
                                            case 54: 
                                            case 55: 
                                            case 56: 
                                            case 57: {
                                                var3_5 = this._parseUnsignedNumber(var3_4);
                                                break;
                                            }
                                        }
                                    } else {
                                        var3_5 = this._parseFloatThatStartsWithPeriod(false);
                                    }
                                } else {
                                    var3_5 = this._parseSignedNumber(true);
                                }
                            } else {
                                var3_5 = JsonToken.START_OBJECT;
                            }
                        } else {
                            this._matchTrue();
                            var3_5 = JsonToken.VALUE_TRUE;
                        }
                    } else {
                        this._matchNull();
                        var3_5 = JsonToken.VALUE_NULL;
                    }
                } else {
                    this._matchFalse();
                    var3_5 = JsonToken.VALUE_FALSE;
                }
            } else {
                var3_5 = JsonToken.START_ARRAY;
            }
        } else {
            if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) ** continue;
            var3_5 = this._parseSignedNumber(false);
        }
        this._nextToken = var3_5;
        return var2_3.equals(var1_2);
    }

    @Override
    public final String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n2 = readerBasedJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n2, readerBasedJsonParser._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n3 = readerBasedJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n3, readerBasedJsonParser._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public final int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n3 = readerBasedJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n3, readerBasedJsonParser._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n4 = readerBasedJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n4, readerBasedJsonParser._tokenInputCol);
            }
            return n2;
        }
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            n2 = this.getIntValue();
        }
        return n2;
    }

    @Override
    public final long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n2 = readerBasedJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n2, readerBasedJsonParser._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                ReaderBasedJsonParser readerBasedJsonParser = this;
                int n3 = readerBasedJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n3, readerBasedJsonParser._tokenInputCol);
            }
            return l2;
        }
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            l2 = this.getLongValue();
        }
        return l2;
    }

    @Override
    public final Boolean nextBooleanValue() {
        if (((ParserMinimalBase)this)._currToken == JsonToken.FIELD_NAME) {
            ((ParserBase)this)._nameCopied = false;
            JsonToken jsonToken = ((ParserBase)this)._nextToken;
            ((ParserBase)this)._nextToken = null;
            ((ParserMinimalBase)this)._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                Object object = this;
                int n2 = ((ParserBase)object)._tokenInputRow;
                ((ParserBase)this)._parsingContext = ((ParserBase)this)._parsingContext.createChildArrayContext(n2, ((ParserBase)object)._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                Object object = this;
                int n3 = ((ParserBase)object)._tokenInputRow;
                ((ParserBase)this)._parsingContext = ((ParserBase)this)._parsingContext.createChildObjectContext(n3, ((ParserBase)object)._tokenInputCol);
            }
            return null;
        }
        if ((this = ((ReaderBasedJsonParser)this).nextToken()) != null) {
            int n4 = ((JsonToken)((Object)this)).id();
            if (n4 == 9) {
                return Boolean.TRUE;
            }
            if (n4 == 10) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Deprecated
    public final JsonToken _parseFloatThatStartsWithPeriod() {
        return this._parseFloatThatStartsWithPeriod(false);
    }

    public final JsonToken _parseFloatThatStartsWithPeriod(boolean bl) {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleOddValue(46);
        }
        int n2 = this._inputPtr;
        int n3 = n2 - 1;
        if (bl) {
            n3 = n2 - 2;
        }
        return this._parseFloat(46, n3, n2, bl, 0);
    }

    public final JsonToken _parseUnsignedNumber(int n2) {
        char c2;
        int n3;
        int n4 = n2;
        ReaderBasedJsonParser readerBasedJsonParser = this;
        n2 = readerBasedJsonParser._inputPtr;
        int n5 = n2 - 1;
        int n6 = readerBasedJsonParser._inputEnd;
        if (n4 == 48) {
            return this._parseNumber2(false, n5);
        }
        int n7 = 1;
        while (true) {
            if (n2 >= n6) {
                this._inputPtr = n5;
                return this._parseNumber2(false, n5);
            }
            int n8 = n2;
            n3 = n8 + 1;
            c2 = this._inputBuffer[n8];
            if (c2 < '0' || c2 > '9') break;
            ++n7;
            n2 = n3;
        }
        if (c2 != '.' && c2 != 'e' && c2 != 'E') {
            this._inputPtr = n2;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(c2);
            }
            ReaderBasedJsonParser readerBasedJsonParser2 = this;
            readerBasedJsonParser2._textBuffer.resetWithShared(this._inputBuffer, n5, n2 -= n5);
            return readerBasedJsonParser2.resetInt(false, n7);
        }
        this._inputPtr = n3;
        return this._parseFloat(c2, n5, n3, false, n7);
    }

    public JsonToken _handleInvalidNumberStart(int n2, boolean bl) {
        return this._handleInvalidNumberStart(n2, bl, false);
    }

    public JsonToken _handleInvalidNumberStart(int n2, boolean bl, boolean bl2) {
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
            }
            n2 = this._inputPtr;
            this._inputPtr = n2 + 1;
            if ((n2 = this._inputBuffer[n2]) == 78) {
                String string = bl ? "-INF" : "+INF";
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser._matchToken(string, 3);
                if ((readerBasedJsonParser._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    double d2 = bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    return this.resetAsNaN(string, d2);
                }
                this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
            } else if (n2 == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                ReaderBasedJsonParser readerBasedJsonParser = this;
                readerBasedJsonParser._matchToken(string, 3);
                if ((readerBasedJsonParser._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    double d3 = bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    return this.resetAsNaN(string, d3);
                }
                this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
            }
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()) && bl2 && !bl) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        String string = bl ? "expected digit (0-9) to follow minus sign, for valid numeric value" : "expected digit (0-9) for valid numeric value";
        this._reportUnexpectedNumberChar(n2, string);
        return null;
    }

    public final String _parseName() {
        int n2;
        int n3 = this._hashSeed;
        int[] nArray = _icLatin1;
        for (n2 = (v84052)._inputPtr; n2 < this._inputEnd; ++n2) {
            char[] cArray = this._inputBuffer;
            char c2 = this._inputBuffer[n2];
            if (c2 < nArray.length && nArray[c2] != 0) {
                if (c2 != '\"') break;
                int n4 = this._inputPtr;
                this._inputPtr = n2 + 1;
                return this._symbols.findSymbol(cArray, n4, n2 - n4, n3);
            }
            n3 = n3 * 33 + c2;
        }
        int n5 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseName2(n5, n3, 34);
    }

    public String _handleOddName(int n2) {
        int[] nArray;
        int n3;
        if (n2 == 39 && (((JsonParser)object)._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return ((ReaderBasedJsonParser)object)._parseAposName();
        }
        if ((((JsonParser)object)._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            ((ParserMinimalBase)object)._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        if (!(n2 >= (n3 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? Character.isJavaIdentifierPart((char)n2) : nArray[n2] == 0)) {
            ((ParserMinimalBase)object)._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        n2 = ((ParserBase)object)._inputPtr;
        ReaderBasedJsonParser readerBasedJsonParser = object;
        int n4 = readerBasedJsonParser._hashSeed;
        int n5 = readerBasedJsonParser._inputEnd;
        if (n2 < n5) {
            do {
                char[] cArray = ((ReaderBasedJsonParser)object)._inputBuffer;
                char c2 = ((ReaderBasedJsonParser)object)._inputBuffer[n2];
                if (c2 < n3) {
                    if (nArray[c2] != 0) {
                        int n6 = ((ParserBase)object)._inputPtr - 1;
                        ((ParserBase)object)._inputPtr = n2;
                        return ((ReaderBasedJsonParser)object)._symbols.findSymbol(cArray, n6, n2 - n6, n4);
                    }
                } else if (!Character.isJavaIdentifierPart(c2)) {
                    ReaderBasedJsonParser readerBasedJsonParser2;
                    int n7 = ((ParserBase)object)._inputPtr - 1;
                    ((ParserBase)object)._inputPtr = n2;
                    Object object = ((ReaderBasedJsonParser)object)._inputBuffer;
                    return readerBasedJsonParser2._symbols.findSymbol((char[])object, n7, n2 -= n7, n4);
                }
                n4 = n4 * 33 + c2;
            } while (++n2 < n5);
        }
        int n8 = ((ParserBase)object)._inputPtr - 1;
        ((ParserBase)object)._inputPtr = n2;
        return ((ReaderBasedJsonParser)object)._handleOddName2(n8, n4, nArray);
    }

    public String _parseAposName() {
        int n2 = this._inputPtr;
        ReaderBasedJsonParser readerBasedJsonParser = this;
        int n3 = readerBasedJsonParser._hashSeed;
        int n4 = readerBasedJsonParser._inputEnd;
        if (n2 < n4) {
            int[] nArray = _icLatin1;
            int n5 = _icLatin1.length;
            do {
                char[] cArray = this._inputBuffer;
                char c2 = this._inputBuffer[n2];
                if (c2 == '\'') {
                    int n6 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(cArray, n6, n2 - n6, n3);
                }
                if (c2 < n5 && nArray[c2] != 0) break;
                n3 = n3 * 33 + c2;
            } while (++n2 < n4);
        }
        int n7 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseName2(n7, n3, 39);
    }

    public JsonToken _handleOddValue(int n2) {
        String string;
        block14: {
            block8: {
                block9: {
                    block10: {
                        block13: {
                            block11: {
                                block12: {
                                    if (n2 == 39) break block8;
                                    if (n2 == 73) break block9;
                                    if (n2 == 78) break block10;
                                    if (n2 == 93) break block11;
                                    if (n2 == 43) break block12;
                                    if (n2 == 44) break block13;
                                    break block14;
                                }
                                if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                                    this._reportInvalidEOFInValue(JsonToken.VALUE_NUMBER_INT);
                                }
                                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false, true);
                            }
                            if (!this._parsingContext.inArray()) break block14;
                        }
                        if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                            --this._inputPtr;
                            return JsonToken.VALUE_NULL;
                        }
                        break block14;
                    }
                    this._matchToken("NaN", 1);
                    if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                        return this.resetAsNaN("NaN", Double.NaN);
                    }
                    this._reportError("Non-standard token 'NaN': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                    break block14;
                }
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break block14;
            }
            if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
                return this._handleApos();
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            string = this._validJsonTokenList();
            this._reportInvalidToken("" + (char)n2, string);
        }
        string = "expected a valid value " + this._validJsonValueList();
        this._reportUnexpectedChar(n2, string);
        return null;
    }

    public JsonToken _handleApos() {
        ReaderBasedJsonParser readerBasedJsonParser = this;
        char[] cArray = readerBasedJsonParser._textBuffer.emptyAndGetCurrentSegment();
        int n2 = readerBasedJsonParser._textBuffer.getCurrentSegmentSize();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            int n3 = this._inputPtr;
            this._inputPtr = n3 + 1;
            if ((n3 = this._inputBuffer[n3]) <= 92) {
                if (n3 == 92) {
                    n3 = this._decodeEscaped();
                } else if (n3 <= 39) {
                    if (n3 == 39) {
                        this._textBuffer.setCurrentLength(n2);
                        return JsonToken.VALUE_STRING;
                    }
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n4 = n2 + 1;
            cArray[n2] = n3;
            n2 = n4;
        }
    }

    @Override
    public final void _finishString() {
        int n2 = ((ParserBase)object)._inputPtr;
        int n3 = ((ParserBase)object)._inputEnd;
        if (n2 < n3) {
            int[] nArray = _icLatin1;
            int n4 = _icLatin1.length;
            do {
                char[] cArray = ((ReaderBasedJsonParser)object)._inputBuffer;
                char c2 = ((ReaderBasedJsonParser)object)._inputBuffer[n2];
                if (c2 >= n4 || nArray[c2] == 0) continue;
                if (c2 != '\"') break;
                int n5 = ((ParserBase)object)._inputPtr;
                ((ParserBase)object)._textBuffer.resetWithShared(cArray, n5, n2 - n5);
                ((ParserBase)object)._inputPtr = n2 + 1;
                return;
            } while (++n2 < n3);
        }
        ReaderBasedJsonParser readerBasedJsonParser = object;
        int n6 = n2;
        int n7 = n2;
        ReaderBasedJsonParser readerBasedJsonParser2 = object;
        Object object = readerBasedJsonParser2._inputBuffer;
        n2 = readerBasedJsonParser2._inputPtr;
        n3 = n7 - n2;
        ((ParserBase)object)._textBuffer.resetWithCopy((char[])object, n2, n3);
        readerBasedJsonParser._inputPtr = n6;
        readerBasedJsonParser._finishString2();
    }

    public void _finishString2() {
        ReaderBasedJsonParser readerBasedJsonParser = this;
        char[] cArray = readerBasedJsonParser._textBuffer.getCurrentSegment();
        int n2 = readerBasedJsonParser._textBuffer.getCurrentSegmentSize();
        int[] nArray = _icLatin1;
        int n3 = _icLatin1.length;
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
            }
            int n4 = this._inputPtr;
            this._inputPtr = n4 + 1;
            if ((n4 = this._inputBuffer[n4]) < n3 && nArray[n4] != 0) {
                if (n4 == 34) {
                    this._textBuffer.setCurrentLength(n2);
                    return;
                }
                if (n4 == 92) {
                    n4 = this._decodeEscaped();
                } else if (n4 < 32) {
                    this._throwUnquotedSpace(n4, "string value");
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n5 = n2 + 1;
            cArray[n2] = n4;
            n2 = n5;
        }
    }

    public final void _skipString() {
        ReaderBasedJsonParser readerBasedJsonParser = this;
        readerBasedJsonParser._tokenIncomplete = false;
        int n2 = readerBasedJsonParser._inputPtr;
        int n3 = readerBasedJsonParser._inputEnd;
        char[] cArray = readerBasedJsonParser._inputBuffer;
        while (true) {
            if (n2 >= n3) {
                this._inputPtr = n2;
                if (!this._loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value", JsonToken.VALUE_STRING);
                }
                ReaderBasedJsonParser readerBasedJsonParser2 = this;
                n2 = readerBasedJsonParser2._inputPtr;
                n3 = readerBasedJsonParser2._inputEnd;
            }
            int n4 = n2 + 1;
            if ((n2 = cArray[n2]) <= 92) {
                if (n2 == 92) {
                    ReaderBasedJsonParser readerBasedJsonParser3 = this;
                    readerBasedJsonParser3._inputPtr = n4;
                    readerBasedJsonParser3._decodeEscaped();
                    n2 = readerBasedJsonParser3._inputPtr;
                    n3 = readerBasedJsonParser3._inputEnd;
                    continue;
                }
                if (n2 <= 34) {
                    if (n2 == 34) {
                        this._inputPtr = n4;
                        return;
                    }
                    if (n2 < 32) {
                        this._inputPtr = n4;
                        this._throwUnquotedSpace(n2, "string value");
                    }
                }
            }
            n2 = n4;
        }
    }

    public final void _skipCR() {
        int n2;
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[n2 = this._inputPtr] == '\n') {
            this._inputPtr = n2 + 1;
        }
        ReaderBasedJsonParser readerBasedJsonParser = this;
        ++readerBasedJsonParser._currInputRow;
        readerBasedJsonParser._currInputRowStart = readerBasedJsonParser._inputPtr;
    }

    @Override
    public char _decodeEscaped() {
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
        }
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        n2 = this._inputBuffer[n2];
        switch (n2) {
            default: {
                return this._handleUnrecognizedCharacterEscape((char)n2);
            }
            case 117: {
                n2 = 0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                        this._reportInvalidEOF(" in character escape sequence", JsonToken.VALUE_STRING);
                    }
                    int n3 = this._inputPtr;
                    this._inputPtr = n3 + 1;
                    int n4 = CharTypes.charToHex(n3 = this._inputBuffer[n3]);
                    if (n4 < 0) {
                        this._reportUnexpectedChar(n3, "expected a hex-digit for character escape sequence");
                    }
                    n2 = n2 << 4 | n4;
                }
                return (char)n2;
            }
            case 116: {
                return '\t';
            }
            case 114: {
                return '\r';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 98: {
                return '\b';
            }
            case 34: 
            case 47: 
            case 92: 
        }
        return (char)n2;
    }

    public final void _matchToken(String string, int n2) {
        int n3;
        int n4 = string.length();
        if (this._inputPtr + n4 >= this._inputEnd) {
            this._matchToken2(string, n2);
            return;
        }
        do {
            if (this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2));
            }
            this._inputPtr = n3 = this._inputPtr + 1;
        } while (++n2 < n4);
        n4 = this._inputBuffer[n3];
        if (n4 >= 48 && n4 != 93 && n4 != 125) {
            this._checkMatchEnd(string, n2, n4);
        }
    }

    public byte[] _decodeBase64(Base64Variant base64Variant) {
        Object object = this._getByteArrayBuilder();
        while (true) {
            int n2;
            int n3;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n3 = this._inputBuffer[this._inputPtr++]) <= 32) continue;
            int n4 = base64Variant.decodeBase64Char((char)n3);
            if (n4 < 0) {
                if (n3 == 34) {
                    return ((ByteArrayBuilder)object).toByteArray();
                }
                n4 = this._decodeBase64Escape(base64Variant, (char)n3, 0);
                if (n4 < 0) continue;
            }
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char((char)(n3 = this._inputBuffer[this._inputPtr++]))) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, (char)n3, 1);
            }
            n3 = n4 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char((char)(n4 = this._inputBuffer[this._inputPtr++]))) < 0) {
                if (n2 != -2) {
                    if (n4 == 34) {
                        ((ByteArrayBuilder)object).append(n3 >> 4);
                        if (base64Variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return ((ByteArrayBuilder)object).toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, (char)n4, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar((char)(n4 = this._inputBuffer[this._inputPtr++])) && this._decodeBase64Escape(base64Variant, (char)n4, 3) != -2) {
                        object = "expected padding character '" + base64Variant.getPaddingChar() + "'";
                        throw this.reportInvalidBase64Char(base64Variant, n4, 3, (String)object);
                    }
                    ((ByteArrayBuilder)object).append(n3 >> 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char((char)(n4 = this._inputBuffer[this._inputPtr++]))) < 0) {
                if (n2 != -2) {
                    if (n4 == 34) {
                        ((ByteArrayBuilder)object).appendTwoBytes(n3 >> 2);
                        if (base64Variant.usesPadding()) {
                            --this._inputPtr;
                            this._handleBase64MissingPadding(base64Variant);
                        }
                        return ((ByteArrayBuilder)object).toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, (char)n4, 3);
                }
                if (n2 == -2) {
                    ((ByteArrayBuilder)object).appendTwoBytes(n3 >> 2);
                    continue;
                }
            }
            ((ByteArrayBuilder)object).appendThreeBytes(n3 << 6 | n2);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        Object object;
        if (((ParserMinimalBase)object)._currToken == JsonToken.FIELD_NAME) {
            ReaderBasedJsonParser readerBasedJsonParser = object;
            long l2 = readerBasedJsonParser._currInputProcessed;
            l2 = readerBasedJsonParser._nameStartOffset - 1L + l2;
            Object object2 = object;
            object = ((ParserBase)object2)._contentReference();
            int n2 = ((ReaderBasedJsonParser)object2)._nameStartRow;
            int n3 = ((ReaderBasedJsonParser)object2)._nameStartCol;
            return new JsonLocation((ContentReference)object, -1L, l2, n2, n3);
        }
        ReaderBasedJsonParser readerBasedJsonParser = object;
        object = readerBasedJsonParser._contentReference();
        long l3 = readerBasedJsonParser._tokenInputTotal - 1L;
        int n4 = readerBasedJsonParser._tokenInputRow;
        int n5 = readerBasedJsonParser._tokenInputCol;
        return new JsonLocation((ContentReference)object, -1L, l3, n4, n5);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        ReaderBasedJsonParser readerBasedJsonParser = this;
        ContentReference contentReference = readerBasedJsonParser._contentReference();
        long l2 = readerBasedJsonParser._currInputProcessed + (long)this._inputPtr;
        int n3 = readerBasedJsonParser._currInputRow;
        return new JsonLocation(contentReference, -1L, l2, n3, n2);
    }

    public void _reportInvalidToken(String string) {
        ReaderBasedJsonParser readerBasedJsonParser = this;
        readerBasedJsonParser._reportInvalidToken(string, readerBasedJsonParser._validJsonTokenList());
    }

    public void _reportInvalidToken(String string, String string2) {
        char c2;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this._loadMore()) && Character.isJavaIdentifierPart(c2 = this._inputBuffer[this._inputPtr])) {
            StringBuilder stringBuilder3 = stringBuilder2;
            ++this._inputPtr;
            stringBuilder3.append(c2);
            if (stringBuilder3.length() < 256) continue;
            stringBuilder2.append("...");
            break;
        }
        this._reportError("Unrecognized token '%s': was expecting %s", stringBuilder2, string2);
    }
}

