/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.base.ParserBase;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import java.io.DataInput;
import java.io.EOFException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;

public class UTF8DataInputJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_NON_NUM_NUMBERS = JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected ObjectCodec _objectCodec;
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete;
    private int _quad1;
    protected DataInput _inputData;
    protected int _nextByte;

    public UTF8DataInputJsonParser(IOContext iOContext, int n2, DataInput dataInput, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n3) {
        super(iOContext, n2);
        this._objectCodec = objectCodec;
        this._symbols = byteQuadsCanonicalizer;
        this._inputData = dataInput;
        this._nextByte = n3;
    }

    /*
     * Unable to fully structure code
     */
    private final JsonToken _nextTokenNotInObject(int var1_1) {
        block6: {
            block7: {
                block8: {
                    block9: {
                        block10: {
                            block11: {
                                block12: {
                                    block13: {
                                        if (var1_1 == 34) {
                                            this._tokenIncomplete = true;
                                            v0 = JsonToken.VALUE_STRING;
lbl4:
                                            // 11 sources

                                            while (true) {
                                                this._currToken = v0;
                                                return v0;
                                            }
                                        }
                                        if (var1_1 == 43) break block6;
                                        if (var1_1 == 91) break block7;
                                        if (var1_1 == 102) break block8;
                                        if (var1_1 == 110) break block9;
                                        if (var1_1 == 116) break block10;
                                        if (var1_1 == 123) break block11;
                                        if (var1_1 == 45) break block12;
                                        if (var1_1 == 46) break block13;
                                        switch (var1_1) {
                                            default: lbl-1000:
                                            // 2 sources

                                            {
                                                while (true) {
                                                    v0 = this._handleUnexpectedValue(var1_1);
                                                    ** GOTO lbl4
                                                    break;
                                                }
                                            }
                                            case 48: 
                                            case 49: 
                                            case 50: 
                                            case 51: 
                                            case 52: 
                                            case 53: 
                                            case 54: 
                                            case 55: 
                                            case 56: 
                                            case 57: 
                                        }
                                        v0 = this._parseUnsignedNumber(var1_1);
                                        ** GOTO lbl4
                                    }
                                    v0 = this._parseFloatThatStartsWithPeriod(false, false);
                                    ** GOTO lbl4
                                }
                                v0 = this._parseNegNumber();
                                ** GOTO lbl4
                            }
                            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                            v0 = JsonToken.START_OBJECT;
                            ** GOTO lbl4
                        }
                        this._matchToken("true", 1);
                        v0 = JsonToken.VALUE_TRUE;
                        ** GOTO lbl4
                    }
                    this._matchToken("null", 1);
                    v0 = JsonToken.VALUE_NULL;
                    ** GOTO lbl4
                }
                this._matchToken("false", 1);
                v0 = JsonToken.VALUE_FALSE;
                ** GOTO lbl4
            }
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            v0 = JsonToken.START_ARRAY;
            ** GOTO lbl4
        }
        ** while (!this.isEnabled((JsonParser.Feature)JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()))
lbl51:
        // 1 sources

        v0 = this._parsePosNumber();
        ** while (true)
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            int n2 = uTF8DataInputJsonParser._tokenInputRow;
            this._parsingContext = this._parsingContext.createChildArrayContext(n2, uTF8DataInputJsonParser._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            int n3 = uTF8DataInputJsonParser._tokenInputRow;
            this._parsingContext = this._parsingContext.createChildObjectContext(n3, uTF8DataInputJsonParser._tokenInputCol);
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JsonToken _parseSignedNumber(boolean bl) {
        int n2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        if (bl) {
            n2 = 1;
            cArray[n3] = 45;
            n3 = n2;
        }
        n2 = this._inputData.readUnsignedByte();
        cArray[n3++] = (char)n2;
        if (n2 <= 48) {
            if (n2 != 48) {
                if (n2 != 46) return this._handleInvalidNumberStart(n2, bl, true);
                return this._parseFloatThatStartsWithPeriod(bl, true);
            }
            n2 = this._handleLeadingZeroes();
        } else {
            if (n2 > 57) {
                return this._handleInvalidNumberStart(n2, bl, true);
            }
            n2 = this._inputData.readUnsignedByte();
        }
        int n4 = 1;
        while (n2 <= 57 && n2 >= 48) {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 46) return this._parseFloat(cArray, n3, n2, bl, n4);
        if (n2 == 101) return this._parseFloat(cArray, n3, n2, bl, n4);
        if (n2 == 69) {
            return this._parseFloat(cArray, n3, n2, bl, n4);
        }
        this._textBuffer.setCurrentLength(n3);
        this._nextByte = n2;
        if (!this._parsingContext.inRoot()) return this.resetInt(bl, n4);
        this._verifyRootSpace();
        return this.resetInt(bl, n4);
    }

    private final int _handleLeadingZeroes() {
        int n2 = this._inputData.readUnsignedByte();
        if (n2 >= 48 && n2 <= 57) {
            if ((this._features & FEAT_MASK_LEADING_ZEROS) == 0) {
                this.reportInvalidNumber("Leading zeroes not allowed");
            }
            while (n2 == 48) {
                n2 = this._inputData.readUnsignedByte();
            }
            return n2;
        }
        return n2;
    }

    private final JsonToken _parseFloat(char[] cArray, int n2, int n3, boolean bl, int n4) {
        int n5 = 0;
        if (n3 == 46) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n6 = n3;
            n3 = n2 + 1;
            cArray[n2] = (char)n6;
            n2 = n3;
            while ((n3 = this._inputData.readUnsignedByte()) >= 48 && n3 <= 57) {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                int n7 = n3;
                n3 = n2 + 1;
                cArray[n2] = (char)n7;
                n2 = n3;
            }
            if (n5 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                this._reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
            }
        }
        int n8 = 0;
        if (n3 == 101 || n3 == 69) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
            if (n3 == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
            }
            while (n3 <= 57 && n3 >= 48) {
                ++n8;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
            }
            if (n8 == 0) {
                this._reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        this._nextByte = n3;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace();
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl, n4, n5, n8);
    }

    private final void _verifyRootSpace() {
        int n2 = this._nextByte;
        if (n2 <= 32) {
            this._nextByte = -1;
            if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            return;
        }
        this._reportMissingRootWS(n2);
    }

    private final String _parseMediumName(int n2) {
        int[] nArray = _icLatin1;
        int n3 = this._inputData.readUnsignedByte();
        if (_icLatin1[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 1);
            }
            return this.parseName(this._quad1, n2, n3, 1);
        }
        n2 = n2 << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 2);
            }
            return this.parseName(this._quad1, n2, n3, 2);
        }
        n2 = n2 << 8 | n3;
        n3 = this._inputData.readUnsignedByte();
        if (nArray[n3] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 3);
            }
            return this.parseName(this._quad1, n2, n3, 3);
        }
        n2 = n2 << 8 | n3;
        int n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n2, 4);
            }
            return this.parseName(this._quad1, n2, n4, 4);
        }
        return this._parseMediumName2(n4, n2);
    }

    private final String _parseMediumName2(int n2, int n3) {
        int[] nArray = _icLatin1;
        int n4 = this._inputData.readUnsignedByte();
        if (_icLatin1[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 1);
            }
            return this.parseName(this._quad1, n3, n2, n4, 1);
        }
        n2 = n2 << 8 | n4;
        n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 2);
            }
            return this.parseName(this._quad1, n3, n2, n4, 2);
        }
        n2 = n2 << 8 | n4;
        n4 = this._inputData.readUnsignedByte();
        if (nArray[n4] != 0) {
            if (n4 == 34) {
                return this.findName(this._quad1, n3, n2, 3);
            }
            return this.parseName(this._quad1, n3, n2, n4, 3);
        }
        n2 = n2 << 8 | n4;
        int n5 = this._inputData.readUnsignedByte();
        if (nArray[n5] != 0) {
            if (n5 == 34) {
                return this.findName(this._quad1, n3, n2, 4);
            }
            return this.parseName(this._quad1, n3, n2, n5, 4);
        }
        return this._parseLongName(n5, n3, n2);
    }

    private final String _parseLongName(int n2, int n3, int n4) {
        int[] nArray = this._quadBuffer;
        nArray[0] = this._quad1;
        nArray[1] = n3;
        this._quadBuffer[2] = n4;
        int[] nArray2 = _icLatin1;
        n4 = 3;
        while (true) {
            int n5;
            if (nArray2[n5 = this._inputData.readUnsignedByte()] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n2, 1);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n2, n5, 1);
            }
            n2 = n2 << 8 | n5;
            n5 = this._inputData.readUnsignedByte();
            if (nArray2[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n2, 2);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n2, n5, 2);
            }
            n2 = n2 << 8 | n5;
            n5 = this._inputData.readUnsignedByte();
            if (nArray2[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n2, 3);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n2, n5, 3);
            }
            n2 = n2 << 8 | n5;
            n5 = this._inputData.readUnsignedByte();
            if (nArray2[n5] != 0) {
                if (n5 == 34) {
                    return this.findName(this._quadBuffer, n4, n2, 4);
                }
                return this.parseEscapedName(this._quadBuffer, n4, n2, n5, 4);
            }
            int[] nArray3 = this._quadBuffer;
            if (n4 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8DataInputJsonParser._growArrayBy(nArray3, n4);
            }
            this._quadBuffer[n4++] = n2;
            n2 = n5;
        }
    }

    private final String parseName(int n2, int n3, int n4) {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        return uTF8DataInputJsonParser.parseEscapedName(uTF8DataInputJsonParser._quadBuffer, 0, n2, n3, n4);
    }

    private final String parseName(int n2, int n3, int n4, int n5) {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        uTF8DataInputJsonParser._quadBuffer[0] = n2;
        return uTF8DataInputJsonParser.parseEscapedName(uTF8DataInputJsonParser._quadBuffer, 1, n3, n4, n5);
    }

    private final String parseName(int n2, int n3, int n4, int n5, int n6) {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        int[] nArray = uTF8DataInputJsonParser._quadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        return uTF8DataInputJsonParser.parseEscapedName(uTF8DataInputJsonParser._quadBuffer, 2, n4, n5, n6);
    }

    private final String findName(int n2, int n3) {
        String string = this._symbols.findName(n2 = UTF8DataInputJsonParser.pad(n2, n3));
        if (string != null) {
            return string;
        }
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        uTF8DataInputJsonParser._quadBuffer[0] = n2;
        return uTF8DataInputJsonParser.addName(uTF8DataInputJsonParser._quadBuffer, 1, n3);
    }

    private final String findName(int n2, int n3, int n4) {
        String string = this._symbols.findName(n2, n3 = UTF8DataInputJsonParser.pad(n3, n4));
        if (string != null) {
            return string;
        }
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        int[] nArray = uTF8DataInputJsonParser._quadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        return uTF8DataInputJsonParser.addName(uTF8DataInputJsonParser._quadBuffer, 2, n4);
    }

    private final String findName(int n2, int n3, int n4, int n5) {
        String string = ((UTF8DataInputJsonParser)this)._symbols.findName(n2, n3, n4 = UTF8DataInputJsonParser.pad(n4, n5));
        if (string != null) {
            return string;
        }
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        int[] nArray = uTF8DataInputJsonParser._quadBuffer;
        Object object = this = (Object)nArray;
        object[0] = n2;
        object[1] = n3;
        nArray[2] = UTF8DataInputJsonParser.pad(n4, n5);
        return uTF8DataInputJsonParser.addName(uTF8DataInputJsonParser._quadBuffer, 3, n5);
    }

    private final String findName(int[] nArray, int n2, int n3, int n4) {
        if (n2 >= nArray.length) {
            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = UTF8DataInputJsonParser.pad(n3, n4);
        String string = this._symbols.findName(nArray, n2);
        if (string == null) {
            return this.addName(nArray, n2, n4);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final String addName(int[] var1_1, int var2_2, int var3_3) {
        var4_5 = (var2_2 << 2) - 4 + var3_3;
        if (var3_3 < 4) {
            var5_6 = var2_2 - 1;
            var6_8 = var1_1[var5_6];
            var1_1[var5_6] = var6_8 << (4 - var3_3 << 3);
        } else {
            var6_8 = 0;
        }
        var5_7 = this._textBuffer.emptyAndGetCurrentSegment();
        var7_9 = 0;
        var8_10 = 0;
        while (var8_10 < var4_5) {
            block21: {
                block20: {
                    var9_11 = var1_1[var8_10 >> 2] >> (3 - (var8_10 & 3) << 3);
                    var10_12 = var9_11 & 255;
                    var11_13 = var8_10 + 1;
                    if (var10_12 <= 127) break block20;
                    if ((var9_11 & 224) == 192) {
                        var9_11 &= 31;
                        var10_12 = 1;
                    } else if ((var9_11 & 240) == 224) {
                        var9_11 &= 15;
                        var10_12 = 2;
                    } else if ((var9_11 & 248) == 240) {
                        var9_11 &= 7;
                        var10_12 = 3;
                    } else {
                        this._reportInvalidInitial(var10_12);
                        var9_11 = var10_12 = 1;
                    }
                    if (var11_13 + var10_12 > var4_5) {
                        this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                    }
                    var11_13 = var1_1[var11_13 >> 2] >> (3 - (var11_13 & 3) << 3);
                    var12_14 = var8_10 + 2;
                    if ((var11_13 & 192) != 128) {
                        this._reportInvalidOther(var11_13);
                    }
                    var9_11 = var9_11 << 6 | var11_13 & 63;
                    if (var10_12 <= 1) ** GOTO lbl-1000
                    var11_13 = var1_1[var12_14 >> 2] >> (3 - (var12_14 & 3) << 3);
                    var12_14 = var8_10 + 3;
                    if ((var11_13 & 192) != 128) {
                        this._reportInvalidOther(var11_13);
                    }
                    var9_11 = var9_11 << 6 | var11_13 & 63;
                    if (var10_12 > 2) {
                        var11_13 = var1_1[var12_14 >> 2] >> (3 - (var12_14 & 3) << 3);
                        var12_14 = var8_10 + 4;
                        if ((var11_13 & 192) != 128) {
                            this._reportInvalidOther(var11_13 & 255);
                        }
                        var8_10 = var9_11 << 6 | var11_13 & 63;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_10 = var9_11;
                    }
                    if (var10_12 > 2) {
                        var8_10 -= 65536;
                        if (var7_9 >= var5_7.length) {
                            var5_7 = this._textBuffer.expandCurrentSegment();
                        }
                        var5_7[var7_9++] = (char)((var8_10 >> 10) + 55296);
                        var10_12 = var8_10 & 1023 | 56320;
                        var8_10 = var12_14;
                    } else {
                        var10_12 = var8_10;
                        var8_10 = var12_14;
                    }
                    break block21;
                }
                var8_10 = var11_13;
            }
            if (var7_9 >= var5_7.length) {
                var5_7 = this._textBuffer.expandCurrentSegment();
            }
            var9_11 = var7_9 + 1;
            var5_7[var7_9] = (char)var10_12;
            var7_9 = var9_11;
        }
        var3_4 = v0;
        v0 = new String(var5_7, 0, var7_9);
        if (var3_3 < 4) {
            var1_1[var2_2 - 1] = var6_8;
        }
        return this._symbols.addName(var3_4, var1_1, var2_2);
    }

    private String _finishAndReturnString() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = cArray.length;
        while (true) {
            int n4;
            if (nArray[n4 = this._inputData.readUnsignedByte()] != 0) {
                if (n4 == 34) {
                    return this._textBuffer.setCurrentAndReturn(n2);
                }
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser._finishString2(cArray, n2, n4);
                return uTF8DataInputJsonParser._textBuffer.contentsAsString();
            }
            int n5 = n2 + 1;
            cArray[n2] = (char)n4;
            if (n5 >= n3) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                uTF8DataInputJsonParser._finishString2(cArray, n5, this._inputData.readUnsignedByte());
                return uTF8DataInputJsonParser._textBuffer.contentsAsString();
            }
            n2 = n5;
        }
    }

    private final void _finishString2(char[] cArray, int n2, int n3) {
        int[] nArray = _icUTF8;
        int n4 = cArray.length;
        while (true) {
            int n5;
            if ((n5 = nArray[n3]) == 0) {
                if (n2 >= n4) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                    n4 = cArray.length;
                }
                cArray[n2++] = (char)n3;
                n3 = this._inputData.readUnsignedByte();
                continue;
            }
            if (n3 == 34) {
                this._textBuffer.setCurrentLength(n2);
                return;
            }
            switch (n5) {
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                        break;
                    }
                    this._reportInvalidChar(n3);
                    break;
                }
                case 4: {
                    n3 = this._decodeUtf8_4(n3);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                        n4 = cArray.length;
                    }
                    cArray[n2++] = (char)(n3 >> 10 | 0xD800);
                    n3 = n3 & 0x3FF | 0xDC00;
                    break;
                }
                case 3: {
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 2: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 1: {
                    n3 = this._decodeEscaped();
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
                n4 = cArray.length;
            }
            cArray[n2++] = (char)n3;
            n3 = this._inputData.readUnsignedByte();
        }
    }

    private final void _checkMatchEnd(String string, int n2, int n3) {
        char c2 = (char)this._decodeCharForError(n3);
        n3 = c2;
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(n3, string.substring(0, n2));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int _skipWS() {
        var1_1 = this._nextByte;
        if (var1_1 < 0) lbl-1000:
        // 3 sources

        {
            while (true) {
                var1_1 = this._inputData.readUnsignedByte();
                break;
            }
        } else {
            this._nextByte = -1;
        }
        if (var1_1 > 32) {
            if (var1_1 != 47 && var1_1 != 35) {
                return var1_1;
            }
            return this._skipWSComment(var1_1);
        }
        if (var1_1 != 13 && var1_1 != 10) ** GOTO lbl-1000
        ++this._currInputRow;
        ** while (true)
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int _skipWSOrEnd() {
        block7: {
            var1_1 = this._nextByte;
            if (var1_1 < 0) break block7;
            this._nextByte = -1;
            ** GOTO lbl13
        }
        try {
            v0 = this._inputData.readUnsignedByte();
        }
        catch (EOFException v1) {
            return this._eofAsNextChar();
        }
        while (true) {
            var1_1 = v0;
lbl13:
            // 2 sources

            if (var1_1 > 32) {
                if (var1_1 == 47) return this._skipWSComment(var1_1);
                if (var1_1 != 35) return var1_1;
                return this._skipWSComment(var1_1);
            }
            if (var1_1 == 13 || var1_1 == 10) {
                ++this._currInputRow;
            }
            try {
                v0 = this._inputData.readUnsignedByte();
            }
            catch (EOFException v2) {
                return this._eofAsNextChar();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int _skipWSComment(int n2) {
        while (true) {
            if (n2 > 32) {
                if (n2 == 47) {
                    this._skipComment();
                } else {
                    if (n2 != 35) return n2;
                    if (!this._skipYAMLComment()) {
                        return n2;
                    }
                }
            } else if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final int _skipColon() {
        int n2 = this._nextByte;
        if (n2 < 0) {
            n2 = this._inputData.readUnsignedByte();
        } else {
            this._nextByte = -1;
        }
        if (n2 == 58) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 > 32) {
                if (n2 != 47 && n2 != 35) {
                    return n2;
                }
                return this._skipColon2(n2, true);
            }
            if ((n2 == 32 || n2 == 9) && (n2 = this._inputData.readUnsignedByte()) > 32) {
                if (n2 != 47 && n2 != 35) {
                    return n2;
                }
                return this._skipColon2(n2, true);
            }
            return this._skipColon2(n2, true);
        }
        if (n2 == 32 || n2 == 9) {
            n2 = this._inputData.readUnsignedByte();
        }
        if (n2 == 58) {
            n2 = this._inputData.readUnsignedByte();
            if (n2 > 32) {
                if (n2 != 47 && n2 != 35) {
                    return n2;
                }
                return this._skipColon2(n2, true);
            }
            if ((n2 == 32 || n2 == 9) && (n2 = this._inputData.readUnsignedByte()) > 32) {
                if (n2 != 47 && n2 != 35) {
                    return n2;
                }
                return this._skipColon2(n2, true);
            }
            return this._skipColon2(n2, true);
        }
        return this._skipColon2(n2, false);
    }

    private final int _skipColon2(int n2, boolean bl) {
        while (true) {
            if (n2 > 32) {
                if (n2 == 47) {
                    this._skipComment();
                } else if (n2 != 35 || !this._skipYAMLComment()) {
                    int n3;
                    if (n3 != 0) {
                        return n2;
                    }
                    if (n2 != 58) {
                        this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
                    }
                    n3 = n2 = 1;
                }
            } else if (n2 == 13 || n2 == 10) {
                ++this._currInputRow;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final void _skipComment() {
        int n2;
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if ((n2 = this._inputData.readUnsignedByte()) == 47) {
            this._skipLine();
        } else if (n2 == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _skipCComment() {
        int[] nArray = CharTypes.getInputCodeComment();
        int n2 = this._inputData.readUnsignedByte();
        while (true) {
            block6: {
                block7: {
                    block8: {
                        int n3;
                        if ((n3 = nArray[n2]) == 0) break block6;
                        if (n3 == 2) break block7;
                        if (n3 == 3) break block8;
                        if (n3 != 4) {
                            if (n3 != 10 && n3 != 13) {
                                if (n3 != 42) {
                                    this._reportInvalidChar(n2);
                                    break block6;
                                } else {
                                    n2 = this._inputData.readUnsignedByte();
                                    if (n2 != 47) continue;
                                    return;
                                }
                            }
                            ++this._currInputRow;
                            break block6;
                        } else {
                            this._skipUtf8_4();
                        }
                        break block6;
                    }
                    this._skipUtf8_3();
                    break block6;
                }
                this._skipUtf8_2();
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    private final boolean _skipYAMLComment() {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private final void _skipLine() {
        int[] nArray = CharTypes.getInputCodeComment();
        while (true) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputData.readUnsignedByte()]) == 0) {
                continue;
            }
            if (n3 != 2) {
                if (n3 != 3) {
                    if (n3 != 4) {
                        if (n3 != 10 && n3 != 13) {
                            if (n3 == 42 || n3 >= 0) continue;
                            this._reportInvalidChar(n2);
                            continue;
                        }
                        ++this._currInputRow;
                        return;
                    }
                    this._skipUtf8_4();
                    continue;
                }
                this._skipUtf8_3();
                continue;
            }
            this._skipUtf8_2();
        }
    }

    private final int _decodeUtf8_2(int n2) {
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        return (n2 & 0x1F) << 6 | n3 & 0x3F;
    }

    private final int _decodeUtf8_3(int n2) {
        n2 &= 0xF;
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        return n2 << 6 | n3 & 0x3F;
    }

    private final int _decodeUtf8_4(int n2) {
        int n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n2 = (n2 & 7) << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        n3 = this._inputData.readUnsignedByte();
        if ((n3 & 0xC0) != 128) {
            this._reportInvalidOther(n3 & 0xFF);
        }
        return (n2 << 6 | n3 & 0x3F) - 65536;
    }

    private final void _skipUtf8_2() {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
    }

    private final void _skipUtf8_3() {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
    }

    private final void _skipUtf8_4() {
        int n2 = this._inputData.readUnsignedByte();
        if ((n2 & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
        if (((n2 = this._inputData.readUnsignedByte()) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF);
        }
    }

    private void _reportInvalidOther(int n2) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    private static int[] _growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, nArray.length + n2);
    }

    private void _closeScope(int n2) {
        if (n2 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        if (n2 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.clearAndGetParent();
            this._currToken = JsonToken.END_OBJECT;
        }
    }

    private static final int pad(int n2, int n3) {
        if (n3 != 4) {
            n2 |= -1 << (n3 << 3);
        }
        return n2;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return ParserBase.JSON_READ_CAPABILITIES;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        return 0;
    }

    @Override
    public Object getInputSource() {
        return this._inputData;
    }

    @Override
    public void _closeInput() {
    }

    @Override
    public void _releaseBuffers() {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        super._releaseBuffers();
        uTF8DataInputJsonParser._symbols.release();
    }

    @Override
    public String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    @Override
    public int getText(Writer writer) {
        Object object;
        JsonToken jsonToken = ((ParserMinimalBase)object)._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (((UTF8DataInputJsonParser)object)._tokenIncomplete) {
                ((UTF8DataInputJsonParser)object)._tokenIncomplete = false;
                ((UTF8DataInputJsonParser)object)._finishString();
            }
            return ((ParserBase)object)._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            object = ((ParserBase)object)._parsingContext.getCurrentName();
            writer.write((String)object);
            return ((String)object).length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return ((ParserBase)object)._textBuffer.contentsToWriter(writer);
            }
            char[] cArray = jsonToken.asCharArray();
            object = cArray;
            writer.write(cArray);
            return ((Object)object).length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                return this._finishAndReturnString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT) {
            return super.getValueAsInt(0);
        }
        int n2 = this._numTypesValid;
        if ((n2 & 1) == 0) {
            if (n2 == 0) {
                return this._parseIntValue();
            }
            if ((n2 & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public int getValueAsInt(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != JsonToken.VALUE_NUMBER_INT && jsonToken != JsonToken.VALUE_NUMBER_FLOAT) {
            return super.getValueAsInt(n2);
        }
        n2 = this._numTypesValid;
        if ((n2 & 1) == 0) {
            if (n2 == 0) {
                return this._parseIntValue();
            }
            if ((n2 & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            default: {
                return jsonToken.asString();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
            case 5: 
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public char[] getTextCharacters() {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                default: {
                    return this._currToken.asCharArray();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
                case 5: 
            }
            if (!this._nameCopied) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                object = uTF8DataInputJsonParser._parsingContext.getCurrentName();
                int n2 = ((String)object).length();
                char[] cArray = uTF8DataInputJsonParser._nameCopyBuffer;
                if (uTF8DataInputJsonParser._nameCopyBuffer == null) {
                    this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                } else if (cArray.length < n2) {
                    this._nameCopyBuffer = new char[n2];
                }
                JsonToken jsonToken = object;
                object = this._nameCopyBuffer;
                ((String)((Object)jsonToken)).getChars(0, n2, (char[])object, 0);
                this._nameCopied = true;
            }
            return this._nameCopyBuffer;
        }
        return null;
    }

    @Override
    public int getTextLength() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.size();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName().length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return this._textBuffer.size();
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                default: {
                    break;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        Object object = this._currToken;
        if (object != JsonToken.VALUE_STRING && (object != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
                this._tokenIncomplete = false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
        } else if (this._binaryValue == null) {
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            object = uTF8DataInputJsonParser._getByteArrayBuilder();
            uTF8DataInputJsonParser._decodeBase64(uTF8DataInputJsonParser.getText(), (ByteArrayBuilder)object, base64Variant);
            uTF8DataInputJsonParser._binaryValue = ((ByteArrayBuilder)object).toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant object, OutputStream outputStream) {
        if (((UTF8DataInputJsonParser)object2)._tokenIncomplete && ((ParserMinimalBase)object2)._currToken == JsonToken.VALUE_STRING) {
            int n2;
            Base64Variant base64Variant = object;
            object = ((ParserBase)object2)._ioContext.allocBase64Buffer();
            try {
                n2 = ((UTF8DataInputJsonParser)object2)._readBinary(base64Variant, outputStream, (byte[])object);
                ((ParserBase)object2)._ioContext.releaseBase64Buffer((byte[])object);
            }
            catch (Throwable throwable) {
                ((ParserBase)object2)._ioContext.releaseBase64Buffer((byte[])object);
                throw throwable;
            }
            return n2;
        }
        byte[] byArray = ((UTF8DataInputJsonParser)object2).getBinaryValue((Base64Variant)object);
        Object object2 = byArray;
        outputStream.write(byArray);
        return ((Object)object2).length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length - 3;
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            int n7;
            block19: {
                block20: {
                    block21: {
                        block14: {
                            block18: {
                                block15: {
                                    block16: {
                                        block17: {
                                            block13: {
                                                if ((n7 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte()) <= 32) {
                                                    continue;
                                                }
                                                n6 = base64Variant.decodeBase64Char(n7);
                                                if (n6 >= 0) break block13;
                                                if (n7 != 34) {
                                                    n6 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n7, 0);
                                                    if (n6 < 0) continue;
                                                }
                                                break block14;
                                            }
                                            if (n2 > n3) {
                                                n4 += n2;
                                                outputStream.write(byArray, 0, n2);
                                                n2 = 0;
                                            }
                                            if ((n5 = base64Variant.decodeBase64Char(n7 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte())) < 0) {
                                                n5 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n7, 1);
                                            }
                                            n7 = n6 << 6 | n5;
                                            n6 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte();
                                            n5 = base64Variant.decodeBase64Char(n6);
                                            if (n5 >= 0) break block15;
                                            if (n5 == -2) break block16;
                                            if (n6 != 34) break block17;
                                            byArray[n2++] = (byte)(n7 >> 4);
                                            if (!base64Variant.usesPadding()) break block14;
                                            break block18;
                                        }
                                        n5 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n6, 2);
                                    }
                                    if (n5 == -2) {
                                        n6 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte();
                                        if (!(base64Variant.usesPaddingChar(n6) || n6 == 92 && ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n6, 3) == -2)) {
                                            UTF8DataInputJsonParser uTF8DataInputJsonParser = string;
                                            String string = "expected padding character '" + base64Variant.getPaddingChar() + "'";
                                            throw uTF8DataInputJsonParser.reportInvalidBase64Char(base64Variant, n6, 3, string);
                                        }
                                        byArray[n2++] = (byte)(n7 >> 4);
                                        continue;
                                    }
                                }
                                n7 = n7 << 6 | n5;
                                n6 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte();
                                n5 = base64Variant.decodeBase64Char(n6);
                                if (n5 >= 0) break block19;
                                if (n5 == -2) break block20;
                                if (n6 != 34) break block21;
                                n3 = n2 + 1;
                                byArray[n2] = (byte)(n7 >> 10);
                                n2 += 2;
                                byArray[n3] = (byte)(n7 >> 2);
                                if (!base64Variant.usesPadding()) break block14;
                            }
                            ((ParserBase)((Object)string))._handleBase64MissingPadding(base64Variant);
                        }
                        ((UTF8DataInputJsonParser)((Object)string))._tokenIncomplete = false;
                        if (n2 > 0) {
                            n4 += n2;
                            outputStream.write(byArray, 0, n2);
                        }
                        return n4;
                    }
                    n5 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n6, 3);
                }
                if (n5 == -2) {
                    int n8 = n7 >> 2;
                    int n9 = n7;
                    n7 = n2 + 1;
                    byArray[n2] = (byte)(n9 >> 10);
                    n2 += 2;
                    byArray[n7] = (byte)n8;
                    continue;
                }
            }
            int n10 = n7 << 6 | n5;
            int n11 = n7 = n10;
            int n12 = n7;
            n7 = n2 + 1;
            byArray[n2] = (byte)(n12 >> 16);
            n6 = n2 + 2;
            byArray[n7] = (byte)(n11 >> 8);
            n2 += 3;
            byArray[n6] = (byte)n10;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public JsonToken nextToken() {
        if (this._closed) {
            return null;
        }
        var1_1 = JsonToken.FIELD_NAME;
        if (this._currToken == var1_1) {
            return this._nextAfterName();
        }
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((var2_4 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._binaryValue = null;
        this._tokenInputRow = this._currInputRow;
        if (var2_4 != 93 && var2_4 != 125) {
            if (this._parsingContext.expectComma()) {
                if (var2_4 != 44) {
                    var3_5 = "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries";
                    this._reportUnexpectedChar(var2_4, var3_5);
                }
                var2_4 = this._skipWS();
                if ((this._features & UTF8DataInputJsonParser.FEAT_MASK_TRAILING_COMMA) != 0 && (var2_4 == 93 || var2_4 == 125)) {
                    this._closeScope(var2_4);
                    return this._currToken;
                }
            }
            if (!this._parsingContext.inObject()) {
                return this._nextTokenNotInObject(var2_4);
            }
            this._parsingContext.setCurrentName(this._parseName(var2_4));
            this._currToken = var1_1;
            var1_2 = this._skipColon();
            if (var1_2 == 34) {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            if (var1_2 != 43) {
                if (var1_2 != 91) {
                    if (var1_2 != 102) {
                        if (var1_2 != 110) {
                            if (var1_2 != 116) {
                                if (var1_2 != 123) {
                                    if (var1_2 != 45) {
                                        if (var1_2 != 46) {
                                            block0 : switch (var1_2) {
                                                default: {
                                                    while (true) {
                                                        var1_3 = this._handleUnexpectedValue(var1_2);
                                                        break block0;
                                                        break;
                                                    }
                                                }
                                                case 48: 
                                                case 49: 
                                                case 50: 
                                                case 51: 
                                                case 52: 
                                                case 53: 
                                                case 54: 
                                                case 55: 
                                                case 56: 
                                                case 57: {
                                                    var1_3 = this._parseUnsignedNumber(var1_2);
                                                    break;
                                                }
                                            }
                                        } else {
                                            var1_3 = this._parseFloatThatStartsWithPeriod(false, false);
                                        }
                                    } else {
                                        var1_3 = this._parseNegNumber();
                                    }
                                } else {
                                    var1_3 = JsonToken.START_OBJECT;
                                }
                            } else {
                                this._matchToken("true", 1);
                                var1_3 = JsonToken.VALUE_TRUE;
                            }
                        } else {
                            this._matchToken("null", 1);
                            var1_3 = JsonToken.VALUE_NULL;
                        }
                    } else {
                        this._matchToken("false", 1);
                        var1_3 = JsonToken.VALUE_FALSE;
                    }
                } else {
                    var1_3 = JsonToken.START_ARRAY;
                }
            } else {
                if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) ** continue;
                var1_3 = this._parsePosNumber();
            }
            this._nextToken = var1_3;
            return this._currToken;
        }
        this._closeScope(var2_4);
        return this._currToken;
    }

    @Override
    public void finishToken() {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            this._finishString();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String nextFieldName() {
        block11: {
            block19: {
                block12: {
                    block13: {
                        block14: {
                            block15: {
                                block16: {
                                    block17: {
                                        block18: {
                                            this._numTypesValid = 0;
                                            var1_1 = JsonToken.FIELD_NAME;
                                            if (this._currToken == var1_1) {
                                                this._nextAfterName();
                                                return null;
                                            }
                                            if (this._tokenIncomplete) {
                                                this._skipString();
                                            }
                                            var2_4 = this._skipWS();
                                            this._binaryValue = null;
                                            this._tokenInputRow = this._currInputRow;
                                            if (var2_4 == 93 || var2_4 == 125) break block11;
                                            if (this._parsingContext.expectComma()) {
                                                if (var2_4 != 44) {
                                                    var3_6 = "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries";
                                                    this._reportUnexpectedChar(var2_4, var3_6);
                                                }
                                                var2_4 = this._skipWS();
                                                if ((this._features & UTF8DataInputJsonParser.FEAT_MASK_TRAILING_COMMA) != 0 && (var2_4 == 93 || var2_4 == 125)) {
                                                    this._closeScope(var2_4);
                                                    return null;
                                                }
                                            }
                                            if (!this._parsingContext.inObject()) {
                                                this._nextTokenNotInObject(var2_4);
                                                return null;
                                            }
                                            var2_5 = this._parseName(var2_4);
                                            this._parsingContext.setCurrentName(var2_5);
                                            this._currToken = var1_1;
                                            var1_2 = this._skipColon();
                                            if (var1_2 == 34) {
                                                this._tokenIncomplete = true;
                                                this._nextToken = JsonToken.VALUE_STRING;
                                                return var2_5;
                                            }
                                            if (var1_2 == 43) break block12;
                                            if (var1_2 == 91) break block13;
                                            if (var1_2 == 102) break block14;
                                            if (var1_2 == 110) break block15;
                                            if (var1_2 == 116) break block16;
                                            if (var1_2 == 123) break block17;
                                            if (var1_2 == 45) break block18;
                                            if (var1_2 == 46) ** GOTO lbl46
                                            block0 : switch (var1_2) {
                                                default: lbl-1000:
                                                // 2 sources

                                                {
                                                    while (true) {
                                                        var1_3 = this._handleUnexpectedValue(var1_2);
                                                        break block0;
                                                        break;
                                                    }
                                                }
lbl46:
                                                // 1 sources

                                                this._parseFloatThatStartsWithPeriod(false, false);
                                                case 48: 
                                                case 49: 
                                                case 50: 
                                                case 51: 
                                                case 52: 
                                                case 53: 
                                                case 54: 
                                                case 55: 
                                                case 56: 
                                                case 57: {
                                                    var1_3 = this._parseUnsignedNumber(var1_2);
                                                    break;
                                                }
                                            }
                                            break block19;
                                        }
                                        var1_3 = this._parseNegNumber();
                                        break block19;
                                    }
                                    var1_3 = JsonToken.START_OBJECT;
                                    break block19;
                                }
                                this._matchToken("true", 1);
                                var1_3 = JsonToken.VALUE_TRUE;
                                break block19;
                            }
                            this._matchToken("null", 1);
                            var1_3 = JsonToken.VALUE_NULL;
                            break block19;
                        }
                        this._matchToken("false", 1);
                        var1_3 = JsonToken.VALUE_FALSE;
                        break block19;
                    }
                    var1_3 = JsonToken.START_ARRAY;
                    break block19;
                }
                ** while (!this.isEnabled((JsonParser.Feature)JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()))
lbl75:
                // 1 sources

                var1_3 = this._parsePosNumber();
            }
            this._nextToken = var1_3;
            return var2_5;
        }
        this._closeScope(var2_4);
        return null;
    }

    @Override
    public String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    return this._finishAndReturnString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                int n2 = uTF8DataInputJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n2, uTF8DataInputJsonParser._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                int n3 = uTF8DataInputJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n3, uTF8DataInputJsonParser._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                int n3 = uTF8DataInputJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n3, uTF8DataInputJsonParser._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                int n4 = uTF8DataInputJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n4, uTF8DataInputJsonParser._tokenInputCol);
            }
            return n2;
        }
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            n2 = this.getIntValue();
        }
        return n2;
    }

    @Override
    public long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                int n2 = uTF8DataInputJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n2, uTF8DataInputJsonParser._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                int n3 = uTF8DataInputJsonParser._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n3, uTF8DataInputJsonParser._tokenInputCol);
            }
            return l2;
        }
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            l2 = this.getLongValue();
        }
        return l2;
    }

    @Override
    public Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                Object object = this;
                int n2 = object._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildArrayContext(n2, object._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                Object object = this;
                int n3 = object._tokenInputRow;
                this._parsingContext = this._parsingContext.createChildObjectContext(n3, object._tokenInputCol);
            }
            return null;
        }
        if ((this = this.nextToken()) == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (this == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Deprecated
    public final JsonToken _parseFloatThatStartsWithPeriod() {
        return this._parseFloatThatStartsWithPeriod(false, false);
    }

    public final JsonToken _parseFloatThatStartsWithPeriod(boolean bl, boolean bl2) {
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            return this._handleUnexpectedValue(46);
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        if (bl) {
            int n3 = 1;
            cArray[n2] = 45;
            n2 = n3;
        }
        return this._parseFloat(cArray, n2, 46, bl, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonToken _parseUnsignedNumber(int n2) {
        int n3;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        if (n2 == 48) {
            n2 = this._handleLeadingZeroes();
            if (n2 <= 57 && n2 >= 48) {
                n3 = 0;
            } else {
                if (n2 == 120 || n2 == 88) return this._handleInvalidNumberStart(n2, false);
                cArray[0] = 48;
                n3 = 1;
            }
        } else {
            cArray[0] = (char)n2;
            n2 = this._inputData.readUnsignedByte();
            n3 = 1;
        }
        int n4 = n3;
        while (n2 <= 57 && n2 >= 48) {
            ++n3;
            if (n4 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n4 = 0;
            }
            int n5 = n2;
            n2 = n4 + 1;
            cArray[n4] = (char)n5;
            int n6 = n4 = this._inputData.readUnsignedByte();
            n4 = n2;
            n2 = n6;
        }
        if (n2 == 46 || n2 == 101 || n2 == 69) return this._parseFloat(cArray, n4, n2, false, n3);
        UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
        uTF8DataInputJsonParser._textBuffer.setCurrentLength(n4);
        if (uTF8DataInputJsonParser._parsingContext.inRoot()) {
            this._verifyRootSpace();
            return this.resetInt(false, n3);
        } else {
            this._nextByte = n2;
        }
        return this.resetInt(false, n3);
    }

    public final JsonToken _parsePosNumber() {
        return this._parseSignedNumber(false);
    }

    public final JsonToken _parseNegNumber() {
        return this._parseSignedNumber(true);
    }

    public final String _parseName(int n2) {
        if (n2 != 34) {
            return this._handleOddName(n2);
        }
        int[] nArray = _icLatin1;
        int n3 = this._inputData.readUnsignedByte();
        if (_icLatin1[n3] == 0) {
            int n4 = this._inputData.readUnsignedByte();
            if (nArray[n4] == 0) {
                n3 = n3 << 8 | n4;
                n4 = this._inputData.readUnsignedByte();
                if (nArray[n4] == 0) {
                    n3 = n3 << 8 | n4;
                    n4 = this._inputData.readUnsignedByte();
                    if (nArray[n4] == 0) {
                        int n5 = n3 << 8 | n4;
                        n3 = this._inputData.readUnsignedByte();
                        if (nArray[n3] == 0) {
                            this._quad1 = n5;
                            return this._parseMediumName(n3);
                        }
                        if (n3 == 34) {
                            return this.findName(n5, 4);
                        }
                        return this.parseName(n5, n3, 4);
                    }
                    if (n4 == 34) {
                        return this.findName(n3, 3);
                    }
                    return this.parseName(n3, n4, 3);
                }
                if (n4 == 34) {
                    return this.findName(n3, 2);
                }
                return this.parseName(n3, n4, 2);
            }
            if (n4 == 34) {
                return this.findName(n3, 1);
            }
            return this.parseName(n3, n4, 1);
        }
        if (n3 == 34) {
            return "";
        }
        return this.parseName(0, n3, 0);
    }

    public final String parseEscapedName(int[] nArray, int n2, int n3, int n4, int n5) {
        int[] nArray2 = _icLatin1;
        while (true) {
            if (nArray2[n4] != 0) {
                if (n4 == 34) {
                    String string;
                    if (n5 > 0) {
                        if (n2 >= nArray.length) {
                            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        int n6 = n3;
                        n3 = n2 + 1;
                        nArray[n2] = UTF8DataInputJsonParser.pad(n6, n5);
                        n2 = n3;
                    }
                    if ((string = this._symbols.findName(nArray, n2)) == null) {
                        string = this.addName(nArray, n2, n5);
                    }
                    return string;
                }
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeEscaped();
                }
                if (n4 > 127) {
                    if (n5 >= 4) {
                        if (n2 >= nArray.length) {
                            nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        n5 = n2 + 1;
                        nArray[n2] = n3;
                        n3 = 0;
                        int n7 = n2 = 0;
                        n2 = n5;
                        n5 = n7;
                    }
                    if (n4 < 2048) {
                        n3 = n3 << 8 | (n4 >> 6 | 0xC0);
                        ++n5;
                    } else {
                        n3 = n3 << 8 | (n4 >> 12 | 0xE0);
                        if (++n5 >= 4) {
                            if (n2 >= nArray.length) {
                                nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            n5 = n2 + 1;
                            nArray[n2] = n3;
                            n3 = 0;
                            int n8 = n2 = 0;
                            n2 = n5;
                            n5 = n8;
                        }
                        n3 = n3 << 8 | (n4 >> 6 & 0x3F | 0x80);
                        ++n5;
                    }
                    n4 = n4 & 0x3F | 0x80;
                }
            }
            if (n5 < 4) {
                int n9 = n3;
                n3 = n5 + 1;
                n4 = n9 << 8 | n4;
                int n10 = n3;
                n3 = n4;
                n5 = n10;
            } else {
                if (n2 >= nArray.length) {
                    nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                n5 = n2 + 1;
                nArray[n2] = n3;
                int n11 = n2 = 1;
                n3 = n4;
                n2 = n5;
                n5 = n11;
            }
            n4 = this._inputData.readUnsignedByte();
        }
    }

    public String _handleOddName(int n2) {
        String string;
        int[] nArray;
        if (n2 == 39 && (this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
            return this._parseAposName();
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            uTF8DataInputJsonParser._reportUnexpectedChar((char)uTF8DataInputJsonParser._decodeCharForError(n2), "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        do {
            if (n5 < 4) {
                int n6 = n4;
                n4 = n5 + 1;
                n2 = n6 << 8 | n2;
                n5 = n4;
                n4 = n2;
                continue;
            }
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser._growArrayBy(nArray2, nArray2.length);
            }
            n5 = n3 + 1;
            nArray2[n3] = n4;
            n3 = 1;
            int n7 = n5;
            n5 = n3;
            n4 = n2;
            n3 = n7;
        } while (nArray[n2 = this._inputData.readUnsignedByte()] == 0);
        this._nextByte = n2;
        if (n5 > 0) {
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8DataInputJsonParser._growArrayBy(nArray2, nArray2.length);
            }
            n2 = n3 + 1;
            nArray2[n3] = n4;
            n3 = n2;
        }
        if ((string = this._symbols.findName(nArray2, n3)) == null) {
            string = this.addName(nArray2, n3, n5);
        }
        return string;
    }

    public String _parseAposName() {
        int n2 = this._inputData.readUnsignedByte();
        if (n2 == 39) {
            return "";
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (n2 == 39) {
                String string;
                if (n5 > 0) {
                    if (n3 >= nArray.length) {
                        this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                    }
                    n2 = n3 + 1;
                    nArray[n3] = UTF8DataInputJsonParser.pad(n4, n5);
                    n3 = n2;
                }
                if ((string = this._symbols.findName(nArray, n3)) == null) {
                    string = this.addName(nArray, n3, n5);
                }
                return string;
            }
            if (n2 != 34 && nArray2[n2] != 0) {
                if (n2 != 92) {
                    this._throwUnquotedSpace(n2, "name");
                } else {
                    n2 = this._decodeEscaped();
                }
                if (n2 > 127) {
                    if (n5 >= 4) {
                        if (n3 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                        }
                        n5 = n3 + 1;
                        nArray[n3] = n4;
                        n4 = 0;
                        int n6 = n3 = 0;
                        n3 = n5;
                        n5 = n6;
                    }
                    if (n2 < 2048) {
                        n4 = n4 << 8 | (n2 >> 6 | 0xC0);
                        ++n5;
                    } else {
                        n4 = n4 << 8 | (n2 >> 12 | 0xE0);
                        if (++n5 >= 4) {
                            if (n3 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                            }
                            n5 = n3 + 1;
                            nArray[n3] = n4;
                            n4 = 0;
                            int n7 = n3 = 0;
                            n3 = n5;
                            n5 = n7;
                        }
                        n4 = n4 << 8 | (n2 >> 6 & 0x3F | 0x80);
                        ++n5;
                    }
                    n2 = n2 & 0x3F | 0x80;
                }
            }
            if (n5 < 4) {
                int n8 = n4;
                n4 = n5 + 1;
                n2 = n8 << 8 | n2;
                int n9 = n4;
                n4 = n2;
                n5 = n9;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8DataInputJsonParser._growArrayBy(nArray, nArray.length);
                }
                n5 = n3 + 1;
                nArray[n3] = n4;
                n3 = 1;
                int n10 = n5;
                n4 = n2;
                n5 = n3;
                n3 = n10;
            }
            n2 = this._inputData.readUnsignedByte();
        }
    }

    @Override
    public void _finishString() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n3 = cArray.length;
        while (true) {
            int n4;
            if (nArray[n4 = this._inputData.readUnsignedByte()] != 0) {
                if (n4 == 34) {
                    this._textBuffer.setCurrentLength(n2);
                    return;
                }
                this._finishString2(cArray, n2, n4);
                return;
            }
            int n5 = n2 + 1;
            cArray[n2] = (char)n4;
            if (n5 >= n3) {
                this._finishString2(cArray, n5, this._inputData.readUnsignedByte());
                return;
            }
            n2 = n5;
        }
    }

    public void _skipString() {
        this._tokenIncomplete = false;
        int[] nArray = _icUTF8;
        block6: while (true) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputData.readUnsignedByte()]) == 0) {
                continue;
            }
            if (n2 == 34) {
                return;
            }
            switch (n3) {
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                        continue block6;
                    }
                    this._reportInvalidChar(n2);
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4();
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2();
                    continue block6;
                }
                case 1: 
            }
            this._decodeEscaped();
        }
    }

    public JsonToken _handleUnexpectedValue(int n2) {
        String string;
        block14: {
            block7: {
                block8: {
                    block9: {
                        block11: {
                            block13: {
                                block10: {
                                    block12: {
                                        if (n2 == 39) break block7;
                                        if (n2 == 73) break block8;
                                        if (n2 == 78) break block9;
                                        if (n2 == 93) break block10;
                                        if (n2 == 125) break block11;
                                        if (n2 == 43) break block12;
                                        if (n2 == 44) break block13;
                                        break block14;
                                    }
                                    return this._handleInvalidNumberStart(this._inputData.readUnsignedByte(), false, true);
                                }
                                if (!this._parsingContext.inArray()) break block14;
                            }
                            if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                                this._nextByte = n2;
                                return JsonToken.VALUE_NULL;
                            }
                        }
                        this._reportUnexpectedChar(n2, "expected a value");
                        break block7;
                    }
                    this._matchToken("NaN", 1);
                    if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                        return this.resetAsNaN("NaN", Double.NaN);
                    }
                    this._reportError("Non-standard token 'NaN': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                    break block14;
                }
                this._matchToken("Infinity", 1);
                if ((this._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
                break block14;
            }
            if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
                return this._handleApos();
            }
        }
        if (Character.isJavaIdentifierStart(n2)) {
            string = "" + (char)n2;
            String string2 = this._validJsonTokenList();
            this._reportInvalidToken(n2, string, string2);
        }
        string = "expected a valid value " + this._validJsonValueList();
        this._reportUnexpectedChar(n2, string);
        return null;
    }

    public JsonToken _handleApos() {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        block6: while (true) {
            int n3 = cArray.length;
            if (n2 >= cArray.length) {
                char[] cArray2 = this._textBuffer.finishCurrentSegment();
                int n4 = 0;
                n3 = cArray2.length;
                cArray = cArray2;
                n2 = n4;
            }
            while (true) {
                int n5;
                if ((n5 = this._inputData.readUnsignedByte()) == 39) {
                    this._textBuffer.setCurrentLength(n2);
                    return JsonToken.VALUE_STRING;
                }
                int n6 = nArray[n5];
                if (n6 != 0 && n5 != 34) {
                    switch (n6) {
                        default: {
                            if (n5 < 32) {
                                this._throwUnquotedSpace(n5, "string value");
                            }
                            this._reportInvalidChar(n5);
                            break;
                        }
                        case 4: {
                            n3 = this._decodeUtf8_4(n5);
                            n5 = n2 + 1;
                            cArray[n2] = (char)(n3 >> 10 | 0xD800);
                            if (n5 >= cArray.length) {
                                cArray = this._textBuffer.finishCurrentSegment();
                                n2 = 0;
                            } else {
                                n2 = n5;
                            }
                            n5 = n3 & 0x3FF | 0xDC00;
                            break;
                        }
                        case 3: {
                            n5 = this._decodeUtf8_3(n5);
                            break;
                        }
                        case 2: {
                            n5 = this._decodeUtf8_2(n5);
                            break;
                        }
                        case 1: {
                            n5 = this._decodeEscaped();
                        }
                    }
                    if (n2 >= cArray.length) {
                        int n7;
                        char[] cArray3 = this._textBuffer.finishCurrentSegment();
                        n2 = n7 = 0;
                        cArray = cArray3;
                    }
                    n3 = n2 + 1;
                    cArray[n2] = (char)n5;
                    n2 = n3;
                    continue block6;
                }
                n6 = n2 + 1;
                cArray[n2] = (char)n5;
                if (n6 >= n3) {
                    n2 = n6;
                    continue block6;
                }
                n2 = n6;
            }
            break;
        }
    }

    public JsonToken _handleInvalidNumberStart(int n2, boolean bl) {
        return this._handleInvalidNumberStart(n2, bl, false);
    }

    public JsonToken _handleInvalidNumberStart(int n2, boolean bl, boolean bl2) {
        while (n2 == 73) {
            String string;
            n2 = this._inputData.readUnsignedByte();
            if (n2 == 78) {
                string = bl ? "-INF" : "+INF";
            } else {
                if (n2 != 110) break;
                string = bl ? "-Infinity" : "+Infinity";
            }
            UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
            uTF8DataInputJsonParser._matchToken(string, 3);
            if ((uTF8DataInputJsonParser._features & FEAT_MASK_NON_NUM_NUMBERS) != 0) {
                double d2 = bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                return this.resetAsNaN(string, d2);
            }
            this._reportError("Non-standard token '" + string + "': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow");
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature()) && bl2 && !bl) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        String string = bl ? "expected digit (0-9) to follow minus sign, for valid numeric value" : "expected digit (0-9) for valid numeric value";
        this._reportUnexpectedNumberChar(n2, string);
        return null;
    }

    public final void _matchToken(String string, int n2) {
        int n3 = string.length();
        do {
            int n4;
            if ((n4 = this._inputData.readUnsignedByte()) == string.charAt(n2)) continue;
            this._reportInvalidToken(n4, string.substring(0, n2));
        } while (++n2 < n3);
        n3 = this._inputData.readUnsignedByte();
        if (n3 >= 48 && n3 != 93 && n3 != 125) {
            this._checkMatchEnd(string, n2, n3);
        }
        this._nextByte = n3;
    }

    @Override
    public char _decodeEscaped() {
        int n2 = this._inputData.readUnsignedByte();
        switch (n2) {
            default: {
                UTF8DataInputJsonParser uTF8DataInputJsonParser = this;
                return uTF8DataInputJsonParser._handleUnrecognizedCharacterEscape((char)uTF8DataInputJsonParser._decodeCharForError(n2));
            }
            case 117: {
                n2 = 0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    int n3 = this._inputData.readUnsignedByte();
                    int n4 = CharTypes.charToHex(n3);
                    if (n4 < 0) {
                        this._reportUnexpectedChar(n3, "expected a hex-digit for character escape sequence");
                    }
                    n2 = n2 << 4 | n4;
                }
                return (char)n2;
            }
            case 116: {
                return '\t';
            }
            case 114: {
                return '\r';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 98: {
                return '\b';
            }
            case 34: 
            case 47: 
            case 92: 
        }
        return (char)n2;
    }

    public int _decodeCharForError(int n2) {
        int n3 = n2 & 0xFF;
        if (n3 > 127) {
            if ((n2 & 0xE0) == 192) {
                n3 = n2 & 0x1F;
                n2 = 1;
            } else if ((n2 & 0xF0) == 224) {
                n3 = n2 & 0xF;
                n2 = 2;
            } else if ((n2 & 0xF8) == 240) {
                n3 = n2 & 7;
                n2 = 3;
            } else {
                this._reportInvalidInitial(n2 & 0xFF);
                n2 = 1;
            }
            int n4 = this._inputData.readUnsignedByte();
            if ((n4 & 0xC0) != 128) {
                this._reportInvalidOther(n4 & 0xFF);
            }
            n3 = n3 << 6 | n4 & 0x3F;
            if (n2 > 1) {
                n4 = this._inputData.readUnsignedByte();
                if ((n4 & 0xC0) != 128) {
                    this._reportInvalidOther(n4 & 0xFF);
                }
                n3 = n3 << 6 | n4 & 0x3F;
                if (n2 > 2) {
                    n2 = this._inputData.readUnsignedByte();
                    if ((n2 & 0xC0) != 128) {
                        this._reportInvalidOther(n2 & 0xFF);
                    }
                    n3 = n3 << 6 | n2 & 0x3F;
                }
            }
        }
        return n3;
    }

    public void _reportInvalidToken(int n2, String string) {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = string2;
        String string2 = uTF8DataInputJsonParser._validJsonTokenList();
        uTF8DataInputJsonParser._reportInvalidToken(n2, string, string2);
    }

    public void _reportInvalidToken(int n2, String string, String string2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string);
        while (true) {
            char c2 = (char)this._decodeCharForError(n2);
            n2 = c2;
            if (!Character.isJavaIdentifierPart(c2)) {
                this._reportError("Unrecognized token '" + stringBuilder2.toString() + "': was expecting " + string2);
                return;
            }
            stringBuilder2.append((char)n2);
            n2 = this._inputData.readUnsignedByte();
        }
    }

    public void _reportInvalidChar(int n2) {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    public void _reportInvalidInitial(int n2) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    public final byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = ((ParserBase)((Object)string))._getByteArrayBuilder();
        while (true) {
            int n2;
            int n3;
            if ((n3 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte()) <= 32) {
                continue;
            }
            int n4 = base64Variant.decodeBase64Char(n3);
            if (n4 < 0) {
                if (n3 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n4 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n3, 0);
                if (n4 < 0) continue;
            }
            if ((n2 = base64Variant.decodeBase64Char(n3 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte())) < 0) {
                n2 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n3, 1);
            }
            n3 = n4 << 6 | n2;
            n4 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte();
            n2 = base64Variant.decodeBase64Char(n4);
            if (n2 < 0) {
                if (n2 != -2) {
                    if (n4 == 34) {
                        byteArrayBuilder.append(n3 >> 4);
                        if (base64Variant.usesPadding()) {
                            ((ParserBase)((Object)string))._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n4, 2);
                }
                if (n2 == -2) {
                    n4 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte();
                    if (!(base64Variant.usesPaddingChar(n4) || n4 == 92 && ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n4, 3) == -2)) {
                        UTF8DataInputJsonParser uTF8DataInputJsonParser = string;
                        String string = "expected padding character '" + base64Variant.getPaddingChar() + "'";
                        throw uTF8DataInputJsonParser.reportInvalidBase64Char(base64Variant, n4, 3, string);
                    }
                    byteArrayBuilder.append(n3 >> 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            n4 = ((UTF8DataInputJsonParser)((Object)string))._inputData.readUnsignedByte();
            n2 = base64Variant.decodeBase64Char(n4);
            if (n2 < 0) {
                if (n2 != -2) {
                    if (n4 == 34) {
                        byteArrayBuilder.appendTwoBytes(n3 >> 2);
                        if (base64Variant.usesPadding()) {
                            ((ParserBase)((Object)string))._handleBase64MissingPadding(base64Variant);
                        }
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = ((ParserBase)((Object)string))._decodeBase64Escape(base64Variant, n4, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >> 2);
                    continue;
                }
            }
            byteArrayBuilder.appendThreeBytes(n3 << 6 | n2);
        }
    }

    @Override
    public JsonLocation getTokenLocation() {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = contentReference;
        ContentReference contentReference = uTF8DataInputJsonParser._contentReference();
        int n2 = uTF8DataInputJsonParser._tokenInputRow;
        return new JsonLocation(contentReference, -1L, -1L, n2, -1);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        UTF8DataInputJsonParser uTF8DataInputJsonParser = contentReference;
        ContentReference contentReference = uTF8DataInputJsonParser._contentReference();
        int n2 = uTF8DataInputJsonParser._currInputRow;
        return new JsonLocation(contentReference, -1L, -1L, n2, -1);
    }
}

