/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.base.GeneratorBase;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.io.NumberOutput;
import com.privatefasterxml.jackson.core.json.JsonGeneratorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UTF8JsonGenerator
extends JsonGeneratorImpl {
    private static final byte BYTE_u = 117;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_LCURLY = 123;
    private static final byte BYTE_RCURLY = 125;
    private static final byte BYTE_BACKSLASH = 92;
    private static final byte BYTE_COMMA = 44;
    private static final byte BYTE_COLON = 58;
    private static final int MAX_BYTES_TO_BUFFER = 512;
    private static final byte[] HEX_BYTES_UPPER = CharTypes.copyHexBytes(true);
    private static final byte[] HEX_BYTES_LOWER = CharTypes.copyHexBytes(false);
    private static final byte[] NULL_BYTES = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE_BYTES = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    protected final OutputStream _outputStream;
    protected byte _quoteChar;
    protected byte[] _outputBuffer;
    protected int _outputTail;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected boolean _bufferRecyclable;

    public UTF8JsonGenerator(IOContext object, int n2, ObjectCodec objectCodec, OutputStream outputStream, char c2) {
        super((IOContext)object, n2, objectCodec);
        this._outputStream = outputStream;
        this._quoteChar = (byte)c2;
        if (c2 != '\"') {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2);
        }
        this._bufferRecyclable = true;
        this._outputBuffer = ((IOContext)object).allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        char[] cArray = ((IOContext)object).allocConcatBuffer();
        object = cArray;
        this._charBuffer = cArray;
        this._charBufferLength = ((Object)object).length;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, char c2, byte[] byArray, int n3, boolean bl) {
        super(iOContext, n2, objectCodec);
        ((UTF8JsonGenerator)object)._outputStream = outputStream;
        ((UTF8JsonGenerator)object)._quoteChar = (byte)c2;
        if (c2 != '\"') {
            ((JsonGeneratorImpl)object)._outputEscapes = CharTypes.get7BitOutputEscapes(c2);
        }
        UTF8JsonGenerator uTF8JsonGenerator = object;
        ((UTF8JsonGenerator)object)._bufferRecyclable = bl;
        ((UTF8JsonGenerator)object)._outputTail = n3;
        ((UTF8JsonGenerator)object)._outputBuffer = byArray;
        ((UTF8JsonGenerator)object)._outputEnd = byArray.length;
        ((UTF8JsonGenerator)object)._outputMaxContiguous = ((UTF8JsonGenerator)object)._outputEnd >> 3;
        char[] cArray = iOContext.allocConcatBuffer();
        Object object = cArray;
        uTF8JsonGenerator._charBuffer = cArray;
        uTF8JsonGenerator._charBufferLength = ((Object)object).length;
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        this(iOContext, n2, objectCodec, outputStream, '\"');
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl) {
        this(iOContext, n2, objectCodec, outputStream, '\"', byArray, n3, bl);
    }

    private final void _writeUnq(SerializableString serializableString) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int n2 = serializableString.appendQuotedUTF8(byArray, uTF8JsonGenerator._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
    }

    private final void _writeSegmentedRaw(char[] cArray, int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        int n4 = uTF8JsonGenerator._outputEnd;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        n3 = n2 + n3;
        block0: while (n2 < n3) {
            do {
                int n5;
                if ((n5 = cArray[n2]) >= 128) {
                    if (this._outputTail + 3 >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    n5 = n2 + 1;
                    if ((n2 = cArray[n2]) < 2048) {
                        int n6 = n2;
                        int n7 = this._outputTail;
                        int n8 = n2;
                        n2 = n7 + 1;
                        byArray[n7] = (byte)(n8 >> 6 | 0xC0);
                        this._outputTail = n7 + 2;
                        byArray[n2] = (byte)(n6 & 0x3F | 0x80);
                        n2 = n5;
                        continue block0;
                    }
                    n2 = this._outputRawMultiByteChar(n2, cArray, n5, n3);
                    continue block0;
                }
                if (this._outputTail >= n4) {
                    this._flushBuffer();
                }
                int n9 = n5;
                n5 = this._outputTail;
                this._outputTail = n5 + 1;
                byArray[n5] = (byte)n9;
            } while (++n2 < n3);
        }
    }

    private void _writeRawSegment(char[] cArray, int n2, int n3) {
        block0: while (n2 < n3) {
            do {
                int n4;
                if ((n4 = cArray[n2]) > 127) {
                    ++n2;
                    if (n4 < 2048) {
                        byte[] byArray = this._outputBuffer;
                        int n5 = n4;
                        int n6 = this._outputTail;
                        int n7 = n4;
                        n4 = n6 + 1;
                        byArray[n6] = (byte)(n7 >> 6 | 0xC0);
                        this._outputTail = n6 + 2;
                        this._outputBuffer[n4] = (byte)(n5 & 0x3F | 0x80);
                        continue block0;
                    }
                    n2 = this._outputRawMultiByteChar(n4, cArray, n2, n3);
                    continue block0;
                }
                int n8 = n4;
                n4 = this._outputTail;
                this._outputTail = n4 + 1;
                this._outputBuffer[n4] = (byte)n8;
            } while (++n2 < n3);
        }
    }

    private final void _writeQuotedShort(short s2) {
        int n2;
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        short s3 = s2;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        int n3 = uTF8JsonGenerator._outputTail;
        s2 = (short)n3;
        uTF8JsonGenerator._outputTail = n2 = n3 + 1;
        this._outputBuffer[s2] = uTF8JsonGenerator._quoteChar;
        s2 = (short)NumberOutput.outputInt((int)s3, this._outputBuffer, n2);
        this._outputTail = s2 + 1;
        this._outputBuffer[s2] = this._quoteChar;
    }

    private final void _writeQuotedInt(int n2) {
        int n3;
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = n2;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n2 = uTF8JsonGenerator._outputTail;
        uTF8JsonGenerator._outputTail = n3 = n2 + 1;
        this._outputBuffer[n2] = uTF8JsonGenerator._quoteChar;
        n2 = NumberOutput.outputInt(n4, this._outputBuffer, n3);
        this._outputTail = n2 + 1;
        this._outputBuffer[n2] = this._quoteChar;
    }

    private final void _writeQuotedLong(long l2) {
        int n2;
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        int n3 = uTF8JsonGenerator._outputTail;
        uTF8JsonGenerator._outputTail = n2 = n3 + 1;
        this._outputBuffer[n3] = uTF8JsonGenerator._quoteChar;
        n3 = NumberOutput.outputLong(l2, this._outputBuffer, n2);
        this._outputTail = n3 + 1;
        this._outputBuffer[n3] = this._quoteChar;
    }

    private final void _writeQuotedRaw(String string) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        int n2 = uTF8JsonGenerator2._outputTail;
        uTF8JsonGenerator2._outputTail = n2 + 1;
        this._outputBuffer[n2] = uTF8JsonGenerator2._quoteChar;
        uTF8JsonGenerator.writeRaw(string);
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n3 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n3 + 1;
        this._outputBuffer[n3] = uTF8JsonGenerator3._quoteChar;
    }

    private void _writeQuotedRaw(char[] cArray, int n2, int n3) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        int n4 = uTF8JsonGenerator2._outputTail;
        uTF8JsonGenerator2._outputTail = n4 + 1;
        this._outputBuffer[n4] = uTF8JsonGenerator2._quoteChar;
        uTF8JsonGenerator.writeRaw(cArray, n2, n3);
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n5 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n5 + 1;
        this._outputBuffer[n5] = uTF8JsonGenerator3._quoteChar;
    }

    private final void _writeBytes(byte[] byArray) {
        int n2 = byArray.length;
        if (((UTF8JsonGenerator)object)._outputTail + n2 > ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
            if (n2 > 512) {
                ((UTF8JsonGenerator)object)._outputStream.write(byArray, 0, n2);
                return;
            }
        }
        UTF8JsonGenerator uTF8JsonGenerator = object;
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        Object object = uTF8JsonGenerator2._outputBuffer;
        int n3 = uTF8JsonGenerator2._outputTail;
        System.arraycopy(byArray, 0, object, n3, n2);
        uTF8JsonGenerator._outputTail += n2;
    }

    private final void _writeBytes(byte[] byArray, int n2, int n3) {
        if (((UTF8JsonGenerator)object)._outputTail + n3 > ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
            if (n3 > 512) {
                ((UTF8JsonGenerator)object)._outputStream.write(byArray, n2, n3);
                return;
            }
        }
        UTF8JsonGenerator uTF8JsonGenerator = object;
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        Object object = uTF8JsonGenerator2._outputBuffer;
        System.arraycopy(byArray, n2, object, uTF8JsonGenerator2._outputTail, n3);
        uTF8JsonGenerator._outputTail += n3;
    }

    private final void _writeStringSegments(String string, boolean bl) {
        int n2;
        int n3;
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = this;
            n3 = uTF8JsonGenerator._outputTail;
            uTF8JsonGenerator._outputTail = n3 + 1;
            this._outputBuffer[n3] = uTF8JsonGenerator._quoteChar;
        }
        int n4 = 0;
        for (n3 = string.length(); n3 > 0; n3 -= n2) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            n2 = Math.min(uTF8JsonGenerator._outputMaxContiguous, n3);
            if (uTF8JsonGenerator._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n4, n2);
            n4 += n2;
        }
        if (bl) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = this;
            int n5 = uTF8JsonGenerator._outputTail;
            uTF8JsonGenerator._outputTail = n5 + 1;
            this._outputBuffer[n5] = uTF8JsonGenerator._quoteChar;
        }
    }

    private final void _writeStringSegments(char[] cArray, int n2, int n3) {
        int n4;
        do {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            n4 = Math.min(uTF8JsonGenerator._outputMaxContiguous, n3);
            if (uTF8JsonGenerator._outputTail + n4 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeStringSegments(String string, int n2, int n3) {
        int n4;
        do {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            n4 = Math.min(uTF8JsonGenerator._outputMaxContiguous, n3);
            if (uTF8JsonGenerator._outputTail + n4 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeStringSegment(char[] cArray, int n2, int n3) {
        int n4;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n3 += n2;
        int n5 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        while (n2 < n3 && (n4 = cArray[n2]) <= 127 && nArray[n4] == 0) {
            int n6 = n4;
            n4 = n5 + 1;
            byArray[n5] = (byte)n6;
            ++n2;
            n5 = n4;
        }
        this._outputTail = n5;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(cArray, n2, n3);
            } else if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(cArray, n2, n3);
            } else {
                this._writeStringSegmentASCII2(cArray, n2, n3);
            }
        }
    }

    private final void _writeStringSegment(String string, int n2, int n3) {
        int n4;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n3 += n2;
        int n5 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        while (n2 < n3 && (n4 = string.charAt(n2)) <= 127 && nArray[n4] == 0) {
            int n6 = n4;
            n4 = n5 + 1;
            byArray[n5] = (byte)n6;
            ++n2;
            n5 = n4;
        }
        this._outputTail = n5;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(string, n2, n3);
            } else if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(string, n2, n3);
            } else {
                this._writeStringSegmentASCII2(string, n2, n3);
            }
        }
    }

    private final void _writeStringSegment2(char[] cArray, int n2, int n3) {
        int n4 = this._outputTail;
        if ((n3 - n2) * 6 + n4 > this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n4 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        while (n2 < n3) {
            int n5 = n2 + 1;
            if ((n2 = cArray[n2]) <= 127) {
                int n6 = nArray[n2];
                if (n6 == 0) {
                    int n7 = n2;
                    n2 = n4 + 1;
                    byArray[n4] = (byte)n7;
                    n4 = n2;
                    n2 = n5;
                    continue;
                }
                if (n6 > 0) {
                    n2 = n4 + 1;
                    byArray[n4] = 92;
                    n4 += 2;
                    byArray[n2] = (byte)n6;
                    n2 = n5;
                    continue;
                }
                n4 = this._writeGenericEscape(n2, n4);
                n2 = n5;
                continue;
            }
            if (n2 <= 2047) {
                int n8 = n2;
                int n9 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)(n9 >> 6 | 0xC0);
                n4 += 2;
                byArray[n2] = (byte)(n8 & 0x3F | 0x80);
            } else {
                n4 = n2 = this._outputMultiByteChar(n2, n4);
            }
            n2 = n5;
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegment2(String string, int n2, int n3) {
        int n4 = this._outputTail;
        if ((n3 - n2) * 6 + n4 > this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n4 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        while (n2 < n3) {
            int n5 = n2 + 1;
            char c2 = string.charAt(n2);
            n2 = c2;
            if (c2 <= '\u007f') {
                int n6 = nArray[n2];
                if (n6 == 0) {
                    int n7 = n2;
                    n2 = n4 + 1;
                    byArray[n4] = (byte)n7;
                    n4 = n2;
                    n2 = n5;
                    continue;
                }
                if (n6 > 0) {
                    n2 = n4 + 1;
                    byArray[n4] = 92;
                    n4 += 2;
                    byArray[n2] = (byte)n6;
                    n2 = n5;
                    continue;
                }
                n4 = this._writeGenericEscape(n2, n4);
                n2 = n5;
                continue;
            }
            if (n2 <= 2047) {
                int n8 = n2;
                int n9 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)(n9 >> 6 | 0xC0);
                n4 += 2;
                byArray[n2] = (byte)(n8 & 0x3F | 0x80);
            } else {
                n4 = n2 = this._outputMultiByteChar(n2, n4);
            }
            n2 = n5;
        }
        this._outputTail = n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeStringSegmentASCII2(char[] cArray, int n2, int n3) {
        int n4 = this._outputTail;
        if ((n3 - n2) * 6 + n4 > this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n4 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        int n5 = uTF8JsonGenerator._maximumNonEscapedChar;
        while (true) {
            int n6;
            block13: {
                block12: {
                    block11: {
                        if (n2 >= n3) {
                            this._outputTail = n4;
                            return;
                        }
                        n6 = n2 + 1;
                        if ((n2 = cArray[n2]) > 127) break block11;
                        int n7 = nArray[n2];
                        if (n7 == 0) {
                            int n8 = n2;
                            n2 = n4 + 1;
                            byArray[n4] = (byte)n8;
                            n4 = n2;
                            n2 = n6;
                            continue;
                        }
                        if (n7 > 0) {
                            n2 = n4 + 1;
                            byArray[n4] = 92;
                            n4 += 2;
                            byArray[n2] = (byte)n7;
                            n2 = n6;
                            continue;
                        }
                        break block12;
                    }
                    if (n2 <= n5) break block13;
                }
                n4 = this._writeGenericEscape(n2, n4);
                n2 = n6;
                continue;
            }
            if (n2 <= 2047) {
                int n9 = n2;
                int n10 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)(n10 >> 6 | 0xC0);
                n4 += 2;
                byArray[n2] = (byte)(n9 & 0x3F | 0x80);
            } else {
                n4 = n2 = this._outputMultiByteChar(n2, n4);
            }
            n2 = n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeStringSegmentASCII2(String string, int n2, int n3) {
        int n4 = this._outputTail;
        if ((n3 - n2) * 6 + n4 > this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n4 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        int n5 = uTF8JsonGenerator._maximumNonEscapedChar;
        while (true) {
            int n6;
            block13: {
                block12: {
                    block11: {
                        if (n2 >= n3) {
                            this._outputTail = n4;
                            return;
                        }
                        n6 = n2 + 1;
                        char c2 = string.charAt(n2);
                        n2 = c2;
                        if (c2 > '\u007f') break block11;
                        int n7 = nArray[n2];
                        if (n7 == 0) {
                            int n8 = n2;
                            n2 = n4 + 1;
                            byArray[n4] = (byte)n8;
                            n4 = n2;
                            n2 = n6;
                            continue;
                        }
                        if (n7 > 0) {
                            n2 = n4 + 1;
                            byArray[n4] = 92;
                            n4 += 2;
                            byArray[n2] = (byte)n7;
                            n2 = n6;
                            continue;
                        }
                        break block12;
                    }
                    if (n2 <= n5) break block13;
                }
                n4 = this._writeGenericEscape(n2, n4);
                n2 = n6;
                continue;
            }
            if (n2 <= 2047) {
                int n9 = n2;
                int n10 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)(n10 >> 6 | 0xC0);
                n4 += 2;
                byArray[n2] = (byte)(n9 & 0x3F | 0x80);
            } else {
                n4 = n2 = this._outputMultiByteChar(n2, n4);
            }
            n2 = n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeCustomStringSegment2(char[] cArray, int n2, int n3) {
        int n4 = this._outputTail;
        if ((n3 - n2) * 6 + n4 > this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n4 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        int n5 = uTF8JsonGenerator._maximumNonEscapedChar;
        if (n5 <= 0) {
            n5 = 65535;
        }
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (true) {
            int n6;
            block17: {
                block16: {
                    block15: {
                        if (n2 >= n3) {
                            this._outputTail = n4;
                            return;
                        }
                        n6 = n2 + 1;
                        if ((n2 = cArray[n2]) > 127) break block15;
                        int n7 = nArray[n2];
                        if (n7 == 0) {
                            int n8 = n2;
                            n2 = n4 + 1;
                            byArray[n4] = (byte)n8;
                            n4 = n2;
                            n2 = n6;
                            continue;
                        }
                        if (n7 > 0) {
                            n2 = n4 + 1;
                            byArray[n4] = 92;
                            n4 += 2;
                            byArray[n2] = (byte)n7;
                            n2 = n6;
                            continue;
                        }
                        if (n7 == -2) {
                            SerializableString serializableString = characterEscapes.getEscapeSequence(n2);
                            if (serializableString == null) {
                                this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n2) + ", although was supposed to have one");
                            }
                            n2 = n3 - n6;
                            n4 = this._writeCustomEscape(byArray, n4, serializableString, n2);
                            n2 = n6;
                            continue;
                        }
                        break block16;
                    }
                    if (n2 <= n5) break block17;
                }
                n4 = this._writeGenericEscape(n2, n4);
                n2 = n6;
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n2);
            if (serializableString != null) {
                n2 = n3 - n6;
                n4 = this._writeCustomEscape(byArray, n4, serializableString, n2);
                n2 = n6;
                continue;
            }
            if (n2 <= 2047) {
                int n9 = n2;
                int n10 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)(n10 >> 6 | 0xC0);
                n4 += 2;
                byArray[n2] = (byte)(n9 & 0x3F | 0x80);
            } else {
                n4 = n2 = this._outputMultiByteChar(n2, n4);
            }
            n2 = n6;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void _writeCustomStringSegment2(String string, int n2, int n3) {
        int n4 = this._outputTail;
        if ((n3 - n2) * 6 + n4 > this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n4 = uTF8JsonGenerator._outputTail;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        int n5 = uTF8JsonGenerator._maximumNonEscapedChar;
        if (n5 <= 0) {
            n5 = 65535;
        }
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (true) {
            int n6;
            block17: {
                block16: {
                    block15: {
                        if (n2 >= n3) {
                            this._outputTail = n4;
                            return;
                        }
                        n6 = n2 + 1;
                        char c2 = string.charAt(n2);
                        n2 = c2;
                        if (c2 > '\u007f') break block15;
                        int n7 = nArray[n2];
                        if (n7 == 0) {
                            int n8 = n2;
                            n2 = n4 + 1;
                            byArray[n4] = (byte)n8;
                            n4 = n2;
                            n2 = n6;
                            continue;
                        }
                        if (n7 > 0) {
                            n2 = n4 + 1;
                            byArray[n4] = 92;
                            n4 += 2;
                            byArray[n2] = (byte)n7;
                            n2 = n6;
                            continue;
                        }
                        if (n7 == -2) {
                            SerializableString serializableString = characterEscapes.getEscapeSequence(n2);
                            if (serializableString == null) {
                                this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n2) + ", although was supposed to have one");
                            }
                            n2 = n3 - n6;
                            n4 = this._writeCustomEscape(byArray, n4, serializableString, n2);
                            n2 = n6;
                            continue;
                        }
                        break block16;
                    }
                    if (n2 <= n5) break block17;
                }
                n4 = this._writeGenericEscape(n2, n4);
                n2 = n6;
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n2);
            if (serializableString != null) {
                n2 = n3 - n6;
                n4 = this._writeCustomEscape(byArray, n4, serializableString, n2);
                n2 = n6;
                continue;
            }
            if (n2 <= 2047) {
                int n9 = n2;
                int n10 = n2;
                n2 = n4 + 1;
                byArray[n4] = (byte)(n10 >> 6 | 0xC0);
                n4 += 2;
                byArray[n2] = (byte)(n9 & 0x3F | 0x80);
            } else {
                n4 = n2 = this._outputMultiByteChar(n2, n4);
            }
            n2 = n6;
        }
    }

    private final int _writeCustomEscape(byte[] byArray, int n2, SerializableString object, int n3) {
        byte[] byArray2 = object.asUnquotedUTF8();
        object = byArray2;
        int n4 = byArray2.length;
        if (n4 > 6) {
            return this._handleLongCustomEscape(byArray, n2, this._outputEnd, (byte[])object, n3);
        }
        System.arraycopy(object, 0, byArray, n2, n4);
        return n2 + n4;
    }

    private final int _handleLongCustomEscape(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = byArray2.length;
        if (n2 + n5 > n3) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._outputTail = n2;
            uTF8JsonGenerator._flushBuffer();
            n2 = uTF8JsonGenerator._outputTail;
            if (n5 > byArray.length) {
                this._outputStream.write(byArray2, 0, n5);
                return n2;
            }
        }
        System.arraycopy(byArray2, 0, byArray, n2, n5);
        int n6 = n2 + n5;
        if (n4 * 6 + n6 > n3) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._outputTail = n6;
            uTF8JsonGenerator._flushBuffer();
            return uTF8JsonGenerator._outputTail;
        }
        return n6;
    }

    private final void _writeUTF8Segments(byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = n3;
            n3 = Math.min(this._outputMaxContiguous, n3);
            this._writeUTF8Segment(byArray, n2, n3);
            n2 += n3;
        } while ((n3 = n4 - n3) > 0);
    }

    private final void _writeUTF8Segment(byte[] byArray, int n2, int n3) {
        int[] nArray = ((JsonGeneratorImpl)object)._outputEscapes;
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            int n6 = n5 + 1;
            if ((n5 = byArray[n5]) >= 0 && nArray[n5] != 0) {
                ((UTF8JsonGenerator)object)._writeUTF8Segment2(byArray, n2, n3);
                return;
            }
            n5 = n6;
        }
        if (((UTF8JsonGenerator)object)._outputTail + n3 > ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = object;
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        Object object = uTF8JsonGenerator2._outputBuffer;
        System.arraycopy(byArray, n2, object, uTF8JsonGenerator2._outputTail, n3);
        uTF8JsonGenerator._outputTail += n3;
    }

    private final void _writeUTF8Segment2(byte[] byArray, int n2, int n3) {
        int n4 = this._outputTail;
        if (n3 * 6 + n4 > this._outputEnd) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._flushBuffer();
            n4 = uTF8JsonGenerator._outputTail;
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        byte[] byArray2 = uTF8JsonGenerator._outputBuffer;
        int[] nArray = uTF8JsonGenerator._outputEscapes;
        int n5 = n3 + n2;
        while (n2 < n5) {
            int n6;
            int n7 = n2 + 1;
            if ((n2 = byArray[n2]) >= 0 && (n6 = nArray[n2]) != 0) {
                if (n6 > 0) {
                    n2 = n4 + 1;
                    byArray2[n4] = 92;
                    n4 += 2;
                    byArray2[n2] = (byte)n6;
                } else {
                    n4 = n2 = this._writeGenericEscape(n2, n4);
                }
                n2 = n7;
                continue;
            }
            n6 = n4 + 1;
            byArray2[n4] = n2;
            n4 = n6;
            n2 = n7;
        }
        this._outputTail = n4;
    }

    private final int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n2 < n3) {
            int n6 = n5 + 1;
            int n7 = n2 + 1;
            byArray[n5] = byArray[n2];
            n5 = n6;
            n2 = n7;
        }
        n2 = Math.min(n4, byArray.length);
        while ((n3 = n2 - n5) != 0) {
            if ((n3 = inputStream.read(byArray, n5, n3)) < 0) {
                return n5;
            }
            if ((n5 += n3) < 3) continue;
        }
        return n5;
    }

    private final int _outputRawMultiByteChar(int n2, char[] objectArray, int n3, int n4) {
        if (n2 >= 55296 && n2 <= 57343) {
            if (n3 < n4 && objectArray != null) {
                objectArray4._outputSurrogates(n2, objectArray[n3]);
            } else {
                Object[] objectArray2 = objectArray4;
                Object[] objectArray3 = new Object[1];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = n2;
                objectArray2._reportError(String.format("Split surrogate on writeRaw() input (last character): first character 0x%4x", objectArray4));
            }
            return n3 + 1;
        }
        objectArray = objectArray4._outputBuffer;
        int n5 = n2;
        int n6 = objectArray4._outputTail;
        int n7 = n6;
        int n8 = n2;
        int n9 = n2;
        n2 = n7 + 1;
        objectArray[n7] = (char)(n9 >> 12 | 0xE0);
        objectArray[n2] = (char)(n8 >> 6 & 0x3F | 0x80);
        objectArray4._outputTail = n6 + 3;
        objectArray4._outputBuffer[n7 += 2] = (byte)(n5 & 0x3F | 0x80);
        return n3;
    }

    private final int _outputMultiByteChar(int n2, int n3) {
        int n4;
        UTF8JsonGenerator uTF8JsonGenerator = object;
        Object object = uTF8JsonGenerator.getHexBytes();
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        if (n2 >= 55296 && n2 <= 57343) {
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = n3;
            n4 = n9 + 1;
            byArray[n9] = 92;
            int n10 = n4;
            n4 = n3 + 2;
            byArray[n10] = 117;
            n2 = n3 + 3;
            byArray[n4] = (byte)object[n8 >> 12 & 0xF];
            n4 = n3 + 4;
            byArray[n2] = (byte)object[n7 >> 8 & 0xF];
            n2 = n3 + 5;
            byArray[n4] = (byte)object[n6 >> 4 & 0xF];
            n4 = n3 + 6;
            byArray[n2] = (byte)object[n5 & 0xF];
        } else {
            int n11 = n2;
            int n12 = n2;
            n4 = n3 + 1;
            byArray[n3] = (byte)(n2 >> 12 | 0xE0);
            n2 = n3 + 2;
            byArray[n4] = (byte)(n12 >> 6 & 0x3F | 0x80);
            n4 = n3 + 3;
            byArray[n2] = (byte)(n11 & 0x3F | 0x80);
        }
        return n4;
    }

    private final void _writeNull() {
        if (((UTF8JsonGenerator)object)._outputTail + 4 >= ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = object;
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        Object object = uTF8JsonGenerator2._outputBuffer;
        int n2 = uTF8JsonGenerator2._outputTail;
        System.arraycopy(NULL_BYTES, 0, object, n2, 4);
        uTF8JsonGenerator._outputTail += 4;
    }

    private int _writeGenericEscape(int n2, int n3) {
        byte[] byArray = ((UTF8JsonGenerator)object)._outputBuffer;
        byte[] byArray2 = byArray;
        Object object = ((UTF8JsonGenerator)object).getHexBytes();
        int n4 = n3 + 1;
        byArray[n3] = 92;
        int n5 = n3 + 2;
        ((UTF8JsonGenerator)object)._outputBuffer[n4] = 117;
        if (n2 > 255) {
            int n6 = n2;
            int n7 = n2 >> 8;
            n2 = n7;
            int n8 = n2 & 0xFF;
            n2 = n3 + 3;
            byArray2[n5] = (byte)object[n8 >> 4];
            n3 += 4;
            byArray2[n2] = (byte)object[n7 & 0xF];
            n2 = n6 & 0xFF;
        } else {
            n4 = n3 + 3;
            byArray2[n5] = 48;
            n3 += 4;
            byArray2[n4] = 48;
        }
        int n9 = n3;
        byArray2[n3++] = (byte)object[n2 >> 4];
        byArray2[n3] = (byte)object[n2 & 0xF];
        return n9 + 2;
    }

    private byte[] getHexBytes() {
        return this._cfgWriteHexUppercase ? HEX_BYTES_UPPER : HEX_BYTES_LOWER;
    }

    @Override
    public Object getOutputTarget() {
        return this._outputStream;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public void writeFieldName(String string) {
        int n2;
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string);
            return;
        }
        int n3 = this._writeContext.writeFieldName(string);
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        n3 = string.length();
        if (n3 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        this._outputTail = n2 = n4 + 1;
        this._outputBuffer[n4] = this._quoteChar;
        if (n3 <= this._outputMaxContiguous) {
            if (n2 + n3 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, 0, n3);
        } else {
            this._writeStringSegments(string, 0, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        int n2;
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString);
            return;
        }
        int n3 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeUnq(serializableString);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n4 = this._outputTail;
        this._outputTail = n2 = n4 + 1;
        this._outputBuffer[n4] = this._quoteChar;
        int n5 = serializableString.appendQuotedUTF8(byArray, n2);
        if (n5 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n5;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public final void writeStartArray() {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("start an array");
        uTF8JsonGenerator._writeContext = uTF8JsonGenerator._writeContext.createChildArrayContext();
        PrettyPrinter prettyPrinter = uTF8JsonGenerator._cfgPrettyPrinter;
        if (prettyPrinter != null) {
            prettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 91;
        }
    }

    @Override
    public final void writeStartArray(Object object) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("start an array");
        uTF8JsonGenerator._writeContext = uTF8JsonGenerator._writeContext.createChildArrayContext(object);
        object = uTF8JsonGenerator._cfgPrettyPrinter;
        if (object != null) {
            object.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 91;
        }
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("start an array");
        uTF8JsonGenerator._writeContext = uTF8JsonGenerator._writeContext.createChildArrayContext(object);
        object = uTF8JsonGenerator._cfgPrettyPrinter;
        if (object != null) {
            object.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n3 = this._outputTail;
            this._outputTail = n3 + 1;
            this._outputBuffer[n3] = 91;
        }
    }

    @Override
    public final void writeEndArray() {
        PrettyPrinter prettyPrinter;
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if ((prettyPrinter = this._cfgPrettyPrinter) != null) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            prettyPrinter.writeEndArray(uTF8JsonGenerator, uTF8JsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public final void writeStartObject() {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("start an object");
        uTF8JsonGenerator._writeContext = uTF8JsonGenerator._writeContext.createChildObjectContext();
        PrettyPrinter prettyPrinter = uTF8JsonGenerator._cfgPrettyPrinter;
        if (prettyPrinter != null) {
            prettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 123;
        }
    }

    @Override
    public void writeStartObject(Object object) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("start an object");
        uTF8JsonGenerator._writeContext = uTF8JsonGenerator._writeContext.createChildObjectContext(object);
        object = uTF8JsonGenerator._cfgPrettyPrinter;
        if (object != null) {
            object.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 123;
        }
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        this.writeStartObject(object);
    }

    @Override
    public final void writeEndObject() {
        PrettyPrinter prettyPrinter;
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if ((prettyPrinter = this._cfgPrettyPrinter) != null) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            prettyPrinter.writeEndObject(uTF8JsonGenerator, uTF8JsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    public final void _writePPFieldName(String object) {
        int n2 = this._writeContext.writeFieldName((String)object);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments((String)object, false);
            return;
        }
        n2 = ((String)object).length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments((String)object, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        String string = object;
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        object = this._charBuffer;
        string.getChars(0, n2, (char[])object, 0);
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(this._charBuffer, 0, n2);
        } else {
            this._writeStringSegments(this._charBuffer, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    public final void _writePPFieldName(SerializableString serializableString) {
        int n2;
        int n3 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        n3 = this._cfgUnqNames ^ 1;
        if (n3 != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        if ((n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail)) < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (n3 != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeString(String string) {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        int n2 = string.length();
        if (n2 > this._outputMaxContiguous) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        int n3 = uTF8JsonGenerator2._outputTail;
        uTF8JsonGenerator2._outputTail = n3 + 1;
        this._outputBuffer[n3] = uTF8JsonGenerator2._quoteChar;
        uTF8JsonGenerator._writeStringSegment(string, 0, n2);
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n4 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n4 + 1;
        this._outputBuffer[n4] = uTF8JsonGenerator3._quoteChar;
    }

    @Override
    public void writeString(Reader reader, int n2) {
        int n3;
        this._verifyValueWrite("write a string");
        if (reader == null) {
            this._reportError("null reader");
            return;
        }
        int n4 = n2 >= 0 ? n2 : Integer.MAX_VALUE;
        char[] cArray = this._charBuffer;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        while (n4 > 0 && (n3 = reader.read(cArray, 0, Math.min(n4, cArray.length))) > 0) {
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegments(cArray, 0, n3);
            n4 -= n3;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n4 > 0 && n2 >= 0) {
            this._reportError("Didn't read enough from reader");
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        int n4;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("write a string");
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n5 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n4 = n5 + 1;
        uTF8JsonGenerator2._outputBuffer[n5] = uTF8JsonGenerator3._quoteChar;
        if (n3 <= uTF8JsonGenerator2._outputMaxContiguous) {
            if (n4 + n3 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n3);
        } else {
            this._writeStringSegments(cArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator4 = this;
        int n6 = uTF8JsonGenerator4._outputTail;
        uTF8JsonGenerator4._outputTail = n6 + 1;
        this._outputBuffer[n6] = uTF8JsonGenerator4._quoteChar;
    }

    @Override
    public final void writeString(SerializableString serializableString) {
        int n2;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("write a string");
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        int n3 = uTF8JsonGenerator2._outputTail;
        uTF8JsonGenerator2._outputTail = n2 = n3 + 1;
        this._outputBuffer[n3] = uTF8JsonGenerator2._quoteChar;
        int n4 = serializableString.appendQuotedUTF8(byArray, n2);
        if (n4 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n4;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n5 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n5 + 1;
        this._outputBuffer[n5] = uTF8JsonGenerator3._quoteChar;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._checkRangeBoundsForByteArray(byArray, n2, n3);
        uTF8JsonGenerator._verifyValueWrite("write a string");
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n4 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n4 + 1;
        this._outputBuffer[n4] = uTF8JsonGenerator3._quoteChar;
        uTF8JsonGenerator2._writeBytes(byArray, n2, n3);
        if (uTF8JsonGenerator2._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator4 = this;
        int n5 = uTF8JsonGenerator4._outputTail;
        uTF8JsonGenerator4._outputTail = n5 + 1;
        this._outputBuffer[n5] = uTF8JsonGenerator4._quoteChar;
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._checkRangeBoundsForByteArray(byArray, n2, n3);
        uTF8JsonGenerator._verifyValueWrite("write a string");
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n4 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n4 + 1;
        uTF8JsonGenerator2._outputBuffer[n4] = uTF8JsonGenerator3._quoteChar;
        if (n3 <= uTF8JsonGenerator2._outputMaxContiguous) {
            this._writeUTF8Segment(byArray, n2, n3);
        } else {
            this._writeUTF8Segments(byArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator4 = this;
        int n5 = uTF8JsonGenerator4._outputTail;
        uTF8JsonGenerator4._outputTail = n5 + 1;
        this._outputBuffer[n5] = uTF8JsonGenerator4._quoteChar;
    }

    @Override
    public void writeRaw(String string) {
        int n2 = string.length();
        char[] cArray = this._charBuffer;
        if (n2 <= this._charBuffer.length) {
            string.getChars(0, n2, cArray, 0);
            this.writeRaw(cArray, 0, n2);
        } else {
            this.writeRaw(string, 0, n2);
        }
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._checkRangeBoundsForString(string, n2, n3);
        char[] cArray = uTF8JsonGenerator._charBuffer;
        int n4 = uTF8JsonGenerator._charBuffer.length;
        if (n3 <= n4) {
            string.getChars(n2, n2 + n3, cArray, 0);
            this.writeRaw(cArray, 0, n3);
            return;
        }
        int n5 = n4;
        n4 = this._outputEnd;
        n4 = Math.min(n5, (n4 >> 2) + (n4 >> 4));
        int n6 = n4 * 3;
        while (n3 > 0) {
            char c2;
            int n7 = n2;
            int n8 = Math.min(n4, n3);
            string.getChars(n7, n7 + n8, cArray, 0);
            if (this._outputTail + n6 > this._outputEnd) {
                this._flushBuffer();
            }
            if (n8 > 1 && (c2 = cArray[n8 - 1]) >= '\ud800' && c2 <= '\udbff') {
                --n8;
            }
            this._writeRawSegment(cArray, 0, n8);
            n2 += n8;
            n3 -= n8;
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int n2 = serializableString.appendUnquotedUTF8(byArray, uTF8JsonGenerator._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asUnquotedUTF8());
        } else {
            this._outputTail += n2;
        }
    }

    @Override
    public void writeRawValue(SerializableString serializableString) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("write a raw (unencoded) value");
        byte[] byArray = uTF8JsonGenerator._outputBuffer;
        int n2 = serializableString.appendUnquotedUTF8(byArray, uTF8JsonGenerator._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asUnquotedUTF8());
        } else {
            this._outputTail += n2;
        }
    }

    @Override
    public final void writeRaw(char[] cArray, int n2, int n3) {
        int n4 = n3;
        this._checkRangeBoundsForCharArray(cArray, n2, n3);
        int n5 = n4 + n4 + n3;
        int n6 = this._outputEnd;
        if (this._outputTail + n5 > n6) {
            if (n6 < n5) {
                this._writeSegmentedRaw(cArray, n2, n3);
                return;
            }
            this._flushBuffer();
        }
        n3 += n2;
        block0: while (n2 < n3) {
            do {
                if ((n5 = cArray[n2]) > 127) {
                    ++n2;
                    if (n5 < 2048) {
                        byte[] byArray = this._outputBuffer;
                        int n7 = n5;
                        int n8 = this._outputTail;
                        int n9 = n5;
                        n5 = n8 + 1;
                        byArray[n8] = (byte)(n9 >> 6 | 0xC0);
                        this._outputTail = n8 + 2;
                        this._outputBuffer[n5] = (byte)(n7 & 0x3F | 0x80);
                        continue block0;
                    }
                    n2 = this._outputRawMultiByteChar(n5, cArray, n2, n3);
                    continue block0;
                }
                int n10 = n5;
                n5 = this._outputTail;
                this._outputTail = n5 + 1;
                this._outputBuffer[n5] = (byte)n10;
            } while (++n2 < n3);
        }
    }

    @Override
    public void writeRaw(char c2) {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        if (c2 <= '\u007f') {
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            byArray[n2] = (byte)c2;
        } else if (c2 < '\u0800') {
            int n3 = this._outputTail;
            int n4 = n3;
            byArray[n4++] = (byte)(c2 >> 6 | 0xC0);
            this._outputTail = n3 + 2;
            byArray[n4] = (byte)(c2 & 0x3F | 0x80);
        } else {
            this._outputRawMultiByteChar(c2, null, 0, 0);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._checkRangeBoundsForByteArray(byArray, n2, n3);
        uTF8JsonGenerator._verifyValueWrite("write a binary value");
        if (uTF8JsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        UTF8JsonGenerator uTF8JsonGenerator3 = this;
        int n4 = uTF8JsonGenerator3._outputTail;
        uTF8JsonGenerator3._outputTail = n4 + 1;
        this._outputBuffer[n4] = uTF8JsonGenerator3._quoteChar;
        n4 = n2 + n3;
        uTF8JsonGenerator2._writeBinary(base64Variant, byArray, n2, n4);
        if (uTF8JsonGenerator2._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator4 = this;
        int n5 = uTF8JsonGenerator4._outputTail;
        uTF8JsonGenerator4._outputTail = n5 + 1;
        this._outputBuffer[n5] = uTF8JsonGenerator4._quoteChar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        Throwable throwable2;
        byte[] byArray;
        block9: {
            block8: {
                String string = "Too few bytes available: missing ";
                this._verifyValueWrite("write a binary value");
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._outputBuffer[this._outputTail++] = this._quoteChar;
                byArray = this._ioContext.allocBase64Buffer();
                if (n2 < 0) {
                    try {
                        n2 = this._writeBinary(base64Variant, inputStream, byArray);
                        break block8;
                    }
                    catch (Throwable throwable2) {
                        break block9;
                    }
                }
                int n3 = this._writeBinary(base64Variant, inputStream, byArray, n2);
                if (n3 > 0) {
                    this._reportError(string + n3 + " bytes (out of " + n2 + ")");
                }
            }
            this._ioContext.releaseBase64Buffer(byArray);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
            return n2;
        }
        this._ioContext.releaseBase64Buffer(byArray);
        throw throwable2;
    }

    @Override
    public void writeNumber(short s2) {
        UTF8JsonGenerator uTF8JsonGenerator = object;
        uTF8JsonGenerator._verifyValueWrite("write a number");
        if (uTF8JsonGenerator._outputTail + 6 >= ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
        }
        if (((GeneratorBase)object)._cfgNumbersAsStrings) {
            ((UTF8JsonGenerator)object)._writeQuotedShort(s2);
            return;
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        UTF8JsonGenerator uTF8JsonGenerator3 = object;
        Object object = uTF8JsonGenerator3._outputBuffer;
        uTF8JsonGenerator2._outputTail = NumberOutput.outputInt((int)s2, (byte[])object, uTF8JsonGenerator3._outputTail);
    }

    @Override
    public void writeNumber(int n2) {
        UTF8JsonGenerator uTF8JsonGenerator = object;
        uTF8JsonGenerator._verifyValueWrite("write a number");
        if (uTF8JsonGenerator._outputTail + 11 >= ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
        }
        if (((GeneratorBase)object)._cfgNumbersAsStrings) {
            ((UTF8JsonGenerator)object)._writeQuotedInt(n2);
            return;
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        UTF8JsonGenerator uTF8JsonGenerator3 = object;
        Object object = uTF8JsonGenerator3._outputBuffer;
        uTF8JsonGenerator2._outputTail = NumberOutput.outputInt(n2, (byte[])object, uTF8JsonGenerator3._outputTail);
    }

    @Override
    public void writeNumber(long l2) {
        UTF8JsonGenerator uTF8JsonGenerator = object;
        uTF8JsonGenerator._verifyValueWrite("write a number");
        if (uTF8JsonGenerator._cfgNumbersAsStrings) {
            ((UTF8JsonGenerator)object)._writeQuotedLong(l2);
            return;
        }
        if (((UTF8JsonGenerator)object)._outputTail + 21 >= ((UTF8JsonGenerator)object)._outputEnd) {
            ((UTF8JsonGenerator)object)._flushBuffer();
        }
        UTF8JsonGenerator uTF8JsonGenerator2 = object;
        UTF8JsonGenerator uTF8JsonGenerator3 = object;
        Object object = uTF8JsonGenerator3._outputBuffer;
        uTF8JsonGenerator2._outputTail = NumberOutput.outputLong(l2, (byte[])object, uTF8JsonGenerator3._outputTail);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    @Override
    public void writeNumber(double d2) {
        if (!(this._cfgNumbersAsStrings || NumberOutput.notFinite(d2) && JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features))) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._verifyValueWrite("write a number");
            this.writeRaw(NumberOutput.toString(d2, uTF8JsonGenerator.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this.writeString(NumberOutput.toString(d2, this.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(float f2) {
        if (!(this._cfgNumbersAsStrings || NumberOutput.notFinite(f2) && JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features))) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._verifyValueWrite("write a number");
            this.writeRaw(NumberOutput.toString(f2, uTF8JsonGenerator.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this.writeString(NumberOutput.toString(f2, this.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._writeQuotedRaw(uTF8JsonGenerator._asString(bigDecimal));
        } else {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator.writeRaw(uTF8JsonGenerator._asString(bigDecimal));
        }
    }

    @Override
    public void writeNumber(String string) {
        this._verifyValueWrite("write a number");
        if (string == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    @Override
    public void writeNumber(char[] cArray, int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("write a number");
        if (uTF8JsonGenerator._cfgNumbersAsStrings) {
            this._writeQuotedRaw(cArray, n2, n3);
        } else {
            this.writeRaw(cArray, n2, n3);
        }
    }

    @Override
    public void writeBoolean(boolean bl) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("write a boolean value");
        if (uTF8JsonGenerator._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = bl ? TRUE_BYTES : FALSE_BYTES;
        byte[] byArray2 = byArray;
        UTF8JsonGenerator uTF8JsonGenerator2 = this;
        int n2 = byArray.length;
        byArray = uTF8JsonGenerator2._outputBuffer;
        int n3 = uTF8JsonGenerator2._outputTail;
        System.arraycopy(byArray2, 0, byArray, n3, n2);
        this._outputTail += n2;
    }

    @Override
    public void writeNull() {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._verifyValueWrite("write a null");
        uTF8JsonGenerator._writeNull();
    }

    @Override
    public final void _verifyValueWrite(String object) {
        int n2;
        UTF8JsonGenerator uTF8JsonGenerator = this;
        int n3 = uTF8JsonGenerator._writeContext.writeValue();
        if (uTF8JsonGenerator._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite((String)object, n3);
            return;
        }
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    if (n3 != 5) {
                        return;
                    }
                    this._reportCantWriteValueExpectName((String)object);
                    return;
                }
                object = this._rootValueSeparator;
                if (object != null) {
                    byte[] byArray = object.asUnquotedUTF8();
                    object = byArray;
                    if (byArray.length > 0) {
                        this._writeBytes((byte[])object);
                    }
                }
                return;
            }
            n2 = 58;
        } else {
            n2 = 44;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        this._outputBuffer[n4] = n2;
    }

    @Override
    public void flush() {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        uTF8JsonGenerator._flushBuffer();
        if (uTF8JsonGenerator._outputStream != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        void var0_3;
        Throwable throwable;
        block16: {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            super.close();
            throwable = null;
            try {
                if (uTF8JsonGenerator._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
                    while (true) {
                        JsonStreamContext jsonStreamContext;
                        if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                            this.writeEndArray();
                            continue;
                        }
                        if (!jsonStreamContext.inObject()) break;
                        this.writeEndObject();
                    }
                }
                this._flushBuffer();
            }
            catch (IOException iOException) {}
            this._outputTail = 0;
            if (this._outputStream != null) {
                try {
                    if (!this._ioContext.isResourceManaged() && !this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                            this._outputStream.flush();
                        }
                    } else {
                        this._outputStream.close();
                    }
                }
                catch (RuntimeException runtimeException) {
                    break block16;
                }
            }
            this._releaseBuffers();
            if (throwable == null) {
                return;
            }
            throw throwable;
            catch (IOException iOException) {}
        }
        if (throwable != null) {
            var0_3.addSuppressed(throwable);
        }
        throw var0_3;
    }

    @Override
    public void _releaseBuffers() {
        Object[] objectArray = this._outputBuffer;
        if (this._outputBuffer != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer((byte[])objectArray);
        }
        objectArray = this._charBuffer;
        if (this._charBuffer != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer((char[])objectArray);
        }
    }

    public final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 3;
        int n5 = ((UTF8JsonGenerator)object)._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n4) {
            int n7;
            if (((UTF8JsonGenerator)object)._outputTail > n5) {
                ((UTF8JsonGenerator)object)._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = object;
            int n8 = n2;
            int n9 = n7 = n8 + 1;
            n7 = n2 + 2;
            n2 += 3;
            n7 = (byArray[n8] << 8 | byArray[n9] & 0xFF) << 8 | byArray[n7] & 0xFF;
            byte[] byArray2 = uTF8JsonGenerator._outputBuffer;
            int n10 = uTF8JsonGenerator._outputTail;
            ((UTF8JsonGenerator)object)._outputTail = n7 = base64Variant.encodeBase64Chunk(n7, byArray2, n10);
            if ((n6 += -1) > 0) continue;
            byte[] byArray3 = ((UTF8JsonGenerator)object)._outputBuffer;
            int n11 = n7;
            n6 = n11 + 1;
            byArray3[n11] = 92;
            ((UTF8JsonGenerator)object)._outputTail = n7 + 2;
            ((UTF8JsonGenerator)object)._outputBuffer[n6] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        if ((n3 -= n2) > 0) {
            if (((UTF8JsonGenerator)object)._outputTail > n5) {
                ((UTF8JsonGenerator)object)._flushBuffer();
            }
            n4 = byArray[n2++] << 16;
            if (n3 == 2) {
                n4 |= (byArray[n2] & 0xFF) << 8;
            }
            UTF8JsonGenerator uTF8JsonGenerator = object;
            UTF8JsonGenerator uTF8JsonGenerator2 = object;
            Object object = uTF8JsonGenerator2._outputBuffer;
            int n12 = uTF8JsonGenerator2._outputTail;
            uTF8JsonGenerator._outputTail = base64Variant.encodeBase64Partial(n4, n3, (byte[])object, n12);
        }
    }

    public final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = ((UTF8JsonGenerator)object)._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 > 2) {
            int n8;
            if (n3 > n5) {
                n4 = ((UTF8JsonGenerator)object)._readMore(inputStream, byArray, n3, n4, n2);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (((UTF8JsonGenerator)object)._outputTail > n6) {
                ((UTF8JsonGenerator)object)._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = object;
            int n9 = n3;
            int n10 = n8 = n9 + 1;
            n8 = n3 + 2;
            n3 += 3;
            n8 = (byArray[n9] << 8 | byArray[n10] & 0xFF) << 8 | byArray[n8] & 0xFF;
            n2 -= 3;
            byte[] byArray2 = uTF8JsonGenerator._outputBuffer;
            int n11 = uTF8JsonGenerator._outputTail;
            ((UTF8JsonGenerator)object)._outputTail = n8 = base64Variant.encodeBase64Chunk(n8, byArray2, n11);
            if ((n7 += -1) > 0) continue;
            byte[] byArray3 = ((UTF8JsonGenerator)object)._outputBuffer;
            int n12 = n8;
            n7 = n12 + 1;
            byArray3[n12] = 92;
            ((UTF8JsonGenerator)object)._outputTail = n8 + 2;
            ((UTF8JsonGenerator)object)._outputBuffer[n7] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 > 0) {
            int n13 = ((UTF8JsonGenerator)object)._readMore(inputStream, byArray, n3, n4, n2);
            n3 = 0;
            if (n13 > 0) {
                int n14;
                if (((UTF8JsonGenerator)object)._outputTail > n6) {
                    ((UTF8JsonGenerator)object)._flushBuffer();
                }
                n4 = 1;
                int n15 = n13;
                n13 = byArray[n3] << 16;
                if (1 < n15) {
                    n13 |= (byArray[n4] & 0xFF) << 8;
                    n14 = 2;
                } else {
                    n14 = 1;
                }
                UTF8JsonGenerator uTF8JsonGenerator = object;
                UTF8JsonGenerator uTF8JsonGenerator2 = object;
                Object object = uTF8JsonGenerator2._outputBuffer;
                int n16 = uTF8JsonGenerator2._outputTail;
                uTF8JsonGenerator._outputTail = base64Variant.encodeBase64Partial(n13, n14, (byte[])object, n16);
                n2 -= n14;
            }
        }
        return n2;
    }

    public final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = ((UTF8JsonGenerator)object)._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            int n8;
            if (n2 > n4) {
                n4 = byArray.length;
                n2 = ((UTF8JsonGenerator)object)._readMore(inputStream, byArray, n2, n3, n4);
                n3 = 0;
                if (n2 < 3) {
                    if (n2 > 0) {
                        if (((UTF8JsonGenerator)object)._outputTail > n6) {
                            ((UTF8JsonGenerator)object)._flushBuffer();
                        }
                        int n9 = 1;
                        int n10 = n2;
                        n2 = byArray[n3] << 16;
                        n3 = 1;
                        if (1 < n10) {
                            n2 |= (byArray[n9] & 0xFF) << 8;
                            n3 = 2;
                        }
                        UTF8JsonGenerator uTF8JsonGenerator = object;
                        UTF8JsonGenerator uTF8JsonGenerator2 = object;
                        n5 += n3;
                        Object object = uTF8JsonGenerator2._outputBuffer;
                        int n11 = uTF8JsonGenerator2._outputTail;
                        uTF8JsonGenerator._outputTail = base64Variant.encodeBase64Partial(n2, n3, (byte[])object, n11);
                    }
                    return n5;
                }
                n4 = n2 - 3;
                int n12 = n3;
                n3 = n2;
                n2 = n12;
            }
            if (((UTF8JsonGenerator)object)._outputTail > n6) {
                ((UTF8JsonGenerator)object)._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = object;
            int n13 = n2;
            int n14 = n8 = n13 + 1;
            n8 = n2 + 2;
            n2 += 3;
            n8 = (byArray[n13] << 8 | byArray[n14] & 0xFF) << 8 | byArray[n8] & 0xFF;
            n5 += 3;
            byte[] byArray2 = uTF8JsonGenerator._outputBuffer;
            int n15 = uTF8JsonGenerator._outputTail;
            ((UTF8JsonGenerator)object)._outputTail = n8 = base64Variant.encodeBase64Chunk(n8, byArray2, n15);
            if ((n7 += -1) > 0) continue;
            byte[] byArray3 = ((UTF8JsonGenerator)object)._outputBuffer;
            int n16 = n8;
            n7 = n16 + 1;
            byArray3[n16] = 92;
            ((UTF8JsonGenerator)object)._outputTail = n8 + 2;
            ((UTF8JsonGenerator)object)._outputBuffer[n7] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
    }

    public final void _outputSurrogates(int n2, int n3) {
        UTF8JsonGenerator uTF8JsonGenerator = this;
        n2 = uTF8JsonGenerator._decodeSurrogate(n2, n3);
        if (uTF8JsonGenerator._outputTail + 4 > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        int n4 = n2;
        int n5 = this._outputTail;
        int n6 = n5;
        int n7 = n2;
        int n8 = n2;
        int n9 = n2;
        n2 = n6 + 1;
        byArray[n6] = (byte)(n9 >> 18 | 0xF0);
        int n10 = n6 + 2;
        byArray[n2] = (byte)(n8 >> 12 & 0x3F | 0x80);
        byArray[n10] = (byte)(n7 >> 6 & 0x3F | 0x80);
        this._outputTail = n5 + 4;
        this._outputBuffer[n6 += 3] = (byte)(n4 & 0x3F | 0x80);
    }

    public final void _flushBuffer() {
        int n2 = this._outputTail;
        if (n2 > 0) {
            this._outputTail = 0;
            this._outputStream.write(this._outputBuffer, 0, n2);
        }
    }
}

