/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonStreamContext;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.PrettyPrinter;
import com.privatefasterxml.jackson.core.SerializableString;
import com.privatefasterxml.jackson.core.base.GeneratorBase;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.CharacterEscapes;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.io.NumberOutput;
import com.privatefasterxml.jackson.core.json.JsonGeneratorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class WriterBasedJsonGenerator
extends JsonGeneratorImpl {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS_UPPER = CharTypes.copyHexChars(true);
    protected static final char[] HEX_CHARS_LOWER = CharTypes.copyHexChars(false);
    protected final Writer _writer;
    protected char _quoteChar;
    protected char[] _outputBuffer;
    protected int _outputHead;
    protected int _outputTail;
    protected int _outputEnd;
    protected char[] _entityBuffer;
    protected SerializableString _currentEscape;
    protected char[] _copyBuffer;

    private char[] getHexChars() {
        return this._cfgWriteHexUppercase ? HEX_CHARS_UPPER : HEX_CHARS_LOWER;
    }

    @Deprecated
    public WriterBasedJsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, Writer writer) {
        this(iOContext, n2, objectCodec, writer, '\"');
    }

    public WriterBasedJsonGenerator(IOContext object, int n2, ObjectCodec objectCodec, Writer writer, char c2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        super((IOContext)object, n2, objectCodec);
        this._writer = writer;
        char[] cArray = ((IOContext)object).allocConcatBuffer();
        object = cArray;
        writerBasedJsonGenerator._outputBuffer = cArray;
        writerBasedJsonGenerator._outputEnd = ((Object)object).length;
        this._quoteChar = c2;
        if (c2 != '\"') {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2);
        }
    }

    private final void _writeFieldNameTail(SerializableString serializableString) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        char[] cArray = serializableString.asQuotedChars();
        writerBasedJsonGenerator.writeRaw(cArray, 0, cArray.length);
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n2 = writerBasedJsonGenerator2._outputTail;
        writerBasedJsonGenerator2._outputTail = n2 + 1;
        this._outputBuffer[n2] = writerBasedJsonGenerator2._quoteChar;
    }

    private void _writeString2(SerializableString object) {
        char[] cArray = object.asQuotedChars();
        object = cArray;
        int n2 = cArray.length;
        if (n2 < 32) {
            if (n2 > this._outputEnd - this._outputTail) {
                this._flushBuffer();
            }
            Object object2 = object;
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            object = writerBasedJsonGenerator._outputBuffer;
            int n3 = writerBasedJsonGenerator._outputTail;
            System.arraycopy(object2, 0, object, n3, n2);
            this._outputTail += n2;
        } else {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator._flushBuffer();
            writerBasedJsonGenerator._writer.write((char[])object, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        int n4 = writerBasedJsonGenerator._outputTail;
        writerBasedJsonGenerator._outputTail = n4 + 1;
        this._outputBuffer[n4] = writerBasedJsonGenerator._quoteChar;
    }

    private void writeRawLong(String object) {
        int n2;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n3 = this._outputTail;
        int n4 = writerBasedJsonGenerator2._outputEnd - n3;
        char[] cArray = writerBasedJsonGenerator2._outputBuffer;
        ((String)object).getChars(0, n4, cArray, n3);
        writerBasedJsonGenerator._outputTail += n4;
        writerBasedJsonGenerator._flushBuffer();
        n3 = ((String)object).length() - n4;
        while (n3 > (n2 = this._outputEnd)) {
            int n5 = n3;
            n3 = n4 + n2;
            char[] cArray2 = this._outputBuffer;
            ((String)object).getChars(n4, n3, cArray2, 0);
            this._outputHead = 0;
            this._outputTail = n2;
            this._flushBuffer();
            int n6 = n4 = n5 - n2;
            n4 = n3;
            n3 = n6;
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        String string = object;
        int n7 = n4 + n3;
        object = this._outputBuffer;
        string.getChars(n4, n7, (char[])object, 0);
        writerBasedJsonGenerator3._outputHead = 0;
        writerBasedJsonGenerator3._outputTail = n3;
    }

    private void _writeQuotedShort(short s2) {
        int n2;
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        short s3 = s2;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        int n3 = writerBasedJsonGenerator._outputTail;
        s2 = (short)n3;
        writerBasedJsonGenerator._outputTail = n2 = n3 + 1;
        this._outputBuffer[s2] = writerBasedJsonGenerator._quoteChar;
        s2 = (short)NumberOutput.outputInt((int)s3, this._outputBuffer, n2);
        this._outputTail = s2 + 1;
        this._outputBuffer[s2] = this._quoteChar;
    }

    private void _writeQuotedInt(int n2) {
        int n3;
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = n2;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        n2 = writerBasedJsonGenerator._outputTail;
        writerBasedJsonGenerator._outputTail = n3 = n2 + 1;
        this._outputBuffer[n2] = writerBasedJsonGenerator._quoteChar;
        n2 = NumberOutput.outputInt(n4, this._outputBuffer, n3);
        this._outputTail = n2 + 1;
        this._outputBuffer[n2] = this._quoteChar;
    }

    private void _writeQuotedLong(long l2) {
        int n2;
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        int n3 = writerBasedJsonGenerator._outputTail;
        writerBasedJsonGenerator._outputTail = n2 = n3 + 1;
        this._outputBuffer[n3] = writerBasedJsonGenerator._quoteChar;
        n3 = NumberOutput.outputLong(l2, this._outputBuffer, n2);
        this._outputTail = n3 + 1;
        this._outputBuffer[n3] = this._quoteChar;
    }

    private void _writeQuotedRaw(String string) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n2 = writerBasedJsonGenerator2._outputTail;
        writerBasedJsonGenerator2._outputTail = n2 + 1;
        this._outputBuffer[n2] = writerBasedJsonGenerator2._quoteChar;
        writerBasedJsonGenerator.writeRaw(string);
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n3 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n3 + 1;
        this._outputBuffer[n3] = writerBasedJsonGenerator3._quoteChar;
    }

    private void _writeQuotedRaw(char[] cArray, int n2, int n3) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n4 = writerBasedJsonGenerator2._outputTail;
        writerBasedJsonGenerator2._outputTail = n4 + 1;
        this._outputBuffer[n4] = writerBasedJsonGenerator2._quoteChar;
        writerBasedJsonGenerator.writeRaw(cArray, n2, n3);
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n5 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n5 + 1;
        this._outputBuffer[n5] = writerBasedJsonGenerator3._quoteChar;
    }

    private void _writeString(String object) {
        int n2;
        int n3 = ((String)object).length();
        if (n3 > (n2 = this._outputEnd)) {
            this._writeLongString((String)object);
            return;
        }
        if (this._outputTail + n3 > n2) {
            this._flushBuffer();
        }
        String string = object;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        object = writerBasedJsonGenerator._outputBuffer;
        n2 = writerBasedJsonGenerator._outputTail;
        string.getChars(0, n3, (char[])object, n2);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n3);
        } else {
            int n4 = this._maximumNonEscapedChar;
            if (n4 != 0) {
                this._writeStringASCII(n3, n4);
            } else {
                this._writeString2(n3);
            }
        }
    }

    private void _writeString2(int n2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        n2 = writerBasedJsonGenerator._outputTail + n2;
        int[] nArray = writerBasedJsonGenerator._outputEscapes;
        int n3 = writerBasedJsonGenerator._outputEscapes.length;
        block0: while (this._outputTail < n2) {
            int n4;
            do {
                char[] cArray = this._outputBuffer;
                n4 = this._outputTail;
                int n5 = this._outputBuffer[n4];
                if (n5 >= n3 || nArray[n5] == 0) continue;
                n5 = n4 - (n4 = this._outputHead);
                if (n5 > 0) {
                    this._writer.write(cArray, n4, n5);
                }
                int n6 = this._outputTail;
                this._outputTail = n6 + 1;
                char c2 = this._outputBuffer[n6];
                this._prependOrWriteCharacterEscape(c2, nArray[c2]);
                continue block0;
            } while ((this._outputTail = n4 + 1) < n2);
        }
    }

    private void _writeLongString(String string) {
        this._flushBuffer();
        int n2 = string.length();
        int n3 = 0;
        do {
            int n4;
            if (n3 + (n4 = this._outputEnd) > n2) {
                n4 = n2 - n3;
            }
            string.getChars(n3, n3 += n4, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n4);
                continue;
            }
            int n5 = this._maximumNonEscapedChar;
            if (n5 != 0) {
                this._writeSegmentASCII(n4, n5);
                continue;
            }
            this._writeSegment(n4);
        } while (n3 < n2);
    }

    private void _writeSegment(int n2) {
        int n3;
        int[] nArray = this._outputEscapes;
        int n4 = this._outputEscapes.length;
        int n5 = n3 = 0;
        while (n3 < n2) {
            char[] cArray;
            char c2;
            do {
                cArray = this._outputBuffer;
            } while (((c2 = this._outputBuffer[n3]) >= n4 || nArray[c2] == 0) && ++n3 < n2);
            int n6 = n3 - n5;
            if (n6 > 0) {
                this._writer.write(cArray, n5, n6);
                if (n3 >= n2) break;
            }
            char[] cArray2 = this._outputBuffer;
            int n7 = nArray[c2];
            n5 = this._prependOrWriteCharacterEscape(cArray2, ++n3, n2, c2, n7);
        }
    }

    private void _writeString(char[] cArray, int n2, int n3) {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n2, n3);
            return;
        }
        int n4 = this._maximumNonEscapedChar;
        if (n4 != 0) {
            this._writeStringASCII(cArray, n2, n3, n4);
            return;
        }
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n5 = this._outputEscapes.length;
        while (n2 < n3) {
            int n6;
            char c2 = n2;
            while (((n6 = cArray[c2]) >= n5 || nArray[n6] == 0) && ++c2 < n3) {
            }
            n6 = c2 - n2;
            if (n6 < 32) {
                if (this._outputTail + n6 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n6 > 0) {
                    WriterBasedJsonGenerator writerBasedJsonGenerator = this;
                    char[] cArray2 = writerBasedJsonGenerator._outputBuffer;
                    System.arraycopy(cArray, n2, cArray2, writerBasedJsonGenerator._outputTail, n6);
                    this._outputTail += n6;
                }
            } else {
                WriterBasedJsonGenerator writerBasedJsonGenerator = this;
                writerBasedJsonGenerator._flushBuffer();
                writerBasedJsonGenerator._writer.write(cArray, n2, n6);
            }
            if (c2 >= n3) break;
            n2 = c2 + 1;
            c2 = cArray[c2];
            this._appendCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeStringASCII(int n2, int n3) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        n2 = writerBasedJsonGenerator._outputTail + n2;
        int[] nArray = writerBasedJsonGenerator._outputEscapes;
        int n4 = Math.min(writerBasedJsonGenerator._outputEscapes.length, n3 + 1);
        block0: while (this._outputTail < n2) {
            int n5;
            do {
                int n6;
                char[] cArray = this._outputBuffer;
                n5 = this._outputTail;
                char c2 = this._outputBuffer[n5];
                if (c2 < n4) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                } else {
                    if (c2 <= n3) continue;
                    n6 = -1;
                }
                int n7 = n5;
                n5 = this._outputHead;
                int n8 = n7 - n5;
                if (n8 > 0) {
                    this._writer.write(cArray, n5, n8);
                }
                ++this._outputTail;
                this._prependOrWriteCharacterEscape(c2, n6);
                continue block0;
            } while ((this._outputTail = n5 + 1) < n2);
        }
    }

    private void _writeSegmentASCII(int n2, int n3) {
        int n4;
        int[] nArray = this._outputEscapes;
        int n5 = Math.min(this._outputEscapes.length, n3 + 1);
        int n6 = 0;
        int n7 = n4 = 0;
        n4 = n6;
        while (n6 < n2) {
            char c2;
            char[] cArray;
            do {
                cArray = this._outputBuffer;
                c2 = this._outputBuffer[n6];
                if (c2 < n5) {
                    n7 = nArray[c2];
                    if (n7 == 0) continue;
                    break;
                }
                if (c2 <= n3) continue;
                n7 = -1;
                break;
            } while (++n6 < n2);
            int n8 = n6 - n4;
            if (n8 > 0) {
                this._writer.write(cArray, n4, n8);
                if (n6 >= n2) break;
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            n4 = writerBasedJsonGenerator._prependOrWriteCharacterEscape(writerBasedJsonGenerator._outputBuffer, ++n6, n2, c2, n7);
        }
    }

    private void _writeStringASCII(char[] cArray, int n2, int n3, int n4) {
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n5 = Math.min(this._outputEscapes.length, n4 + 1);
        int n6 = 0;
        while (n2 < n3) {
            char c2;
            int n7 = n2;
            do {
                if ((c2 = cArray[n7]) < n5) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 <= n4) continue;
                n6 = -1;
                break;
            } while (++n7 < n3);
            int n8 = n7 - n2;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    WriterBasedJsonGenerator writerBasedJsonGenerator = this;
                    char[] cArray2 = writerBasedJsonGenerator._outputBuffer;
                    System.arraycopy(cArray, n2, cArray2, writerBasedJsonGenerator._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                WriterBasedJsonGenerator writerBasedJsonGenerator = this;
                writerBasedJsonGenerator._flushBuffer();
                writerBasedJsonGenerator._writer.write(cArray, n2, n8);
            }
            if (n7 >= n3) break;
            n2 = n7 + 1;
            this._appendCharacterEscape(c2, n6);
        }
    }

    private void _writeStringCustom(int n2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        n2 = writerBasedJsonGenerator._outputTail + n2;
        int[] nArray = writerBasedJsonGenerator._outputEscapes;
        int n3 = writerBasedJsonGenerator._maximumNonEscapedChar;
        if (n3 < 1) {
            n3 = 65535;
        }
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        block0: while (this._outputTail < n2) {
            char c2;
            do {
                block8: {
                    int n5;
                    block9: {
                        block10: {
                            block7: {
                                if ((c2 = this._outputBuffer[this._outputTail]) >= n4) break block7;
                                n5 = nArray[c2];
                                if (n5 == 0) break block8;
                                break block9;
                            }
                            if (c2 <= n3) break block10;
                            n5 = -1;
                            break block9;
                        }
                        this._currentEscape = characterEscapes.getEscapeSequence(c2);
                        if (this._currentEscape == null) break block8;
                        n5 = -2;
                    }
                    int n6 = this._outputHead;
                    int n7 = this._outputTail - n6;
                    if (n7 > 0) {
                        this._writer.write(this._outputBuffer, n6, n7);
                    }
                    ++this._outputTail;
                    this._prependOrWriteCharacterEscape(c2, n5);
                    continue block0;
                }
                c2 = this._outputTail + 1;
                this._outputTail = c2;
            } while (c2 < n2);
        }
    }

    private void _writeSegmentCustom(int n2) {
        int n3;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        int[] nArray = writerBasedJsonGenerator._outputEscapes;
        int n4 = writerBasedJsonGenerator._maximumNonEscapedChar;
        if (n4 < 1) {
            n4 = 65535;
        }
        int n5 = Math.min(nArray.length, n4 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n6 = 0;
        int n7 = n3 = 0;
        n3 = n6;
        while (n6 < n2) {
            char c2;
            do {
                if ((c2 = this._outputBuffer[n6]) < n5) {
                    n7 = nArray[c2];
                    if (n7 == 0) continue;
                    break;
                }
                if (c2 > n4) {
                    n7 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(c2);
                if (this._currentEscape == null) continue;
                n7 = -2;
                break;
            } while (++n6 < n2);
            int n8 = n6 - n3;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n3, n8);
                if (n6 >= n2) break;
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
            n3 = writerBasedJsonGenerator2._prependOrWriteCharacterEscape(writerBasedJsonGenerator2._outputBuffer, ++n6, n2, c2, n7);
        }
    }

    private void _writeStringCustom(char[] cArray, int n2, int n3) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        n3 += n2;
        int[] nArray = writerBasedJsonGenerator._outputEscapes;
        int n4 = writerBasedJsonGenerator._maximumNonEscapedChar;
        if (n4 < 1) {
            n4 = 65535;
        }
        int n5 = Math.min(nArray.length, n4 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n6 = 0;
        while (n2 < n3) {
            char c2;
            int n7 = n2;
            do {
                if ((c2 = cArray[n7]) < n5) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 > n4) {
                    n6 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(c2);
                if (this._currentEscape == null) continue;
                n6 = -2;
                break;
            } while (++n7 < n3);
            int n8 = n7 - n2;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
                    char[] cArray2 = writerBasedJsonGenerator2._outputBuffer;
                    System.arraycopy(cArray, n2, cArray2, writerBasedJsonGenerator2._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
                writerBasedJsonGenerator3._flushBuffer();
                writerBasedJsonGenerator3._writer.write(cArray, n2, n8);
            }
            if (n7 >= n3) break;
            n2 = n7 + 1;
            this._appendCharacterEscape(c2, n6);
        }
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n2 < n3) {
            int n6 = n5 + 1;
            int n7 = n2 + 1;
            byArray[n5] = byArray[n2];
            n5 = n6;
            n2 = n7;
        }
        n2 = Math.min(n4, byArray.length);
        while ((n3 = n2 - n5) != 0) {
            if ((n3 = inputStream.read(byArray, n5, n3)) < 0) {
                return n5;
            }
            if ((n5 += n3) < 3) continue;
        }
        return n5;
    }

    private final void _writeNull() {
        if (((WriterBasedJsonGenerator)object)._outputTail + 4 >= ((WriterBasedJsonGenerator)object)._outputEnd) {
            ((WriterBasedJsonGenerator)object)._flushBuffer();
        }
        int n2 = ((WriterBasedJsonGenerator)object)._outputTail;
        Object object = ((WriterBasedJsonGenerator)object)._outputBuffer;
        object[n2] = 110;
        object[n2 + 1] = 117;
        object[n2 + 2] = 108;
        ((WriterBasedJsonGenerator)object)._outputBuffer[n2 + 3] = 108;
        v0._outputTail = n2 + 4;
    }

    private void _prependOrWriteCharacterEscape(char c2, int n2) {
        String string;
        if (n2 >= 0) {
            int n3 = ((WriterBasedJsonGenerator)object)._outputTail;
            c2 = (char)n3;
            if (n3 >= 2) {
                int n4;
                ((WriterBasedJsonGenerator)object)._outputHead = n4 = c2 - 2;
                int n5 = c2 - '\u0001';
                ((WriterBasedJsonGenerator)object)._outputBuffer[n4] = 92;
                ((WriterBasedJsonGenerator)object)._outputBuffer[n5] = (char)n2;
                return;
            }
            char[] cArray = ((WriterBasedJsonGenerator)object)._entityBuffer;
            if (((WriterBasedJsonGenerator)object)._entityBuffer == null) {
                cArray = ((WriterBasedJsonGenerator)object)._allocateEntityBuffer();
            }
            ((WriterBasedJsonGenerator)object)._outputHead = ((WriterBasedJsonGenerator)object)._outputTail;
            cArray[1] = (char)n2;
            ((WriterBasedJsonGenerator)object)._writer.write(cArray, 0, 2);
            return;
        }
        if (n2 != -2) {
            char[] cArray = ((WriterBasedJsonGenerator)object).getHexChars();
            int n6 = ((WriterBasedJsonGenerator)object)._outputTail;
            if (n6 >= 6) {
                int n7;
                char[] cArray2 = ((WriterBasedJsonGenerator)object)._outputBuffer;
                ((WriterBasedJsonGenerator)object)._outputHead = n6 - 6;
                cArray2[((WriterBasedJsonGenerator)object)._outputHead] = 92;
                ((WriterBasedJsonGenerator)object)._outputBuffer[n6 - 5] = 117;
                if (c2 > '\u00ff') {
                    int n8 = c2 >> 8;
                    n7 = n8;
                    int n9 = n7 & 0xFF;
                    n7 = n6 - 4;
                    cArray2[n7] = cArray[n9 >> 4];
                    n7 = n6 - 3;
                    cArray2[n7] = cArray[n8 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray2[n6 - 4] = 48;
                    n7 = n6 - 3;
                    cArray2[n7] = 48;
                }
                char c3 = c2;
                char c4 = c2;
                c2 = (char)(n7 + 1);
                cArray2[c2] = cArray[c4 >> 4];
                cArray2[n7 += 2] = cArray[c3 & 0xF];
                return;
            }
            char[] cArray3 = ((WriterBasedJsonGenerator)object)._entityBuffer;
            if (((WriterBasedJsonGenerator)object)._entityBuffer == null) {
                cArray3 = ((WriterBasedJsonGenerator)object)._allocateEntityBuffer();
            }
            ((WriterBasedJsonGenerator)object)._outputHead = ((WriterBasedJsonGenerator)object)._outputTail;
            if (c2 > '\u00ff') {
                char c5 = c2;
                char c6 = c2;
                int n10 = c6 >> 8;
                c2 = (char)n10;
                int n11 = n10 & 0xFF;
                cArray3[10] = cArray[n11 >> 4];
                cArray3[11] = cArray[c2 & 0xF];
                cArray3[12] = cArray[(c6 & 0xFF) >> 4];
                cArray3[13] = cArray[c5 & 0xF];
                ((WriterBasedJsonGenerator)object)._writer.write(cArray3, 8, 6);
            } else {
                cArray3[6] = cArray[c2 >> 4];
                cArray3[7] = cArray[c2 & 0xF];
                ((WriterBasedJsonGenerator)object)._writer.write(cArray3, 2, 6);
            }
            return;
        }
        SerializableString serializableString = ((WriterBasedJsonGenerator)object)._currentEscape;
        if (serializableString == null) {
            string = ((JsonGeneratorImpl)object)._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = serializableString.getValue();
            ((WriterBasedJsonGenerator)object)._currentEscape = null;
        }
        int n12 = string.length();
        int n13 = ((WriterBasedJsonGenerator)object)._outputTail;
        if (n13 >= n12) {
            int n14;
            ((WriterBasedJsonGenerator)object)._outputHead = n14 = n13 - n12;
            Object object = ((WriterBasedJsonGenerator)object)._outputBuffer;
            string.getChars(0, n12, (char[])object, n14);
            return;
        }
        ((WriterBasedJsonGenerator)object)._outputHead = n13;
        ((WriterBasedJsonGenerator)object)._writer.write(string);
    }

    private int _prependOrWriteCharacterEscape(char[] cArray, int n2, int n3, char c2, int n4) {
        String string;
        if (n4 >= 0) {
            if (n2 > 1 && n2 < n3) {
                int n5 = n2 + -2;
                cArray[n5] = 92;
                int n6 = n2 + -1;
                cArray[n6] = (char)n4;
                n2 = n5;
            } else {
                cArray = this._entityBuffer;
                if (this._entityBuffer == null) {
                    cArray = this._allocateEntityBuffer();
                }
                cArray[1] = (char)n4;
                this._writer.write(cArray, 0, 2);
            }
            return n2;
        }
        if (n4 != -2) {
            char[] cArray2 = this.getHexChars();
            if (n2 > 5 && n2 < n3) {
                int n7 = n2 + -6;
                n3 = n2 + -5;
                cArray[n7] = 92;
                n7 = n2 + -4;
                cArray[n3] = 117;
                if (c2 > '\u00ff') {
                    n3 = c2 >> 8;
                    int n8 = n7;
                    n7 = n2 + -3;
                    cArray[n8] = cArray2[(n3 & 0xFF) >> 4];
                    n2 -= 2;
                    cArray[n7] = cArray2[n3 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    n3 = n2 + -3;
                    cArray[n7] = 48;
                    n2 -= 2;
                    cArray[n3] = 48;
                }
                n7 = n2 + 1;
                cArray[n2] = cArray2[c2 >> 4];
                cArray[n7] = cArray2[c2 & 0xF];
                n2 -= 4;
            } else {
                cArray = this._entityBuffer;
                if (this._entityBuffer == null) {
                    cArray = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c2 > '\u00ff') {
                    char c3 = c2;
                    int n9 = c3 >> 8;
                    n3 = n9 & 0xFF;
                    cArray[10] = cArray2[n3 >> 4];
                    cArray[11] = cArray2[n9 & 0xF];
                    cArray[12] = cArray2[(c3 & 0xFF) >> 4];
                    cArray[13] = cArray2[c2 & 0xF];
                    this._writer.write(cArray, 8, 6);
                } else {
                    cArray[6] = cArray2[c2 >> 4];
                    cArray[7] = cArray2[c2 & 0xF];
                    this._writer.write(cArray, 2, 6);
                }
            }
            return n2;
        }
        SerializableString serializableString = this._currentEscape;
        if (serializableString == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = serializableString.getValue();
            this._currentEscape = null;
        }
        int n10 = string.length();
        if (n2 >= n10 && n2 < n3) {
            string.getChars(0, n10, cArray, n2 -= n10);
        } else {
            this._writer.write(string);
        }
        return n2;
    }

    private void _appendCharacterEscape(char c2, int n2) {
        Object object;
        if (n2 >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            int n3 = this._outputTail;
            c2 = (char)n3;
            n2 = n3 + 1;
            this._outputBuffer[c2] = 92;
            this._outputTail = c2 + 2;
            this._outputBuffer[n2] = (char)n2;
            return;
        }
        if (n2 != -2) {
            if (this._outputTail + 5 >= this._outputEnd) {
                this._flushBuffer();
            }
            n2 = this._outputTail;
            char[] cArray = this._outputBuffer;
            char[] cArray2 = cArray;
            char[] cArray3 = this.getHexChars();
            int n4 = n2 + 1;
            cArray[n2] = 92;
            int n5 = n2 + 2;
            this._outputBuffer[n4] = 117;
            if (c2 > '\u00ff') {
                char c3 = c2;
                int n6 = c2 >> 8;
                c2 = (char)n6;
                int n7 = c2 & 0xFF;
                c2 = (char)(n2 + 3);
                cArray2[n5] = cArray3[n7 >> 4];
                n2 += 4;
                cArray2[c2] = cArray3[n6 & 0xF];
                c2 = (char)(c3 & 0xFF);
            } else {
                n4 = n2 + 3;
                cArray2[n5] = 48;
                n2 += 4;
                cArray2[n4] = 48;
            }
            char c4 = c2;
            char c5 = c2;
            c2 = (char)(n2 + 1);
            cArray2[n2] = cArray3[c5 >> 4];
            cArray2[c2] = cArray3[c4 & 0xF];
            this._outputTail = n2 += 2;
            return;
        }
        SerializableString serializableString = this._currentEscape;
        if (serializableString == null) {
            object = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            object = serializableString.getValue();
            this._currentEscape = null;
        }
        int n8 = ((String)object).length();
        if (this._outputTail + n8 > this._outputEnd) {
            this._flushBuffer();
            if (n8 > this._outputEnd) {
                this._writer.write((String)object);
                return;
            }
        }
        String string = object;
        object = this._outputBuffer;
        int n9 = this._outputTail;
        string.getChars(0, n8, (char[])object, n9);
        this._outputTail += n8;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray;
        char[] cArray2 = cArray = new char[14];
        cArray2[0] = 92;
        cArray2[2] = 92;
        cArray2[3] = 117;
        cArray2[4] = 48;
        cArray2[5] = 48;
        cArray2[8] = 92;
        cArray[9] = 117;
        this._entityBuffer = cArray;
        return cArray;
    }

    private char[] _allocateCopyBuffer() {
        if (this._copyBuffer == null) {
            this._copyBuffer = this._ioContext.allocNameCopyBuffer(2000);
        }
        return this._copyBuffer;
    }

    @Override
    public Object getOutputTarget() {
        return this._writer;
    }

    @Override
    public int getOutputBuffered() {
        return Math.max(0, this._outputTail - this._outputHead);
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public void writeFieldName(String string) {
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        n2 = n2 == 1 ? 1 : 0;
        this._writeFieldName(string, n2 != 0);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        n2 = n2 == 1 ? 1 : 0;
        this._writeFieldName(serializableString, n2 != 0);
    }

    public final void _writeFieldName(String string, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    public final void _writeFieldName(SerializableString object, boolean bl) {
        int n2;
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName((SerializableString)object, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            char[] cArray = object.asQuotedChars();
            object = cArray;
            int cArray2 = cArray.length;
            this.writeRaw((char[])object, 0, cArray2);
            return;
        }
        char[] n4 = this._outputBuffer;
        int n3 = this._outputTail;
        this._outputTail = n2 = n3 + 1;
        this._outputBuffer[n3] = this._quoteChar;
        int n5 = object.appendQuoted(n4, n2);
        if (n5 < 0) {
            this._writeFieldNameTail((SerializableString)object);
            return;
        }
        if ((this._outputTail += n5) >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeStartArray() {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("start an array");
        writerBasedJsonGenerator._writeContext = writerBasedJsonGenerator._writeContext.createChildArrayContext();
        PrettyPrinter prettyPrinter = writerBasedJsonGenerator._cfgPrettyPrinter;
        if (prettyPrinter != null) {
            prettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 91;
        }
    }

    @Override
    public void writeStartArray(Object object) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("start an array");
        writerBasedJsonGenerator._writeContext = writerBasedJsonGenerator._writeContext.createChildArrayContext(object);
        object = writerBasedJsonGenerator._cfgPrettyPrinter;
        if (object != null) {
            object.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 91;
        }
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("start an array");
        writerBasedJsonGenerator._writeContext = writerBasedJsonGenerator._writeContext.createChildArrayContext(object);
        object = writerBasedJsonGenerator._cfgPrettyPrinter;
        if (object != null) {
            object.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n3 = this._outputTail;
            this._outputTail = n3 + 1;
            this._outputBuffer[n3] = 91;
        }
    }

    @Override
    public void writeEndArray() {
        PrettyPrinter prettyPrinter;
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if ((prettyPrinter = this._cfgPrettyPrinter) != null) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            prettyPrinter.writeEndArray(writerBasedJsonGenerator, writerBasedJsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public void writeStartObject() {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("start an object");
        writerBasedJsonGenerator._writeContext = writerBasedJsonGenerator._writeContext.createChildObjectContext();
        PrettyPrinter prettyPrinter = writerBasedJsonGenerator._cfgPrettyPrinter;
        if (prettyPrinter != null) {
            prettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 123;
        }
    }

    @Override
    public void writeStartObject(Object object) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("start an object");
        writerBasedJsonGenerator._writeContext = writerBasedJsonGenerator._writeContext.createChildObjectContext(object);
        object = writerBasedJsonGenerator._cfgPrettyPrinter;
        if (object != null) {
            object.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 123;
        }
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        this.writeStartObject(object);
    }

    @Override
    public void writeEndObject() {
        PrettyPrinter prettyPrinter;
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if ((prettyPrinter = this._cfgPrettyPrinter) != null) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            prettyPrinter.writeEndObject(writerBasedJsonGenerator, writerBasedJsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            this._outputTail = n2 + 1;
            this._outputBuffer[n2] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    public final void _writePPFieldName(String string, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeString(string);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
            this._writeString(string);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    public final void _writePPFieldName(SerializableString object, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        object = object.asQuotedChars();
        if (this._cfgUnqNames) {
            int n2 = ((Object)object).length;
            this.writeRaw((char[])object, 0, n2);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
            int n3 = ((Object)object).length;
            this.writeRaw((char[])object, 0, n3);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeString(String string) {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n2 = writerBasedJsonGenerator2._outputTail;
        writerBasedJsonGenerator2._outputTail = n2 + 1;
        this._outputBuffer[n2] = writerBasedJsonGenerator2._quoteChar;
        writerBasedJsonGenerator._writeString(string);
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n3 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n3 + 1;
        this._outputBuffer[n3] = writerBasedJsonGenerator3._quoteChar;
    }

    @Override
    public void writeString(Reader reader, int n2) {
        int n3;
        this._verifyValueWrite("write a string");
        if (reader == null) {
            this._reportError("null reader");
            return;
        }
        int n4 = n2 >= 0 ? n2 : Integer.MAX_VALUE;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n5 = writerBasedJsonGenerator2._outputTail;
        writerBasedJsonGenerator2._outputTail = n5 + 1;
        writerBasedJsonGenerator._outputBuffer[n5] = writerBasedJsonGenerator2._quoteChar;
        char[] cArray = writerBasedJsonGenerator._allocateCopyBuffer();
        while (n4 > 0 && (n3 = reader.read(cArray, 0, Math.min(n4, cArray.length))) > 0) {
            this._writeString(cArray, 0, n3);
            n4 -= n3;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n6 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n6 + 1;
        this._outputBuffer[n6] = writerBasedJsonGenerator3._quoteChar;
        if (n4 > 0 && n2 >= 0) {
            this._reportError("Didn't read enough from reader");
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("write a string");
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n4 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n4 + 1;
        this._outputBuffer[n4] = writerBasedJsonGenerator3._quoteChar;
        writerBasedJsonGenerator2._writeString(cArray, n2, n3);
        if (writerBasedJsonGenerator2._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator4 = this;
        int n5 = writerBasedJsonGenerator4._outputTail;
        writerBasedJsonGenerator4._outputTail = n5 + 1;
        this._outputBuffer[n5] = writerBasedJsonGenerator4._quoteChar;
    }

    @Override
    public void writeString(SerializableString serializableString) {
        int n2;
        int n3;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("write a string");
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char[] cArray = this._outputBuffer;
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n4 = writerBasedJsonGenerator2._outputTail;
        writerBasedJsonGenerator2._outputTail = n3 = n4 + 1;
        this._outputBuffer[n4] = writerBasedJsonGenerator2._quoteChar;
        int n5 = serializableString.appendQuoted(cArray, n3);
        if (n5 < 0) {
            this._writeString2(serializableString);
            return;
        }
        this._outputTail = n2 = this._outputTail + n5;
        if (n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n6 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n6 + 1;
        this._outputBuffer[n6] = writerBasedJsonGenerator3._quoteChar;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) {
        int n2 = string.length();
        int n3 = ((WriterBasedJsonGenerator)object)._outputEnd - ((WriterBasedJsonGenerator)object)._outputTail;
        if (n3 == 0) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            writerBasedJsonGenerator._flushBuffer();
            n3 = writerBasedJsonGenerator._outputEnd - ((WriterBasedJsonGenerator)object)._outputTail;
        }
        if (n3 >= n2) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
            Object object = writerBasedJsonGenerator2._outputBuffer;
            int n4 = writerBasedJsonGenerator2._outputTail;
            string.getChars(0, n2, (char[])object, n4);
            writerBasedJsonGenerator._outputTail += n2;
        } else {
            ((WriterBasedJsonGenerator)object).writeRawLong(string);
        }
    }

    @Override
    public void writeRaw(String object, int n2, int n3) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._checkRangeBoundsForString((String)object, n2, n3);
        int n4 = writerBasedJsonGenerator._outputEnd - this._outputTail;
        if (n4 < n3) {
            WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
            writerBasedJsonGenerator2._flushBuffer();
            n4 = writerBasedJsonGenerator2._outputEnd - this._outputTail;
        }
        if (n4 >= n3) {
            String string = object;
            int n5 = n2;
            WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
            int n6 = n2 + n3;
            object = writerBasedJsonGenerator3._outputBuffer;
            n2 = writerBasedJsonGenerator3._outputTail;
            string.getChars(n5, n6, (char[])object, n2);
            this._outputTail += n3;
        } else {
            int n7 = n2;
            this.writeRawLong(((String)object).substring(n7, n7 + n3));
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        char[] cArray = writerBasedJsonGenerator._outputBuffer;
        int n2 = serializableString.appendUnquoted(cArray, writerBasedJsonGenerator._outputTail);
        if (n2 < 0) {
            this.writeRaw(serializableString.getValue());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        ((GeneratorBase)object)._checkRangeBoundsForCharArray(cArray, n2, n3);
        if (n3 < 32) {
            if (n3 > ((WriterBasedJsonGenerator)object)._outputEnd - ((WriterBasedJsonGenerator)object)._outputTail) {
                ((WriterBasedJsonGenerator)object)._flushBuffer();
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
            Object object = writerBasedJsonGenerator2._outputBuffer;
            System.arraycopy(cArray, n2, object, writerBasedJsonGenerator2._outputTail, n3);
            writerBasedJsonGenerator._outputTail += n3;
            return;
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator = object;
        writerBasedJsonGenerator._flushBuffer();
        writerBasedJsonGenerator._writer.write(cArray, n2, n3);
    }

    @Override
    public void writeRaw(char c2) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        int n2 = this._outputTail;
        this._outputTail = n2 + 1;
        this._outputBuffer[n2] = c2;
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._checkRangeBoundsForByteArray(byArray, n2, n3);
        writerBasedJsonGenerator._verifyValueWrite("write a binary value");
        if (writerBasedJsonGenerator._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = this;
        int n4 = writerBasedJsonGenerator3._outputTail;
        writerBasedJsonGenerator3._outputTail = n4 + 1;
        this._outputBuffer[n4] = writerBasedJsonGenerator3._quoteChar;
        n4 = n2 + n3;
        writerBasedJsonGenerator2._writeBinary(base64Variant, byArray, n2, n4);
        if (writerBasedJsonGenerator2._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator4 = this;
        int n5 = writerBasedJsonGenerator4._outputTail;
        writerBasedJsonGenerator4._outputTail = n5 + 1;
        this._outputBuffer[n5] = writerBasedJsonGenerator4._quoteChar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        Throwable throwable2;
        byte[] byArray;
        block9: {
            block8: {
                String string = "Too few bytes available: missing ";
                this._verifyValueWrite("write a binary value");
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
                this._outputBuffer[this._outputTail++] = this._quoteChar;
                byArray = this._ioContext.allocBase64Buffer();
                if (n2 < 0) {
                    try {
                        n2 = this._writeBinary(base64Variant, inputStream, byArray);
                        break block8;
                    }
                    catch (Throwable throwable2) {
                        break block9;
                    }
                }
                int n3 = this._writeBinary(base64Variant, inputStream, byArray, n2);
                if (n3 > 0) {
                    this._reportError(string + n3 + " bytes (out of " + n2 + ")");
                }
            }
            this._ioContext.releaseBase64Buffer(byArray);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
            return n2;
        }
        this._ioContext.releaseBase64Buffer(byArray);
        throw throwable2;
    }

    @Override
    public void writeNumber(short s2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = object;
        writerBasedJsonGenerator._verifyValueWrite("write a number");
        if (writerBasedJsonGenerator._cfgNumbersAsStrings) {
            ((WriterBasedJsonGenerator)object)._writeQuotedShort(s2);
            return;
        }
        if (((WriterBasedJsonGenerator)object)._outputTail + 6 >= ((WriterBasedJsonGenerator)object)._outputEnd) {
            ((WriterBasedJsonGenerator)object)._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = object;
        Object object = writerBasedJsonGenerator3._outputBuffer;
        writerBasedJsonGenerator2._outputTail = NumberOutput.outputInt((int)s2, (char[])object, writerBasedJsonGenerator3._outputTail);
    }

    @Override
    public void writeNumber(int n2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = object;
        writerBasedJsonGenerator._verifyValueWrite("write a number");
        if (writerBasedJsonGenerator._cfgNumbersAsStrings) {
            ((WriterBasedJsonGenerator)object)._writeQuotedInt(n2);
            return;
        }
        if (((WriterBasedJsonGenerator)object)._outputTail + 11 >= ((WriterBasedJsonGenerator)object)._outputEnd) {
            ((WriterBasedJsonGenerator)object)._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = object;
        Object object = writerBasedJsonGenerator3._outputBuffer;
        writerBasedJsonGenerator2._outputTail = NumberOutput.outputInt(n2, (char[])object, writerBasedJsonGenerator3._outputTail);
    }

    @Override
    public void writeNumber(long l2) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = object;
        writerBasedJsonGenerator._verifyValueWrite("write a number");
        if (writerBasedJsonGenerator._cfgNumbersAsStrings) {
            ((WriterBasedJsonGenerator)object)._writeQuotedLong(l2);
            return;
        }
        if (((WriterBasedJsonGenerator)object)._outputTail + 21 >= ((WriterBasedJsonGenerator)object)._outputEnd) {
            ((WriterBasedJsonGenerator)object)._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
        WriterBasedJsonGenerator writerBasedJsonGenerator3 = object;
        Object object = writerBasedJsonGenerator3._outputBuffer;
        writerBasedJsonGenerator2._outputTail = NumberOutput.outputLong(l2, (char[])object, writerBasedJsonGenerator3._outputTail);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    @Override
    public void writeNumber(double d2) {
        if (!(this._cfgNumbersAsStrings || NumberOutput.notFinite(d2) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS))) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator._verifyValueWrite("write a number");
            this.writeRaw(NumberOutput.toString(d2, writerBasedJsonGenerator.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this.writeString(NumberOutput.toString(d2, this.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(float f2) {
        if (!(this._cfgNumbersAsStrings || NumberOutput.notFinite(f2) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS))) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator._verifyValueWrite("write a number");
            this.writeRaw(NumberOutput.toString(f2, writerBasedJsonGenerator.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this.writeString(NumberOutput.toString(f2, this.isEnabled(JsonGenerator.Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator._writeQuotedRaw(writerBasedJsonGenerator._asString(bigDecimal));
        } else {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            writerBasedJsonGenerator.writeRaw(writerBasedJsonGenerator._asString(bigDecimal));
        }
    }

    @Override
    public void writeNumber(String string) {
        this._verifyValueWrite("write a number");
        if (string == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    @Override
    public void writeNumber(char[] cArray, int n2, int n3) {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("write a number");
        if (writerBasedJsonGenerator._cfgNumbersAsStrings) {
            this._writeQuotedRaw(cArray, n2, n3);
        } else {
            this.writeRaw(cArray, n2, n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBoolean(boolean bl) {
        void var1_5;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("write a boolean value");
        if (writerBasedJsonGenerator._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        WriterBasedJsonGenerator writerBasedJsonGenerator2 = this;
        int n2 = writerBasedJsonGenerator2._outputTail;
        char[] cArray = writerBasedJsonGenerator2._outputBuffer;
        if (bl) {
            cArray[n2] = 116;
            cArray[n2 + 1] = 114;
            cArray[n2 + 2] = 117;
            int n3 = n2 + 3;
            cArray[n3] = 101;
        } else {
            cArray[n2] = 102;
            cArray[n2 + 1] = 97;
            cArray[n2 + 2] = 108;
            cArray[n2 + 3] = 115;
            int n4 = n2 + 4;
            cArray[n4] = 101;
        }
        this._outputTail = var1_5 + true;
    }

    @Override
    public void writeNull() {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._verifyValueWrite("write a null");
        writerBasedJsonGenerator._writeNull();
    }

    @Override
    public final void _verifyValueWrite(String object) {
        int n2;
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        int n3 = writerBasedJsonGenerator._writeContext.writeValue();
        if (writerBasedJsonGenerator._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite((String)object, n3);
            return;
        }
        if (n3 != 1) {
            if (n3 != 2) {
                if (n3 != 3) {
                    if (n3 != 5) {
                        return;
                    }
                    this._reportCantWriteValueExpectName((String)object);
                    return;
                }
                object = this._rootValueSeparator;
                if (object != null) {
                    this.writeRaw(object.getValue());
                }
                return;
            }
            n2 = 58;
        } else {
            n2 = 44;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        this._outputTail = n4 + 1;
        this._outputBuffer[n4] = n2;
    }

    @Override
    public void flush() {
        WriterBasedJsonGenerator writerBasedJsonGenerator = this;
        writerBasedJsonGenerator._flushBuffer();
        if (writerBasedJsonGenerator._writer != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        void var0_3;
        Throwable throwable;
        block16: {
            WriterBasedJsonGenerator writerBasedJsonGenerator = this;
            super.close();
            throwable = null;
            try {
                if (writerBasedJsonGenerator._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
                    while (true) {
                        JsonStreamContext jsonStreamContext;
                        if ((jsonStreamContext = this.getOutputContext()).inArray()) {
                            this.writeEndArray();
                            continue;
                        }
                        if (!jsonStreamContext.inObject()) break;
                        this.writeEndObject();
                    }
                }
                this._flushBuffer();
            }
            catch (IOException iOException) {}
            this._outputHead = 0;
            this._outputTail = 0;
            if (this._writer != null) {
                try {
                    if (!this._ioContext.isResourceManaged() && !this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                        if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                            this._writer.flush();
                        }
                    } else {
                        this._writer.close();
                    }
                }
                catch (RuntimeException runtimeException) {
                    break block16;
                }
            }
            this._releaseBuffers();
            if (throwable == null) {
                return;
            }
            throw throwable;
            catch (IOException iOException) {}
        }
        if (throwable != null) {
            var0_3.addSuppressed(throwable);
        }
        throw var0_3;
    }

    @Override
    public void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (this._outputBuffer != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
        cArray = this._copyBuffer;
        if (this._copyBuffer != null) {
            this._copyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    public final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 3;
        int n5 = ((WriterBasedJsonGenerator)object)._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n4) {
            int n7;
            if (((WriterBasedJsonGenerator)object)._outputTail > n5) {
                ((WriterBasedJsonGenerator)object)._flushBuffer();
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            int n8 = n2;
            int n9 = n7 = n8 + 1;
            n7 = n2 + 2;
            n2 += 3;
            n7 = (byArray[n8] << 8 | byArray[n9] & 0xFF) << 8 | byArray[n7] & 0xFF;
            char[] cArray = writerBasedJsonGenerator._outputBuffer;
            int n10 = writerBasedJsonGenerator._outputTail;
            ((WriterBasedJsonGenerator)object)._outputTail = n7 = base64Variant.encodeBase64Chunk(n7, cArray, n10);
            if ((n6 += -1) > 0) continue;
            char[] cArray2 = ((WriterBasedJsonGenerator)object)._outputBuffer;
            int n11 = n7;
            n6 = n11 + 1;
            cArray2[n11] = 92;
            ((WriterBasedJsonGenerator)object)._outputTail = n7 + 2;
            ((WriterBasedJsonGenerator)object)._outputBuffer[n6] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        if ((n3 -= n2) > 0) {
            if (((WriterBasedJsonGenerator)object)._outputTail > n5) {
                ((WriterBasedJsonGenerator)object)._flushBuffer();
            }
            n4 = byArray[n2++] << 16;
            if (n3 == 2) {
                n4 |= (byArray[n2] & 0xFF) << 8;
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
            Object object = writerBasedJsonGenerator2._outputBuffer;
            int n12 = writerBasedJsonGenerator2._outputTail;
            writerBasedJsonGenerator._outputTail = base64Variant.encodeBase64Partial(n4, n3, (char[])object, n12);
        }
    }

    public final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = ((WriterBasedJsonGenerator)object)._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 > 2) {
            int n8;
            if (n3 > n5) {
                n4 = ((WriterBasedJsonGenerator)object)._readMore(inputStream, byArray, n3, n4, n2);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (((WriterBasedJsonGenerator)object)._outputTail > n6) {
                ((WriterBasedJsonGenerator)object)._flushBuffer();
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            int n9 = n3;
            int n10 = n8 = n9 + 1;
            n8 = n3 + 2;
            n3 += 3;
            n8 = (byArray[n9] << 8 | byArray[n10] & 0xFF) << 8 | byArray[n8] & 0xFF;
            n2 -= 3;
            char[] cArray = writerBasedJsonGenerator._outputBuffer;
            int n11 = writerBasedJsonGenerator._outputTail;
            ((WriterBasedJsonGenerator)object)._outputTail = n8 = base64Variant.encodeBase64Chunk(n8, cArray, n11);
            if ((n7 += -1) > 0) continue;
            char[] cArray2 = ((WriterBasedJsonGenerator)object)._outputBuffer;
            int n12 = n8;
            n7 = n12 + 1;
            cArray2[n12] = 92;
            ((WriterBasedJsonGenerator)object)._outputTail = n8 + 2;
            ((WriterBasedJsonGenerator)object)._outputBuffer[n7] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 > 0) {
            int n13 = ((WriterBasedJsonGenerator)object)._readMore(inputStream, byArray, n3, n4, n2);
            n3 = 0;
            if (n13 > 0) {
                int n14;
                if (((WriterBasedJsonGenerator)object)._outputTail > n6) {
                    ((WriterBasedJsonGenerator)object)._flushBuffer();
                }
                n4 = 1;
                int n15 = n13;
                n13 = byArray[n3] << 16;
                if (1 < n15) {
                    n13 |= (byArray[n4] & 0xFF) << 8;
                    n14 = 2;
                } else {
                    n14 = 1;
                }
                WriterBasedJsonGenerator writerBasedJsonGenerator = object;
                WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
                Object object = writerBasedJsonGenerator2._outputBuffer;
                int n16 = writerBasedJsonGenerator2._outputTail;
                writerBasedJsonGenerator._outputTail = base64Variant.encodeBase64Partial(n13, n14, (char[])object, n16);
                n2 -= n14;
            }
        }
        return n2;
    }

    public final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = -3;
        int n5 = 0;
        int n6 = ((WriterBasedJsonGenerator)object)._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            int n8;
            if (n2 > n4) {
                n4 = byArray.length;
                n2 = ((WriterBasedJsonGenerator)object)._readMore(inputStream, byArray, n2, n3, n4);
                n3 = 0;
                if (n2 < 3) {
                    if (n2 > 0) {
                        if (((WriterBasedJsonGenerator)object)._outputTail > n6) {
                            ((WriterBasedJsonGenerator)object)._flushBuffer();
                        }
                        int n9 = 1;
                        int n10 = n2;
                        n2 = byArray[n3] << 16;
                        n3 = 1;
                        if (1 < n10) {
                            n2 |= (byArray[n9] & 0xFF) << 8;
                            n3 = 2;
                        }
                        WriterBasedJsonGenerator writerBasedJsonGenerator = object;
                        WriterBasedJsonGenerator writerBasedJsonGenerator2 = object;
                        n5 += n3;
                        Object object = writerBasedJsonGenerator2._outputBuffer;
                        int n11 = writerBasedJsonGenerator2._outputTail;
                        writerBasedJsonGenerator._outputTail = base64Variant.encodeBase64Partial(n2, n3, (char[])object, n11);
                    }
                    return n5;
                }
                n4 = n2 - 3;
                int n12 = n3;
                n3 = n2;
                n2 = n12;
            }
            if (((WriterBasedJsonGenerator)object)._outputTail > n6) {
                ((WriterBasedJsonGenerator)object)._flushBuffer();
            }
            WriterBasedJsonGenerator writerBasedJsonGenerator = object;
            int n13 = n2;
            int n14 = n8 = n13 + 1;
            n8 = n2 + 2;
            n2 += 3;
            n8 = (byArray[n13] << 8 | byArray[n14] & 0xFF) << 8 | byArray[n8] & 0xFF;
            n5 += 3;
            char[] cArray = writerBasedJsonGenerator._outputBuffer;
            int n15 = writerBasedJsonGenerator._outputTail;
            ((WriterBasedJsonGenerator)object)._outputTail = n8 = base64Variant.encodeBase64Chunk(n8, cArray, n15);
            if ((n7 += -1) > 0) continue;
            char[] cArray2 = ((WriterBasedJsonGenerator)object)._outputBuffer;
            int n16 = n8;
            n7 = n16 + 1;
            cArray2[n16] = 92;
            ((WriterBasedJsonGenerator)object)._outputTail = n8 + 2;
            ((WriterBasedJsonGenerator)object)._outputBuffer[n7] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
    }

    public void _flushBuffer() {
        int n2 = this._outputHead;
        int n3 = this._outputTail - n2;
        if (n3 > 0) {
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n2, n3);
        }
    }
}

