/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json.async;

import com.privatefasterxml.jackson.core.async.ByteBufferFeeder;
import com.privatefasterxml.jackson.core.async.NonBlockingInputFeeder;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.json.async.NonBlockingUtf8JsonParserBase;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;

public class NonBlockingByteBufferJsonParser
extends NonBlockingUtf8JsonParserBase
implements ByteBufferFeeder {
    private ByteBuffer _inputBuffer = ByteBuffer.wrap(ParserMinimalBase.NO_BYTES);

    public NonBlockingByteBufferJsonParser(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n2, byteQuadsCanonicalizer);
    }

    @Override
    public NonBlockingInputFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public void feedInput(ByteBuffer byteBuffer) {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        if (n2 < n3) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", n3 - n2);
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        n2 = byteBuffer2.position();
        n3 = byteBuffer2.limit();
        if (n3 < n2) {
            Integer n4 = n3;
            Integer n5 = n2;
            this._reportError("Input end (%d) may not be before start (%d)", n4, n5);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        NonBlockingByteBufferJsonParser nonBlockingByteBufferJsonParser = this;
        nonBlockingByteBufferJsonParser._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart = n2 - (nonBlockingByteBufferJsonParser._inputEnd - this._currInputRowStart);
        this._currBufferStart = n2;
        this._inputBuffer = byteBuffer;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._origBufferLen = n3 - n2;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 > 0) {
            Channels.newChannel(outputStream).write(this._inputBuffer);
        }
        return n2;
    }

    @Override
    public byte getNextSignedByteFromBuffer() {
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return this._inputBuffer.get(n2);
    }

    @Override
    public int getNextUnsignedByteFromBuffer() {
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return this._inputBuffer.get(n2) & 0xFF;
    }

    @Override
    public byte getByteFromBuffer(int n2) {
        return this._inputBuffer.get(n2);
    }
}

