/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json.async;

import com.privatefasterxml.jackson.core.async.ByteArrayFeeder;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.json.async.NonBlockingUtf8JsonParserBase;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import java.io.OutputStream;

public class NonBlockingJsonParser
extends NonBlockingUtf8JsonParserBase
implements ByteArrayFeeder {
    private byte[] _inputBuffer = ParserMinimalBase.NO_BYTES;

    public NonBlockingJsonParser(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n2, byteQuadsCanonicalizer);
    }

    @Override
    public ByteArrayFeeder getNonBlockingInputFeeder() {
        return this;
    }

    @Override
    public void feedInput(byte[] byArray, int n2, int n3) {
        int n4 = this._inputPtr;
        int n5 = this._inputEnd;
        if (n4 < n5) {
            this._reportError("Still have %d undecoded bytes, should not call 'feedInput'", n5 - n4);
        }
        if (n3 < n2) {
            Integer n6 = n3;
            Integer n7 = n2;
            this._reportError("Input end (%d) may not be before start (%d)", n6, n7);
        }
        if (this._endOfInput) {
            this._reportError("Already closed, can not feed more input");
        }
        NonBlockingJsonParser nonBlockingJsonParser = this;
        nonBlockingJsonParser._currInputProcessed += (long)this._origBufferLen;
        this._currInputRowStart = n2 - (nonBlockingJsonParser._inputEnd - this._currInputRowStart);
        this._currBufferStart = n2;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._origBufferLen = n3 - n2;
    }

    @Override
    public int releaseBuffered(OutputStream outputStream) {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd - n2;
        if (n3 > 0) {
            outputStream.write(this._inputBuffer, n2, n3);
        }
        return n3;
    }

    @Override
    public byte getNextSignedByteFromBuffer() {
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return this._inputBuffer[n2];
    }

    @Override
    public int getNextUnsignedByteFromBuffer() {
        int n2 = this._inputPtr;
        this._inputPtr = n2 + 1;
        return this._inputBuffer[n2] & 0xFF;
    }

    @Override
    public byte getByteFromBuffer(int n2) {
        return this._inputBuffer[n2];
    }
}

