/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json.async;

import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.base.ParserBase;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.ContentReference;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.json.JsonReadContext;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.privatefasterxml.jackson.core.util.ByteArrayBuilder;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import java.io.OutputStream;
import java.io.Writer;

public abstract class NonBlockingJsonParserBase
extends ParserBase {
    protected static final int MAJOR_INITIAL = 0;
    protected static final int MAJOR_ROOT = 1;
    protected static final int MAJOR_OBJECT_FIELD_FIRST = 2;
    protected static final int MAJOR_OBJECT_FIELD_NEXT = 3;
    protected static final int MAJOR_OBJECT_VALUE = 4;
    protected static final int MAJOR_ARRAY_ELEMENT_FIRST = 5;
    protected static final int MAJOR_ARRAY_ELEMENT_NEXT = 6;
    protected static final int MAJOR_CLOSED = 7;
    protected static final int MINOR_ROOT_BOM = 1;
    protected static final int MINOR_ROOT_NEED_SEPARATOR = 2;
    protected static final int MINOR_ROOT_GOT_SEPARATOR = 3;
    protected static final int MINOR_FIELD_LEADING_WS = 4;
    protected static final int MINOR_FIELD_LEADING_COMMA = 5;
    protected static final int MINOR_FIELD_NAME = 7;
    protected static final int MINOR_FIELD_NAME_ESCAPE = 8;
    protected static final int MINOR_FIELD_APOS_NAME = 9;
    protected static final int MINOR_FIELD_UNQUOTED_NAME = 10;
    protected static final int MINOR_VALUE_LEADING_WS = 12;
    protected static final int MINOR_VALUE_EXPECTING_COMMA = 13;
    protected static final int MINOR_VALUE_EXPECTING_COLON = 14;
    protected static final int MINOR_VALUE_WS_AFTER_COMMA = 15;
    protected static final int MINOR_VALUE_TOKEN_NULL = 16;
    protected static final int MINOR_VALUE_TOKEN_TRUE = 17;
    protected static final int MINOR_VALUE_TOKEN_FALSE = 18;
    protected static final int MINOR_VALUE_TOKEN_NON_STD = 19;
    protected static final int MINOR_NUMBER_PLUS = 22;
    protected static final int MINOR_NUMBER_MINUS = 23;
    protected static final int MINOR_NUMBER_ZERO = 24;
    protected static final int MINOR_NUMBER_MINUSZERO = 25;
    protected static final int MINOR_NUMBER_INTEGER_DIGITS = 26;
    protected static final int MINOR_NUMBER_FRACTION_DIGITS = 30;
    protected static final int MINOR_NUMBER_EXPONENT_MARKER = 31;
    protected static final int MINOR_NUMBER_EXPONENT_DIGITS = 32;
    protected static final int MINOR_VALUE_STRING = 40;
    protected static final int MINOR_VALUE_STRING_ESCAPE = 41;
    protected static final int MINOR_VALUE_STRING_UTF8_2 = 42;
    protected static final int MINOR_VALUE_STRING_UTF8_3 = 43;
    protected static final int MINOR_VALUE_STRING_UTF8_4 = 44;
    protected static final int MINOR_VALUE_APOS_STRING = 45;
    protected static final int MINOR_VALUE_TOKEN_ERROR = 50;
    protected static final int MINOR_COMMENT_LEADING_SLASH = 51;
    protected static final int MINOR_COMMENT_CLOSING_ASTERISK = 52;
    protected static final int MINOR_COMMENT_C = 53;
    protected static final int MINOR_COMMENT_CPP = 54;
    protected static final int MINOR_COMMENT_YAML = 55;
    protected static final int NON_STD_TOKEN_NAN = 0;
    protected static final int NON_STD_TOKEN_INFINITY = 1;
    protected static final int NON_STD_TOKEN_PLUS_INFINITY = 2;
    protected static final int NON_STD_TOKEN_MINUS_INFINITY = 3;
    protected static final String[] NON_STD_TOKENS = new String[]{"NaN", "Infinity", "+Infinity", "-Infinity"};
    protected static final double[] NON_STD_TOKEN_VALUES = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
    protected final ByteQuadsCanonicalizer _symbols;
    protected int[] _quadBuffer;
    protected int _quadLength;
    protected int _quad1;
    protected int _pending32;
    protected int _pendingBytes;
    protected int _quoted32;
    protected int _quotedDigits;
    protected int _majorState;
    protected int _majorStateAfterValue;
    protected int _minorState;
    protected int _minorStateAfterSplit;
    protected boolean _endOfInput;
    protected int _nonStdTokenType;
    protected int _currBufferStart;
    protected int _currInputRowAlt;

    public NonBlockingJsonParserBase(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        super(iOContext, n2);
        this._quadBuffer = new int[8];
        this._endOfInput = false;
        this._currBufferStart = 0;
        this._currInputRowAlt = 1;
        nonBlockingJsonParserBase._symbols = byteQuadsCanonicalizer;
        nonBlockingJsonParserBase._currToken = null;
        nonBlockingJsonParserBase._majorState = 0;
        nonBlockingJsonParserBase._majorStateAfterValue = 1;
    }

    public static final int _padLastQuad(int n2, int n3) {
        if (n3 != 4) {
            n2 |= -1 << (n3 << 3);
        }
        return n2;
    }

    @Override
    public ObjectCodec getCodec() {
        return null;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        throw new UnsupportedOperationException("Can not use ObjectMapper with non-blocking parser");
    }

    @Override
    public boolean canParseAsync() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return ParserBase.JSON_READ_CAPABILITIES;
    }

    public ByteQuadsCanonicalizer symbolTableForTests() {
        return this._symbols;
    }

    @Override
    public abstract int releaseBuffered(OutputStream var1);

    @Override
    public void _releaseBuffers() {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        super._releaseBuffers();
        nonBlockingJsonParserBase._symbols.release();
    }

    @Override
    public Object getInputSource() {
        return null;
    }

    @Override
    public void _closeInput() {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        nonBlockingJsonParserBase._currBufferStart = 0;
        nonBlockingJsonParserBase._inputEnd = 0;
    }

    @Override
    public boolean hasTextCharacters() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        int n2 = nonBlockingJsonParserBase._inputPtr - this._currInputRowStart + 1;
        int n3 = Math.max(nonBlockingJsonParserBase._currInputRow, this._currInputRowAlt);
        return new JsonLocation(this._contentReference(), this._currInputProcessed + (long)(this._inputPtr - this._currBufferStart), -1L, n3, n2);
    }

    @Override
    public JsonLocation getTokenLocation() {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = contentReference;
        ContentReference contentReference = nonBlockingJsonParserBase._contentReference();
        long l2 = nonBlockingJsonParserBase._tokenInputTotal;
        int n2 = nonBlockingJsonParserBase._tokenInputRow;
        int n3 = nonBlockingJsonParserBase._tokenInputCol;
        return new JsonLocation(contentReference, l2, -1L, n2, n3);
    }

    @Override
    public String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    public final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        int n2 = jsonToken.id();
        if (n2 != -1) {
            switch (n2) {
                default: {
                    return jsonToken.asString();
                }
                case 6: 
                case 7: 
                case 8: {
                    return this._textBuffer.contentsAsString();
                }
                case 5: 
            }
            return this._parsingContext.getCurrentName();
        }
        return null;
    }

    @Override
    public int getText(Writer writer) {
        Object object;
        JsonToken jsonToken = ((ParserMinimalBase)object)._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return ((ParserBase)object)._textBuffer.contentsToWriter(writer);
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            object = ((ParserBase)object)._parsingContext.getCurrentName();
            writer.write((String)object);
            return ((String)object).length();
        }
        if (jsonToken != null) {
            if (jsonToken.isNumeric()) {
                return ((ParserBase)object)._textBuffer.contentsToWriter(writer);
            }
            if (jsonToken == JsonToken.NOT_AVAILABLE) {
                ((ParserMinimalBase)object)._reportError("Current token not available: can not call this method");
            }
            char[] cArray = jsonToken.asCharArray();
            object = cArray;
            writer.write(cArray);
            return ((Object)object).length;
        }
        return 0;
    }

    @Override
    public String getValueAsString() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    @Override
    public char[] getTextCharacters() {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                default: {
                    return this._currToken.asCharArray();
                }
                case 6: 
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
                case 5: 
            }
            if (!this._nameCopied) {
                NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
                object = nonBlockingJsonParserBase._parsingContext.getCurrentName();
                int n2 = ((String)object).length();
                char[] cArray = nonBlockingJsonParserBase._nameCopyBuffer;
                if (nonBlockingJsonParserBase._nameCopyBuffer == null) {
                    this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                } else if (cArray.length < n2) {
                    this._nameCopyBuffer = new char[n2];
                }
                JsonToken jsonToken = object;
                object = this._nameCopyBuffer;
                ((String)((Object)jsonToken)).getChars(0, n2, (char[])object, 0);
                this._nameCopied = true;
            }
            return this._nameCopyBuffer;
        }
        return null;
    }

    @Override
    public int getTextLength() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                default: {
                    return this._currToken.asCharArray().length;
                }
                case 6: 
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
                case 5: 
            }
            return this._parsingContext.getCurrentName().length();
        }
        return 0;
    }

    @Override
    public int getTextOffset() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken != null) {
            switch (jsonToken.id()) {
                default: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        Object object = this._currToken;
        if (object != JsonToken.VALUE_STRING) {
            this._reportError("Current token (%s) not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary", object);
        }
        if (this._binaryValue == null) {
            NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
            object = nonBlockingJsonParserBase._getByteArrayBuilder();
            nonBlockingJsonParserBase._decodeBase64(nonBlockingJsonParserBase.getText(), (ByteArrayBuilder)object, base64Variant);
            nonBlockingJsonParserBase._binaryValue = ((ByteArrayBuilder)object).toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        byte[] byArray = ((NonBlockingJsonParserBase)object).getBinaryValue(base64Variant);
        Object object = byArray;
        outputStream.write(byArray);
        return ((Object)object).length;
    }

    @Override
    public Object getEmbeddedObject() {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    public final JsonToken _startArrayScope() {
        this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
        this._majorState = 5;
        this._majorStateAfterValue = 6;
        this._currToken = JsonToken.START_ARRAY;
        return this._currToken;
    }

    public final JsonToken _startObjectScope() {
        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
        this._majorState = 2;
        this._majorStateAfterValue = 3;
        this._currToken = JsonToken.START_OBJECT;
        return this._currToken;
    }

    public final JsonToken _closeArrayScope() {
        JsonReadContext jsonReadContext;
        if (!this._parsingContext.inArray()) {
            this._reportMismatchedEndMarker(93, '}');
        }
        this._parsingContext = jsonReadContext = this._parsingContext.getParent();
        int n2 = jsonReadContext.inObject() ? 3 : (jsonReadContext.inArray() ? 6 : 1);
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        nonBlockingJsonParserBase._majorState = n2;
        nonBlockingJsonParserBase._majorStateAfterValue = n2;
        this._currToken = JsonToken.END_ARRAY;
        return this._currToken;
    }

    public final JsonToken _closeObjectScope() {
        JsonReadContext jsonReadContext;
        if (!this._parsingContext.inObject()) {
            this._reportMismatchedEndMarker(125, ']');
        }
        this._parsingContext = jsonReadContext = this._parsingContext.getParent();
        int n2 = jsonReadContext.inObject() ? 3 : (jsonReadContext.inArray() ? 6 : 1);
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        nonBlockingJsonParserBase._majorState = n2;
        nonBlockingJsonParserBase._majorStateAfterValue = n2;
        this._currToken = JsonToken.END_OBJECT;
        return this._currToken;
    }

    public final String _findName(int n2, int n3) {
        String string = this._symbols.findName(n2 = NonBlockingJsonParserBase._padLastQuad(n2, n3));
        if (string != null) {
            return string;
        }
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        nonBlockingJsonParserBase._quadBuffer[0] = n2;
        return nonBlockingJsonParserBase._addName(nonBlockingJsonParserBase._quadBuffer, 1, n3);
    }

    public final String _findName(int n2, int n3, int n4) {
        String string = this._symbols.findName(n2, n3 = NonBlockingJsonParserBase._padLastQuad(n3, n4));
        if (string != null) {
            return string;
        }
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        int[] nArray = nonBlockingJsonParserBase._quadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        return nonBlockingJsonParserBase._addName(nonBlockingJsonParserBase._quadBuffer, 2, n4);
    }

    public final String _findName(int n2, int n3, int n4, int n5) {
        String string = ((NonBlockingJsonParserBase)this)._symbols.findName(n2, n3, n4 = NonBlockingJsonParserBase._padLastQuad(n4, n5));
        if (string != null) {
            return string;
        }
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        int[] nArray = nonBlockingJsonParserBase._quadBuffer;
        Object object = this = (Object)nArray;
        object[0] = n2;
        object[1] = n3;
        nArray[2] = NonBlockingJsonParserBase._padLastQuad(n4, n5);
        return nonBlockingJsonParserBase._addName(nonBlockingJsonParserBase._quadBuffer, 3, n5);
    }

    /*
     * Unable to fully structure code
     */
    public final String _addName(int[] var1_1, int var2_2, int var3_3) {
        var4_5 = (var2_2 << 2) - 4 + var3_3;
        if (var3_3 < 4) {
            var5_6 = var2_2 - 1;
            var6_8 = var1_1[var5_6];
            var1_1[var5_6] = var6_8 << (4 - var3_3 << 3);
        } else {
            var6_8 = 0;
        }
        var5_7 = this._textBuffer.emptyAndGetCurrentSegment();
        var7_9 = 0;
        var8_10 = 0;
        while (var8_10 < var4_5) {
            block21: {
                block20: {
                    var9_11 = var1_1[var8_10 >> 2] >> (3 - (var8_10 & 3) << 3);
                    var10_12 = var9_11 & 255;
                    var11_13 = var8_10 + 1;
                    if (var10_12 <= 127) break block20;
                    if ((var9_11 & 224) == 192) {
                        var9_11 &= 31;
                        var10_12 = 1;
                    } else if ((var9_11 & 240) == 224) {
                        var9_11 &= 15;
                        var10_12 = 2;
                    } else if ((var9_11 & 248) == 240) {
                        var9_11 &= 7;
                        var10_12 = 3;
                    } else {
                        this._reportInvalidInitial(var10_12);
                        var9_11 = var10_12 = 1;
                    }
                    if (var11_13 + var10_12 > var4_5) {
                        this._reportInvalidEOF(" in field name", JsonToken.FIELD_NAME);
                    }
                    var11_13 = var1_1[var11_13 >> 2] >> (3 - (var11_13 & 3) << 3);
                    var12_14 = var8_10 + 2;
                    if ((var11_13 & 192) != 128) {
                        this._reportInvalidOther(var11_13);
                    }
                    var9_11 = var9_11 << 6 | var11_13 & 63;
                    if (var10_12 <= 1) ** GOTO lbl-1000
                    var11_13 = var1_1[var12_14 >> 2] >> (3 - (var12_14 & 3) << 3);
                    var12_14 = var8_10 + 3;
                    if ((var11_13 & 192) != 128) {
                        this._reportInvalidOther(var11_13);
                    }
                    var9_11 = var9_11 << 6 | var11_13 & 63;
                    if (var10_12 > 2) {
                        var11_13 = var1_1[var12_14 >> 2] >> (3 - (var12_14 & 3) << 3);
                        var12_14 = var8_10 + 4;
                        if ((var11_13 & 192) != 128) {
                            this._reportInvalidOther(var11_13 & 255);
                        }
                        var8_10 = var9_11 << 6 | var11_13 & 63;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_10 = var9_11;
                    }
                    if (var10_12 > 2) {
                        var8_10 -= 65536;
                        if (var7_9 >= var5_7.length) {
                            var5_7 = this._textBuffer.expandCurrentSegment();
                        }
                        var5_7[var7_9++] = (char)((var8_10 >> 10) + 55296);
                        var10_12 = var8_10 & 1023 | 56320;
                        var8_10 = var12_14;
                    } else {
                        var10_12 = var8_10;
                        var8_10 = var12_14;
                    }
                    break block21;
                }
                var8_10 = var11_13;
            }
            if (var7_9 >= var5_7.length) {
                var5_7 = this._textBuffer.expandCurrentSegment();
            }
            var9_11 = var7_9 + 1;
            var5_7[var7_9] = (char)var10_12;
            var7_9 = var9_11;
        }
        var3_4 = v0;
        v0 = new String(var5_7, 0, var7_9);
        if (var3_3 < 4) {
            var1_1[var2_2 - 1] = var6_8;
        }
        return this._symbols.addName(var3_4, var1_1, var2_2);
    }

    public final JsonToken _eofAsNextToken() {
        this._majorState = 7;
        if (!this._parsingContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        this._currToken = null;
        return null;
    }

    public final JsonToken _fieldComplete(String string) {
        this._majorState = 4;
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        return this._currToken;
    }

    public final JsonToken _valueComplete(JsonToken jsonToken) {
        this._majorState = this._majorStateAfterValue;
        this._currToken = jsonToken;
        return jsonToken;
    }

    public final JsonToken _valueCompleteInt(int n2, String string) {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        this._textBuffer.resetWithString(string);
        nonBlockingJsonParserBase._intLength = string.length();
        nonBlockingJsonParserBase._numTypesValid = 1;
        this._numberInt = n2;
        this._majorState = this._majorStateAfterValue;
        this._currToken = JsonToken.VALUE_NUMBER_INT;
        return this._currToken;
    }

    public final JsonToken _valueNonStdNumberComplete(int n2) {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        String string = NON_STD_TOKENS[n2];
        nonBlockingJsonParserBase._textBuffer.resetWithString(string);
        if (!nonBlockingJsonParserBase.isEnabled(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
            this._reportError("Non-standard token '%s': enable `JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS` to allow", string);
        }
        this._intLength = 0;
        this._numTypesValid = 8;
        this._numberDouble = NON_STD_TOKEN_VALUES[n2];
        this._majorState = this._majorStateAfterValue;
        this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
        return this._currToken;
    }

    public final String _nonStdToken(int n2) {
        return NON_STD_TOKENS[n2];
    }

    public final void _updateTokenLocation() {
        NonBlockingJsonParserBase nonBlockingJsonParserBase = this;
        nonBlockingJsonParserBase._tokenInputRow = Math.max(nonBlockingJsonParserBase._currInputRow, this._currInputRowAlt);
        int n2 = nonBlockingJsonParserBase._inputPtr;
        nonBlockingJsonParserBase._tokenInputCol = n2 - this._currInputRowStart;
        nonBlockingJsonParserBase._tokenInputTotal = nonBlockingJsonParserBase._currInputProcessed + (long)(n2 - this._currBufferStart);
    }

    public void _reportInvalidChar(int n2) {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    public void _reportInvalidInitial(int n2) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    public void _reportInvalidOther(int n2, int n3) {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    public void _reportInvalidOther(int n2) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }
}

