/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.json.async;

import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.base.ParserBase;
import com.privatefasterxml.jackson.core.base.ParserMinimalBase;
import com.privatefasterxml.jackson.core.io.CharTypes;
import com.privatefasterxml.jackson.core.io.IOContext;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.core.json.async.NonBlockingJsonParserBase;
import com.privatefasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.privatefasterxml.jackson.core.util.VersionUtil;

public abstract class NonBlockingUtf8JsonParserBase
extends NonBlockingJsonParserBase {
    private static final int FEAT_MASK_TRAILING_COMMA = JsonParser.Feature.ALLOW_TRAILING_COMMA.getMask();
    private static final int FEAT_MASK_LEADING_ZEROS = JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS.getMask();
    private static final int FEAT_MASK_ALLOW_MISSING = JsonParser.Feature.ALLOW_MISSING_VALUES.getMask();
    private static final int FEAT_MASK_ALLOW_SINGLE_QUOTES = JsonParser.Feature.ALLOW_SINGLE_QUOTES.getMask();
    private static final int FEAT_MASK_ALLOW_UNQUOTED_NAMES = JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
    private static final int FEAT_MASK_ALLOW_JAVA_COMMENTS = JsonParser.Feature.ALLOW_COMMENTS.getMask();
    private static final int FEAT_MASK_ALLOW_YAML_COMMENTS = JsonParser.Feature.ALLOW_YAML_COMMENTS.getMask();
    private static final int[] _icUTF8 = CharTypes.getInputCodeUtf8();
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected int _origBufferLen;

    public NonBlockingUtf8JsonParserBase(IOContext iOContext, int n2, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        super(iOContext, n2, byteQuadsCanonicalizer);
    }

    private final JsonToken _startDocument(int n2) {
        if ((n2 &= 0xFF) == 239 && this._minorState != 1) {
            return this._finishBOM(1);
        }
        while (n2 <= 32) {
            if (n2 != 32) {
                if (n2 == 10) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRow;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                } else if (n2 == 13) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRowAlt;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                } else if (n2 != 9) {
                    this._throwInvalidSpace(n2);
                }
            }
            if (this._inputPtr >= this._inputEnd) {
                this._minorState = 3;
                if (this._closed) {
                    return null;
                }
                if (this._endOfInput) {
                    return this._eofAsNextToken();
                }
                return JsonToken.NOT_AVAILABLE;
            }
            n2 = this.getNextUnsignedByteFromBuffer();
        }
        return this._startValue(n2);
    }

    private final JsonToken _finishBOM(int n2) {
        while (this._inputPtr < this._inputEnd) {
            int n3 = this.getNextUnsignedByteFromBuffer();
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 == 3) {
                        this._currInputProcessed -= 3L;
                        return this._startDocument(n3);
                    }
                } else if (n3 != 191) {
                    this._reportError("Unexpected byte 0x%02x following 0xEF 0xBB; should get 0xBF as third byte of UTF-8 BOM", n3);
                }
            } else if (n3 != 187) {
                this._reportError("Unexpected byte 0x%02x following 0xEF; should get 0xBB as second byte UTF-8 BOM", n3);
            }
            ++n2;
        }
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        nonBlockingUtf8JsonParserBase._pending32 = n2;
        nonBlockingUtf8JsonParserBase._minorState = 1;
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    private final JsonToken _startFieldName(int n2) {
        String string;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 4;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 != 34) {
            if (n2 == 125) {
                return this._closeObjectScope();
            }
            return this._handleOddName(n2);
        }
        if (this._inputPtr + 13 <= this._inputEnd && (string = this._fastParseName()) != null) {
            return this._fieldComplete(string);
        }
        return this._parseEscapedName(0, 0, 0);
    }

    private final JsonToken _startFieldNameAfterComma(int n2) {
        String string;
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 5;
            return this._currToken;
        }
        if (n2 != 44) {
            if (n2 == 125) {
                return this._closeObjectScope();
            }
            if (n2 == 35) {
                return this._finishHashComment(5);
            }
            if (n2 == 47) {
                return this._startSlashComment(5);
            }
            String string2 = "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries";
            this._reportUnexpectedChar(n2, string2);
        }
        if ((n2 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 4;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = this.getByteFromBuffer(n2);
        this._inputPtr = n2 + 1;
        if (n3 <= 32 && (n3 = this._skipWS(n3)) <= 0) {
            this._minorState = 4;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n3 != 34) {
            if (n3 == 125 && (this._features & FEAT_MASK_TRAILING_COMMA) != 0) {
                return this._closeObjectScope();
            }
            return this._handleOddName(n3);
        }
        if (this._inputPtr + 13 <= this._inputEnd && (string = this._fastParseName()) != null) {
            return this._fieldComplete(string);
        }
        return this._parseEscapedName(0, 0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JsonToken _startValue(int n2) {
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 12;
            return this._currToken;
        }
        this._updateTokenLocation();
        this._parsingContext.expectComma();
        if (n2 == 34) {
            return this._startString();
        }
        switch (n2) {
            default: {
                switch (n2) {
                    default: {
                        return this._startUnexpectedValue(false, n2);
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        return this._startPositiveNumber(n2);
                    }
                    case 48: {
                        return this._startNumberLeadingZero();
                    }
                    case 47: {
                        return this._startSlashComment(12);
                    }
                    case 46: {
                        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) return this._startUnexpectedValue(false, n2);
                        return this._startFloatThatStartsWithPeriod();
                    }
                    case 45: 
                }
                return this._startNegativeNumber();
            }
            case 125: {
                return this._closeObjectScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 102: {
                return this._startFalseToken();
            }
            case 93: {
                return this._closeArrayScope();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 43: {
                return this._startPositiveNumber();
            }
            case 35: 
        }
        return this._finishHashComment(12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JsonToken _startValueExpectComma(int n2) {
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 13;
            return this._currToken;
        }
        if (n2 != 44) {
            if (n2 == 93) {
                return this._closeArrayScope();
            }
            if (n2 == 125) {
                return this._closeObjectScope();
            }
            if (n2 == 47) {
                return this._startSlashComment(13);
            }
            if (n2 == 35) {
                return this._finishHashComment(13);
            }
            String string = "was expecting comma to separate " + this._parsingContext.typeDesc() + " entries";
            this._reportUnexpectedChar(n2, string);
        }
        this._parsingContext.expectComma();
        n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._minorState = 15;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = this.getByteFromBuffer(n2);
        this._inputPtr = n2 + 1;
        if (n3 <= 32 && (n3 = this._skipWS(n3)) <= 0) {
            this._minorState = 15;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n3 == 34) {
            return this._startString();
        }
        switch (n3) {
            default: {
                switch (n3) {
                    default: {
                        return this._startUnexpectedValue(true, n3);
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        return this._startPositiveNumber(n3);
                    }
                    case 48: {
                        return this._startNumberLeadingZero();
                    }
                    case 47: {
                        return this._startSlashComment(15);
                    }
                }
            }
            case 125: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) return this._startUnexpectedValue(true, n3);
                return this._closeObjectScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 102: {
                return this._startFalseToken();
            }
            case 93: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) return this._startUnexpectedValue(true, n3);
                return this._closeArrayScope();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 43: {
                return this._startPositiveNumber();
            }
            case 35: 
        }
        return this._finishHashComment(15);
    }

    private final JsonToken _startValueExpectColon(int n2) {
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 14;
            return this._currToken;
        }
        if (n2 != 58) {
            if (n2 == 47) {
                return this._startSlashComment(14);
            }
            if (n2 == 35) {
                return this._finishHashComment(14);
            }
            this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
        }
        if ((n2 = this._inputPtr) >= this._inputEnd) {
            this._minorState = 12;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = this.getByteFromBuffer(n2);
        this._inputPtr = n2 + 1;
        if (n3 <= 32 && (n3 = this._skipWS(n3)) <= 0) {
            this._minorState = 12;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n3 == 34) {
            return this._startString();
        }
        if (n3 != 35) {
            if (n3 != 43) {
                if (n3 != 45) {
                    if (n3 != 91) {
                        if (n3 != 102) {
                            if (n3 != 110) {
                                if (n3 != 116) {
                                    if (n3 != 123) {
                                        switch (n3) {
                                            default: {
                                                return this._startUnexpectedValue(false, n3);
                                            }
                                            case 49: 
                                            case 50: 
                                            case 51: 
                                            case 52: 
                                            case 53: 
                                            case 54: 
                                            case 55: 
                                            case 56: 
                                            case 57: {
                                                return this._startPositiveNumber(n3);
                                            }
                                            case 48: {
                                                return this._startNumberLeadingZero();
                                            }
                                            case 47: 
                                        }
                                        return this._startSlashComment(12);
                                    }
                                    return this._startObjectScope();
                                }
                                return this._startTrueToken();
                            }
                            return this._startNullToken();
                        }
                        return this._startFalseToken();
                    }
                    return this._startArrayScope();
                }
                return this._startNegativeNumber();
            }
            return this._startPositiveNumber();
        }
        return this._finishHashComment(12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JsonToken _startValueAfterComma(int n2) {
        if (n2 <= 32 && (n2 = this._skipWS(n2)) <= 0) {
            this._minorState = 15;
            return this._currToken;
        }
        this._updateTokenLocation();
        if (n2 == 34) {
            return this._startString();
        }
        switch (n2) {
            default: {
                switch (n2) {
                    default: {
                        return this._startUnexpectedValue(true, n2);
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        return this._startPositiveNumber(n2);
                    }
                    case 48: {
                        return this._startNumberLeadingZero();
                    }
                    case 47: {
                        return this._startSlashComment(15);
                    }
                }
            }
            case 125: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) return this._startUnexpectedValue(true, n2);
                return this._closeObjectScope();
            }
            case 123: {
                return this._startObjectScope();
            }
            case 116: {
                return this._startTrueToken();
            }
            case 110: {
                return this._startNullToken();
            }
            case 102: {
                return this._startFalseToken();
            }
            case 93: {
                if ((this._features & FEAT_MASK_TRAILING_COMMA) == 0) return this._startUnexpectedValue(true, n2);
                return this._closeArrayScope();
            }
            case 91: {
                return this._startArrayScope();
            }
            case 45: {
                return this._startNegativeNumber();
            }
            case 43: {
                return this._startPositiveNumber();
            }
            case 35: 
        }
        return this._finishHashComment(15);
    }

    private final int _skipWS(int n2) {
        do {
            if (n2 != 32) {
                if (n2 == 10) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRow;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                } else if (n2 == 13) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRowAlt;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                } else if (n2 != 9) {
                    this._throwInvalidSpace(n2);
                }
            }
            if (this._inputPtr < this._inputEnd) continue;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return 0;
        } while ((n2 = this.getNextUnsignedByteFromBuffer()) <= 32);
        return n2;
    }

    private final JsonToken _startSlashComment(int n2) {
        if ((this._features & FEAT_MASK_ALLOW_JAVA_COMMENTS) == 0) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            nonBlockingUtf8JsonParserBase._pending32 = n2;
            nonBlockingUtf8JsonParserBase._minorState = 51;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        byte by = this.getNextSignedByteFromBuffer();
        if (by == 42) {
            return this._finishCComment(n2, false);
        }
        if (by == 47) {
            return this._finishCppComment(n2);
        }
        this._reportUnexpectedChar(by & 0xFF, "was expecting either '*' or '/' for a comment");
        return null;
    }

    private final JsonToken _finishHashComment(int n2) {
        if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) == 0) {
            this._reportUnexpectedChar(35, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_YAML_COMMENTS' not enabled for parser)");
        }
        while (true) {
            int n3;
            block8: {
                block7: {
                    block6: {
                        if (this._inputPtr >= this._inputEnd) {
                            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                            nonBlockingUtf8JsonParserBase._minorState = 55;
                            nonBlockingUtf8JsonParserBase._pending32 = n2;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        n3 = this.getNextUnsignedByteFromBuffer();
                        if (n3 >= 32) continue;
                        if (n3 != 10) break block6;
                        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                        ++nonBlockingUtf8JsonParserBase._currInputRow;
                        nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                        break block7;
                    }
                    if (n3 != 13) break block8;
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRowAlt;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                }
                return this._startAfterComment(n2);
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
    }

    private final JsonToken _finishCppComment(int n2) {
        while (true) {
            int n3;
            block7: {
                block6: {
                    block5: {
                        if (this._inputPtr >= this._inputEnd) {
                            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                            nonBlockingUtf8JsonParserBase._minorState = 54;
                            nonBlockingUtf8JsonParserBase._pending32 = n2;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        n3 = this.getNextUnsignedByteFromBuffer();
                        if (n3 >= 32) continue;
                        if (n3 != 10) break block5;
                        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                        ++nonBlockingUtf8JsonParserBase._currInputRow;
                        nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                        break block6;
                    }
                    if (n3 != 13) break block7;
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRowAlt;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                }
                return this._startAfterComment(n2);
            }
            if (n3 == 9) continue;
            this._throwInvalidSpace(n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JsonToken _finishCComment(int n2, boolean bl) {
        while (true) {
            boolean bl2;
            if (this._inputPtr >= this._inputEnd) {
                void var2_6;
                if (bl2) {
                    int n3 = 52;
                } else {
                    int n4 = 53;
                }
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._minorState = var2_6;
                nonBlockingUtf8JsonParserBase._pending32 = n2;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n5 = this.getNextUnsignedByteFromBuffer();
            if (n5 < 32) {
                if (n5 == 10) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRow;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                } else if (n5 == 13) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    ++nonBlockingUtf8JsonParserBase._currInputRowAlt;
                    nonBlockingUtf8JsonParserBase._currInputRowStart = nonBlockingUtf8JsonParserBase._inputPtr;
                } else if (n5 != 9) {
                    this._throwInvalidSpace(n5);
                }
            } else {
                if (n5 == 42) {
                    bl2 = true;
                    continue;
                }
                if (n5 == 47 && bl2) {
                    return this._startAfterComment(n2);
                }
            }
            bl2 = false;
        }
    }

    private final JsonToken _startAfterComment(int n2) {
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = n2;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = this.getNextUnsignedByteFromBuffer();
        if (n2 != 4) {
            if (n2 != 5) {
                switch (n2) {
                    default: {
                        VersionUtil.throwInternal();
                        return null;
                    }
                    case 15: {
                        return this._startValueAfterComma(n3);
                    }
                    case 14: {
                        return this._startValueExpectColon(n3);
                    }
                    case 13: {
                        return this._startValueExpectComma(n3);
                    }
                    case 12: 
                }
                return this._startValue(n3);
            }
            return this._startFieldNameAfterComma(n3);
        }
        return this._startFieldName(n3);
    }

    private final String _fastParseName() {
        int[] nArray = _icLatin1;
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        int n2 = nonBlockingUtf8JsonParserBase._inputPtr;
        int n3 = n2 + 1;
        int n4 = nonBlockingUtf8JsonParserBase.getByteFromBuffer(n2) & 0xFF;
        if (_icLatin1[n4] == 0) {
            int n5 = n3;
            n3 = n2 + 2;
            int n6 = this.getByteFromBuffer(n5) & 0xFF;
            if (nArray[n6] == 0) {
                int n7 = n3;
                n3 = n4 << 8 | n6;
                n4 = n2 + 3;
                n6 = this.getByteFromBuffer(n7) & 0xFF;
                if (nArray[n6] == 0) {
                    int n8 = n4;
                    n3 = n3 << 8 | n6;
                    n4 = n2 + 4;
                    n6 = this.getByteFromBuffer(n8) & 0xFF;
                    if (nArray[n6] == 0) {
                        int n9 = n3 << 8 | n6;
                        n2 += 5;
                        n3 = this.getByteFromBuffer(n4) & 0xFF;
                        if (nArray[n3] == 0) {
                            this._quad1 = n9;
                            return this._parseMediumName(n2, n3);
                        }
                        if (n3 == 34) {
                            this._inputPtr = n2;
                            return this._findName(n9, 4);
                        }
                        return null;
                    }
                    if (n6 == 34) {
                        this._inputPtr = n4;
                        return this._findName(n3, 3);
                    }
                    return null;
                }
                if (n6 == 34) {
                    this._inputPtr = n4;
                    return this._findName(n3, 2);
                }
                return null;
            }
            if (n6 == 34) {
                this._inputPtr = n3;
                return this._findName(n4, 1);
            }
            return null;
        }
        if (n4 == 34) {
            this._inputPtr = n3;
            return "";
        }
        return null;
    }

    private final String _parseMediumName(int n2, int n3) {
        int[] nArray = _icLatin1;
        int n4 = n2;
        int n5 = n4 + 1;
        int n6 = this.getByteFromBuffer(n4) & 0xFF;
        if (_icLatin1[n6] == 0) {
            int n7 = n5;
            n3 = n3 << 8 | n6;
            n5 = n2 + 2;
            n6 = this.getByteFromBuffer(n7) & 0xFF;
            if (nArray[n6] == 0) {
                int n8 = n5;
                n3 = n3 << 8 | n6;
                n5 = n2 + 3;
                n6 = this.getByteFromBuffer(n8) & 0xFF;
                if (nArray[n6] == 0) {
                    n3 = n3 << 8 | n6;
                    n2 += 4;
                    int n9 = this.getByteFromBuffer(n5) & 0xFF;
                    if (nArray[n9] == 0) {
                        return this._parseMediumName2(n2, n9, n3);
                    }
                    if (n9 == 34) {
                        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                        nonBlockingUtf8JsonParserBase._inputPtr = n2;
                        return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n3, 4);
                    }
                    return null;
                }
                if (n6 == 34) {
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    nonBlockingUtf8JsonParserBase._inputPtr = n5;
                    return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n3, 3);
                }
                return null;
            }
            if (n6 == 34) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._inputPtr = n5;
                return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n3, 2);
            }
            return null;
        }
        if (n6 == 34) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            nonBlockingUtf8JsonParserBase._inputPtr = n5;
            return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n3, 1);
        }
        return null;
    }

    private final String _parseMediumName2(int n2, int n3, int n4) {
        int[] nArray = _icLatin1;
        int n5 = n2;
        int n6 = n5 + 1;
        int n7 = this.getByteFromBuffer(n5) & 0xFF;
        if (_icLatin1[n7] != 0) {
            if (n7 == 34) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._inputPtr = n6;
                return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n4, n3, 1);
            }
            return null;
        }
        int n8 = n6;
        n3 = n3 << 8 | n7;
        n6 = n2 + 2;
        n7 = this.getByteFromBuffer(n8) & 0xFF;
        if (nArray[n7] != 0) {
            if (n7 == 34) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._inputPtr = n6;
                return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n4, n3, 2);
            }
            return null;
        }
        n3 = n3 << 8 | n7;
        int n9 = n2 + 3;
        if (nArray[n6 = this.getByteFromBuffer(n6) & 0xFF] != 0) {
            if (n6 == 34) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._inputPtr = n9;
                return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n4, n3, 3);
            }
            return null;
        }
        n3 = n3 << 8 | n6;
        n2 += 4;
        if ((this.getByteFromBuffer(n9) & 0xFF) == 34) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            nonBlockingUtf8JsonParserBase._inputPtr = n2;
            return nonBlockingUtf8JsonParserBase._findName(nonBlockingUtf8JsonParserBase._quad1, n4, n3, 4);
        }
        return null;
    }

    private final JsonToken _parseEscapedName(int n2, int n3, int n4) {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n2;
                this._pending32 = n3;
                this._pendingBytes = n4;
                this._minorState = 7;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n5 = this.getNextUnsignedByteFromBuffer();
            if (nArray2[n5] == 0) {
                if (n4 < 4) {
                    ++n4;
                    n3 = n3 << 8 | n5;
                    continue;
                }
                if (n2 >= nArray.length) {
                    int[] nArray3 = ParserBase.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray3;
                    nArray = nArray3;
                }
                n4 = n2 + 1;
                nArray[n2] = n3;
                n2 = 1;
                int n6 = n4;
                n4 = n2;
                n3 = n5;
                n2 = n6;
                continue;
            }
            if (n5 == 34) {
                if (n4 > 0) {
                    if (n2 >= nArray.length) {
                        this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
                    }
                    int n7 = n3;
                    n3 = n2 + 1;
                    nArray[n2] = NonBlockingJsonParserBase._padLastQuad(n7, n4);
                    n2 = n3;
                } else if (n2 == 0) {
                    return this._fieldComplete("");
                }
                String string = this._symbols.findName(nArray, n2);
                if (string == null) {
                    string = this._addName(nArray, n2, n4);
                }
                return this._fieldComplete(string);
            }
            if (n5 != 92) {
                this._throwUnquotedSpace(n5, "name");
            } else {
                n5 = this._decodeCharEscape();
                if (n5 < 0) {
                    this._minorState = 8;
                    this._minorStateAfterSplit = 7;
                    this._quadLength = n2;
                    this._pending32 = n3;
                    this._pendingBytes = n4;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
            }
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
            }
            if (n5 > 127) {
                if (n4 >= 4) {
                    n4 = n2 + 1;
                    nArray[n2] = n3;
                    n3 = 0;
                    int n8 = n2 = 0;
                    n2 = n4;
                    n4 = n8;
                }
                if (n5 < 2048) {
                    n3 = n3 << 8 | (n5 >> 6 | 0xC0);
                } else {
                    n3 = n3 << 8 | (n5 >> 12 | 0xE0);
                    if (++n4 >= 4) {
                        n4 = n2 + 1;
                        nArray[n2] = n3;
                        n3 = 0;
                        int n9 = n2 = 0;
                        n2 = n4;
                        n4 = n9;
                    }
                    n3 = n3 << 8 | (n5 >> 6 & 0x3F | 0x80);
                    ++n4;
                }
                n5 = n5 & 0x3F | 0x80;
                int n10 = ++n4;
                n4 = n5;
                n5 = n10;
            } else {
                int n11 = n4;
                n4 = n5;
                n5 = n11;
            }
            if (n5 < 4) {
                int n12 = n3;
                n3 = n5 + 1;
                int n13 = n4 = n12 << 8 | n4;
                n4 = n3;
                n3 = n13;
                continue;
            }
            n5 = n2 + 1;
            nArray[n2] = n3;
            n2 = 1;
            int n14 = n4;
            n4 = n2;
            n3 = n14;
            n2 = n5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JsonToken _handleOddName(int n2) {
        if (n2 != 35) {
            if (n2 != 39) {
                if (n2 == 47) return this._startSlashComment(4);
                if (n2 == 93) {
                    return this._closeArrayScope();
                }
            } else if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
                return this._finishAposName(0, 0, 0);
            }
        } else if ((this._features & FEAT_MASK_ALLOW_YAML_COMMENTS) != 0) {
            return this._finishHashComment(4);
        }
        if ((this._features & FEAT_MASK_ALLOW_UNQUOTED_NAMES) == 0) {
            this._reportUnexpectedChar((char)n2, "was expecting double-quote to start field name");
        }
        if (CharTypes.getInputCodeUtf8JsNames()[n2] == 0) return this._finishUnquotedName(0, n2, 1);
        this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        return this._finishUnquotedName(0, n2, 1);
    }

    private JsonToken _finishUnquotedName(int n2, int n3, int n4) {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = CharTypes.getInputCodeUtf8JsNames();
        while (true) {
            int n5;
            if ((n5 = this._inputPtr) >= this._inputEnd) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._quadLength = n2;
                nonBlockingUtf8JsonParserBase._pending32 = n3;
                nonBlockingUtf8JsonParserBase._pendingBytes = n4;
                nonBlockingUtf8JsonParserBase._minorState = 10;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (nArray2[n5 = this.getByteFromBuffer(n5) & 0xFF] != 0) {
                String string;
                if (n4 > 0) {
                    if (n2 >= nArray.length) {
                        this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
                    }
                    int n6 = n2 + 1;
                    nArray[n2] = n3;
                    n2 = n6;
                }
                if ((string = this._symbols.findName(nArray, n2)) == null) {
                    string = this._addName(nArray, n2, n4);
                }
                return this._fieldComplete(string);
            }
            ++this._inputPtr;
            if (n4 < 4) {
                int n7 = n3;
                n3 = n4 + 1;
                int n8 = n4 = n7 << 8 | n5;
                n4 = n3;
                n3 = n8;
                continue;
            }
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
            }
            n4 = n2 + 1;
            nArray[n2] = n3;
            n2 = 1;
            int n9 = n4;
            n4 = n2;
            n3 = n5;
            n2 = n9;
        }
    }

    private JsonToken _finishAposName(int n2, int n3, int n4) {
        int[] nArray = this._quadBuffer;
        int[] nArray2 = _icLatin1;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._quadLength = n2;
                this._pending32 = n3;
                this._pendingBytes = n4;
                this._minorState = 9;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            int n5 = this.getNextUnsignedByteFromBuffer();
            if (n5 == 39) {
                if (n4 > 0) {
                    if (n2 >= nArray.length) {
                        this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
                    }
                    int n6 = n3;
                    n3 = n2 + 1;
                    nArray[n2] = NonBlockingJsonParserBase._padLastQuad(n6, n4);
                    n2 = n3;
                } else if (n2 == 0) {
                    return this._fieldComplete("");
                }
                String string = this._symbols.findName(nArray, n2);
                if (string == null) {
                    string = this._addName(nArray, n2, n4);
                }
                return this._fieldComplete(string);
            }
            if (n5 != 34 && nArray2[n5] != 0) {
                if (n5 != 92) {
                    this._throwUnquotedSpace(n5, "name");
                } else {
                    n5 = this._decodeCharEscape();
                    if (n5 < 0) {
                        this._minorState = 8;
                        this._minorStateAfterSplit = 9;
                        this._quadLength = n2;
                        this._pending32 = n3;
                        this._pendingBytes = n4;
                        this._currToken = JsonToken.NOT_AVAILABLE;
                        return this._currToken;
                    }
                }
                if (n5 > 127) {
                    if (n4 >= 4) {
                        if (n2 >= nArray.length) {
                            this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
                        }
                        n4 = n2 + 1;
                        nArray[n2] = n3;
                        n3 = 0;
                        int n7 = n2 = 0;
                        n2 = n4;
                        n4 = n7;
                    }
                    if (n5 < 2048) {
                        n3 = n3 << 8 | (n5 >> 6 | 0xC0);
                        ++n4;
                    } else {
                        n3 = n3 << 8 | (n5 >> 12 | 0xE0);
                        if (++n4 >= 4) {
                            if (n2 >= nArray.length) {
                                this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
                            }
                            n4 = n2 + 1;
                            nArray[n2] = n3;
                            n3 = 0;
                            int n8 = n2 = 0;
                            n2 = n4;
                            n4 = n8;
                        }
                        n3 = n3 << 8 | (n5 >> 6 & 0x3F | 0x80);
                        ++n4;
                    }
                    n5 = n5 & 0x3F | 0x80;
                }
            }
            if (n4 < 4) {
                int n9 = n3;
                n3 = n4 + 1;
                int n10 = n4 = n9 << 8 | n5;
                n4 = n3;
                n3 = n10;
                continue;
            }
            if (n2 >= nArray.length) {
                this._quadBuffer = nArray = ParserBase.growArrayBy(nArray, nArray.length);
            }
            n4 = n2 + 1;
            nArray[n2] = n3;
            n2 = 1;
            int n11 = n4;
            n4 = n2;
            n3 = n5;
            n2 = n11;
        }
    }

    private int _decodeSplitEscaped(int n2, int n3) {
        if (this._inputPtr >= this._inputEnd) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            nonBlockingUtf8JsonParserBase._quoted32 = n2;
            nonBlockingUtf8JsonParserBase._quotedDigits = n3;
            return -1;
        }
        int n4 = this.getNextSignedByteFromBuffer();
        if (n3 == -1) {
            switch (n4) {
                default: {
                    return this._handleUnrecognizedCharacterEscape((char)n4);
                }
                case 117: {
                    if (this._inputPtr >= this._inputEnd) {
                        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                        nonBlockingUtf8JsonParserBase._quotedDigits = 0;
                        nonBlockingUtf8JsonParserBase._quoted32 = 0;
                        return -1;
                    }
                    n4 = this.getNextSignedByteFromBuffer();
                    n3 = 0;
                    break;
                }
                case 116: {
                    return 9;
                }
                case 114: {
                    return 13;
                }
                case 110: {
                    return 10;
                }
                case 102: {
                    return 12;
                }
                case 98: {
                    return 8;
                }
                case 34: 
                case 47: 
                case 92: {
                    return n4;
                }
            }
        }
        n4 &= 0xFF;
        while (true) {
            int n5;
            if ((n5 = CharTypes.charToHex(n4)) < 0) {
                this._reportUnexpectedChar(n4 & 0xFF, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n5;
            if (++n3 == 4) {
                return n2;
            }
            if (this._inputPtr >= this._inputEnd) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._quotedDigits = n3;
                nonBlockingUtf8JsonParserBase._quoted32 = n2;
                return -1;
            }
            n4 = this.getNextUnsignedByteFromBuffer();
        }
    }

    private final JsonToken _finishRegularString() {
        int[] nArray = _icUTF8;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int n3 = this._inputPtr;
        int n4 = this._inputEnd - 5;
        block6: while (true) {
            if (n3 >= this._inputEnd) {
                this._inputPtr = n3;
                this._minorState = 40;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n5 = Math.min(this._inputEnd, cArray.length - n2 + n3);
            while (true) {
                if (n3 >= n5) continue block6;
                int n6 = n3 + 1;
                int n7 = this.getByteFromBuffer(n3) & 0xFF;
                int n8 = nArray[n7];
                if (n8 != 0) {
                    if (n7 == 34) {
                        this._inputPtr = n6;
                        this._textBuffer.setCurrentLength(n2);
                        return this._valueComplete(JsonToken.VALUE_STRING);
                    }
                    if (n6 >= n4) {
                        this._inputPtr = n6;
                        this._textBuffer.setCurrentLength(n2);
                        int n9 = nArray[n7];
                        n2 = n6 < this._inputEnd ? 1 : 0;
                        if (!this._decodeSplitMultiByte(n7, n9, n2 != 0)) {
                            this._minorStateAfterSplit = 40;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        cArray = this._textBuffer.getBufferWithoutReset();
                        n2 = this._textBuffer.getCurrentSegmentSize();
                        n3 = this._inputPtr;
                        continue block6;
                    }
                    switch (n8) {
                        default: {
                            if (n7 < 32) {
                                this._throwUnquotedSpace(n7, "string value");
                            } else {
                                this._reportInvalidChar(n7);
                            }
                            n3 = n6;
                            break;
                        }
                        case 4: {
                            n5 = n3 + 2;
                            n6 = this.getByteFromBuffer(n6);
                            int n10 = n3 + 3;
                            n5 = this.getByteFromBuffer(n5);
                            n3 += 4;
                            n8 = this.getByteFromBuffer(n10);
                            n5 = this._decodeUTF8_4(n7, n6, n5, n8);
                            n6 = n2 + 1;
                            cArray[n2] = (char)(n5 >> 10 | 0xD800);
                            if (n6 >= cArray.length) {
                                cArray = this._textBuffer.finishCurrentSegment();
                                n2 = 0;
                            } else {
                                n2 = n6;
                            }
                            n7 = n5 & 0x3FF | 0xDC00;
                            break;
                        }
                        case 3: {
                            int n11 = n3 + 2;
                            n5 = this.getByteFromBuffer(n6);
                            n3 += 3;
                            n6 = this.getByteFromBuffer(n11);
                            n7 = this._decodeUTF8_3(n7, n5, n6);
                            break;
                        }
                        case 2: {
                            n3 += 2;
                            n5 = this.getByteFromBuffer(n6);
                            n7 = this._decodeUTF8_2(n7, n5);
                            break;
                        }
                        case 1: {
                            this._inputPtr = n6;
                            n7 = this._decodeFastCharEscape();
                            n3 = this._inputPtr;
                        }
                    }
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n5 = n2 + 1;
                    cArray[n2] = (char)n7;
                    n2 = n5;
                    continue block6;
                }
                n3 = n2 + 1;
                cArray[n2] = (char)n7;
                n2 = n3;
                n3 = n6;
            }
            break;
        }
    }

    private final JsonToken _finishAposString() {
        int[] nArray = _icUTF8;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        int n3 = this._inputPtr;
        int n4 = this._inputEnd - 5;
        block6: while (true) {
            if (n3 >= this._inputEnd) {
                this._inputPtr = n3;
                this._minorState = 45;
                this._textBuffer.setCurrentLength(n2);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            int n5 = Math.min(this._inputEnd, cArray.length - n2 + n3);
            while (true) {
                if (n3 >= n5) continue block6;
                int n6 = n3 + 1;
                int n7 = this.getByteFromBuffer(n3) & 0xFF;
                int n8 = nArray[n7];
                if (n8 != 0 && n7 != 34) {
                    if (n6 >= n4) {
                        this._inputPtr = n6;
                        this._textBuffer.setCurrentLength(n2);
                        int n9 = nArray[n7];
                        n2 = n6 < this._inputEnd ? 1 : 0;
                        if (!this._decodeSplitMultiByte(n7, n9, n2 != 0)) {
                            this._minorStateAfterSplit = 45;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        cArray = this._textBuffer.getBufferWithoutReset();
                        n2 = this._textBuffer.getCurrentSegmentSize();
                        n3 = this._inputPtr;
                        continue block6;
                    }
                    switch (n8) {
                        default: {
                            if (n7 < 32) {
                                this._throwUnquotedSpace(n7, "string value");
                            } else {
                                this._reportInvalidChar(n7);
                            }
                            n3 = n6;
                            break;
                        }
                        case 4: {
                            n5 = n3 + 2;
                            n6 = this.getByteFromBuffer(n6);
                            int n10 = n3 + 3;
                            n5 = this.getByteFromBuffer(n5);
                            n3 += 4;
                            n8 = this.getByteFromBuffer(n10);
                            n5 = this._decodeUTF8_4(n7, n6, n5, n8);
                            n6 = n2 + 1;
                            cArray[n2] = (char)(n5 >> 10 | 0xD800);
                            if (n6 >= cArray.length) {
                                cArray = this._textBuffer.finishCurrentSegment();
                                n2 = 0;
                            } else {
                                n2 = n6;
                            }
                            n7 = n5 & 0x3FF | 0xDC00;
                            break;
                        }
                        case 3: {
                            int n11 = n3 + 2;
                            n5 = this.getByteFromBuffer(n6);
                            n3 += 3;
                            n6 = this.getByteFromBuffer(n11);
                            n7 = this._decodeUTF8_3(n7, n5, n6);
                            break;
                        }
                        case 2: {
                            n3 += 2;
                            n5 = this.getByteFromBuffer(n6);
                            n7 = this._decodeUTF8_2(n7, n5);
                            break;
                        }
                        case 1: {
                            this._inputPtr = n6;
                            n7 = this._decodeFastCharEscape();
                            n3 = this._inputPtr;
                        }
                    }
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n5 = n2 + 1;
                    cArray[n2] = (char)n7;
                    n2 = n5;
                    continue block6;
                }
                if (n7 == 39) {
                    this._inputPtr = n6;
                    this._textBuffer.setCurrentLength(n2);
                    return this._valueComplete(JsonToken.VALUE_STRING);
                }
                n3 = n2 + 1;
                cArray[n2] = (char)n7;
                n2 = n3;
                n3 = n6;
            }
            break;
        }
    }

    private final boolean _decodeSplitMultiByte(int n2, int n3, boolean bl) {
        switch (n3) {
            default: {
                if (n2 < 32) {
                    this._throwUnquotedSpace(n2, "string value");
                } else {
                    this._reportInvalidChar(n2);
                }
                this._textBuffer.append((char)n2);
                return true;
            }
            case 4: {
                n2 &= 7;
                if (bl) {
                    n3 = this.getNextSignedByteFromBuffer();
                    return this._decodeSplitUTF8_4(n2, 1, n3);
                }
                this._pending32 = n2;
                this._pendingBytes = 1;
                this._minorState = 44;
                return false;
            }
            case 3: {
                n2 &= 0xF;
                if (bl) {
                    n3 = this.getNextSignedByteFromBuffer();
                    return this._decodeSplitUTF8_3(n2, 1, n3);
                }
                this._minorState = 43;
                this._pending32 = n2;
                this._pendingBytes = 1;
                return false;
            }
            case 2: {
                if (bl) {
                    n3 = this.getNextSignedByteFromBuffer();
                    this._textBuffer.append((char)this._decodeUTF8_2(n2, n3));
                    return true;
                }
                this._minorState = 42;
                this._pending32 = n2;
                return false;
            }
            case 1: 
        }
        n2 = this._decodeSplitEscaped(0, -1);
        if (n2 < 0) {
            this._minorState = 41;
            return false;
        }
        this._textBuffer.append((char)n2);
        return true;
    }

    private final boolean _decodeSplitUTF8_3(int n2, int n3, int n4) {
        if (n3 == 1) {
            if ((n4 & 0xC0) != 128) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                n3 = n4 & 0xFF;
                nonBlockingUtf8JsonParserBase._reportInvalidOther(n3, nonBlockingUtf8JsonParserBase._inputPtr);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._minorState = 43;
                nonBlockingUtf8JsonParserBase._pending32 = n2;
                nonBlockingUtf8JsonParserBase._pendingBytes = 2;
                return false;
            }
            n4 = this.getNextSignedByteFromBuffer();
        }
        if ((n4 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            n3 = n4 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n3, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        this._textBuffer.append((char)(n2 << 6 | n4 & 0x3F));
        return true;
    }

    private final boolean _decodeSplitUTF8_4(int n2, int n3, int n4) {
        if (n3 == 1) {
            if ((n4 & 0xC0) != 128) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                n3 = n4 & 0xFF;
                nonBlockingUtf8JsonParserBase._reportInvalidOther(n3, nonBlockingUtf8JsonParserBase._inputPtr);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._minorState = 44;
                nonBlockingUtf8JsonParserBase._pending32 = n2;
                nonBlockingUtf8JsonParserBase._pendingBytes = 2;
                return false;
            }
            n3 = 2;
            n4 = this.getNextSignedByteFromBuffer();
        }
        if (n3 == 2) {
            if ((n4 & 0xC0) != 128) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                n3 = n4 & 0xFF;
                nonBlockingUtf8JsonParserBase._reportInvalidOther(n3, nonBlockingUtf8JsonParserBase._inputPtr);
            }
            n2 = n2 << 6 | n4 & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._minorState = 44;
                nonBlockingUtf8JsonParserBase._pending32 = n2;
                nonBlockingUtf8JsonParserBase._pendingBytes = 3;
                return false;
            }
            n4 = this.getNextSignedByteFromBuffer();
        }
        if ((n4 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            n3 = n4 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n3, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        int n5 = (n2 << 6 | n4 & 0x3F) - 65536;
        this._textBuffer.append((char)(n5 >> 10 | 0xD800));
        int n6 = n5 & 0x3FF | 0xDC00;
        this._textBuffer.append((char)n6);
        return true;
    }

    private final int _decodeCharEscape() {
        if (this._inputEnd - this._inputPtr < 5) {
            return this._decodeSplitEscaped(0, -1);
        }
        return this._decodeFastCharEscape();
    }

    private final int _decodeFastCharEscape() {
        int n2 = this.getNextSignedByteFromBuffer();
        switch (n2) {
            default: {
                return this._handleUnrecognizedCharacterEscape((char)n2);
            }
            case 117: {
                int n3;
                n2 = this.getNextSignedByteFromBuffer();
                int n4 = CharTypes.charToHex(n2);
                if (n4 >= 0 && (n3 = CharTypes.charToHex(n2 = this.getNextSignedByteFromBuffer())) >= 0) {
                    n2 = n4 << 4 | n3;
                    byte by = this.getNextSignedByteFromBuffer();
                    n4 = by;
                    n3 = CharTypes.charToHex(by);
                    if (n3 >= 0) {
                        n2 = n2 << 4 | n3;
                        byte by2 = this.getNextSignedByteFromBuffer();
                        n4 = by2;
                        n3 = CharTypes.charToHex(by2);
                        if (n3 >= 0) {
                            return n2 << 4 | n3;
                        }
                    }
                    n2 = n4;
                }
                this._reportUnexpectedChar(n2 & 0xFF, "expected a hex-digit for character escape sequence");
                return -1;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 110: {
                return 10;
            }
            case 102: {
                return 12;
            }
            case 98: {
                return 8;
            }
            case 34: 
            case 47: 
            case 92: 
        }
        return (char)n2;
    }

    private final int _decodeUTF8_2(int n2, int n3) {
        if ((n3 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            int n4 = n3 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n4, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        return (n2 & 0x1F) << 6 | n3 & 0x3F;
    }

    private final int _decodeUTF8_3(int n2, int n3, int n4) {
        n2 &= 0xF;
        if ((n3 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            int n5 = n3 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n5, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        n2 = n2 << 6 | n3 & 0x3F;
        if ((n4 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            int n6 = n4 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n6, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        return n2 << 6 | n4 & 0x3F;
    }

    private final int _decodeUTF8_4(int n2, int n3, int n4, int n5) {
        if ((n3 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            int n6 = n3 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n6, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        n2 = (n2 & 7) << 6 | n3 & 0x3F;
        if ((n4 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            n3 = n4 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n3, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        n2 = n2 << 6 | n4 & 0x3F;
        if ((n5 & 0xC0) != 128) {
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            int n7 = n5 & 0xFF;
            nonBlockingUtf8JsonParserBase._reportInvalidOther(n7, nonBlockingUtf8JsonParserBase._inputPtr);
        }
        return (n2 << 6 | n5 & 0x3F) - 65536;
    }

    public final boolean needMoreInput() {
        return this._inputPtr >= this._inputEnd && !this._endOfInput;
    }

    public void endOfInput() {
        this._endOfInput = true;
    }

    @Override
    public char _decodeEscaped() {
        VersionUtil.throwInternal();
        return ' ';
    }

    @Override
    public JsonToken nextToken() {
        long l2;
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            if (this._closed) {
                return null;
            }
            if (this._endOfInput) {
                if (this._currToken == JsonToken.NOT_AVAILABLE) {
                    return this._finishTokenWithEOF();
                }
                return this._eofAsNextToken();
            }
            return JsonToken.NOT_AVAILABLE;
        }
        if (this._currToken == JsonToken.NOT_AVAILABLE) {
            return this._finishToken();
        }
        this._numTypesValid = 0;
        this._tokenInputTotal = l2 = this._currInputProcessed + (long)n2;
        this._binaryValue = null;
        int n3 = this.getNextUnsignedByteFromBuffer();
        switch (this._majorState) {
            default: {
                VersionUtil.throwInternal();
                return null;
            }
            case 6: {
                return this._startValueExpectComma(n3);
            }
            case 5: {
                return this._startValue(n3);
            }
            case 4: {
                return this._startValueExpectColon(n3);
            }
            case 3: {
                return this._startFieldNameAfterComma(n3);
            }
            case 2: {
                return this._startFieldName(n3);
            }
            case 1: {
                return this._startValue(n3);
            }
            case 0: 
        }
        return this._startDocument(n3);
    }

    public abstract byte getNextSignedByteFromBuffer();

    public abstract int getNextUnsignedByteFromBuffer();

    public abstract byte getByteFromBuffer(int var1);

    public final JsonToken _finishToken() {
        switch (this._minorState) {
            default: {
                VersionUtil.throwInternal();
                return null;
            }
            case 55: {
                return this._finishHashComment(this._pending32);
            }
            case 54: {
                return this._finishCppComment(this._pending32);
            }
            case 53: {
                return this._finishCComment(this._pending32, false);
            }
            case 52: {
                return this._finishCComment(this._pending32, true);
            }
            case 51: {
                return this._startSlashComment(this._pending32);
            }
            case 50: {
                return this._finishErrorToken();
            }
            case 45: {
                return this._finishAposString();
            }
            case 44: {
                int n2 = this._pendingBytes;
                byte by = this.getNextSignedByteFromBuffer();
                if (!this._decodeSplitUTF8_4(this._pending32, n2, by)) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 43: {
                int n3 = this._pendingBytes;
                byte by = this.getNextSignedByteFromBuffer();
                if (!this._decodeSplitUTF8_3(this._pending32, n3, by)) {
                    return JsonToken.NOT_AVAILABLE;
                }
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 42: {
                byte by = this.getNextSignedByteFromBuffer();
                this._textBuffer.append((char)this._decodeUTF8_2(this._pending32, by));
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 41: {
                int n4 = this._quotedDigits;
                n4 = this._decodeSplitEscaped(this._quoted32, n4);
                if (n4 < 0) {
                    return JsonToken.NOT_AVAILABLE;
                }
                this._textBuffer.append((char)n4);
                if (this._minorStateAfterSplit == 45) {
                    return this._finishAposString();
                }
                return this._finishRegularString();
            }
            case 40: {
                return this._finishRegularString();
            }
            case 32: {
                int n5 = this.getNextUnsignedByteFromBuffer();
                return this._finishFloatExponent(false, n5);
            }
            case 31: {
                int n6 = this.getNextUnsignedByteFromBuffer();
                return this._finishFloatExponent(true, n6);
            }
            case 30: {
                return this._finishFloatFraction();
            }
            case 26: {
                int n7 = this._textBuffer.getCurrentSegmentSize();
                return this._finishNumberIntegralPart(this._textBuffer.getBufferWithoutReset(), n7);
            }
            case 25: {
                return this._finishNumberLeadingNegZeroes();
            }
            case 24: {
                return this._finishNumberLeadingZeroes();
            }
            case 23: {
                return this._finishNumberMinus(this.getNextUnsignedByteFromBuffer());
            }
            case 22: {
                return this._finishNumberPlus(this.getNextUnsignedByteFromBuffer());
            }
            case 19: {
                int n8 = this._pending32;
                return this._finishNonStdToken(this._nonStdTokenType, n8);
            }
            case 18: {
                int n9 = this._pending32;
                JsonToken jsonToken = JsonToken.VALUE_FALSE;
                return this._finishKeywordToken("false", n9, jsonToken);
            }
            case 17: {
                int n10 = this._pending32;
                JsonToken jsonToken = JsonToken.VALUE_TRUE;
                return this._finishKeywordToken("true", n10, jsonToken);
            }
            case 16: {
                int n11 = this._pending32;
                JsonToken jsonToken = JsonToken.VALUE_NULL;
                return this._finishKeywordToken("null", n11, jsonToken);
            }
            case 15: {
                return this._startValueAfterComma(this.getNextUnsignedByteFromBuffer());
            }
            case 14: {
                return this._startValueExpectColon(this.getNextUnsignedByteFromBuffer());
            }
            case 13: {
                return this._startValueExpectComma(this.getNextUnsignedByteFromBuffer());
            }
            case 12: {
                return this._startValue(this.getNextUnsignedByteFromBuffer());
            }
            case 10: {
                int n12 = this._pending32;
                int n13 = this._pendingBytes;
                return this._finishUnquotedName(this._quadLength, n12, n13);
            }
            case 9: {
                int n14 = this._pending32;
                int n15 = this._pendingBytes;
                return this._finishAposName(this._quadLength, n14, n15);
            }
            case 8: {
                return this._finishFieldWithEscape();
            }
            case 7: {
                int n16 = this._pending32;
                int n17 = this._pendingBytes;
                return this._parseEscapedName(this._quadLength, n16, n17);
            }
            case 5: {
                return this._startFieldNameAfterComma(this.getNextUnsignedByteFromBuffer());
            }
            case 4: {
                return this._startFieldName(this.getNextUnsignedByteFromBuffer());
            }
            case 1: 
        }
        return this._finishBOM(this._pending32);
    }

    public final JsonToken _finishTokenWithEOF() {
        JsonToken jsonToken = this._currToken;
        switch (this._minorState) {
            default: {
                JsonToken jsonToken2 = jsonToken;
                jsonToken = this._currToken;
                this._reportInvalidEOF(": was expecting rest of token (internal state: " + this._minorState + ")", jsonToken);
                return jsonToken2;
            }
            case 50: {
                return this._finishErrorTokenWithEOF();
            }
            case 31: {
                jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                this._reportInvalidEOF(": was expecting fraction after exponent marker", jsonToken);
            }
            case 52: 
            case 53: {
                jsonToken = JsonToken.NOT_AVAILABLE;
                this._reportInvalidEOF(": was expecting closing '*/' for comment", jsonToken);
            }
            case 54: 
            case 55: {
                return this._eofAsNextToken();
            }
            case 30: {
                this._expLength = 0;
            }
            case 32: {
                return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
            }
            case 26: {
                int n2 = this._textBuffer.getCurrentSegmentSize();
                if (this._numberNegative) {
                    --n2;
                }
                this._intLength = n2;
                return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
            }
            case 24: 
            case 25: {
                return this._valueCompleteInt(0, "0");
            }
            case 19: {
                int n3 = this._pending32;
                return this._finishNonStdTokenWithEOF(this._nonStdTokenType, n3);
            }
            case 18: {
                int n4 = this._pending32;
                JsonToken jsonToken3 = JsonToken.VALUE_FALSE;
                return this._finishKeywordTokenWithEOF("false", n4, jsonToken3);
            }
            case 17: {
                int n5 = this._pending32;
                JsonToken jsonToken4 = JsonToken.VALUE_TRUE;
                return this._finishKeywordTokenWithEOF("true", n5, jsonToken4);
            }
            case 16: {
                int n6 = this._pending32;
                JsonToken jsonToken5 = JsonToken.VALUE_NULL;
                return this._finishKeywordTokenWithEOF("null", n6, jsonToken5);
            }
            case 12: {
                return this._eofAsNextToken();
            }
            case 3: 
        }
        return this._eofAsNextToken();
    }

    public JsonToken _startUnexpectedValue(boolean bl, int n2) {
        block8: {
            block4: {
                block5: {
                    block6: {
                        block10: {
                            block7: {
                                block9: {
                                    if (n2 == 39) break block4;
                                    if (n2 == 73) break block5;
                                    if (n2 == 78) break block6;
                                    if (n2 == 93) break block7;
                                    if (n2 == 125) break block8;
                                    if (n2 == 43) break block9;
                                    if (n2 == 44) break block10;
                                    break block8;
                                }
                                return this._finishNonStdToken(2, 1);
                            }
                            if (!this._parsingContext.inArray()) break block8;
                        }
                        if (!this._parsingContext.inRoot() && (this._features & FEAT_MASK_ALLOW_MISSING) != 0) {
                            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                            --nonBlockingUtf8JsonParserBase._inputPtr;
                            return nonBlockingUtf8JsonParserBase._valueComplete(JsonToken.VALUE_NULL);
                        }
                        break block8;
                    }
                    return this._finishNonStdToken(0, 1);
                }
                return this._finishNonStdToken(1, 1);
            }
            if ((this._features & FEAT_MASK_ALLOW_SINGLE_QUOTES) != 0) {
                return this._startAposString();
            }
        }
        this._reportUnexpectedChar(n2, "expected a valid value " + this._validJsonValueList());
        return null;
    }

    public JsonToken _startFalseToken() {
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase;
        int n2 = ((ParserBase)((Object)jsonToken))._inputPtr;
        if (n2 + 4 < ((ParserBase)((Object)jsonToken))._inputEnd) {
            int n3 = n2;
            int n4 = n3 + 1;
            if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n3) == 97) {
                int n5 = n4;
                n4 = n2 + 2;
                if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n5) == 108) {
                    int n6 = n4;
                    n4 = n2 + 3;
                    if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n6) == 115 && ((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n4) == 101 && ((n4 = ((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n2 += 4) & 0xFF) < 48 || n4 == 93 || n4 == 125)) {
                        ((ParserBase)((Object)jsonToken))._inputPtr = n2;
                        return ((NonBlockingJsonParserBase)((Object)jsonToken))._valueComplete(JsonToken.VALUE_FALSE);
                    }
                }
            }
        }
        ((NonBlockingJsonParserBase)((Object)jsonToken))._minorState = 18;
        JsonToken jsonToken = JsonToken.VALUE_FALSE;
        return nonBlockingUtf8JsonParserBase._finishKeywordToken("false", 1, jsonToken);
    }

    public JsonToken _startTrueToken() {
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase;
        int n2 = ((ParserBase)((Object)jsonToken))._inputPtr;
        if (n2 + 3 < ((ParserBase)((Object)jsonToken))._inputEnd) {
            int n3 = n2;
            int n4 = n3 + 1;
            if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n3) == 114) {
                int n5 = n4;
                n4 = n2 + 2;
                if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n5) == 117 && ((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n4) == 101 && ((n4 = ((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n2 += 3) & 0xFF) < 48 || n4 == 93 || n4 == 125)) {
                    ((ParserBase)((Object)jsonToken))._inputPtr = n2;
                    return ((NonBlockingJsonParserBase)((Object)jsonToken))._valueComplete(JsonToken.VALUE_TRUE);
                }
            }
        }
        ((NonBlockingJsonParserBase)((Object)jsonToken))._minorState = 17;
        JsonToken jsonToken = JsonToken.VALUE_TRUE;
        return nonBlockingUtf8JsonParserBase._finishKeywordToken("true", 1, jsonToken);
    }

    public JsonToken _startNullToken() {
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase;
        int n2 = ((ParserBase)((Object)jsonToken))._inputPtr;
        if (n2 + 3 < ((ParserBase)((Object)jsonToken))._inputEnd) {
            int n3 = n2;
            int n4 = n3 + 1;
            if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n3) == 117) {
                int n5 = n4;
                n4 = n2 + 2;
                if (((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n5) == 108 && ((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n4) == 108 && ((n4 = ((NonBlockingUtf8JsonParserBase)((Object)jsonToken)).getByteFromBuffer(n2 += 3) & 0xFF) < 48 || n4 == 93 || n4 == 125)) {
                    ((ParserBase)((Object)jsonToken))._inputPtr = n2;
                    return ((NonBlockingJsonParserBase)((Object)jsonToken))._valueComplete(JsonToken.VALUE_NULL);
                }
            }
        }
        ((NonBlockingJsonParserBase)((Object)jsonToken))._minorState = 16;
        JsonToken jsonToken = JsonToken.VALUE_NULL;
        return nonBlockingUtf8JsonParserBase._finishKeywordToken("null", 1, jsonToken);
    }

    public JsonToken _finishKeywordToken(String string, int n2, JsonToken jsonToken) {
        int n3 = string.length();
        while (true) {
            block9: {
                block8: {
                    int n4;
                    block7: {
                        if ((n4 = this._inputPtr) >= this._inputEnd) {
                            this._pending32 = n2;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        n4 = this.getByteFromBuffer(n4);
                        if (n2 != n3) break block7;
                        if (n4 < 48 || n4 == 93 || n4 == 125) {
                            return this._valueComplete(jsonToken);
                        }
                        break block8;
                    }
                    if (n4 == string.charAt(n2)) break block9;
                }
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._minorState = 50;
                nonBlockingUtf8JsonParserBase._textBuffer.resetWithCopy(string, 0, n2);
                return nonBlockingUtf8JsonParserBase._finishErrorToken();
            }
            ++n2;
            ++this._inputPtr;
        }
    }

    public JsonToken _finishKeywordTokenWithEOF(String string, int n2, JsonToken jsonToken) {
        if (n2 == string.length()) {
            this._currToken = jsonToken;
            return jsonToken;
        }
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        nonBlockingUtf8JsonParserBase._textBuffer.resetWithCopy(string, 0, n2);
        return nonBlockingUtf8JsonParserBase._finishErrorTokenWithEOF();
    }

    public JsonToken _finishNonStdToken(int n2, int n3) {
        String string = this._nonStdToken(n2);
        int n4 = string.length();
        while (true) {
            block9: {
                block8: {
                    int n5;
                    block7: {
                        if ((n5 = this._inputPtr) >= this._inputEnd) {
                            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                            nonBlockingUtf8JsonParserBase._nonStdTokenType = n2;
                            nonBlockingUtf8JsonParserBase._pending32 = n3;
                            nonBlockingUtf8JsonParserBase._minorState = 19;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        n5 = this.getByteFromBuffer(n5);
                        if (n3 != n4) break block7;
                        if (n5 < 48 || n5 == 93 || n5 == 125) {
                            return this._valueNonStdNumberComplete(n2);
                        }
                        break block8;
                    }
                    if (n5 == string.charAt(n3)) break block9;
                }
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._minorState = 50;
                nonBlockingUtf8JsonParserBase._textBuffer.resetWithCopy(string, 0, n3);
                return nonBlockingUtf8JsonParserBase._finishErrorToken();
            }
            ++n3;
            ++this._inputPtr;
        }
    }

    public JsonToken _finishNonStdTokenWithEOF(int n2, int n3) {
        String string = this._nonStdToken(n2);
        if (n3 == string.length()) {
            return this._valueNonStdNumberComplete(n2);
        }
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        nonBlockingUtf8JsonParserBase._textBuffer.resetWithCopy(string, 0, n3);
        return nonBlockingUtf8JsonParserBase._finishErrorTokenWithEOF();
    }

    public JsonToken _finishErrorToken() {
        while (this._inputPtr < this._inputEnd) {
            char c2 = (char)this.getNextSignedByteFromBuffer();
            if (Character.isJavaIdentifierPart(c2)) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                nonBlockingUtf8JsonParserBase._textBuffer.append(c2);
                if (nonBlockingUtf8JsonParserBase._textBuffer.size() < 256) continue;
            }
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            return nonBlockingUtf8JsonParserBase._reportErrorToken(nonBlockingUtf8JsonParserBase._textBuffer.contentsAsString());
        }
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    public JsonToken _finishErrorTokenWithEOF() {
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        return nonBlockingUtf8JsonParserBase._reportErrorToken(nonBlockingUtf8JsonParserBase._textBuffer.contentsAsString());
    }

    public JsonToken _reportErrorToken(String string) {
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = string2;
        String string2 = nonBlockingUtf8JsonParserBase._textBuffer.contentsAsString();
        string = nonBlockingUtf8JsonParserBase._validJsonTokenList();
        nonBlockingUtf8JsonParserBase._reportError("Unrecognized token '%s': was expecting %s", string2, string);
        return JsonToken.NOT_AVAILABLE;
    }

    public JsonToken _startFloatThatStartsWithPeriod() {
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        nonBlockingUtf8JsonParserBase._numberNegative = false;
        nonBlockingUtf8JsonParserBase._intLength = 0;
        return nonBlockingUtf8JsonParserBase._startFloat(nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment(), 0, 46);
    }

    public JsonToken _startPositiveNumber(int n2) {
        this._numberNegative = false;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        char[] cArray2 = cArray;
        cArray[0] = (char)n2;
        n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(1);
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        int n3 = 1;
        n2 = this.getByteFromBuffer(n2) & 0xFF;
        while (true) {
            block11: {
                block12: {
                    block10: {
                        block9: {
                            if (n2 >= 48) break block9;
                            if (n2 == 46) {
                                this._intLength = n3;
                                ++this._inputPtr;
                                return this._startFloat(cArray2, n3, n2);
                            }
                            break block10;
                        }
                        if (n2 <= 57) break block11;
                        if (n2 == 101 || n2 == 69) break block12;
                    }
                    this._intLength = n3;
                    this._textBuffer.setCurrentLength(n3);
                    return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
                }
                this._intLength = n3;
                ++this._inputPtr;
                return this._startFloat(cArray2, n3, n2);
            }
            if (n3 >= cArray2.length) {
                cArray2 = this._textBuffer.expandCurrentSegment();
            }
            cArray2[n3++] = (char)n2;
            this._inputPtr = n2 = this._inputPtr + 1;
            if (n2 >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(n3);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            n2 = this.getByteFromBuffer(n2) & 0xFF;
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonToken _startNegativeNumber() {
        this._numberNegative = true;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 23;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        var1_1 = this.getNextUnsignedByteFromBuffer();
        if (var1_1 <= 48) {
            if (var1_1 == 48) {
                return this._finishNumberLeadingNegZeroes();
            }
            while (true) {
                this._reportUnexpectedNumberChar(var1_1, "expected digit (0-9) to follow minus sign, for valid numeric value");
                break;
            }
        } else if (var1_1 > 57) {
            if (var1_1 != 73) ** continue;
            return this._finishNonStdToken(3, 2);
        }
        v0 = this._textBuffer.emptyAndGetCurrentSegment();
        var2_2 = v0;
        var2_2[0] = 45;
        v0[1] = (char)var1_1;
        var1_1 = this._inputPtr;
        if (var1_1 >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(2);
            this._intLength = 1;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        var1_1 = this.getByteFromBuffer(var1_1);
        var3_3 = 2;
        while (true) {
            block17: {
                block18: {
                    block16: {
                        block15: {
                            if (var1_1 >= 48) break block15;
                            if (var1_1 == 46) {
                                this._intLength = var3_3 - 1;
                                ++this._inputPtr;
                                return this._startFloat(var2_2, var3_3, var1_1);
                            }
                            break block16;
                        }
                        if (var1_1 <= 57) break block17;
                        if (var1_1 == 101 || var1_1 == 69) break block18;
                    }
                    this._intLength = var3_3 - 1;
                    this._textBuffer.setCurrentLength(var3_3);
                    return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
                }
                this._intLength = var3_3 - 1;
                ++this._inputPtr;
                return this._startFloat(var2_2, var3_3, var1_1);
            }
            if (var3_3 >= var2_2.length) {
                var2_2 = this._textBuffer.expandCurrentSegment();
            }
            var2_2[var3_3++] = (char)var1_1;
            this._inputPtr = var1_1 = this._inputPtr + 1;
            if (var1_1 >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(var3_3);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            var1_1 = this.getByteFromBuffer(var1_1) & 255;
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonToken _startPositiveNumber() {
        this._numberNegative = false;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 22;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        var1_1 = this.getNextUnsignedByteFromBuffer();
        if (var1_1 <= 48) {
            if (var1_1 == 48) {
                if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                    this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
                }
                return this._finishNumberLeadingPosZeroes();
            }
            while (true) {
                this._reportUnexpectedNumberChar(var1_1, "expected digit (0-9) to follow plus sign, for valid numeric value");
                break;
            }
        } else if (var1_1 > 57) {
            if (var1_1 != 73) ** continue;
            return this._finishNonStdToken(2, 2);
        }
        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        v0 = this._textBuffer.emptyAndGetCurrentSegment();
        var2_2 = v0;
        var2_2[0] = 43;
        v0[1] = (char)var1_1;
        var1_1 = this._inputPtr;
        if (var1_1 >= this._inputEnd) {
            this._minorState = 26;
            this._textBuffer.setCurrentLength(2);
            this._intLength = 1;
            this._currToken = JsonToken.NOT_AVAILABLE;
            return this._currToken;
        }
        var1_1 = this.getByteFromBuffer(var1_1);
        var3_3 = 2;
        while (true) {
            block19: {
                block20: {
                    block18: {
                        block17: {
                            if (var1_1 >= 48) break block17;
                            if (var1_1 == 46) {
                                this._intLength = var3_3 - 1;
                                ++this._inputPtr;
                                return this._startFloat(var2_2, var3_3, var1_1);
                            }
                            break block18;
                        }
                        if (var1_1 <= 57) break block19;
                        if (var1_1 == 101 || var1_1 == 69) break block20;
                    }
                    this._intLength = var3_3 - 1;
                    this._textBuffer.setCurrentLength(var3_3);
                    return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
                }
                this._intLength = var3_3 - 1;
                ++this._inputPtr;
                return this._startFloat(var2_2, var3_3, var1_1);
            }
            if (var3_3 >= var2_2.length) {
                var2_2 = this._textBuffer.expandCurrentSegment();
            }
            var2_2[var3_3++] = (char)var1_1;
            this._inputPtr = var1_1 = this._inputPtr + 1;
            if (var1_1 >= this._inputEnd) {
                this._minorState = 26;
                this._textBuffer.setCurrentLength(var3_3);
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            var1_1 = this.getByteFromBuffer(var1_1) & 255;
        }
    }

    public JsonToken _startNumberLeadingZero() {
        block9: {
            int n2;
            int n3;
            block10: {
                block8: {
                    block7: {
                        n3 = this._inputPtr;
                        if (n3 >= this._inputEnd) {
                            this._minorState = 24;
                            this._currToken = JsonToken.NOT_AVAILABLE;
                            return this._currToken;
                        }
                        if ((n2 = this.getByteFromBuffer(n3++) & 0xFF) >= 48) break block7;
                        if (n2 == 46) {
                            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                            nonBlockingUtf8JsonParserBase._inputPtr = n3;
                            nonBlockingUtf8JsonParserBase._intLength = 1;
                            char[] cArray = nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment();
                            cArray[0] = 48;
                            return nonBlockingUtf8JsonParserBase._startFloat(cArray, 1, n2);
                        }
                        break block8;
                    }
                    if (n2 <= 57) break block9;
                    if (n2 == 101 || n2 == 69) break block10;
                    if (n2 != 93 && n2 != 125) {
                        this._reportUnexpectedNumberChar(n2, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                    }
                }
                return this._valueCompleteInt(0, "0");
            }
            NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
            nonBlockingUtf8JsonParserBase._inputPtr = n3;
            nonBlockingUtf8JsonParserBase._intLength = 1;
            char[] cArray = nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment();
            cArray[0] = 48;
            return nonBlockingUtf8JsonParserBase._startFloat(cArray, 1, n2);
        }
        return this._finishNumberLeadingZeroes();
    }

    public JsonToken _finishNumberMinus(int n2) {
        return this._finishNumberPlusMinus(n2, true);
    }

    public JsonToken _finishNumberPlus(int n2) {
        return this._finishNumberPlusMinus(n2, false);
    }

    /*
     * Unable to fully structure code
     */
    public JsonToken _finishNumberPlusMinus(int var1_1, boolean var2_2) {
        block11: {
            block12: {
                block13: {
                    if (var1_1 > 48) break block12;
                    if (var1_1 == 48) {
                        if (var2_2) {
                            return this._finishNumberLeadingNegZeroes();
                        }
                        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
                        }
                        return this._finishNumberLeadingPosZeroes();
                    }
                    if (var1_1 == 46 && this.isEnabled(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                        if (var2_2) {
                            --this._inputPtr;
                            return this._finishNumberLeadingNegZeroes();
                        }
                        if (!this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
                            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
                        }
                        --this._inputPtr;
                        return this._finishNumberLeadingPosZeroes();
                    }
                    if (!var2_2) break block13;
lbl19:
                    // 2 sources

                    while (true) {
                        var3_4 = "expected digit (0-9) to follow minus sign, for valid numeric value";
                        ** GOTO lbl25
                        break;
                    }
                }
                while (true) {
                    var3_4 = "expected digit (0-9) for valid numeric value";
lbl25:
                    // 2 sources

                    this._reportUnexpectedNumberChar(var1_1, var3_4);
                    break block11;
                    break;
                }
            }
            if (var1_1 > 57) {
                if (var1_1 == 73) {
                    var1_1 = var2_2 != false ? 3 : 2;
                    return this._finishNonStdToken(var1_1, 2);
                }
                if (!var2_2) ** continue;
                ** continue;
            }
        }
        if (!var2_2 && !this.isEnabled(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS.mappedFeature())) {
            this._reportUnexpectedNumberChar(43, "JSON spec does not allow numbers to have plus signs: enable `JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS` to allow");
        }
        var2_3 = this._textBuffer.emptyAndGetCurrentSegment();
        var3_5 = 0;
        var4_6 = var2_2 != false ? 45 : 43;
        var2_3[var3_5] = var4_6;
        var2_3[1] = (char)var1_1;
        this._intLength = 1;
        return this._finishNumberIntegralPart(var2_3, 2);
    }

    public JsonToken _finishNumberLeadingZeroes() {
        Object object;
        int n2;
        do {
            block10: {
                block11: {
                    block9: {
                        block8: {
                            if (((ParserBase)object)._inputPtr >= ((ParserBase)object)._inputEnd) {
                                ((NonBlockingJsonParserBase)object)._minorState = 24;
                                ((ParserMinimalBase)object)._currToken = JsonToken.NOT_AVAILABLE;
                                return ((ParserMinimalBase)object)._currToken;
                            }
                            n2 = ((NonBlockingUtf8JsonParserBase)object).getNextUnsignedByteFromBuffer();
                            if (n2 >= 48) break block8;
                            if (n2 == 46) {
                                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = object;
                                char[] cArray = nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment();
                                object = cArray;
                                cArray[0] = 48;
                                nonBlockingUtf8JsonParserBase._intLength = 1;
                                return nonBlockingUtf8JsonParserBase._startFloat((char[])object, 1, n2);
                            }
                            break block9;
                        }
                        if (n2 <= 57) break block10;
                        if (n2 == 101 || n2 == 69) break block11;
                        if (n2 != 93 && n2 != 125) {
                            ((ParserMinimalBase)object)._reportUnexpectedNumberChar(n2, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                        }
                    }
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = object;
                    --nonBlockingUtf8JsonParserBase._inputPtr;
                    return nonBlockingUtf8JsonParserBase._valueCompleteInt(0, "0");
                }
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = object;
                char[] cArray = nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment();
                object = cArray;
                cArray[0] = 48;
                nonBlockingUtf8JsonParserBase._intLength = 1;
                return nonBlockingUtf8JsonParserBase._startFloat((char[])object, 1, n2);
            }
            if ((((JsonParser)object)._features & FEAT_MASK_LEADING_ZEROS) != 0) continue;
            ((ParserMinimalBase)object).reportInvalidNumber("Leading zeroes not allowed");
        } while (n2 == 48);
        Object object2 = object;
        char[] cArray = ((ParserBase)object2)._textBuffer.emptyAndGetCurrentSegment();
        object = cArray;
        cArray[0] = (char)n2;
        ((ParserBase)object2)._intLength = 1;
        return ((NonBlockingUtf8JsonParserBase)object2)._finishNumberIntegralPart((char[])object, 1);
    }

    public JsonToken _finishNumberLeadingNegZeroes() {
        return this._finishNumberLeadingPosNegZeroes(true);
    }

    public JsonToken _finishNumberLeadingPosZeroes() {
        return this._finishNumberLeadingPosNegZeroes(false);
    }

    /*
     * WARNING - void declaration
     */
    public JsonToken _finishNumberLeadingPosNegZeroes(boolean bl) {
        int n2;
        do {
            block12: {
                block13: {
                    block11: {
                        block10: {
                            if (this._inputPtr >= this._inputEnd) {
                                void cArray;
                                if (bl) {
                                    int cArray2 = 25;
                                } else {
                                    int cArray3 = 24;
                                }
                                this._minorState = cArray;
                                this._currToken = JsonToken.NOT_AVAILABLE;
                                return this._currToken;
                            }
                            n2 = this.getNextUnsignedByteFromBuffer();
                            if (n2 >= 48) break block10;
                            if (n2 == 46) {
                                char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                                int n3 = 0;
                                int n4 = bl ? 45 : 43;
                                cArray[n3] = n4;
                                cArray[1] = 48;
                                this._intLength = 1;
                                return this._startFloat(cArray, 2, n2);
                            }
                            break block11;
                        }
                        if (n2 <= 57) break block12;
                        if (n2 == 101 || n2 == 69) break block13;
                        if (n2 != 93 && n2 != 125) {
                            this._reportUnexpectedNumberChar(n2, "expected digit (0-9), decimal point (.) or exponent indicator (e/E) to follow '0'");
                        }
                    }
                    NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
                    --nonBlockingUtf8JsonParserBase._inputPtr;
                    return nonBlockingUtf8JsonParserBase._valueCompleteInt(0, "0");
                }
                char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
                int n5 = 0;
                int n6 = bl ? 45 : 43;
                cArray[n5] = n6;
                cArray[1] = 48;
                this._intLength = 1;
                return this._startFloat(cArray, 2, n2);
            }
            if ((this._features & FEAT_MASK_LEADING_ZEROS) != 0) continue;
            this.reportInvalidNumber("Leading zeroes not allowed");
        } while (n2 == 48);
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n7 = 0;
        int n8 = bl ? 45 : 43;
        cArray[n7] = n8;
        cArray[1] = (char)n2;
        this._intLength = 1;
        return this._finishNumberIntegralPart(cArray, 2);
    }

    public JsonToken _finishNumberIntegralPart(char[] cArray, int n2) {
        int n3 = this._numberNegative ? -1 : 0;
        while (true) {
            int n4;
            block10: {
                block11: {
                    block9: {
                        block8: {
                            if ((n4 = this._inputPtr) >= this._inputEnd) {
                                this._minorState = 26;
                                this._textBuffer.setCurrentLength(n2);
                                this._currToken = JsonToken.NOT_AVAILABLE;
                                return this._currToken;
                            }
                            if ((n4 = this.getByteFromBuffer(n4) & 0xFF) >= 48) break block8;
                            if (n4 == 46) {
                                this._intLength = n2 + n3;
                                ++this._inputPtr;
                                return this._startFloat(cArray, n2, n4);
                            }
                            break block9;
                        }
                        if (n4 <= 57) break block10;
                        if (n4 == 101 || n4 == 69) break block11;
                    }
                    this._intLength = n2 + n3;
                    this._textBuffer.setCurrentLength(n2);
                    return this._valueComplete(JsonToken.VALUE_NUMBER_INT);
                }
                this._intLength = n2 + n3;
                ++this._inputPtr;
                return this._startFloat(cArray, n2, n4);
            }
            ++this._inputPtr;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            int n5 = n4;
            n4 = n2 + 1;
            cArray[n2] = (char)n5;
            n2 = n4;
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonToken _startFloat(char[] var1_1, int var2_3, int var3_4) {
        block14: {
            block13: {
                block15: {
                    var4_5 = 0;
                    if (var3_4 == 46) {
                        if (var2_3 >= var1_1.length) {
                            var1_1 = this._textBuffer.expandCurrentSegment();
                        }
                        var3_4 = var2_3 + 1;
                        var1_1[var2_3] = 46;
                        var2_3 = var3_4;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this._textBuffer.setCurrentLength(var2_3);
                                this._minorState = 30;
                                this._fractLength = var4_5;
                                this._currToken = JsonToken.NOT_AVAILABLE;
                                return this._currToken;
                            }
                            v0 = this.getNextSignedByteFromBuffer();
                            var3_4 = v0;
                            if (v0 < 48 || var3_4 > 57) break;
                            if (var2_3 >= var1_1.length) {
                                var1_1 = this._textBuffer.expandCurrentSegment();
                            }
                            v1 = var3_4;
                            var3_4 = var2_3 + 1;
                            var1_1[var2_3] = (char)v1;
                            ++var4_5;
                            var2_3 = var3_4;
                        }
                        var3_4 &= 255;
                        if (var4_5 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
                            this._reportUnexpectedNumberChar(var3_4, "Decimal point not followed by a digit");
                        }
                    }
                    this._fractLength = var4_5;
                    var4_5 = 0;
                    if (var3_4 != 101 && var3_4 != 69) break block14;
                    if (var2_3 >= var1_1.length) {
                        var1_1 = this._textBuffer.expandCurrentSegment();
                    }
                    v2 = var3_4;
                    var3_4 = var2_3 + 1;
                    var1_1[var2_3] = (char)v2;
                    if (this._inputPtr >= this._inputEnd) {
                        this._textBuffer.setCurrentLength(var3_4);
                        this._minorState = 31;
                        this._expLength = 0;
                        this._currToken = JsonToken.NOT_AVAILABLE;
                        return this._currToken;
                    }
                    var5_6 = this.getNextSignedByteFromBuffer();
                    if (var5_6 == 45 || var5_6 == 43) break block15;
                    var2_3 = var3_4;
                    ** GOTO lbl61
                }
                if (var3_4 >= var1_1.length) {
                    var1_1 = this._textBuffer.expandCurrentSegment();
                }
                var2_3 += 2;
                var1_1[var3_4] = (char)var5_6;
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(var2_3);
                    this._minorState = 32;
                    this._expLength = 0;
                    this._currToken = JsonToken.NOT_AVAILABLE;
                    return this._currToken;
                }
                do {
                    var5_6 = this.getNextSignedByteFromBuffer();
lbl61:
                    // 2 sources

                    if (var5_6 < 48 || var5_6 > 57) break block13;
                    ++var4_5;
                    if (var2_3 >= var1_1.length) {
                        var1_1 = this._textBuffer.expandCurrentSegment();
                    }
                    var1_1[var2_3++] = (char)var5_6;
                } while (this._inputPtr < this._inputEnd);
                this._textBuffer.setCurrentLength(var2_3);
                this._minorState = 32;
                this._expLength = var4_5;
                this._currToken = JsonToken.NOT_AVAILABLE;
                return this._currToken;
            }
            var1_2 = var5_6 & 255;
            if (var4_5 == 0) {
                this._reportUnexpectedNumberChar(var1_2, "Exponent indicator not followed by a digit");
            }
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(var2_3);
        this._expLength = var4_5;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    public JsonToken _finishFloatFraction() {
        int n2 = this._fractLength;
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        byte by = this.getNextSignedByteFromBuffer();
        boolean bl = true;
        while (bl) {
            if (by >= 48 && by <= 57) {
                ++n2;
                if (n3 >= cArray.length) {
                    cArray = this._textBuffer.expandCurrentSegment();
                }
                cArray[n3++] = (char)by;
                if (this._inputPtr >= this._inputEnd) {
                    this._textBuffer.setCurrentLength(n3);
                    this._fractLength = n2;
                    return JsonToken.NOT_AVAILABLE;
                }
                by = this.getNextSignedByteFromBuffer();
                continue;
            }
            if (by != 102 && by != 100 && by != 70 && by != 68) {
                if (by == 46) {
                    this._reportUnexpectedNumberChar(by, "Cannot parse number with more than one decimal point");
                    continue;
                }
                bl = false;
                continue;
            }
            this._reportUnexpectedNumberChar(by, "JSON does not support parsing numbers that have 'f' or 'd' suffixes");
        }
        if (n2 == 0 && !this.isEnabled(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS.mappedFeature())) {
            this._reportUnexpectedNumberChar(by, "Decimal point not followed by a digit");
        }
        this._fractLength = n2;
        this._textBuffer.setCurrentLength(n3);
        if (by != 101 && by != 69) {
            --this._inputPtr;
            this._textBuffer.setCurrentLength(n3);
            this._expLength = 0;
            return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
        }
        this._textBuffer.append((char)by);
        this._expLength = 0;
        if (this._inputPtr >= this._inputEnd) {
            this._minorState = 31;
            return JsonToken.NOT_AVAILABLE;
        }
        this._minorState = 32;
        n2 = this.getNextUnsignedByteFromBuffer();
        return this._finishFloatExponent(true, n2);
    }

    public JsonToken _finishFloatExponent(boolean bl, int n2) {
        if (bl) {
            this._minorState = 32;
            if (n2 == 45 || n2 == 43) {
                this._textBuffer.append((char)n2);
                if (this._inputPtr >= this._inputEnd) {
                    this._minorState = 32;
                    this._expLength = 0;
                    return JsonToken.NOT_AVAILABLE;
                }
                n2 = this.getNextSignedByteFromBuffer();
            }
        }
        char[] cArray = this._textBuffer.getBufferWithoutReset();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        int n4 = this._expLength;
        while (n2 >= 48 && n2 <= 57) {
            ++n4;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n3++] = (char)n2;
            if (this._inputPtr >= this._inputEnd) {
                this._textBuffer.setCurrentLength(n3);
                this._expLength = n4;
                return JsonToken.NOT_AVAILABLE;
            }
            n2 = this.getNextSignedByteFromBuffer();
        }
        int n5 = n2 & 0xFF;
        if (n4 == 0) {
            this._reportUnexpectedNumberChar(n5, "Exponent indicator not followed by a digit");
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        this._expLength = n4;
        return this._valueComplete(JsonToken.VALUE_NUMBER_FLOAT);
    }

    public final JsonToken _finishFieldWithEscape() {
        int n2 = this._quotedDigits;
        if ((n2 = this._decodeSplitEscaped(this._quoted32, n2)) < 0) {
            this._minorState = 8;
            return JsonToken.NOT_AVAILABLE;
        }
        int[] nArray = this._quadBuffer;
        if (this._quadLength >= this._quadBuffer.length) {
            this._quadBuffer = ParserBase.growArrayBy(nArray, 32);
        }
        int n3 = this._pending32;
        int n4 = this._pendingBytes;
        if (n2 > 127) {
            if (n4 >= 4) {
                this._quadBuffer[this._quadLength++] = n3;
                n3 = 0;
                n4 = 0;
            }
            if (n2 < 2048) {
                n3 = n3 << 8 | (n2 >> 6 | 0xC0);
                ++n4;
            } else {
                n3 = n3 << 8 | (n2 >> 12 | 0xE0);
                if (++n4 >= 4) {
                    this._quadBuffer[this._quadLength++] = n3;
                    n3 = 0;
                    n4 = 0;
                }
                n3 = n3 << 8 | (n2 >> 6 & 0x3F | 0x80);
                ++n4;
            }
            n2 = n2 & 0x3F | 0x80;
        }
        if (n4 < 4) {
            int n5 = n3;
            n3 = n4 + 1;
            n2 = n5 << 8 | n2;
        } else {
            this._quadBuffer[this._quadLength++] = n3;
            n3 = 1;
        }
        if (this._minorStateAfterSplit == 9) {
            return this._finishAposName(this._quadLength, n2, n3);
        }
        return this._parseEscapedName(this._quadLength, n2, n3);
    }

    public JsonToken _startString() {
        int n2;
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        int n3 = 0;
        char[] cArray = nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n4 = Math.min(nonBlockingUtf8JsonParserBase._inputEnd, n2 + cArray.length);
        for (n2 = (v143941)._inputPtr; n2 < n4; ++n2) {
            int n5 = this.getByteFromBuffer(n2) & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase2 = this;
                nonBlockingUtf8JsonParserBase2._inputPtr = n2 + 1;
                nonBlockingUtf8JsonParserBase2._textBuffer.setCurrentLength(n3);
                return nonBlockingUtf8JsonParserBase2._valueComplete(JsonToken.VALUE_STRING);
            }
            int n6 = n5;
            n5 = n3 + 1;
            cArray[n3] = (char)n6;
            n3 = n5;
        }
        this._textBuffer.setCurrentLength(n3);
        this._inputPtr = n2;
        return this._finishRegularString();
    }

    public JsonToken _startAposString() {
        int n2;
        NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase = this;
        int n3 = 0;
        char[] cArray = nonBlockingUtf8JsonParserBase._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = _icUTF8;
        int n4 = Math.min(nonBlockingUtf8JsonParserBase._inputEnd, n2 + cArray.length);
        for (n2 = (v144002)._inputPtr; n2 < n4; ++n2) {
            int n5 = this.getByteFromBuffer(n2) & 0xFF;
            if (n5 == 39) {
                NonBlockingUtf8JsonParserBase nonBlockingUtf8JsonParserBase2 = this;
                nonBlockingUtf8JsonParserBase2._inputPtr = n2 + 1;
                nonBlockingUtf8JsonParserBase2._textBuffer.setCurrentLength(n3);
                return nonBlockingUtf8JsonParserBase2._valueComplete(JsonToken.VALUE_STRING);
            }
            if (nArray[n5] != 0) break;
            int n6 = n5;
            n5 = n3 + 1;
            cArray[n3] = (char)n6;
            n3 = n5;
        }
        this._textBuffer.setCurrentLength(n3);
        this._inputPtr = n2;
        return this._finishAposString();
    }
}

