/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.sym;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.sym.a;
import com.privatefasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteQuadsCanonicalizer {
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    private static final int MIN_HASH_SIZE = 16;
    protected static final int MAX_ENTRIES_FOR_REUSE = 6000;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;
    protected final ByteQuadsCanonicalizer _parent;
    protected final AtomicReference<a> _tableInfo;
    protected final int _seed;
    protected final boolean _intern;
    protected final boolean _failOnDoS;
    protected int[] _hashArea;
    protected int _hashSize;
    protected int _secondaryStart;
    protected int _tertiaryStart;
    protected int _tertiaryShift;
    protected int _count;
    protected String[] _names;
    protected int _spilloverEnd;
    protected int _longNameOffset;
    protected boolean _hashShared;

    private ByteQuadsCanonicalizer(int n2, int n3) {
        this._parent = null;
        this._count = 0;
        this._hashShared = true;
        this._seed = n3;
        this._intern = false;
        this._failOnDoS = true;
        if (n2 < 16) {
            n2 = 16;
        } else {
            int n4 = n2;
            if ((n4 & n4 - 1) != 0) {
                n3 = 16;
                while (n3 < n2) {
                    int n5 = n3;
                    n3 = n5 + n5;
                }
                n2 = n3;
            }
        }
        this._tableInfo = new AtomicReference<a>(a.a(n2));
    }

    private ByteQuadsCanonicalizer(ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n2, a a2, boolean bl, boolean bl2) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer3 = this;
        this._parent = byteQuadsCanonicalizer;
        this._seed = n2;
        this._intern = bl;
        byteQuadsCanonicalizer3._failOnDoS = bl2;
        byteQuadsCanonicalizer3._tableInfo = null;
        this._count = a2.b;
        this._hashSize = a2.a;
        this._secondaryStart = this._hashSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = a2.c;
        this._hashArea = a2.d;
        this._names = a2.e;
        this._spilloverEnd = a2.f;
        byteQuadsCanonicalizer2._longNameOffset = a2.g;
        byteQuadsCanonicalizer2._hashShared = true;
    }

    private ByteQuadsCanonicalizer(a a2) {
        int n2;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        this._parent = null;
        this._seed = 0;
        this._intern = false;
        this._failOnDoS = true;
        this._tableInfo = null;
        this._count = -1;
        int[] nArray = a2.d;
        this._hashArea = nArray;
        this._names = a2.e;
        this._hashSize = a2.a;
        byteQuadsCanonicalizer._secondaryStart = n2 = a2.d.length;
        byteQuadsCanonicalizer._tertiaryStart = n2;
        byteQuadsCanonicalizer._tertiaryShift = 1;
        byteQuadsCanonicalizer._spilloverEnd = n2;
        byteQuadsCanonicalizer._longNameOffset = n2;
        byteQuadsCanonicalizer._hashShared = true;
    }

    public static ByteQuadsCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        return ByteQuadsCanonicalizer.createRoot((int)l2 + (int)(l2 >>> 32) | 1);
    }

    public static ByteQuadsCanonicalizer createRoot(int n2) {
        return new ByteQuadsCanonicalizer(64, n2);
    }

    private void mergeChild(a a2) {
        int n2 = a2.b;
        a a3 = this._tableInfo.get();
        if (n2 == a3.b) {
            return;
        }
        if (n2 > 6000) {
            a2 = a.a(64);
        }
        this._tableInfo.compareAndSet(a3, a2);
    }

    private final int _calcOffset(int n2) {
        return (n2 & this._hashSize - 1) << 2;
    }

    private String _findSecondary(int n2, int n3) {
        int n4 = n2;
        n2 = this._tertiaryShift;
        int n5 = this._tertiaryStart + (n4 >> n2 + 2 << n2);
        int[] nArray = this._hashArea;
        n2 = n5 + (1 << n2);
        while (n5 < n2) {
            int n6 = nArray[n5 + 3];
            if (n3 == nArray[n5] && 1 == n6) {
                return this._names[n5 >> 2];
            }
            if (n6 == 0) {
                return null;
            }
            n5 += 4;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray[n2] || 1 != nArray[n2 + 3]) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n2, int n3, int n4) {
        int n5 = n2;
        n2 = this._tertiaryShift;
        int n6 = this._tertiaryStart + (n5 >> n2 + 2 << n2);
        int[] nArray = this._hashArea;
        n2 = n6 + (1 << n2);
        while (n6 < n2) {
            int n7 = nArray[n6 + 3];
            if (n3 == nArray[n6] && n4 == nArray[n6 + 1] && 2 == n7) {
                return this._names[n6 >> 2];
            }
            if (n7 == 0) {
                return null;
            }
            n6 += 4;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray[n2] || n4 != nArray[n2 + 1] || 2 != nArray[n2 + 3]) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n2, int n3, int n4, int n5) {
        int n6 = n2;
        n2 = this._tertiaryShift;
        int n7 = this._tertiaryStart + (n6 >> n2 + 2 << n2);
        int[] nArray = this._hashArea;
        n2 = n7 + (1 << n2);
        while (n7 < n2) {
            int n8 = nArray[n7 + 3];
            if (n3 == nArray[n7] && n4 == nArray[n7 + 1] && n5 == nArray[n7 + 2] && 3 == n8) {
                return this._names[n7 >> 2];
            }
            if (n8 == 0) {
                return null;
            }
            n7 += 4;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray[n2] || n4 != nArray[n2 + 1] || n5 != nArray[n2 + 2] || 3 != nArray[n2 + 3]) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n2, int n3, int[] nArray, int n4) {
        int n5 = n2;
        n2 = this._tertiaryShift;
        int n6 = this._tertiaryStart + (n5 >> n2 + 2 << n2);
        int[] nArray2 = this._hashArea;
        n2 = n6 + (1 << n2);
        while (n6 < n2) {
            int n7 = nArray2[n6 + 3];
            if (n3 == nArray2[n6] && n4 == n7 && this._verifyLongName(nArray, n4, nArray2[n6 + 1])) {
                return this._names[n6 >> 2];
            }
            if (n7 == 0) {
                return null;
            }
            n6 += 4;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray2[n2] || n4 != nArray2[n2 + 3] || !this._verifyLongName(nArray, n4, nArray2[n2 + 1])) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private boolean _verifyLongName(int[] nArray, int n2, int n3) {
        int[] nArray2 = this._hashArea;
        int n4 = 0;
        switch (n2) {
            default: {
                return this._verifyLongName2(nArray, n2, n3);
            }
            case 8: {
                int n5 = n4;
                n4 = 1;
                if (nArray[n5] != nArray2[n3++]) {
                    return false;
                }
            }
            case 7: {
                if (nArray[n4++] != nArray2[n3++]) {
                    return false;
                }
            }
            case 6: {
                if (nArray[n4++] != nArray2[n3++]) {
                    return false;
                }
            }
            case 5: {
                if (nArray[n4++] == nArray2[n3++]) break;
                return false;
            }
            case 4: 
        }
        int n6 = n4;
        int n7 = n6 + 1;
        int n8 = n3;
        n2 = n8 + 1;
        if (nArray[n6] != nArray2[n8]) {
            return false;
        }
        int n9 = n7;
        n7 = n4 + 2;
        int n10 = n2;
        n2 = n3 + 2;
        if (nArray[n9] != nArray2[n10]) {
            return false;
        }
        int n11 = n7;
        n7 = n4 + 3;
        int n12 = n2;
        n2 = n3 + 3;
        if (nArray[n11] != nArray2[n12]) {
            return false;
        }
        return nArray[n7] == nArray2[n2];
    }

    private boolean _verifyLongName2(int[] nArray, int n2, int n3) {
        int n4 = 0;
        do {
            if (nArray[n4++] == this._hashArea[n3++]) continue;
            return false;
        } while (n4 < n2);
        return true;
    }

    private void _verifySharing() {
        if (this._hashShared) {
            if (this._parent == null) {
                if (this._count == 0) {
                    throw new IllegalStateException("Cannot add names to Root symbol table");
                }
                throw new IllegalStateException("Cannot add names to Placeholder symbol table");
            }
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            byteQuadsCanonicalizer._hashArea = Arrays.copyOf(byteQuadsCanonicalizer._hashArea, byteQuadsCanonicalizer._hashArea.length);
            byteQuadsCanonicalizer._names = Arrays.copyOf(byteQuadsCanonicalizer._names, byteQuadsCanonicalizer._names.length);
            byteQuadsCanonicalizer._hashShared = false;
        }
    }

    private int _findOffsetForAdd(int n2) {
        int n3;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n4 = byteQuadsCanonicalizer._calcOffset(n2);
        int[] nArray = byteQuadsCanonicalizer._hashArea;
        if (byteQuadsCanonicalizer._hashArea[n4 + 3] == 0) {
            return n4;
        }
        if (this._checkNeedForRehash()) {
            return this._resizeAndFindOffsetForAdd(n2);
        }
        int n5 = this._secondaryStart + (n4 >> 3 << 2);
        if (nArray[n5 + 3] == 0) {
            return n5;
        }
        int n6 = n4;
        n4 = this._tertiaryShift;
        n5 = this._tertiaryStart + (n6 >> n4 + 2 << n4);
        n4 = n5 + (1 << n4);
        while (n5 < n4) {
            if (nArray[n5 + 3] == 0) {
                return n5;
            }
            n5 += 4;
        }
        n4 = this._spilloverEnd;
        this._spilloverEnd = n3 = n4 + 4;
        if (n3 >= this._hashSize << 3) {
            if (this._failOnDoS) {
                this._reportTooManyCollisions();
            }
            return this._resizeAndFindOffsetForAdd(n2);
        }
        return n4;
    }

    private int _resizeAndFindOffsetForAdd(int n2) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        this.rehash();
        n2 = byteQuadsCanonicalizer._calcOffset(n2);
        int[] nArray = byteQuadsCanonicalizer._hashArea;
        if (byteQuadsCanonicalizer._hashArea[n2 + 3] == 0) {
            return n2;
        }
        int n3 = this._secondaryStart + (n2 >> 3 << 2);
        if (nArray[n3 + 3] == 0) {
            return n3;
        }
        int n4 = n2;
        n2 = this._tertiaryShift;
        n3 = this._tertiaryStart + (n4 >> n2 + 2 << n2);
        n2 = n3 + (1 << n2);
        while (n3 < n2) {
            if (nArray[n3 + 3] == 0) {
                return n3;
            }
            n3 += 4;
        }
        int n5 = this._spilloverEnd;
        this._spilloverEnd = n5 + 4;
        return n5;
    }

    private boolean _checkNeedForRehash() {
        if (this._count > this._hashSize >> 1) {
            int n2 = this._count;
            if (this._spilloverEnd - this._spilloverStart() >> 2 > n2 + 1 >> 7 || (double)n2 > (double)this._hashSize * 0.8) {
                return true;
            }
        }
        return false;
    }

    private int _appendLongName(int[] nArray, int n2) {
        int n3 = this._longNameOffset;
        int n4 = n3 + n2;
        int[] nArray2 = this._hashArea;
        if (n4 > this._hashArea.length) {
            int n5 = n4 - nArray2.length;
            n4 = this._hashArea.length;
            n4 = Math.max(n5, Math.min(4096, this._hashSize)) + n4;
            this._hashArea = Arrays.copyOf(this._hashArea, n4);
        }
        System.arraycopy(nArray, 0, this._hashArea, n3, n2);
        this._longNameOffset += n2;
        return n3;
    }

    private void rehash() {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        byteQuadsCanonicalizer._hashShared = false;
        int[] nArray = byteQuadsCanonicalizer._hashArea;
        String[] stringArray = byteQuadsCanonicalizer._names;
        int n2 = byteQuadsCanonicalizer._hashSize;
        int n3 = this._count;
        int n4 = n2 + n2;
        int n5 = this._spilloverEnd;
        if (n4 > 65536) {
            this.nukeSymbols(true);
            return;
        }
        this._hashArea = new int[nArray.length + (n2 << 3)];
        this._hashSize = n4;
        this._secondaryStart = n4 << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = ByteQuadsCanonicalizer._calcTertiaryShift(n4);
        this._names = new String[stringArray.length << 1];
        this.nukeSymbols(false);
        n2 = 0;
        int[] nArray2 = new int[16];
        for (int i2 = 0; i2 < n5; i2 += 4) {
            int n6 = nArray[i2 + 3];
            if (n6 == 0) continue;
            ++n2;
            String string = stringArray[i2 >> 2];
            if (n6 != 1) {
                if (n6 != 2) {
                    if (n6 != 3) {
                        if (n6 > nArray2.length) {
                            nArray2 = new int[n6];
                        }
                        System.arraycopy(nArray, nArray[i2 + 1], nArray2, 0, n6);
                        this.addName(string, nArray2, n6);
                        continue;
                    }
                    nArray2[0] = nArray[i2];
                    nArray2[1] = nArray[i2 + 1];
                    nArray2[2] = nArray[i2 + 2];
                    this.addName(string, nArray2, 3);
                    continue;
                }
                nArray2[0] = nArray[i2];
                nArray2[1] = nArray[i2 + 1];
                this.addName(string, nArray2, 2);
                continue;
            }
            nArray2[0] = nArray[i2];
            this.addName(string, nArray2, 1);
        }
        if (n2 == n3) {
            return;
        }
        throw new IllegalStateException("Failed rehash(): old count=" + n3 + ", copyCount=" + n2);
    }

    private void nukeSymbols(boolean bl) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        byteQuadsCanonicalizer._count = 0;
        byteQuadsCanonicalizer._spilloverEnd = byteQuadsCanonicalizer._spilloverStart();
        byteQuadsCanonicalizer._longNameOffset = byteQuadsCanonicalizer._hashSize << 3;
        if (bl) {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
            Arrays.fill(byteQuadsCanonicalizer2._hashArea, 0);
            Arrays.fill(byteQuadsCanonicalizer2._names, null);
        }
    }

    private final int _spilloverStart() {
        int n2 = this._hashSize;
        return (n2 << 3) - n2;
    }

    public static int _calcTertiaryShift(int n2) {
        if ((n2 >>= 2) < 64) {
            return 4;
        }
        if (n2 <= 256) {
            return 5;
        }
        if (n2 <= 1024) {
            return 6;
        }
        return 7;
    }

    public ByteQuadsCanonicalizer makeChild(int n2) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n3 = byteQuadsCanonicalizer._seed;
        boolean bl = JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(n2);
        n2 = JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n2) ? 1 : 0;
        return new ByteQuadsCanonicalizer(byteQuadsCanonicalizer, n3, byteQuadsCanonicalizer._tableInfo.get(), bl, n2 != 0);
    }

    public ByteQuadsCanonicalizer makeChildOrPlaceholder(int n2) {
        if (JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2)) {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            int n3 = byteQuadsCanonicalizer._seed;
            boolean bl = JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(n2);
            n2 = JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n2) ? 1 : 0;
            return new ByteQuadsCanonicalizer(byteQuadsCanonicalizer, n3, byteQuadsCanonicalizer._tableInfo.get(), bl, n2 != 0);
        }
        return new ByteQuadsCanonicalizer(this._tableInfo.get());
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new a(this));
            this._hashShared = true;
        }
    }

    public int size() {
        AtomicReference<a> atomicReference = this._tableInfo;
        if (atomicReference != null) {
            return atomicReference.get().b;
        }
        return this._count;
    }

    public int bucketCount() {
        return this._hashSize;
    }

    public boolean maybeDirty() {
        return this._hashShared ^ true;
    }

    public int hashSeed() {
        return this._seed;
    }

    public boolean isCanonicalizing() {
        return this._parent != null;
    }

    public int primaryCount() {
        int n2 = 0;
        int n3 = this._secondaryStart;
        for (int i2 = 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public int secondaryCount() {
        int n2 = 0;
        int n3 = this._tertiaryStart;
        for (int i2 = (v145339)._secondaryStart + 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public int tertiaryCount() {
        int n2;
        int n3 = 0;
        int n4 = n2 + this._hashSize;
        for (n2 = this._tertiaryStart + 3; n2 < n4; n2 += 4) {
            if (this._hashArea[n2] == 0) continue;
            ++n3;
        }
        return n3;
    }

    public int spilloverCount() {
        return this._spilloverEnd - this._spilloverStart() >> 2;
    }

    public int totalCount() {
        int n2 = 0;
        int n3 = this._hashSize << 3;
        for (int i2 = 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public String toString() {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n2 = byteQuadsCanonicalizer.primaryCount();
        int n3 = byteQuadsCanonicalizer.secondaryCount();
        int n4 = byteQuadsCanonicalizer.tertiaryCount();
        int n5 = byteQuadsCanonicalizer.spilloverCount();
        int n6 = byteQuadsCanonicalizer.totalCount();
        Object[] objectArray = new Object[9];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ByteQuadsCanonicalizer.class.getName();
        objectArray2[1] = this._count;
        objectArray2[2] = this._hashSize;
        objectArray2[3] = n2;
        objectArray2[4] = n3;
        objectArray2[5] = n4;
        objectArray2[6] = n5;
        objectArray2[7] = n2 + n3 + n4 + n5;
        objectArray[8] = n6;
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", objectArray2);
    }

    public String findName(int n2) {
        int n3;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n4 = byteQuadsCanonicalizer._calcOffset(byteQuadsCanonicalizer.calcHash(n2));
        int[] nArray = byteQuadsCanonicalizer._hashArea;
        int n5 = byteQuadsCanonicalizer._hashArea[n4 + 3];
        if (n5 == 1) {
            if (nArray[n4] == n2) {
                return this._names[n4 >> 2];
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n3 = nArray[(n5 = this._secondaryStart + (n4 >> 3 << 2)) + 3]) == 1) {
            if (nArray[n5] == n2) {
                return this._names[n5 >> 2];
            }
        } else if (n3 == 0) {
            return null;
        }
        return this._findSecondary(n4, n2);
    }

    public String findName(int n2, int n3) {
        int n4;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n5 = byteQuadsCanonicalizer._calcOffset(byteQuadsCanonicalizer.calcHash(n2, n3));
        int[] nArray = byteQuadsCanonicalizer._hashArea;
        int n6 = byteQuadsCanonicalizer._hashArea[n5 + 3];
        if (n6 == 2) {
            if (n2 == nArray[n5] && n3 == nArray[n5 + 1]) {
                return this._names[n5 >> 2];
            }
        } else if (n6 == 0) {
            return null;
        }
        if ((n4 = nArray[(n6 = this._secondaryStart + (n5 >> 3 << 2)) + 3]) == 2) {
            if (n2 == nArray[n6] && n3 == nArray[n6 + 1]) {
                return this._names[n6 >> 2];
            }
        } else if (n4 == 0) {
            return null;
        }
        return this._findSecondary(n5, n2, n3);
    }

    public String findName(int n2, int n3, int n4) {
        int n5;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n6 = byteQuadsCanonicalizer._calcOffset(byteQuadsCanonicalizer.calcHash(n2, n3, n4));
        int[] nArray = byteQuadsCanonicalizer._hashArea;
        int n7 = byteQuadsCanonicalizer._hashArea[n6 + 3];
        if (n7 == 3) {
            if (n2 == nArray[n6] && nArray[n6 + 1] == n3 && nArray[n6 + 2] == n4) {
                return this._names[n6 >> 2];
            }
        } else if (n7 == 0) {
            return null;
        }
        if ((n5 = nArray[(n7 = this._secondaryStart + (n6 >> 3 << 2)) + 3]) == 3) {
            if (n2 == nArray[n7] && nArray[n7 + 1] == n3 && nArray[n7 + 2] == n4) {
                return this._names[n7 >> 2];
            }
        } else if (n5 == 0) {
            return null;
        }
        return this._findSecondary(n6, n2, n3, n4);
    }

    public String findName(int[] nArray, int n2) {
        if (n2 < 4) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        return "";
                    }
                    int n3 = nArray[0];
                    int n4 = nArray[1];
                    n2 = nArray[2];
                    return this.findName(n3, n4, n2);
                }
                int n5 = nArray[0];
                return this.findName(n5, nArray[1]);
            }
            return this.findName(nArray[0]);
        }
        int n6 = this.calcHash(nArray, n2);
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n7 = byteQuadsCanonicalizer._calcOffset(n6);
        int[] nArray2 = byteQuadsCanonicalizer._hashArea;
        int n8 = nArray2[n7 + 3];
        if (n6 == byteQuadsCanonicalizer._hashArea[n7] && n8 == n2 && this._verifyLongName(nArray, n2, nArray2[n7 + 1])) {
            return this._names[n7 >> 2];
        }
        if (n8 == 0) {
            return null;
        }
        n8 = this._secondaryStart + (n7 >> 3 << 2);
        int n9 = nArray2[n8 + 3];
        if (n6 == nArray2[n8] && n9 == n2 && this._verifyLongName(nArray, n2, nArray2[n8 + 1])) {
            return this._names[n8 >> 2];
        }
        return this._findSecondary(n7, n6, nArray, n2);
    }

    public String addName(String string, int n2) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        byteQuadsCanonicalizer._verifySharing();
        if (byteQuadsCanonicalizer._intern) {
            string = InternCache.instance.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
        int n3 = byteQuadsCanonicalizer2._findOffsetForAdd(byteQuadsCanonicalizer2.calcHash(n2));
        byteQuadsCanonicalizer2._hashArea[n3] = n2;
        byteQuadsCanonicalizer2._hashArea[n3 + 3] = 1;
        byteQuadsCanonicalizer2._names[n3 >> 2] = string;
        ++byteQuadsCanonicalizer2._count;
        return string;
    }

    public String addName(String string, int n2, int n3) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        byteQuadsCanonicalizer._verifySharing();
        if (byteQuadsCanonicalizer._intern) {
            string = InternCache.instance.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
        int n4 = byteQuadsCanonicalizer2._findOffsetForAdd(byteQuadsCanonicalizer2.calcHash(n2, n3));
        int[] nArray = byteQuadsCanonicalizer2._hashArea;
        nArray[n4] = n2;
        nArray[n4 + 1] = n3;
        byteQuadsCanonicalizer2._hashArea[n4 + 3] = 2;
        byteQuadsCanonicalizer2._names[n4 >> 2] = string;
        ++byteQuadsCanonicalizer2._count;
        return string;
    }

    public String addName(String string, int n2, int n3, int n4) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        byteQuadsCanonicalizer._verifySharing();
        if (byteQuadsCanonicalizer._intern) {
            string = InternCache.instance.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
        int n5 = byteQuadsCanonicalizer2._findOffsetForAdd(byteQuadsCanonicalizer2.calcHash(n2, n3, n4));
        int[] nArray = byteQuadsCanonicalizer2._hashArea;
        nArray[n5] = n2;
        nArray[n5 + 1] = n3;
        nArray[n5 + 2] = n4;
        byteQuadsCanonicalizer2._hashArea[n5 + 3] = 3;
        byteQuadsCanonicalizer2._names[n5 >> 2] = string;
        ++byteQuadsCanonicalizer2._count;
        return string;
    }

    public String addName(String string, int[] nArray, int n2) {
        int n3;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        byteQuadsCanonicalizer._verifySharing();
        if (byteQuadsCanonicalizer._intern) {
            string = InternCache.instance.intern(string);
        }
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = this;
                    ByteQuadsCanonicalizer byteQuadsCanonicalizer3 = this;
                    int n4 = byteQuadsCanonicalizer3.calcHash(nArray, n2);
                    n3 = byteQuadsCanonicalizer3._findOffsetForAdd(n4);
                    byteQuadsCanonicalizer3._hashArea[n3] = n4;
                    byteQuadsCanonicalizer2._hashArea[n3 + 1] = n4 = byteQuadsCanonicalizer2._appendLongName(nArray, n2);
                    byteQuadsCanonicalizer2._hashArea[n3 + 3] = n2;
                } else {
                    ByteQuadsCanonicalizer byteQuadsCanonicalizer4 = this;
                    n2 = nArray[0];
                    n3 = nArray[1];
                    int n5 = nArray[2];
                    n3 = byteQuadsCanonicalizer4._findOffsetForAdd(byteQuadsCanonicalizer4.calcHash(n2, n3, n5));
                    int[] nArray2 = byteQuadsCanonicalizer4._hashArea;
                    nArray2[n3] = nArray[0];
                    int n6 = n3 + 1;
                    nArray2[n6] = nArray[1];
                    n6 = n3 + 2;
                    nArray2[n6] = nArray[2];
                    byteQuadsCanonicalizer4._hashArea[n3 + 3] = 3;
                }
            } else {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer5 = this;
                n2 = nArray[0];
                n3 = byteQuadsCanonicalizer5._findOffsetForAdd(byteQuadsCanonicalizer5.calcHash(n2, nArray[1]));
                int[] nArray3 = byteQuadsCanonicalizer5._hashArea;
                nArray3[n3] = nArray[0];
                int n7 = n3 + 1;
                nArray3[n7] = nArray[1];
                byteQuadsCanonicalizer5._hashArea[n3 + 3] = 2;
            }
        } else {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer6 = this;
            n3 = byteQuadsCanonicalizer6._findOffsetForAdd(byteQuadsCanonicalizer6.calcHash(nArray[0]));
            byteQuadsCanonicalizer6._hashArea[n3] = nArray[0];
            byteQuadsCanonicalizer6._hashArea[n3 + 3] = 1;
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer7 = this;
        byteQuadsCanonicalizer7._names[n3 >> 2] = string;
        ++byteQuadsCanonicalizer7._count;
        return string;
    }

    public int calcHash(int n2) {
        int n3 = n2 ^ this._seed;
        int n4 = n3 + (n3 >>> 16);
        int n5 = n4 ^ n4 << 3;
        return n5 + (n5 >>> 12);
    }

    public int calcHash(int n2, int n3) {
        int n4 = n2;
        int n5 = n4 + (n4 >>> 15);
        n2 = n5 ^ n5 >>> 9;
        int n6 = n3 * 33 + n2 ^ this._seed;
        int n7 = n6 + (n6 >>> 16);
        int n8 = n7 ^ n7 >>> 4;
        return n8 + (n8 << 3);
    }

    public int calcHash(int n2, int n3, int n4) {
        int n5 = n2 ^ this._seed;
        int n6 = ((n5 + (n5 >>> 9)) * 31 + n3) * 33;
        int n7 = n6 + (n6 >>> 15) ^ n4;
        int n8 = n7 + (n7 >>> 4);
        int n9 = n8 + (n8 >>> 15);
        return n9 ^ n9 << 9;
    }

    public int calcHash(int[] nArray, int n2) {
        if (n2 >= 4) {
            int n3 = nArray[0] ^ this._seed;
            int n4 = n3 + (n3 >>> 9) + nArray[1];
            int n5 = (n4 + (n4 >>> 15)) * 33 ^ nArray[2];
            int n6 = n5 + (n5 >>> 4);
            for (int i2 = 3; i2 < n2; ++i2) {
                int n7 = nArray[i2];
                n6 += n7 ^ n7 >> 21;
            }
            int n8 = n6 * 65599;
            int n9 = n8 + (n8 >>> 19);
            return n9 ^ n9 << 5;
        }
        throw new IllegalArgumentException();
    }

    public void _reportTooManyCollisions() {
        if (this._hashSize <= 1024) {
            return;
        }
        throw new IllegalStateException("Spill-over slots in symbol table with " + this._count + " entries, hash area of " + this._hashSize + " slots is now full (all " + (this._hashSize >> 3) + " slots -- suspect a DoS attack based on hash collisions. You can disable the check via `JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW`");
    }
}

