/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.sym;

import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.sym.b;
import com.privatefasterxml.jackson.core.sym.c;
import com.privatefasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 150;
    protected final CharsToNameCanonicalizer _parent;
    protected final AtomicReference<c> _tableInfo;
    protected final int _seed;
    protected final int _flags;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected b[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _hashShared;
    protected BitSet _overflows;

    private CharsToNameCanonicalizer(int n2) {
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        this._parent = null;
        charsToNameCanonicalizer._seed = n2;
        charsToNameCanonicalizer._canonicalize = true;
        charsToNameCanonicalizer._flags = -1;
        charsToNameCanonicalizer._hashShared = false;
        charsToNameCanonicalizer._longestCollisionList = 0;
        charsToNameCanonicalizer._tableInfo = new AtomicReference<c>(c.a());
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer stringArray, int n2, int n3, c c2) {
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        CharsToNameCanonicalizer charsToNameCanonicalizer2 = this;
        CharsToNameCanonicalizer charsToNameCanonicalizer3 = this;
        this._parent = stringArray;
        charsToNameCanonicalizer3._seed = n3;
        charsToNameCanonicalizer3._tableInfo = null;
        charsToNameCanonicalizer2._flags = n2;
        charsToNameCanonicalizer2._canonicalize = JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        stringArray = c2.c;
        this._symbols = stringArray;
        this._buckets = c2.d;
        this._size = c2.a;
        this._longestCollisionList = c2.b;
        int n4 = c2.c.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        charsToNameCanonicalizer._indexMask = n4 - 1;
        charsToNameCanonicalizer._hashShared = true;
    }

    private static int _thresholdSize(int n2) {
        int n3 = n2;
        return n3 - (n3 >> 2);
    }

    public static CharsToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        return CharsToNameCanonicalizer.createRoot((int)l2 + (int)(l2 >>> 32) | 1);
    }

    public static CharsToNameCanonicalizer createRoot(int n2) {
        return new CharsToNameCanonicalizer(n2);
    }

    private void mergeChild(c c2) {
        int n2 = c2.a;
        c c3 = this._tableInfo.get();
        if (n2 == c3.a) {
            return;
        }
        if (n2 > 12000) {
            c2 = c.a();
        }
        this._tableInfo.compareAndSet(c3, c2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private String _findSymbol2(char[] cArray, int n2, int n3, b b2) {
        while (true) {
            block5: {
                Object object;
                int n4;
                if (b2 == null) {
                    return null;
                }
                boolean bl = true;
                do {
                    block7: {
                        block6: {
                            if (!bl || (bl = false)) break block6;
                            if (b2.a.length() != n3) break block7;
                            n4 = 0;
                        }
                        if (b2.a.charAt(n4) == cArray[n2 + n4]) continue;
                    }
                    object = null;
                    break block5;
                } while (++n4 < n3);
                object = b2.a;
            }
            if (object != null) {
                return object;
            }
            b2 = b2.b;
        }
    }

    private String _addSymbol(char[] objectArray, int n2, int n3, int n4, int n5) {
        String string;
        if (this._hashShared) {
            this.copyArrays();
            this._hashShared = false;
        } else if (this._size >= this._sizeThreshold) {
            CharsToNameCanonicalizer charsToNameCanonicalizer = this;
            this.rehash();
            n5 = charsToNameCanonicalizer._hashToIndex(charsToNameCanonicalizer.calcHash((char[])objectArray, n2, n3));
        }
        String string2 = string;
        string = new String((char[])objectArray, n2, n3);
        if (JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            string2 = InternCache.instance.intern(string2);
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        ++charsToNameCanonicalizer._size;
        objectArray = charsToNameCanonicalizer._symbols;
        if (charsToNameCanonicalizer._symbols[n5] == null) {
            objectArray[n5] = (char)string2;
        } else {
            b b2;
            int n6 = n5 >> 1;
            b b3 = b2;
            b[] bArray = this._buckets;
            int n7 = new b((String)string2, (b)this._buckets[n6]).c;
            if (n7 > 150) {
                this._handleSpillOverflow(n6, b3, n5);
            } else {
                bArray[n6] = b3;
                this._longestCollisionList = Math.max(n7, this._longestCollisionList);
            }
        }
        return string2;
    }

    private void _handleSpillOverflow(int n2, b b2, int n3) {
        BitSet bitSet = this._overflows;
        if (bitSet == null) {
            BitSet bitSet2;
            bitSet = bitSet2;
            bitSet();
            this._overflows = bitSet;
            bitSet2.set(n2);
        } else if (bitSet.get(n2)) {
            if (JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this._reportTooManyCollisions(150);
            }
            this._canonicalize = false;
        } else {
            this._overflows.set(n2);
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        charsToNameCanonicalizer._symbols[n3] = b2.a;
        charsToNameCanonicalizer._buckets[n2] = null;
        charsToNameCanonicalizer._size -= b2.c;
        charsToNameCanonicalizer._longestCollisionList = -1;
    }

    private void copyArrays() {
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        charsToNameCanonicalizer._symbols = Arrays.copyOf(charsToNameCanonicalizer._symbols, charsToNameCanonicalizer._symbols.length);
        charsToNameCanonicalizer._buckets = Arrays.copyOf(charsToNameCanonicalizer._buckets, charsToNameCanonicalizer._buckets.length);
    }

    private void rehash() {
        Object[] objectArray;
        String string;
        String[] stringArray = this._symbols;
        int n2 = this._symbols.length;
        int n3 = n2 + n2;
        if (n3 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new b[32];
            this._indexMask = 63;
            this._hashShared = false;
            return;
        }
        int n4 = n3;
        b[] bArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new b[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            b b2;
            string = stringArray[i2];
            if (string == null) continue;
            ++n5;
            int n7 = this._hashToIndex(this.calcHash(string));
            objectArray = this._symbols;
            if (this._symbols[n7] == null) {
                objectArray[n7] = string;
                continue;
            }
            int n8 = n6;
            n6 = n7 >> 1;
            b b3 = b2;
            objectArray = this._buckets;
            b3(string, (b)objectArray[n6]);
            n6 = Math.max(n8, b2.c);
        }
        int n9 = n2 >> 1;
        for (n2 = 0; n2 < n9; ++n2) {
            b b4 = bArray[n2];
            while (b4 != null) {
                ++n5;
                string = b4.a;
                int n10 = this._hashToIndex(this.calcHash(string));
                objectArray = this._symbols;
                if (this._symbols[n10] == null) {
                    objectArray[n10] = string;
                } else {
                    b b5;
                    int n11 = n6;
                    n6 = n10 >> 1;
                    b b6 = b5;
                    objectArray = this._buckets;
                    b6(string, (b)objectArray[n6]);
                    n6 = Math.max(n11, b5.c);
                }
                b4 = b4.b;
            }
        }
        this._longestCollisionList = n6;
        this._overflows = null;
        if (n5 == this._size) {
            return;
        }
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray3[0] = this._size;
        objectArray2[1] = n5;
        throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", objectArray3));
    }

    public CharsToNameCanonicalizer makeChild(int n2) {
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        int n3 = charsToNameCanonicalizer._seed;
        c c2 = charsToNameCanonicalizer._tableInfo.get();
        return new CharsToNameCanonicalizer(charsToNameCanonicalizer, n2, n3, c2);
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        Object object = this._parent;
        if (object != null && this._canonicalize) {
            c c2;
            CharsToNameCanonicalizer charsToNameCanonicalizer = object;
            object = c2;
            c2 = new c(this);
            charsToNameCanonicalizer.mergeChild((c)object);
            this._hashShared = true;
        }
    }

    public int size() {
        AtomicReference<c> atomicReference = this._tableInfo;
        if (atomicReference != null) {
            return atomicReference.get().a;
        }
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return this._hashShared ^ true;
    }

    public int hashSeed() {
        return this._seed;
    }

    public int collisionCount() {
        int n2 = 0;
        b[] bArray = this._buckets;
        int n3 = this._buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            b b2 = bArray[i2];
            if (b2 == null) continue;
            n2 += b2.c;
        }
        return n2;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public String findSymbol(char[] cArray, int n2, int n3, int n4) {
        int n5;
        block9: {
            String string;
            Object object;
            block8: {
                int n6;
                if (n3 < 1) {
                    return "";
                }
                if (!this._canonicalize) {
                    return new String(cArray, n2, n3);
                }
                CharsToNameCanonicalizer charsToNameCanonicalizer = this;
                n5 = charsToNameCanonicalizer._hashToIndex(n4);
                object = charsToNameCanonicalizer._symbols[n5];
                if (object == null) break block9;
                if (((String)object).length() == n3) {
                    n6 = 0;
                    while (((String)object).charAt(n6) == cArray[n2 + n6]) {
                        if (++n6 != n3) continue;
                        return object;
                    }
                }
                if ((object = this._buckets[n5 >> 1]) == null) break block9;
                boolean bl = true;
                do {
                    block11: {
                        block10: {
                            if (!bl || (bl = false)) break block10;
                            if (((b)object).a.length() != n3) break block11;
                            n6 = 0;
                        }
                        if (((b)object).a.charAt(n6) == cArray[n2 + n6]) continue;
                    }
                    string = null;
                    break block8;
                } while (++n6 < n3);
                string = ((b)object).a;
            }
            if (string != null) {
                return string;
            }
            object = ((b)object).b;
            if ((object = this._findSymbol2(cArray, n2, n3, (b)object)) != null) {
                return object;
            }
        }
        return this._addSymbol(cArray, n2, n3, n4, n5);
    }

    public int _hashToIndex(int n2) {
        int n3 = n2;
        int n4 = n3 + (n3 >>> 15);
        int n5 = n4 ^ n4 << 7;
        return n5 + (n5 >>> 3) & this._indexMask;
    }

    public int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._seed;
        n3 = n2 + n3;
        while (n2 < n3) {
            n4 = n4 * 33 + cArray[n2];
            ++n2;
        }
        if (n4 == 0) {
            n4 = 1;
        }
        return n4;
    }

    public int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._seed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 *= 33;
            n3 = string.charAt(i2) + n3;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        return n3;
    }

    public void _reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    public void verifyInternalConsistency() {
        int n2;
        int n3 = 0;
        int n4 = this._symbols.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this._symbols[n2] == null) continue;
            ++n3;
        }
        n4 >>= 1;
        for (n2 = 0; n2 < n4; ++n2) {
            b b2 = this._buckets[n2];
            while (b2 != null) {
                ++n3;
                b2 = b2.b;
            }
        }
        if (n3 == this._size) {
            return;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this._size;
        objectArray[1] = n3;
        throw new IllegalStateException(String.format("Internal error: expected internal size %d vs calculated count %d", objectArray2));
    }
}

