/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.util;

import java.util.concurrent.atomic.AtomicReferenceArray;

public class BufferRecycler {
    public static final int BYTE_READ_IO_BUFFER = 0;
    public static final int BYTE_WRITE_ENCODING_BUFFER = 1;
    public static final int BYTE_WRITE_CONCAT_BUFFER = 2;
    public static final int BYTE_BASE64_CODEC_BUFFER = 3;
    public static final int CHAR_TOKEN_BUFFER = 0;
    public static final int CHAR_CONCAT_BUFFER = 1;
    public static final int CHAR_TEXT_BUFFER = 2;
    public static final int CHAR_NAME_COPY_BUFFER = 3;
    private static final int[] BYTE_BUFFER_LENGTHS = new int[]{8000, 8000, 2000, 2000};
    private static final int[] CHAR_BUFFER_LENGTHS = new int[]{4000, 4000, 200, 200};
    protected final AtomicReferenceArray<byte[]> _byteBuffers;
    protected final AtomicReferenceArray<char[]> _charBuffers;

    public BufferRecycler() {
        this(4, 4);
    }

    public BufferRecycler(int n2, int n3) {
        AtomicReferenceArray atomicReferenceArray;
        AtomicReferenceArray atomicReferenceArray2;
        Object object = atomicReferenceArray2;
        atomicReferenceArray2 = new AtomicReferenceArray(n2);
        v1._byteBuffers = object;
        object = atomicReferenceArray;
        atomicReferenceArray = new AtomicReferenceArray(n3);
        v1._charBuffers = object;
    }

    public final byte[] allocByteBuffer(int n2) {
        return this.allocByteBuffer(n2, 0);
    }

    public byte[] allocByteBuffer(int n2, int n3) {
        byte[] byArray;
        int n4 = this.byteBufferLength(n2);
        if (n3 < n4) {
            n3 = n4;
        }
        if ((byArray = (byte[])this._byteBuffers.getAndSet(n2, null)) == null || byArray.length < n3) {
            byArray = this.balloc(n3);
        }
        return byArray;
    }

    public void releaseByteBuffer(int n2, byte[] byArray) {
        this._byteBuffers.set(n2, byArray);
    }

    public final char[] allocCharBuffer(int n2) {
        return this.allocCharBuffer(n2, 0);
    }

    public char[] allocCharBuffer(int n2, int n3) {
        char[] cArray;
        int n4 = this.charBufferLength(n2);
        if (n3 < n4) {
            n3 = n4;
        }
        if ((cArray = (char[])this._charBuffers.getAndSet(n2, null)) == null || cArray.length < n3) {
            cArray = this.calloc(n3);
        }
        return cArray;
    }

    public void releaseCharBuffer(int n2, char[] cArray) {
        this._charBuffers.set(n2, cArray);
    }

    public int byteBufferLength(int n2) {
        return BYTE_BUFFER_LENGTHS[n2];
    }

    public int charBufferLength(int n2) {
        return CHAR_BUFFER_LENGTHS[n2];
    }

    public byte[] balloc(int n2) {
        return new byte[n2];
    }

    public char[] calloc(int n2) {
        return new char[n2];
    }
}

