/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.util;

import com.privatefasterxml.jackson.core.util.BufferRecycler;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream {
    public static final byte[] NO_BYTES = new byte[0];
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 131072;
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private final BufferRecycler _bufferRecycler;
    private final LinkedList<byte[]> _pastBlocks;
    private int _pastLen;
    private byte[] _currBlock;
    private int _currBlockPtr;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(int n2) {
        this(null, n2);
    }

    public ByteArrayBuilder(BufferRecycler object, int n2) {
        LinkedList linkedList;
        LinkedList linkedList2 = linkedList;
        linkedList = new LinkedList();
        this._pastBlocks = linkedList2;
        this._bufferRecycler = object;
        if (n2 > 131072) {
            n2 = 131072;
        }
        object = object == null ? (Object)new byte[n2] : (Object)((BufferRecycler)object).allocByteBuffer(2);
        this._currBlock = (byte[])object;
    }

    private ByteArrayBuilder(BufferRecycler bufferRecycler, byte[] byArray, int n2) {
        LinkedList linkedList;
        LinkedList linkedList2 = linkedList;
        linkedList = new LinkedList();
        v1._pastBlocks = linkedList2;
        v1._bufferRecycler = null;
        v1._currBlock = byArray;
        v1._currBlockPtr = n2;
    }

    public static ByteArrayBuilder fromInitial(byte[] byArray, int n2) {
        return new ByteArrayBuilder(null, byArray, n2);
    }

    private void _allocMore() {
        int n2 = this._pastLen + this._currBlock.length;
        if (n2 >= 0) {
            this._pastLen = n2;
            if ((n2 = Math.max(n2 >> 1, 1000)) > 131072) {
                n2 = 131072;
            }
            ByteArrayBuilder byteArrayBuilder = this;
            this._pastBlocks.add(this._currBlock);
            byteArrayBuilder._currBlock = new byte[n2];
            byteArrayBuilder._currBlockPtr = 0;
            return;
        }
        throw new IllegalStateException("Maximum Java array size (2GB) exceeded by `ByteArrayBuilder`");
    }

    public void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public int size() {
        return this._pastLen + this._currBlockPtr;
    }

    public void release() {
        ByteArrayBuilder byteArrayBuilder = this;
        byteArrayBuilder.reset();
        BufferRecycler bufferRecycler = byteArrayBuilder._bufferRecycler;
        if (bufferRecycler != null) {
            byte[] byArray = this._currBlock;
            if (this._currBlock != null) {
                bufferRecycler.releaseByteBuffer(2, byArray);
                this._currBlock = null;
            }
        }
    }

    public void append(int n2) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        int n3 = this._currBlockPtr;
        this._currBlockPtr = n3 + 1;
        this._currBlock[n3] = (byte)n2;
    }

    public void appendTwoBytes(int n2) {
        int n3 = this._currBlockPtr;
        byte[] byArray = this._currBlock;
        if (n3 + 1 < this._currBlock.length) {
            int n4 = n3 + 1;
            byArray[n3] = (byte)(n2 >> 8);
            this._currBlockPtr = n3 + 2;
            byArray[n4] = (byte)n2;
        } else {
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public void appendThreeBytes(int n2) {
        int n3 = this._currBlockPtr;
        byte[] byArray = this._currBlock;
        if (n3 + 2 < this._currBlock.length) {
            int n4 = n2;
            int n5 = n2;
            int n6 = n3 + 1;
            byArray[n3] = (byte)(n2 >> 16);
            n2 = n3 + 2;
            byArray[n6] = (byte)(n5 >> 8);
            this._currBlockPtr = n3 + 3;
            byArray[n2] = (byte)n4;
        } else {
            this.append(n2 >> 16);
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public void appendFourBytes(int n2) {
        int n3 = this._currBlockPtr;
        byte[] byArray = this._currBlock;
        if (n3 + 3 < this._currBlock.length) {
            int n4 = n2;
            int n5 = n2;
            int n6 = n2;
            int n7 = n3 + 1;
            byArray[n3] = (byte)(n2 >> 24);
            n2 = n3 + 2;
            byArray[n7] = (byte)(n6 >> 16);
            n7 = n3 + 3;
            byArray[n2] = (byte)(n5 >> 8);
            this._currBlockPtr = n3 + 4;
            byArray[n7] = (byte)n4;
        } else {
            this.append(n2 >> 24);
            this.append(n2 >> 16);
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public byte[] toByteArray() {
        int n2 = this._pastLen + this._currBlockPtr;
        if (n2 == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        ByteArrayBuilder byteArrayBuilder = this;
        int n5 = this._currBlockPtr;
        System.arraycopy(byteArrayBuilder._currBlock, 0, byArray, n3, n5);
        if ((n3 += byteArrayBuilder._currBlockPtr) == n2) {
            if (!this._pastBlocks.isEmpty()) {
                this.reset();
            }
            return byArray;
        }
        throw new RuntimeException("Internal error: total len assumed to be " + n2 + ", copied " + n3 + " bytes");
    }

    public byte[] resetAndGetFirstSegment() {
        ByteArrayBuilder byteArrayBuilder = this;
        byteArrayBuilder.reset();
        return byteArrayBuilder._currBlock;
    }

    public byte[] finishCurrentSegment() {
        ByteArrayBuilder byteArrayBuilder = this;
        byteArrayBuilder._allocMore();
        return byteArrayBuilder._currBlock;
    }

    public byte[] completeAndCoalesce(int n2) {
        this._currBlockPtr = n2;
        return this.toByteArray();
    }

    public byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public void setCurrentSegmentLength(int n2) {
        this._currBlockPtr = n2;
    }

    public int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    @Override
    public void write(byte[] byArray) {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        while (true) {
            int n4;
            if ((n4 = Math.min(this._currBlock.length - this._currBlockPtr, n3)) > 0) {
                ByteArrayBuilder byteArrayBuilder = this;
                byte[] byArray2 = byteArrayBuilder._currBlock;
                System.arraycopy(byArray, n2, byArray2, byteArrayBuilder._currBlockPtr, n4);
                n2 += n4;
                this._currBlockPtr += n4;
                n3 -= n4;
            }
            if (n3 <= 0) {
                return;
            }
            this._allocMore();
        }
    }

    @Override
    public void write(int n2) {
        this.append(n2);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

