/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.util;

import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.util.DefaultPrettyPrinter;

public class DefaultIndenter
extends DefaultPrettyPrinter.NopIndenter {
    private static final long serialVersionUID = 1L;
    public static final String SYS_LF;
    public static final DefaultIndenter SYSTEM_LINEFEED_INSTANCE;
    private static final int INDENT_LEVELS = 16;
    private final char[] indents;
    private final int charsPerLevel;
    private final String eol;

    public DefaultIndenter() {
        this("  ", SYS_LF);
    }

    public DefaultIndenter(String string, String string2) {
        this.charsPerLevel = string.length();
        this.indents = new char[string.length() * 16];
        int n2 = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            String string3 = string;
            int n3 = string.length();
            char[] cArray = this.indents;
            string3.getChars(0, n3, cArray, n2);
            n2 = string3.length() + n2;
        }
        this.eol = string2;
    }

    static {
        String string;
        try {
            string = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            string = "\n";
        }
        SYS_LF = string;
        SYSTEM_LINEFEED_INSTANCE = new DefaultIndenter("  ", string);
    }

    public DefaultIndenter withLinefeed(String string) {
        if (string.equals(this.eol)) {
            return this;
        }
        return new DefaultIndenter(this.getIndent(), string);
    }

    public DefaultIndenter withIndent(String string) {
        if (string.equals(this.getIndent())) {
            return this;
        }
        return new DefaultIndenter(string, this.eol);
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public void writeIndentation(JsonGenerator jsonGenerator, int n2) {
        jsonGenerator.writeRaw(this.eol);
        if (n2 > 0) {
            char[] cArray;
            n2 *= this.charsPerLevel;
            while (true) {
                cArray = this.indents;
                if (n2 <= this.indents.length) break;
                jsonGenerator.writeRaw(cArray, 0, cArray.length);
                n2 -= this.indents.length;
            }
            jsonGenerator.writeRaw(cArray, 0, n2);
        }
    }

    public String getEol() {
        return this.eol;
    }

    public String getIndent() {
        DefaultIndenter defaultIndenter = object;
        Object object = defaultIndenter.indents;
        int n2 = defaultIndenter.charsPerLevel;
        return new String((char[])object, 0, n2);
    }
}

