/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.util;

import com.privatefasterxml.jackson.core.util.JacksonFeature;

public final class JacksonFeatureSet<F extends JacksonFeature> {
    protected int _enabled;

    public JacksonFeatureSet(int n2) {
        this._enabled = n2;
    }

    public static <F extends JacksonFeature> JacksonFeatureSet<F> fromDefaults(F[] FArray) {
        if (FArray.length <= 31) {
            int n2 = 0;
            for (F f2 : FArray) {
                if (!f2.enabledByDefault()) continue;
                n2 |= f2.getMask();
            }
            return new JacksonFeatureSet<F>(n2);
        }
        String string = FArray[0].getClass().getName();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string;
        objectArray[1] = FArray.length;
        throw new IllegalArgumentException(String.format("Can not use type `%s` with JacksonFeatureSet: too many entries (%d > 31)", objectArray2));
    }

    public static <F extends JacksonFeature> JacksonFeatureSet<F> fromBitmask(int n2) {
        return new JacksonFeatureSet<F>(n2);
    }

    public JacksonFeatureSet<F> with(F f2) {
        int n2 = jacksonFeatureSet2._enabled | f2.getMask();
        if (n2 != jacksonFeatureSet2._enabled) {
            JacksonFeatureSet<F> jacksonFeatureSet;
            JacksonFeatureSet jacksonFeatureSet2 = jacksonFeatureSet;
            jacksonFeatureSet = new JacksonFeatureSet<F>(n2);
        }
        return jacksonFeatureSet2;
    }

    public JacksonFeatureSet<F> without(F f2) {
        int n2 = jacksonFeatureSet2._enabled & ~f2.getMask();
        if (n2 != jacksonFeatureSet2._enabled) {
            JacksonFeatureSet<F> jacksonFeatureSet;
            JacksonFeatureSet jacksonFeatureSet2 = jacksonFeatureSet;
            jacksonFeatureSet = new JacksonFeatureSet<F>(n2);
        }
        return jacksonFeatureSet2;
    }

    public boolean isEnabled(F f2) {
        return (f2.getMask() & this._enabled) != 0;
    }

    public int asBitmask() {
        return this._enabled;
    }
}

