/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.core.util;

import com.privatefasterxml.jackson.core.io.NumberInput;
import com.privatefasterxml.jackson.core.util.BufferRecycler;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public final class TextBuffer {
    static final char[] NO_CHARS = new char[0];
    static final int MIN_SEGMENT_LEN = 500;
    static final int MAX_SEGMENT_LEN = 65536;
    private final BufferRecycler _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private ArrayList<char[]> _segments;
    private boolean _hasSegments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public TextBuffer(BufferRecycler bufferRecycler) {
        this._allocator = bufferRecycler;
    }

    public TextBuffer(BufferRecycler bufferRecycler, char[] cArray) {
        TextBuffer textBuffer = this;
        this._allocator = bufferRecycler;
        this._currentSegment = cArray;
        textBuffer._currentSize = cArray.length;
        textBuffer._inputStart = -1;
    }

    public static TextBuffer fromInitial(char[] cArray) {
        return new TextBuffer(null, cArray);
    }

    private char[] buf(int n2) {
        BufferRecycler bufferRecycler = ((TextBuffer)((Object)bufferRecycler))._allocator;
        if (bufferRecycler != null) {
            return bufferRecycler.allocCharBuffer(2, n2);
        }
        return new char[Math.max(n2, 500)];
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        this._segmentSize = 0;
        this._currentSize = 0;
    }

    private void unshare(int n2) {
        TextBuffer textBuffer = this;
        int n3 = textBuffer._inputLen;
        TextBuffer textBuffer2 = this;
        textBuffer2._inputLen = 0;
        char[] cArray = textBuffer2._inputBuffer;
        textBuffer2._inputBuffer = null;
        int n4 = textBuffer2._inputStart;
        textBuffer2._inputStart = -1;
        n2 = n3 + n2;
        char[] cArray2 = textBuffer._currentSegment;
        if (textBuffer._currentSegment == null || n2 > cArray2.length) {
            this._currentSegment = this.buf(n2);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this._currentSegment, 0, n3);
        }
        TextBuffer textBuffer3 = this;
        textBuffer3._segmentSize = 0;
        textBuffer3._currentSize = n3;
    }

    private void expand(int n2) {
        if (this._segments == null) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            this._segments = arrayList2;
        }
        char[] cArray = this._currentSegment;
        TextBuffer textBuffer = this;
        textBuffer._hasSegments = true;
        textBuffer._segments.add(cArray);
        textBuffer._segmentSize += cArray.length;
        textBuffer._currentSize = 0;
        int n3 = this._currentSegment.length;
        int n4 = n3 + (n3 >> 1);
        if (n4 < 500) {
            n4 = 500;
        } else if (n4 > 65536) {
            n4 = 65536;
        }
        this._currentSegment = this.carr(n4);
    }

    private char[] resultArray() {
        String string = this._resultString;
        if (string != null) {
            return string.toCharArray();
        }
        int n2 = this._inputStart;
        if (n2 >= 0) {
            int n3 = this._inputLen;
            if (n3 < 1) {
                return NO_CHARS;
            }
            if (n2 == 0) {
                return Arrays.copyOf(this._inputBuffer, n3);
            }
            int n4 = n2;
            return Arrays.copyOfRange(this._inputBuffer, n4, n4 + n3);
        }
        n2 = this.size();
        if (n2 < 1) {
            return NO_CHARS;
        }
        TextBuffer textBuffer = this;
        int n5 = 0;
        char[] cArray = textBuffer.carr(n2);
        ArrayList<char[]> arrayList = textBuffer._segments;
        if (arrayList != null) {
            int n6 = arrayList.size();
            for (int i2 = 0; i2 < n6; ++i2) {
                char[] cArray2 = this._segments.get(i2);
                int n7 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n5, n7);
                n5 += n7;
            }
        }
        int n8 = this._currentSize;
        System.arraycopy(this._currentSegment, 0, cArray, n5, n8);
        return cArray;
    }

    private char[] carr(int n2) {
        return new char[n2];
    }

    public void releaseBuffers() {
        BufferRecycler bufferRecycler;
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        if ((bufferRecycler = this._allocator) != null) {
            char[] cArray = this._currentSegment;
            if (this._currentSegment != null) {
                this._currentSegment = null;
                bufferRecycler.releaseCharBuffer(2, cArray);
            }
        }
    }

    public void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWith(char c2) {
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(1);
        }
        this._currentSegment[0] = c2;
        this._segmentSize = 1;
        this._currentSize = 1;
    }

    public void resetWithShared(char[] cArray, int n2, int n3) {
        TextBuffer textBuffer = this;
        textBuffer._resultString = null;
        textBuffer._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n2;
        this._inputLen = n3;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithCopy(char[] cArray, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        this._segmentSize = 0;
        this._currentSize = 0;
        this.append(cArray, n2, n3);
    }

    public void resetWithCopy(String string, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        this._segmentSize = 0;
        this._currentSize = 0;
        this.append(string, n2, n3);
    }

    public void resetWithString(String string) {
        TextBuffer textBuffer = this;
        textBuffer._inputBuffer = null;
        textBuffer._inputStart = -1;
        textBuffer._inputLen = 0;
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    public char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    public int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        Object object = this._resultArray;
        if (this._resultArray != null) {
            return ((char[])object).length;
        }
        String string = this._resultString;
        object = string;
        if (string != null) {
            return ((String)object).length();
        }
        return this._segmentSize + this._currentSize;
    }

    public int getTextOffset() {
        int n2 = this._inputStart;
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public boolean hasTextAsCharacters() {
        if (this._inputStart < 0 && this._resultArray == null) {
            return this._resultString == null;
        }
        return true;
    }

    public char[] getTextBuffer() {
        if (((TextBuffer)object2)._inputStart >= 0) {
            return ((TextBuffer)object2)._inputBuffer;
        }
        Object object = ((TextBuffer)object2)._resultArray;
        if (((TextBuffer)object2)._resultArray != null) {
            return object;
        }
        String string = ((TextBuffer)object2)._resultString;
        object = string;
        if (string != null) {
            ((TextBuffer)object2)._resultArray = ((String)object).toCharArray();
            return ((TextBuffer)object2)._resultArray;
        }
        if (!((TextBuffer)object2)._hasSegments) {
            Object object2 = ((TextBuffer)object2)._currentSegment;
            if (((TextBuffer)object2)._currentSegment == null) {
                object2 = NO_CHARS;
            }
            return object2;
        }
        return ((TextBuffer)object2).contentsAsArray();
    }

    public String contentsAsString() {
        if (this._resultString == null) {
            char[] cArray = this._resultArray;
            if (this._resultArray != null) {
                String string;
                String string2 = string;
                string = new String(cArray);
                this._resultString = string2;
            } else {
                int n2 = this._inputStart;
                if (n2 >= 0) {
                    int n3 = this._inputLen;
                    if (n3 < 1) {
                        this._resultString = "";
                        return "";
                    }
                    this._resultString = new String(this._inputBuffer, n2, n3);
                } else {
                    n2 = this._segmentSize;
                    int n4 = this._currentSize;
                    if (n2 == 0) {
                        String string;
                        if (n4 == 0) {
                            string = "";
                        } else {
                            String string3;
                            string = string3;
                            string3 = new String(this._currentSegment, 0, n4);
                        }
                        this._resultString = string;
                    } else {
                        StringBuilder stringBuilder;
                        StringBuilder stringBuilder2 = stringBuilder;
                        stringBuilder = new StringBuilder(n2 + n4);
                        ArrayList<char[]> arrayList = this._segments;
                        if (arrayList != null) {
                            n4 = arrayList.size();
                            for (int i2 = 0; i2 < n4; ++i2) {
                                char[] cArray2 = this._segments.get(i2);
                                stringBuilder2.append(cArray2, 0, cArray2.length);
                            }
                        }
                        StringBuilder stringBuilder3 = stringBuilder2;
                        TextBuffer textBuffer = this;
                        char[] cArray3 = textBuffer._currentSegment;
                        n4 = textBuffer._currentSize;
                        stringBuilder3.append(cArray3, 0, n4);
                        this._resultString = stringBuilder3.toString();
                    }
                }
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (this._resultArray == null) {
            this._resultArray = cArray = this.resultArray();
        }
        return cArray;
    }

    public BigDecimal contentsAsDecimal() {
        char[] cArray = this._resultArray;
        if (this._resultArray != null) {
            return NumberInput.parseBigDecimal(cArray);
        }
        int n2 = this._inputStart;
        if (n2 >= 0) {
            char[] cArray2 = this._inputBuffer;
            if (this._inputBuffer != null) {
                return NumberInput.parseBigDecimal(cArray2, n2, this._inputLen);
            }
        }
        if (this._segmentSize == 0) {
            char[] cArray3 = this._currentSegment;
            if (this._currentSegment != null) {
                return NumberInput.parseBigDecimal(cArray3, 0, this._currentSize);
            }
        }
        return NumberInput.parseBigDecimal(this.contentsAsArray());
    }

    @Deprecated
    public double contentsAsDouble() {
        return this.contentsAsDouble(false);
    }

    public double contentsAsDouble(boolean bl) {
        return NumberInput.parseDouble(this.contentsAsString(), bl);
    }

    @Deprecated
    public float contentsAsFloat() {
        return this.contentsAsFloat(false);
    }

    public float contentsAsFloat(boolean bl) {
        return NumberInput.parseFloat(this.contentsAsString(), bl);
    }

    public int contentsAsInt(boolean bl) {
        int n2 = this._inputStart;
        if (n2 >= 0) {
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                if (bl) {
                    return -NumberInput.parseInt(cArray, n2 + 1, this._inputLen - 1);
                }
                return NumberInput.parseInt(cArray, n2, this._inputLen);
            }
        }
        if (bl) {
            return -NumberInput.parseInt(this._currentSegment, 1, this._currentSize - 1);
        }
        return NumberInput.parseInt(this._currentSegment, 0, this._currentSize);
    }

    public long contentsAsLong(boolean bl) {
        int n2 = this._inputStart;
        if (n2 >= 0) {
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                if (bl) {
                    return -NumberInput.parseLong(cArray, n2 + 1, this._inputLen - 1);
                }
                return NumberInput.parseLong(cArray, n2, this._inputLen);
            }
        }
        if (bl) {
            return -NumberInput.parseLong(this._currentSegment, 1, this._currentSize - 1);
        }
        return NumberInput.parseLong(this._currentSegment, 0, this._currentSize);
    }

    public int contentsToWriter(Writer writer) {
        int n2;
        Object object = this._resultArray;
        if (this._resultArray != null) {
            writer.write((char[])object);
            return this._resultArray.length;
        }
        String string = this._resultString;
        object = string;
        if (string != null) {
            writer.write((String)object);
            return this._resultString.length();
        }
        int n3 = this._inputStart;
        if (n3 >= 0) {
            int n4 = this._inputLen;
            if (n4 > 0) {
                writer.write(this._inputBuffer, n3, n4);
            }
            return n4;
        }
        n3 = 0;
        ArrayList<char[]> arrayList = this._segments;
        if (arrayList != null) {
            int n5 = arrayList.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = n3;
                char[] cArray = this._segments.get(i2);
                n3 = cArray.length;
                writer.write(cArray, 0, n3);
                n3 = n6 + n3;
            }
        }
        if ((n2 = this._currentSize) > 0) {
            writer.write(this._currentSegment, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    public void append(char c2) {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        TextBuffer textBuffer = this;
        textBuffer._resultString = null;
        textBuffer._resultArray = null;
        char[] cArray = textBuffer._currentSegment;
        if (textBuffer._currentSize >= cArray.length) {
            TextBuffer textBuffer2 = this;
            textBuffer2.expand(1);
            cArray = textBuffer2._currentSegment;
        }
        int n2 = this._currentSize;
        this._currentSize = n2 + 1;
        cArray[n2] = c2;
    }

    public void append(char[] cArray, int n2, int n3) {
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        TextBuffer textBuffer = this;
        textBuffer._resultString = null;
        textBuffer._resultArray = null;
        char[] cArray2 = textBuffer._currentSegment;
        int n4 = this._currentSize;
        int n5 = textBuffer._currentSegment.length - n4;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, n4, n3);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, n4, n5);
            n2 += n5;
            n3 -= n5;
        }
        while (true) {
            int n6 = n3;
            int n7 = n2;
            int n8 = n2;
            TextBuffer textBuffer2 = this;
            textBuffer2.expand(n3);
            n2 = Math.min(textBuffer2._currentSegment.length, n3);
            System.arraycopy(cArray, n8, textBuffer2._currentSegment, 0, n2);
            this._currentSize += n2;
            n3 = n7 + n2;
            n2 = n6 - n2;
            if (n2 <= 0) {
                return;
            }
            int n9 = n2;
            n2 = n3;
            n3 = n9;
        }
    }

    public void append(String string, int n2, int n3) {
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        TextBuffer textBuffer = this;
        textBuffer._resultString = null;
        textBuffer._resultArray = null;
        char[] cArray = textBuffer._currentSegment;
        int n4 = this._currentSize;
        int n5 = textBuffer._currentSegment.length - n4;
        if (n5 >= n3) {
            int n6 = n2;
            string.getChars(n6, n6 + n3, cArray, n4);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            int n7 = n3;
            n3 = n2 + n5;
            string.getChars(n2, n3, cArray, n4);
            int n8 = n2 = n7 - n5;
            n2 = n3;
            n3 = n8;
        }
        while (true) {
            int n9 = n3;
            int n10 = n2;
            int n11 = n2;
            TextBuffer textBuffer2 = this;
            textBuffer2.expand(n3);
            n2 = Math.min(textBuffer2._currentSegment.length, n3);
            n3 = n11 + n2;
            string.getChars(n10, n3, this._currentSegment, 0);
            this._currentSize += n2;
            n2 = n9 - n2;
            if (n2 <= 0) {
                return;
            }
            int n12 = n2;
            n2 = n3;
            n3 = n12;
        }
    }

    public char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (this._currentSegment == null) {
                this._currentSegment = this.buf(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this._currentSegment;
    }

    public char[] emptyAndGetCurrentSegment() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        char[] cArray = this._currentSegment;
        if (this._currentSegment == null) {
            this._currentSegment = cArray = this.buf(0);
        }
        return cArray;
    }

    public int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public String setCurrentAndReturn(int n2) {
        String string;
        this._currentSize = n2;
        if (this._segmentSize > 0) {
            return this.contentsAsString();
        }
        if (n2 == 0) {
            string = "";
        } else {
            String string2;
            String string3 = string2;
            string2 = new String(this._currentSegment, 0, n2);
            string = string3;
        }
        this._resultString = string;
        return string;
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            this._segments = arrayList2;
        }
        TextBuffer textBuffer = this;
        textBuffer._hasSegments = true;
        textBuffer._segments.add(this._currentSegment);
        int n2 = textBuffer._currentSegment.length;
        this._segmentSize += n2;
        this._currentSize = 0;
        n2 += n2 >> 1;
        if (n2 < 500) {
            n2 = 500;
        } else if (n2 > 65536) {
            n2 = 65536;
        }
        this._currentSegment = this.carr(n2);
        return this._currentSegment;
    }

    public char[] expandCurrentSegment() {
        char[] cArray = this._currentSegment;
        int n2 = this._currentSegment.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 > 65536) {
            int n4 = n2;
            n3 = n4 + (n4 >> 2);
        }
        this._currentSegment = Arrays.copyOf(cArray, n3);
        return this._currentSegment;
    }

    public char[] expandCurrentSegment(int n2) {
        char[] cArray = this._currentSegment;
        if (this._currentSegment.length >= n2) {
            return cArray;
        }
        this._currentSegment = Arrays.copyOf(cArray, n2);
        return this._currentSegment;
    }

    public String toString() {
        return this.contentsAsString();
    }
}

