/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.JsonInclude;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyMetadata;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.Annotations;
import com.privatefasterxml.jackson.databind.util.Named;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public interface BeanProperty
extends Named {
    public static final JsonFormat.Value EMPTY_FORMAT = new JsonFormat.Value();
    public static final JsonInclude.Value EMPTY_INCLUDE = JsonInclude.Value.empty();

    @Override
    public String getName();

    public PropertyName getFullName();

    public JavaType getType();

    public PropertyName getWrapperName();

    public PropertyMetadata getMetadata();

    public boolean isRequired();

    public boolean isVirtual();

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public <A extends Annotation> A getContextAnnotation(Class<A> var1);

    public AnnotatedMember getMember();

    @Deprecated
    public JsonFormat.Value findFormatOverrides(AnnotationIntrospector var1);

    public JsonFormat.Value findPropertyFormat(MapperConfig<?> var1, Class<?> var2);

    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> var1, Class<?> var2);

    public List<PropertyName> findAliases(MapperConfig<?> var1);

    public void depositSchemaProperty(JsonObjectFormatVisitor var1, SerializerProvider var2);

    public static class Bogus
    implements BeanProperty {
        @Override
        public String getName() {
            return "";
        }

        @Override
        public PropertyName getFullName() {
            return PropertyName.NO_NAME;
        }

        @Override
        public JavaType getType() {
            return TypeFactory.unknownType();
        }

        @Override
        public PropertyName getWrapperName() {
            return null;
        }

        @Override
        public PropertyMetadata getMetadata() {
            return PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return null;
        }

        @Override
        public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
            return null;
        }

        @Override
        public AnnotatedMember getMember() {
            return null;
        }

        @Override
        @Deprecated
        public JsonFormat.Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
            return JsonFormat.Value.empty();
        }

        @Override
        public JsonFormat.Value findPropertyFormat(MapperConfig<?> mapperConfig, Class<?> clazz) {
            return JsonFormat.Value.empty();
        }

        @Override
        public JsonInclude.Value findPropertyInclusion(MapperConfig<?> mapperConfig, Class<?> clazz) {
            return null;
        }

        @Override
        public List<PropertyName> findAliases(MapperConfig<?> mapperConfig) {
            return Collections.emptyList();
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
        }
    }

    public static class Std
    implements BeanProperty,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final PropertyName _name;
        protected final JavaType _type;
        protected final PropertyName _wrapperName;
        protected final PropertyMetadata _metadata;
        protected final AnnotatedMember _member;

        public Std(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, AnnotatedMember annotatedMember, PropertyMetadata propertyMetadata) {
            this._name = propertyName;
            this._type = javaType;
            this._wrapperName = propertyName2;
            this._metadata = propertyMetadata;
            this._member = annotatedMember;
        }

        @Deprecated
        public Std(PropertyName propertyName, JavaType javaType, PropertyName propertyName2, Annotations annotations, AnnotatedMember annotatedMember, PropertyMetadata propertyMetadata) {
            this(propertyName, javaType, propertyName2, annotatedMember, propertyMetadata);
        }

        public Std(Std serializable, JavaType javaType) {
            Std std = serializable2;
            Std std2 = serializable;
            Serializable serializable2 = std2._name;
            serializable = std2._wrapperName;
            AnnotatedMember annotatedMember = std2._member;
            PropertyMetadata propertyMetadata = std2._metadata;
            std((PropertyName)serializable2, javaType, (PropertyName)serializable, annotatedMember, propertyMetadata);
        }

        public Std withType(JavaType javaType) {
            return new Std(this, javaType);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            Serializable serializable = ((Std)serializable)._member;
            return serializable == null ? null : (A)((AnnotatedMember)serializable).getAnnotation(clazz);
        }

        @Override
        public <A extends Annotation> A getContextAnnotation(Class<A> clazz) {
            return null;
        }

        @Override
        @Deprecated
        public JsonFormat.Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
            Serializable serializable = serializable._member;
            if (serializable != null && annotationIntrospector != null && (serializable = annotationIntrospector.findFormat((Annotated)((Object)serializable))) != null) {
                return serializable;
            }
            return EMPTY_FORMAT;
        }

        @Override
        public JsonFormat.Value findPropertyFormat(MapperConfig<?> serializable, Class<?> serializable2) {
            AnnotatedMember annotatedMember;
            AnnotationIntrospector annotationIntrospector;
            JsonFormat.Value value;
            void v0 = value;
            value = v0.getDefaultPropertyFormat((Class<?>)((Object)annotationIntrospector));
            annotationIntrospector = v0.getAnnotationIntrospector();
            if (annotationIntrospector != null && (annotatedMember = this._member) != null) {
                JsonFormat.Value value2 = annotationIntrospector.findFormat(annotatedMember);
                if (value2 == null) {
                    return value;
                }
                return value.withOverrides(value2);
            }
            return value;
        }

        @Override
        public JsonInclude.Value findPropertyInclusion(MapperConfig<?> serializable, Class<?> serializable2) {
            AnnotatedMember annotatedMember;
            AnnotationIntrospector annotationIntrospector;
            JsonInclude.Value value;
            void v0 = value;
            value = v0.getDefaultInclusion((Class<?>)((Object)annotationIntrospector), this._type.getRawClass());
            annotationIntrospector = v0.getAnnotationIntrospector();
            if (annotationIntrospector != null && (annotatedMember = this._member) != null) {
                JsonInclude.Value value2 = annotationIntrospector.findPropertyInclusion(annotatedMember);
                if (value2 == null) {
                    return value;
                }
                return value.withOverrides(value2);
            }
            return value;
        }

        @Override
        public List<PropertyName> findAliases(MapperConfig<?> mapperConfig) {
            return Collections.emptyList();
        }

        @Override
        public String getName() {
            return this._name.getSimpleName();
        }

        @Override
        public PropertyName getFullName() {
            return this._name;
        }

        @Override
        public JavaType getType() {
            return this._type;
        }

        @Override
        public PropertyName getWrapperName() {
            return this._wrapperName;
        }

        @Override
        public boolean isRequired() {
            return this._metadata.isRequired();
        }

        @Override
        public PropertyMetadata getMetadata() {
            return this._metadata;
        }

        @Override
        public AnnotatedMember getMember() {
            return this._member;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }

        @Override
        public void depositSchemaProperty(JsonObjectFormatVisitor jsonObjectFormatVisitor, SerializerProvider serializerProvider) {
            throw new UnsupportedOperationException("Instances of " + this.getClass().getName() + " should not get visited");
        }
    }
}

