/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.applitools.android.common.a;
import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.privatefasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DatabindContext {
    private static final int MAX_ERROR_STR_LEN = 500;

    private JavaType _resolveAndValidateGeneric(JavaType javaType, String string, PolymorphicTypeValidator polymorphicTypeValidator, int n2) {
        MapperConfig<?> mapperConfig = this.getConfig();
        Object object = string.substring(0, n2);
        if ((object = polymorphicTypeValidator.validateSubClassName(mapperConfig, javaType, (String)object)) == PolymorphicTypeValidator.Validity.DENIED) {
            return (JavaType)this._throwSubtypeNameNotAllowed(javaType, string, polymorphicTypeValidator);
        }
        JavaType javaType2 = this.getTypeFactory().constructFromCanonical(string);
        if (!javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
            return (JavaType)this._throwNotASubtype(javaType, string);
        }
        if (object != (object = PolymorphicTypeValidator.Validity.ALLOWED) && polymorphicTypeValidator.validateSubType(mapperConfig, javaType, javaType2) != object) {
            return (JavaType)this._throwSubtypeClassNotAllowed(javaType, string, polymorphicTypeValidator);
        }
        return javaType2;
    }

    public abstract MapperConfig<?> getConfig();

    public abstract AnnotationIntrospector getAnnotationIntrospector();

    public abstract boolean isEnabled(MapperFeature var1);

    public abstract boolean isEnabled(DatatypeFeature var1);

    public abstract boolean canOverrideAccessModifiers();

    public abstract Class<?> getActiveView();

    public abstract Locale getLocale();

    public abstract TimeZone getTimeZone();

    public abstract JsonFormat.Value getDefaultPropertyFormat(Class<?> var1);

    public abstract Object getAttribute(Object var1);

    public abstract DatabindContext setAttribute(Object var1, Object var2);

    public JavaType constructType(Type type) {
        if (type == null) {
            return null;
        }
        return this.getTypeFactory().constructType(type);
    }

    public abstract JavaType constructSpecializedType(JavaType var1, Class<?> var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JavaType resolveSubType(JavaType javaType, String string) {
        Object[] objectArray3;
        if (string.indexOf(60) > 0) {
            JavaType javaType2 = objectArray3.getTypeFactory().constructFromCanonical(string);
            if (!javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) throw objectArray3.invalidTypeIdException(javaType, string, "Not a subtype");
            return javaType2;
        }
        try {
            Class<?> clazz = objectArray3.getTypeFactory().findClass(string);
            if (!javaType.isTypeOrSuperTypeOf(clazz)) throw objectArray3.invalidTypeIdException(javaType, string, "Not a subtype");
            return objectArray3.getTypeFactory().constructSpecializedType(javaType, clazz);
        }
        catch (Exception exception) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        objectArray3 = objectArray2;
        objectArray3[0] = exception.getClass().getName();
        objectArray2[1] = ClassUtil.exceptionMessage(exception);
        throw objectArray.invalidTypeIdException(javaType, string, String.format("problem: (%s) %s", objectArray3));
    }

    public JavaType resolveAndValidateSubType(JavaType javaType, String string, PolymorphicTypeValidator polymorphicTypeValidator) {
        block7: {
            Exception exception2;
            Class<?> clazz;
            Object object;
            MapperConfig<?> mapperConfig;
            block6: {
                int n2 = string.indexOf(60);
                if (n2 > 0) {
                    return objectArray3._resolveAndValidateGeneric(javaType, string, polymorphicTypeValidator, n2);
                }
                mapperConfig = objectArray3.getConfig();
                object = polymorphicTypeValidator.validateSubClassName(mapperConfig, javaType, string);
                if (object == PolymorphicTypeValidator.Validity.DENIED) {
                    return (JavaType)objectArray3._throwSubtypeNameNotAllowed(javaType, string, polymorphicTypeValidator);
                }
                try {
                    clazz = objectArray3.getTypeFactory().findClass(string);
                    if (javaType.isTypeOrSuperTypeOf(clazz)) break block6;
                }
                catch (Exception exception2) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break block7;
                }
                return (JavaType)objectArray3._throwNotASubtype(javaType, string);
            }
            PolymorphicTypeValidator.Validity validity = object;
            object = mapperConfig.getTypeFactory().constructSpecializedType(javaType, clazz);
            if (validity == PolymorphicTypeValidator.Validity.INDETERMINATE && polymorphicTypeValidator.validateSubType(mapperConfig, javaType, (JavaType)object) != PolymorphicTypeValidator.Validity.ALLOWED) {
                return (JavaType)objectArray3._throwSubtypeClassNotAllowed(javaType, string, polymorphicTypeValidator);
            }
            return object;
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = exception2.getClass().getName();
            objectArray2[1] = ClassUtil.exceptionMessage(exception2);
            throw objectArray.invalidTypeIdException(javaType, string, String.format("problem: (%s) %s", objectArray3));
        }
        return null;
    }

    public <T> T _throwNotASubtype(JavaType javaType, String string) {
        throw this.invalidTypeIdException(javaType, string, "Not a subtype");
    }

    public <T> T _throwSubtypeNameNotAllowed(JavaType javaType, String string, PolymorphicTypeValidator polymorphicTypeValidator) {
        throw this.invalidTypeIdException(javaType, string, "Configured `PolymorphicTypeValidator` (of type " + ClassUtil.classNameOf(polymorphicTypeValidator) + ") denied resolution");
    }

    public <T> T _throwSubtypeClassNotAllowed(JavaType javaType, String string, PolymorphicTypeValidator polymorphicTypeValidator) {
        throw this.invalidTypeIdException(javaType, string, "Configured `PolymorphicTypeValidator` (of type " + ClassUtil.classNameOf(polymorphicTypeValidator) + ") denied resolution");
    }

    public abstract JsonMappingException invalidTypeIdException(JavaType var1, String var2, String var3);

    public abstract TypeFactory getTypeFactory();

    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated object, ObjectIdInfo objectIdInfo) {
        DatabindContext databindContext = clazz;
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        MapperConfig<?> mapperConfig = databindContext.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        object = handlerInstantiator == null ? null : handlerInstantiator.objectIdGeneratorInstance(mapperConfig, (Annotated)object, clazz);
        if (object == null) {
            object = (ObjectIdGenerator)ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return ((ObjectIdGenerator)object).forScope(objectIdInfo.getScope());
    }

    public ObjectIdResolver objectIdResolverInstance(Annotated object, ObjectIdInfo mapperConfig) {
        DatabindContext databindContext = clazz;
        Class<? extends ObjectIdResolver> clazz = ((ObjectIdInfo)((Object)mapperConfig)).getResolverType();
        mapperConfig = databindContext.getConfig();
        HandlerInstantiator handlerInstantiator = mapperConfig.getHandlerInstantiator();
        object = handlerInstantiator == null ? null : handlerInstantiator.resolverIdGeneratorInstance(mapperConfig, (Annotated)object, clazz);
        if (object == null) {
            object = (ObjectIdResolver)ClassUtil.createInstance(clazz, mapperConfig.canOverrideAccessModifiers());
        }
        return object;
    }

    public Converter<Object, Object> converterInstance(Annotated object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Converter) {
            return (Converter)object2;
        }
        if (object2 instanceof Class) {
            if ((object2 = (Class)object2) != Converter.None.class && !ClassUtil.isBogusClass(object2)) {
                if (Converter.class.isAssignableFrom((Class<?>)object2)) {
                    HandlerInstantiator handlerInstantiator = ((MapperConfig)(this = ((DatabindContext)this).getConfig())).getHandlerInstantiator();
                    object = handlerInstantiator == null ? null : handlerInstantiator.converterInstance((MapperConfig<?>)this, (Annotated)object, (Class<?>)object2);
                    if (object == null) {
                        object = (Converter)ClassUtil.createInstance(object2, ((MapperConfig)this).canOverrideAccessModifiers());
                    }
                    return object;
                }
                throw new IllegalStateException(a.a((Class)object2, new StringBuilder("AnnotationIntrospector returned Class "), "; expected Class<Converter>"));
            }
            return null;
        }
        throw new IllegalStateException("AnnotationIntrospector returned Converter definition of type " + object2.getClass().getName() + "; expected type Converter or Class<Converter> instead");
    }

    public abstract <T> T reportBadDefinition(JavaType var1, String var2);

    public <T> T reportBadDefinition(Class<?> clazz, String string) {
        DatabindContext databindContext = this;
        return databindContext.reportBadDefinition(databindContext.constructType(clazz), string);
    }

    public final String _format(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            return String.format(string, objectArray);
        }
        return string;
    }

    public final String _truncate(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() <= 500) {
            return string;
        }
        String string2 = string;
        return string.substring(0, 500) + "]...[" + string2.substring(string2.length() - 500);
    }

    public String _quotedString(String string) {
        if (string == null) {
            return "[N/A]";
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = this._truncate(string);
        return String.format("\"%s\"", objectArray2);
    }

    public String _colonConcat(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        return string + ": " + string2;
    }

    public String _desc(String string) {
        if (string == null) {
            return "[N/A]";
        }
        return this._truncate(string);
    }
}

