/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.FormatFeature;
import com.privatefasterxml.jackson.core.FormatSchema;
import com.privatefasterxml.jackson.core.JsonFactory;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.json.JsonReadFeature;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.PropertyName;
import com.privatefasterxml.jackson.databind.cfg.BaseSettings;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionConfigs;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.cfg.ConfigOverrides;
import com.privatefasterxml.jackson.databind.cfg.ConstructorDetector;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.privatefasterxml.jackson.databind.cfg.MapperConfig;
import com.privatefasterxml.jackson.databind.cfg.MapperConfigBase;
import com.privatefasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedClass;
import com.privatefasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.privatefasterxml.jackson.databind.jsontype.NamedType;
import com.privatefasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.util.LinkedNode;
import com.privatefasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.util.Collection;

public final class DeserializationConfig
extends MapperConfigBase<DeserializationFeature, DeserializationConfig>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final int DESER_FEATURE_DEFAULTS = MapperConfig.collectFeatureDefaults(DeserializationFeature.class);
    protected final LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected final JsonNodeFactory _nodeFactory;
    protected final CoercionConfigs _coercionConfigs;
    protected final ConstructorDetector _ctorDetector;
    protected final int _deserFeatures;
    protected final int _parserFeatures;
    protected final int _parserFeaturesToChange;
    protected final int _formatReadFeatures;
    protected final int _formatReadFeaturesToChange;

    public DeserializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, CoercionConfigs coercionConfigs, DatatypeFeatures datatypeFeatures) {
        DeserializationConfig deserializationConfig = this;
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides, datatypeFeatures);
        this._deserFeatures = DESER_FEATURE_DEFAULTS;
        this._problemHandlers = null;
        this._nodeFactory = JsonNodeFactory.instance;
        this._ctorDetector = null;
        deserializationConfig._coercionConfigs = coercionConfigs;
        deserializationConfig._parserFeatures = 0;
        deserializationConfig._parserFeaturesToChange = 0;
        deserializationConfig._formatReadFeatures = 0;
        deserializationConfig._formatReadFeaturesToChange = 0;
    }

    public DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, CoercionConfigs coercionConfigs) {
        super(deserializationConfig, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._coercionConfigs = coercionConfigs;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, long l2, int n2, int n3, int n4, int n5, int n6) {
        super(deserializationConfig, l2);
        this._deserFeatures = n2;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = n3;
        this._parserFeaturesToChange = n4;
        this._formatReadFeatures = n5;
        this._formatReadFeaturesToChange = n6;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver) {
        super(deserializationConfig, subtypeResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, BaseSettings baseSettings) {
        super(deserializationConfig, baseSettings);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, JsonNodeFactory jsonNodeFactory) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = jsonNodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, ConstructorDetector constructorDetector) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = constructorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, LinkedNode<DeserializationProblemHandler> linkedNode) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = linkedNode;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, PropertyName propertyName) {
        super(deserializationConfig, propertyName);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, Class<?> clazz) {
        super(deserializationConfig, clazz);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    public DeserializationConfig(DeserializationConfig deserializationConfig, ContextAttributes contextAttributes) {
        super(deserializationConfig, contextAttributes);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    public DeserializationConfig(DeserializationConfig deserializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(deserializationConfig, simpleMixInResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    public DeserializationConfig(DeserializationConfig deserializationConfig, DatatypeFeatures datatypeFeatures) {
        super(deserializationConfig, datatypeFeatures);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._coercionConfigs = deserializationConfig._coercionConfigs;
        this._ctorDetector = deserializationConfig._ctorDetector;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig _withJsonReadFeatures(FormatFeature ... object) {
        int n2;
        int n3 = object3._parserFeatures;
        int n4 = object3._parserFeaturesToChange;
        int n5 = object3._formatReadFeatures;
        int n6 = object3._formatReadFeaturesToChange;
        int n7 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n6;
            Object object2 = object[i2];
            n6 = object2.getMask();
            n2 = n5 | n6;
            n6 = n8 | n6;
            if (object2 instanceof JsonReadFeature && (object2 = ((JsonReadFeature)object2).mappedFeature()) != null) {
                int n9 = n4;
                int n10 = n3;
                n3 = ((JsonParser.Feature)((Object)object2)).getMask();
                n4 = n10 | n3;
                n3 = n9 | n3;
                int n11 = n4;
                n4 = n3;
                n3 = n11;
            }
            n5 = n2;
        }
        if (object3._formatReadFeatures != n5 || object3._formatReadFeaturesToChange != n6 || object3._parserFeatures != n3 || object3._parserFeaturesToChange != n4) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object3._mapperFeatures;
            n2 = object3._deserFeatures;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object3, l2, n2, n3, n4, n5, n6);
            Object object3 = object;
        }
        return object3;
    }

    private DeserializationConfig _withoutJsonReadFeatures(FormatFeature ... object) {
        int n2;
        int n3 = object3._parserFeatures;
        int n4 = object3._parserFeaturesToChange;
        int n5 = object3._formatReadFeatures;
        int n6 = object3._formatReadFeaturesToChange;
        int n7 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n6;
            Object object2 = object[i2];
            n6 = object2.getMask();
            n2 = n5 & ~n6;
            n6 = n8 | n6;
            if (object2 instanceof JsonReadFeature && (object2 = ((JsonReadFeature)object2).mappedFeature()) != null) {
                int n9 = n4;
                int n10 = n3;
                n3 = ((JsonParser.Feature)((Object)object2)).getMask();
                n4 = n10 & ~n3;
                n3 = n9 | n3;
                int n11 = n4;
                n4 = n3;
                n3 = n11;
            }
            n5 = n2;
        }
        if (object3._formatReadFeatures != n5 || object3._formatReadFeaturesToChange != n6 || object3._parserFeatures != n3 || object3._parserFeaturesToChange != n4) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object3._mapperFeatures;
            n2 = object3._deserFeatures;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object3, l2, n2, n3, n4, n5, n6);
            Object object3 = object;
        }
        return object3;
    }

    public BaseSettings getBaseSettings() {
        return this._base;
    }

    @Override
    public final DeserializationConfig _withBase(BaseSettings baseSettings) {
        if (deserializationConfig3._base != baseSettings) {
            DeserializationConfig deserializationConfig;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            deserializationConfig = new DeserializationConfig(deserializationConfig3, baseSettings);
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
        }
        return deserializationConfig3;
    }

    @Override
    public final DeserializationConfig _withMapperFeatures(long l2) {
        DeserializationConfig deserializationConfig = this;
        int n2 = deserializationConfig._deserFeatures;
        int n3 = deserializationConfig._parserFeatures;
        int n4 = deserializationConfig._parserFeaturesToChange;
        int n5 = deserializationConfig._formatReadFeatures;
        int n6 = deserializationConfig._formatReadFeaturesToChange;
        return new DeserializationConfig(this, l2, n2, n3, n4, n5, n6);
    }

    @Override
    public final DeserializationConfig _with(DatatypeFeatures datatypeFeatures) {
        return new DeserializationConfig(this, datatypeFeatures);
    }

    @Override
    public DeserializationConfig with(SubtypeResolver subtypeResolver) {
        if (deserializationConfig3._subtypeResolver != subtypeResolver) {
            DeserializationConfig deserializationConfig;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            deserializationConfig = new DeserializationConfig(deserializationConfig3, subtypeResolver);
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
        }
        return deserializationConfig3;
    }

    @Override
    public DeserializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new DeserializationConfig(this, propertyName);
    }

    @Override
    public DeserializationConfig withView(Class<?> clazz) {
        if (deserializationConfig3._view != clazz) {
            DeserializationConfig deserializationConfig;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            deserializationConfig = new DeserializationConfig(deserializationConfig3, clazz);
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
        }
        return deserializationConfig3;
    }

    @Override
    public DeserializationConfig with(ContextAttributes contextAttributes) {
        if (contextAttributes != deserializationConfig3._attributes) {
            DeserializationConfig deserializationConfig;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            deserializationConfig = new DeserializationConfig(deserializationConfig3, contextAttributes);
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
        }
        return deserializationConfig3;
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature) {
        int n2 = deserializationConfig4._deserFeatures | deserializationFeature.getMask();
        if (n2 != deserializationConfig4._deserFeatures) {
            DeserializationConfig deserializationConfig;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            DeserializationConfig deserializationConfig3 = deserializationConfig4;
            long l2 = deserializationConfig3._mapperFeatures;
            int n3 = deserializationConfig3._parserFeatures;
            int n4 = deserializationConfig3._parserFeaturesToChange;
            int n5 = deserializationConfig3._formatReadFeatures;
            int n6 = deserializationConfig3._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig(deserializationConfig4, l2, n2, n3, n4, n5, n6);
            DeserializationConfig deserializationConfig4 = deserializationConfig2;
        }
        return deserializationConfig4;
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature, DeserializationFeature ... object) {
        int n2 = object2._deserFeatures | deserializationFeature.getMask();
        int n3 = ((DeserializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 |= object[i2].getMask();
        }
        if (n2 != object2._deserFeatures) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._parserFeatures;
            int n5 = object2._parserFeaturesToChange;
            int n6 = object2._formatReadFeatures;
            int n7 = object2._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig withFeatures(DeserializationFeature ... object) {
        int n2 = object2._deserFeatures;
        int n3 = ((DeserializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 |= object[i2].getMask();
        }
        if (n2 != object2._deserFeatures) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._parserFeatures;
            int n5 = object2._parserFeaturesToChange;
            int n6 = object2._formatReadFeatures;
            int n7 = object2._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature) {
        int n2 = deserializationConfig4._deserFeatures & ~deserializationFeature.getMask();
        if (n2 != deserializationConfig4._deserFeatures) {
            DeserializationConfig deserializationConfig;
            DeserializationConfig deserializationConfig2 = deserializationConfig;
            DeserializationConfig deserializationConfig3 = deserializationConfig4;
            long l2 = deserializationConfig3._mapperFeatures;
            int n3 = deserializationConfig3._parserFeatures;
            int n4 = deserializationConfig3._parserFeaturesToChange;
            int n5 = deserializationConfig3._formatReadFeatures;
            int n6 = deserializationConfig3._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig(deserializationConfig4, l2, n2, n3, n4, n5, n6);
            DeserializationConfig deserializationConfig4 = deserializationConfig2;
        }
        return deserializationConfig4;
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature, DeserializationFeature ... object) {
        int n2 = object2._deserFeatures & ~deserializationFeature.getMask();
        int n3 = ((DeserializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 &= ~object[i2].getMask();
        }
        if (n2 != object2._deserFeatures) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._parserFeatures;
            int n5 = object2._parserFeaturesToChange;
            int n6 = object2._formatReadFeatures;
            int n7 = object2._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig withoutFeatures(DeserializationFeature ... object) {
        int n2 = object2._deserFeatures;
        int n3 = ((DeserializationFeature[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 &= ~object[i2].getMask();
        }
        if (n2 != object2._deserFeatures) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n4 = object2._parserFeatures;
            int n5 = object2._parserFeaturesToChange;
            int n6 = object2._formatReadFeatures;
            int n7 = object2._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n2, n4, n5, n6, n7);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig with(JsonParser.Feature feature) {
        DeserializationConfig deserializationConfig = deserializationConfig5;
        int n2 = deserializationConfig._parserFeatures | feature.getMask();
        int n3 = deserializationConfig._parserFeaturesToChange | feature.getMask();
        if (deserializationConfig._parserFeatures != n2 || deserializationConfig5._parserFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig2;
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
            DeserializationConfig deserializationConfig4 = deserializationConfig5;
            long l2 = deserializationConfig4._mapperFeatures;
            int n4 = deserializationConfig4._deserFeatures;
            int n5 = deserializationConfig4._formatReadFeatures;
            int n6 = deserializationConfig4._formatReadFeaturesToChange;
            deserializationConfig2 = new DeserializationConfig(deserializationConfig5, l2, n4, n2, n3, n5, n6);
            DeserializationConfig deserializationConfig5 = deserializationConfig3;
        }
        return deserializationConfig5;
    }

    public DeserializationConfig withFeatures(JsonParser.Feature ... object) {
        int n2 = object2._parserFeatures;
        int n3 = object2._parserFeaturesToChange;
        int n4 = ((JsonParser.Feature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 | n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._parserFeatures != n2 || object2._parserFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._deserFeatures;
            int n9 = object2._formatReadFeatures;
            int n10 = object2._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n8, n2, n3, n9, n10);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig without(JsonParser.Feature feature) {
        DeserializationConfig deserializationConfig = deserializationConfig5;
        int n2 = deserializationConfig._parserFeatures & ~feature.getMask();
        int n3 = deserializationConfig._parserFeaturesToChange | feature.getMask();
        if (deserializationConfig._parserFeatures != n2 || deserializationConfig5._parserFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig2;
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
            DeserializationConfig deserializationConfig4 = deserializationConfig5;
            long l2 = deserializationConfig4._mapperFeatures;
            int n4 = deserializationConfig4._deserFeatures;
            int n5 = deserializationConfig4._formatReadFeatures;
            int n6 = deserializationConfig4._formatReadFeaturesToChange;
            deserializationConfig2 = new DeserializationConfig(deserializationConfig5, l2, n4, n2, n3, n5, n6);
            DeserializationConfig deserializationConfig5 = deserializationConfig3;
        }
        return deserializationConfig5;
    }

    public DeserializationConfig withoutFeatures(JsonParser.Feature ... object) {
        int n2 = object2._parserFeatures;
        int n3 = object2._parserFeaturesToChange;
        int n4 = ((JsonParser.Feature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 & ~n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._parserFeatures != n2 || object2._parserFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._deserFeatures;
            int n9 = object2._formatReadFeatures;
            int n10 = object2._formatReadFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n8, n2, n3, n9, n10);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig with(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonReadFeature) {
            return deserializationConfig5._withJsonReadFeatures(formatFeature);
        }
        DeserializationConfig deserializationConfig = deserializationConfig5;
        int n2 = deserializationConfig._formatReadFeatures | formatFeature.getMask();
        int n3 = deserializationConfig._formatReadFeaturesToChange | formatFeature.getMask();
        if (deserializationConfig._formatReadFeatures != n2 || deserializationConfig5._formatReadFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig2;
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
            DeserializationConfig deserializationConfig4 = deserializationConfig5;
            long l2 = deserializationConfig4._mapperFeatures;
            int n4 = deserializationConfig4._deserFeatures;
            int n5 = deserializationConfig4._parserFeatures;
            int n6 = deserializationConfig4._parserFeaturesToChange;
            deserializationConfig2 = new DeserializationConfig(deserializationConfig5, l2, n4, n5, n6, n2, n3);
            DeserializationConfig deserializationConfig5 = deserializationConfig3;
        }
        return deserializationConfig5;
    }

    public DeserializationConfig withFeatures(FormatFeature ... object) {
        if (((FormatFeature[])object).length > 0 && object[0] instanceof JsonReadFeature) {
            return object2._withJsonReadFeatures((FormatFeature)object);
        }
        int n2 = object2._formatReadFeatures;
        int n3 = object2._formatReadFeaturesToChange;
        int n4 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 | n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._formatReadFeatures != n2 || object2._formatReadFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._deserFeatures;
            int n9 = object2._parserFeatures;
            int n10 = object2._parserFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n8, n9, n10, n2, n3);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig without(FormatFeature formatFeature) {
        if (formatFeature instanceof JsonReadFeature) {
            return deserializationConfig5._withoutJsonReadFeatures(formatFeature);
        }
        DeserializationConfig deserializationConfig = deserializationConfig5;
        int n2 = deserializationConfig._formatReadFeatures & ~formatFeature.getMask();
        int n3 = deserializationConfig._formatReadFeaturesToChange | formatFeature.getMask();
        if (deserializationConfig._formatReadFeatures != n2 || deserializationConfig5._formatReadFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig2;
            DeserializationConfig deserializationConfig3 = deserializationConfig2;
            DeserializationConfig deserializationConfig4 = deserializationConfig5;
            long l2 = deserializationConfig4._mapperFeatures;
            int n4 = deserializationConfig4._deserFeatures;
            int n5 = deserializationConfig4._parserFeatures;
            int n6 = deserializationConfig4._parserFeaturesToChange;
            deserializationConfig2 = new DeserializationConfig(deserializationConfig5, l2, n4, n5, n6, n2, n3);
            DeserializationConfig deserializationConfig5 = deserializationConfig3;
        }
        return deserializationConfig5;
    }

    public DeserializationConfig withoutFeatures(FormatFeature ... object) {
        if (((FormatFeature[])object).length > 0 && object[0] instanceof JsonReadFeature) {
            return object2._withoutJsonReadFeatures((FormatFeature)object);
        }
        int n2 = object2._formatReadFeatures;
        int n3 = object2._formatReadFeaturesToChange;
        int n4 = ((FormatFeature[])object).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n3;
            int n6 = n2;
            n2 = object[i2].getMask();
            n3 = n6 & ~n2;
            n2 = n5 | n2;
            int n7 = n3;
            n3 = n2;
            n2 = n7;
        }
        if (object2._formatReadFeatures != n2 || object2._formatReadFeaturesToChange != n3) {
            DeserializationConfig deserializationConfig;
            object = deserializationConfig;
            long l2 = object2._mapperFeatures;
            int n8 = object2._deserFeatures;
            int n9 = object2._parserFeatures;
            int n10 = object2._parserFeaturesToChange;
            deserializationConfig = new DeserializationConfig((DeserializationConfig)object2, l2, n8, n9, n10, n2, n3);
            Object object2 = object;
        }
        return object2;
    }

    public DeserializationConfig with(JsonNodeFactory jsonNodeFactory) {
        if (this._nodeFactory == jsonNodeFactory) {
            return this;
        }
        return new DeserializationConfig(this, jsonNodeFactory);
    }

    public DeserializationConfig with(ConstructorDetector constructorDetector) {
        if (this._ctorDetector == constructorDetector) {
            return this;
        }
        return new DeserializationConfig(this, constructorDetector);
    }

    public DeserializationConfig withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        LinkedNode<DeserializationProblemHandler> linkedNode;
        if (LinkedNode.contains(this._problemHandlers, deserializationProblemHandler)) {
            return this;
        }
        LinkedNode<DeserializationProblemHandler> linkedNode2 = linkedNode;
        linkedNode = new LinkedNode<DeserializationProblemHandler>(deserializationProblemHandler, this._problemHandlers);
        return new DeserializationConfig(this, linkedNode2);
    }

    public DeserializationConfig withNoProblemHandlers() {
        if (this._problemHandlers == null) {
            return this;
        }
        return new DeserializationConfig(this, null);
    }

    public JsonParser initialize(JsonParser jsonParser) {
        int n2 = this._parserFeaturesToChange;
        if (n2 != 0) {
            jsonParser.overrideStdFeatures(this._parserFeatures, n2);
        }
        if ((n2 = this._formatReadFeaturesToChange) != 0) {
            jsonParser.overrideFormatFeatures(this._formatReadFeatures, n2);
        }
        return jsonParser;
    }

    public JsonParser initialize(JsonParser jsonParser, FormatSchema formatSchema) {
        int n2 = this._parserFeaturesToChange;
        if (n2 != 0) {
            jsonParser.overrideStdFeatures(this._parserFeatures, n2);
        }
        if ((n2 = this._formatReadFeaturesToChange) != 0) {
            jsonParser.overrideFormatFeatures(this._formatReadFeatures, n2);
        }
        if (formatSchema != null) {
            jsonParser.setSchema(formatSchema);
        }
        return jsonParser;
    }

    @Override
    public boolean useRootWrapping() {
        PropertyName propertyName = this._rootName;
        if (propertyName != null) {
            return propertyName.isEmpty() ^ true;
        }
        return this.isEnabled(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._deserFeatures & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonParser.Feature feature, JsonFactory jsonFactory) {
        int n2 = feature.getMask();
        if ((this._parserFeaturesToChange & n2) != 0) {
            return (this._parserFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasDeserializationFeatures(int n2) {
        return (this._deserFeatures & n2) == n2;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._deserFeatures & n2) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._deserFeatures;
    }

    public final boolean requiresFullValue() {
        return DeserializationFeature.FAIL_ON_TRAILING_TOKENS.enabledIn(this._deserFeatures);
    }

    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._datatypeFeatures.isEnabled(datatypeFeature);
    }

    public LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public ConstructorDetector getConstructorDetector() {
        Serializable serializable = serializable._ctorDetector;
        if (serializable == null) {
            return ConstructorDetector.DEFAULT;
        }
        return serializable;
    }

    public BeanDescription introspect(JavaType javaType) {
        return this.getClassIntrospector().forDeserialization(this, javaType, this);
    }

    public BeanDescription introspectForCreation(JavaType javaType) {
        return this.getClassIntrospector().forCreation(this, javaType, this);
    }

    public BeanDescription introspectForBuilder(JavaType javaType, BeanDescription beanDescription) {
        return this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this, beanDescription);
    }

    @Deprecated
    public BeanDescription introspectForBuilder(JavaType javaType) {
        return this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this);
    }

    public TypeDeserializer findTypeDeserializer(JavaType javaType) {
        DeserializationConfig deserializationConfig = this;
        AnnotatedClass annotatedClass = deserializationConfig.introspectClassAnnotations(javaType.getRawClass()).getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig.getAnnotationIntrospector().findTypeResolver(this, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = this.getSubtypeResolver().collectAndResolveSubtypesByTypeId(this, annotatedClass);
        }
        return typeResolverBuilder.buildTypeDeserializer(this, javaType, collection);
    }

    public CoercionAction findCoercionAction(LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        return this._coercionConfigs.findCoercion(this, logicalType, clazz, coercionInputShape);
    }

    public CoercionAction findCoercionFromBlankString(LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        return this._coercionConfigs.findCoercionFromBlankString(this, logicalType, clazz, coercionAction);
    }
}

