/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.JsonFormat;
import com.privatefasterxml.jackson.annotation.ObjectIdGenerator;
import com.privatefasterxml.jackson.annotation.ObjectIdResolver;
import com.privatefasterxml.jackson.core.Base64Variant;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.core.JsonToken;
import com.privatefasterxml.jackson.core.ObjectCodec;
import com.privatefasterxml.jackson.core.StreamReadCapability;
import com.privatefasterxml.jackson.core.util.JacksonFeatureSet;
import com.privatefasterxml.jackson.databind.AnnotationIntrospector;
import com.privatefasterxml.jackson.databind.BeanDescription;
import com.privatefasterxml.jackson.databind.BeanProperty;
import com.privatefasterxml.jackson.databind.DatabindContext;
import com.privatefasterxml.jackson.databind.DatabindException;
import com.privatefasterxml.jackson.databind.DeserializationConfig;
import com.privatefasterxml.jackson.databind.DeserializationFeature;
import com.privatefasterxml.jackson.databind.InjectableValues;
import com.privatefasterxml.jackson.databind.JavaType;
import com.privatefasterxml.jackson.databind.JsonDeserializer;
import com.privatefasterxml.jackson.databind.JsonMappingException;
import com.privatefasterxml.jackson.databind.JsonNode;
import com.privatefasterxml.jackson.databind.KeyDeserializer;
import com.privatefasterxml.jackson.databind.MapperFeature;
import com.privatefasterxml.jackson.databind.a;
import com.privatefasterxml.jackson.databind.cfg.CoercionAction;
import com.privatefasterxml.jackson.databind.cfg.CoercionInputShape;
import com.privatefasterxml.jackson.databind.cfg.ContextAttributes;
import com.privatefasterxml.jackson.databind.cfg.DatatypeFeature;
import com.privatefasterxml.jackson.databind.deser.ContextualDeserializer;
import com.privatefasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.privatefasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.privatefasterxml.jackson.databind.deser.DeserializerCache;
import com.privatefasterxml.jackson.databind.deser.DeserializerFactory;
import com.privatefasterxml.jackson.databind.deser.ValueInstantiator;
import com.privatefasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.privatefasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.privatefasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.privatefasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.privatefasterxml.jackson.databind.exc.InvalidFormatException;
import com.privatefasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.privatefasterxml.jackson.databind.exc.MismatchedInputException;
import com.privatefasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.privatefasterxml.jackson.databind.exc.ValueInstantiationException;
import com.privatefasterxml.jackson.databind.introspect.Annotated;
import com.privatefasterxml.jackson.databind.introspect.AnnotatedMember;
import com.privatefasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.privatefasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.privatefasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.privatefasterxml.jackson.databind.node.JsonNodeFactory;
import com.privatefasterxml.jackson.databind.node.TreeTraversingParser;
import com.privatefasterxml.jackson.databind.type.LogicalType;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ArrayBuilders;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import com.privatefasterxml.jackson.databind.util.LinkedNode;
import com.privatefasterxml.jackson.databind.util.ObjectBuffer;
import com.privatefasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DeserializationContext
extends DatabindContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final JacksonFeatureSet<StreamReadCapability> _readCapabilities;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;
    protected transient ContextAttributes _attributes;
    protected LinkedNode<JavaType> _currentType;

    public DeserializationContext(DeserializerFactory deserializerFactory) {
        this(deserializerFactory, null);
    }

    public DeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        if (deserializerFactory != null) {
            this._factory = deserializerFactory;
            if (deserializerCache == null) {
                DeserializerCache deserializerCache2;
                deserializerCache = deserializerCache2;
                deserializerCache2 = new DeserializerCache();
            }
            DeserializationContext deserializationContext = this;
            deserializationContext._cache = deserializerCache;
            deserializationContext._featureFlags = 0;
            deserializationContext._readCapabilities = null;
            deserializationContext._config = null;
            deserializationContext._injectableValues = null;
            deserializationContext._view = null;
            deserializationContext._attributes = null;
            return;
        }
        throw new NullPointerException("Cannot pass null DeserializerFactory");
    }

    public DeserializationContext(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory) {
        this._cache = deserializationContext._cache;
        this._factory = deserializerFactory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._readCapabilities = deserializationContext._readCapabilities;
        this._view = deserializationContext._view;
        this._parser = deserializationContext._parser;
        this._injectableValues = deserializationContext._injectableValues;
        this._attributes = deserializationContext._attributes;
    }

    public DeserializationContext(DeserializationContext object, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        this._cache = ((DeserializationContext)object)._cache;
        this._factory = ((DeserializationContext)object)._factory;
        object = jsonParser == null ? null : jsonParser.getReadCapabilities();
        this._readCapabilities = object;
        this._config = deserializationConfig;
        this._featureFlags = deserializationConfig.getDeserializationFeatures();
        this._view = deserializationConfig.getActiveView();
        this._parser = jsonParser;
        this._injectableValues = injectableValues;
        this._attributes = deserializationConfig.getAttributes();
    }

    public DeserializationContext(DeserializationContext deserializationContext, DeserializationConfig deserializationConfig) {
        DeserializationContext deserializationContext2 = this;
        DeserializationContext deserializationContext3 = this;
        this._cache = deserializationContext._cache;
        deserializationContext3._factory = deserializationContext._factory;
        deserializationContext3._readCapabilities = null;
        this._config = deserializationConfig;
        deserializationContext2._featureFlags = deserializationConfig.getDeserializationFeatures();
        deserializationContext2._view = null;
        deserializationContext2._parser = null;
        deserializationContext2._injectableValues = null;
        deserializationContext2._attributes = null;
    }

    public DeserializationContext(DeserializationContext deserializationContext) {
        DeserializationContext deserializationContext2 = this;
        this._cache = new DeserializerCache();
        this._factory = deserializationContext._factory;
        this._config = deserializationContext._config;
        this._featureFlags = deserializationContext._featureFlags;
        this._readCapabilities = deserializationContext._readCapabilities;
        deserializationContext2._view = deserializationContext._view;
        deserializationContext2._injectableValues = null;
    }

    private TreeTraversingParser _treeAsTokens(JsonNode jsonNode) {
        Object object = ((DeserializationContext)object)._parser;
        object = object == null ? null : ((JsonParser)object).getCodec();
        TreeTraversingParser treeTraversingParser = new TreeTraversingParser(jsonNode, (ObjectCodec)object);
        treeTraversingParser.nextToken();
        return treeTraversingParser;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final Class<?> getActiveView() {
        return this._view;
    }

    @Override
    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    @Override
    public final boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Override
    public final boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._config.isEnabled(datatypeFeature);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._config.getDefaultPropertyFormat(clazz);
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        if (javaType.hasRawClass(clazz)) {
            return javaType;
        }
        return this.getConfig().getTypeFactory().constructSpecializedType(javaType, clazz, false);
    }

    @Override
    public Locale getLocale() {
        return this._config.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    @Override
    public Object getAttribute(Object object) {
        return this._attributes.getAttribute(object);
    }

    @Override
    public DeserializationContext setAttribute(Object object, Object object2) {
        DeserializationContext deserializationContext = this;
        deserializationContext._attributes = deserializationContext._attributes.withPerCallAttribute(object, object2);
        return deserializationContext;
    }

    public JavaType getContextualType() {
        LinkedNode<JavaType> linkedNode = ((DeserializationContext)((Object)linkedNode))._currentType;
        return linkedNode == null ? null : (JavaType)linkedNode.value();
    }

    public DeserializerFactory getFactory() {
        return this._factory;
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._featureFlags & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(StreamReadCapability streamReadCapability) {
        return this._readCapabilities.isEnabled(streamReadCapability);
    }

    public final int getDeserializationFeatures() {
        return this._featureFlags;
    }

    public final boolean hasDeserializationFeatures(int n2) {
        return (this._featureFlags & n2) == n2;
    }

    public final boolean hasSomeOfFeatures(int n2) {
        return (this._featureFlags & n2) != 0;
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object object, BeanProperty beanProperty, Object object2) {
        InjectableValues injectableValues = objectArray3._injectableValues;
        if (injectableValues == null) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = object;
            return objectArray.reportBadDefinition(ClassUtil.classOf(object), String.format("No 'injectableValues' configured, cannot inject value with id [%s]", objectArray3));
        }
        return injectableValues.findInjectableValue(object, (DeserializationContext)objectArray3, beanProperty, object2);
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public CoercionAction findCoercionAction(LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        return this._config.findCoercionAction(logicalType, clazz, coercionInputShape);
    }

    public CoercionAction findCoercionFromBlankString(LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        return this._config.findCoercionFromBlankString(logicalType, clazz, coercionAction);
    }

    public TokenBuffer bufferForInputBuffering(JsonParser jsonParser) {
        return new TokenBuffer(jsonParser, this);
    }

    public final TokenBuffer bufferForInputBuffering() {
        DeserializationContext deserializationContext = this;
        return deserializationContext.bufferForInputBuffering(deserializationContext.getParser());
    }

    public TokenBuffer bufferAsCopyOfValue(JsonParser jsonParser) {
        TokenBuffer tokenBuffer = this.bufferForInputBuffering(jsonParser);
        tokenBuffer.copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasValueDeserializerFor(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        void var0_3;
        block4: {
            block3: {
                try {
                    DeserializationContext deserializationContext = this;
                    return this._cache.hasValueDeserializerFor(deserializationContext, deserializationContext._factory, javaType);
                }
                catch (RuntimeException runtimeException) {
                }
                catch (DatabindException databindException) {
                    break block3;
                }
                if (atomicReference == null) throw runtimeException;
                break block4;
            }
            if (atomicReference == null) return false;
        }
        atomicReference.set((Throwable)var0_3);
        return false;
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType javaType, BeanProperty beanProperty) {
        DeserializationContext deserializationContext = this;
        JsonDeserializer<Object> jsonDeserializer = this._cache.findValueDeserializer(deserializationContext, deserializationContext._factory, javaType);
        if (jsonDeserializer != null) {
            jsonDeserializer = this.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        return jsonDeserializer;
    }

    public final JsonDeserializer<Object> findNonContextualValueDeserializer(JavaType javaType) {
        DeserializationContext deserializationContext = this;
        return this._cache.findValueDeserializer(deserializationContext, deserializationContext._factory, javaType);
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType javaType) {
        DeserializationContext deserializationContext = object;
        JsonDeserializer<Object> jsonDeserializer = ((DeserializationContext)object)._cache.findValueDeserializer(deserializationContext, deserializationContext._factory, javaType);
        if (jsonDeserializer == null) {
            return null;
        }
        DeserializationContext deserializationContext2 = object;
        jsonDeserializer = deserializationContext2.handleSecondaryContextualization(jsonDeserializer, null, javaType);
        Object object = deserializationContext2._factory.findTypeDeserializer(((DeserializationContext)object)._config, javaType);
        if (object != null) {
            object = ((TypeDeserializer)object).forProperty(null);
            return new TypeWrappedDeserializer((TypeDeserializer)object, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType object, BeanProperty beanProperty) {
        try {
            DeserializationContext deserializationContext = this;
            object = this._cache.findKeyDeserializer(deserializationContext, deserializationContext._factory, (JavaType)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = ClassUtil.exceptionMessage(illegalArgumentException);
            this.reportBadDefinition((JavaType)object, string);
            object = null;
        }
        if (object instanceof ContextualKeyDeserializer) {
            object = ((ContextualKeyDeserializer)object).createContextual(this, beanProperty);
        }
        return object;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2, ObjectIdResolver var3);

    public abstract void checkUnresolvedObjectId();

    public final JavaType constructType(Class<?> clazz) {
        return clazz == null ? null : this._config.constructType(clazz);
    }

    public Class<?> findClass(String string) {
        return this.getTypeFactory().findClass(string);
    }

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer objectBuffer = this._objectBuffer;
        if (objectBuffer == null) {
            ObjectBuffer objectBuffer2;
            objectBuffer = objectBuffer2;
            objectBuffer2 = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return objectBuffer;
    }

    public final void returnObjectBuffer(ObjectBuffer objectBuffer) {
        if (this._objectBuffer == null || objectBuffer.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = objectBuffer;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            ArrayBuilders arrayBuilders;
            ArrayBuilders arrayBuilders2 = arrayBuilders;
            arrayBuilders = new ArrayBuilders();
            this._arrayBuilders = arrayBuilders2;
        }
        return this._arrayBuilders;
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2);

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2);

    public JsonDeserializer<?> handlePrimaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
                this._currentType = this._currentType.next();
            }
            catch (Throwable throwable) {
                this._currentType = this._currentType.next();
                throw throwable;
            }
        }
        return jsonDeserializer;
    }

    public JsonDeserializer<?> handleSecondaryContextualization(JsonDeserializer<?> jsonDeserializer, BeanProperty beanProperty, JavaType javaType) {
        if (jsonDeserializer instanceof ContextualDeserializer) {
            this._currentType = new LinkedNode<JavaType>(javaType, this._currentType);
            try {
                jsonDeserializer = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(this, beanProperty);
                this._currentType = this._currentType.next();
            }
            catch (Throwable throwable) {
                this._currentType = this._currentType.next();
                throw throwable;
            }
        }
        return jsonDeserializer;
    }

    public Date parseDate(String string) {
        try {
            return this._getDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = ClassUtil.exceptionMessage(parseException);
            throw new IllegalArgumentException(String.format("Failed to parse Date value '%s': %s", objectArray2));
        }
    }

    public Calendar constructCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public String extractScalarFromObject(JsonParser jsonParser, JsonDeserializer<?> jsonDeserializer, Class<?> clazz) {
        return (String)this.handleUnexpectedToken(clazz, jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) {
        return this.readValue(jsonParser, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return this.reportBadDefinition(javaType, "Could not find JsonDeserializer for type " + ClassUtil.getTypeDescription(javaType));
        }
        return (T)jsonDeserializer.deserialize(jsonParser, this);
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, Class<T> clazz) {
        return this.readPropertyValue(jsonParser, beanProperty, this.getTypeFactory().constructType(clazz));
    }

    public <T> T readPropertyValue(JsonParser jsonParser, BeanProperty beanProperty, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = objectArray3.findContextualValueDeserializer(javaType, beanProperty);
        if (jsonDeserializer == null) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = ClassUtil.getTypeDescription(javaType);
            objectArray2[1] = ClassUtil.nameOf(beanProperty);
            return objectArray.reportBadDefinition(javaType, String.format("Could not find JsonDeserializer for type %s (via property %s)", objectArray3));
        }
        return (T)jsonDeserializer.deserialize(jsonParser, (DeserializationContext)objectArray3);
    }

    public JsonNode readTree(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            return this.getNodeFactory().missingNode();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return this.getNodeFactory().nullNode();
        }
        DeserializationContext deserializationContext = this;
        return (JsonNode)deserializationContext.findRootValueDeserializer(deserializationContext._config.constructType(JsonNode.class)).deserialize(jsonParser, this);
    }

    public <T> T readTreeAsValue(JsonNode object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        object = deserializationContext._treeAsTokens((JsonNode)object);
        try {
            DeserializationContext deserializationContext = deserializationContext.readValue((JsonParser)object, clazz);
            return (T)deserializationContext;
        }
        finally {
            if (object != null) {
                ((TreeTraversingParser)object).close();
            }
        }
    }

    public <T> T readTreeAsValue(JsonNode object, JavaType javaType) {
        if (object == null) {
            return null;
        }
        object = deserializationContext._treeAsTokens((JsonNode)object);
        try {
            DeserializationContext deserializationContext = deserializationContext.readValue((JsonParser)object, javaType);
            return (T)deserializationContext;
        }
        finally {
            if (object != null) {
                ((TreeTraversingParser)object).close();
            }
        }
    }

    public boolean handleUnknownProperty(JsonParser object, JsonDeserializer<?> jsonDeserializer, Object object2, String string) {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            if (!linkedNode.value().handleUnknownProperty(this, (JsonParser)object, jsonDeserializer, object2, string)) continue;
            return true;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            ((JsonParser)object).skipChildren();
            return true;
        }
        object = jsonDeserializer == null ? null : jsonDeserializer.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, object2, string, (Collection<Object>)object);
    }

    public Object handleWeirdKey(Class<?> clazz, String string, String string2, Object ... object) {
        string2 = objectArray3._format(string2, (Object[])object);
        for (object = objectArray3._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleWeirdKey((DeserializationContext)objectArray3, clazz, string, string2);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 != null && !clazz.isInstance(object2)) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray3[0] = ClassUtil.getClassDescription(clazz);
                objectArray2[1] = ClassUtil.getClassDescription(object2);
                throw objectArray.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", objectArray3));
            }
            return object2;
        }
        throw objectArray3.weirdKeyException(clazz, string, string2);
    }

    public Object handleWeirdStringValue(Class<?> clazz, String string, String string2, Object ... object) {
        string2 = objectArray3._format(string2, (Object[])object);
        for (object = objectArray3._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleWeirdStringValue((DeserializationContext)objectArray3, clazz, string, string2);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (objectArray3._isCompatible(clazz, object2)) {
                return object2;
            }
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = ClassUtil.getClassDescription(clazz);
            objectArray2[1] = ClassUtil.getClassDescription(object2);
            throw objectArray.weirdStringException(string, clazz, String.format("DeserializationProblemHandler.handleWeirdStringValue() for type %s returned value of type %s", objectArray3));
        }
        throw objectArray3.weirdStringException(string, clazz, string2);
    }

    public Object handleWeirdNumberValue(Class<?> clazz, Number number, String string, Object ... object) {
        string = objectArray4._format(string, (Object[])object);
        for (object = objectArray4._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleWeirdNumberValue((DeserializationContext)objectArray4, clazz, number, string);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (objectArray4._isCompatible(clazz, object2)) {
                return object2;
            }
            Object[] objectArray = objectArray4;
            Object[] objectArray2 = objectArray4;
            Object[] objectArray3 = new Object[2];
            Object[] objectArray4 = objectArray3;
            objectArray4[0] = ClassUtil.getClassDescription(clazz);
            objectArray3[1] = ClassUtil.getClassDescription(object2);
            throw objectArray.weirdNumberException(number, clazz, objectArray2._format("DeserializationProblemHandler.handleWeirdNumberValue() for type %s returned value of type %s", objectArray4));
        }
        throw objectArray4.weirdNumberException(number, clazz, string);
    }

    public Object handleWeirdNativeValue(JavaType javaType, Object object, JsonParser jsonParser) {
        Class<?> clazz = javaType.getRawClass();
        for (LinkedNode<DeserializationProblemHandler> linkedNode = objectArray3._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleWeirdNativeValue((DeserializationContext)objectArray3, javaType, object, jsonParser);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (object2 != null && !clazz.isInstance(object2)) {
                Object[] objectArray = objectArray3;
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray3[0] = ClassUtil.getClassDescription(javaType);
                objectArray2[1] = ClassUtil.getClassDescription(object2);
                throw JsonMappingException.from(jsonParser, objectArray._format("DeserializationProblemHandler.handleWeirdNativeValue() for type %s returned value of type %s", objectArray3));
            }
            return object2;
        }
        throw objectArray3.weirdNativeValueException(object, clazz);
    }

    public Object handleMissingInstantiator(Class<?> clazz, ValueInstantiator valueInstantiator, JsonParser jsonParser, String string, Object ... object) {
        Object[] objectArray;
        if (jsonParser == null) {
            jsonParser = objectArray.getParser();
        }
        string = objectArray._format(string, (Object[])object);
        for (object = objectArray._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleMissingInstantiator((DeserializationContext)objectArray, clazz, valueInstantiator, jsonParser, string);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (objectArray._isCompatible(clazz, object2)) {
                return object2;
            }
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = ClassUtil.getClassDescription(clazz);
            objectArray2[1] = ClassUtil.getClassDescription(object2);
            objectArray.reportBadDefinition(objectArray.constructType(clazz), String.format("DeserializationProblemHandler.handleMissingInstantiator() for type %s returned value of type %s", objectArray3));
        }
        if (valueInstantiator == null) {
            Object[] objectArray4 = objectArray;
            Object[] objectArray5 = new Object[2];
            objectArray = objectArray5;
            objectArray5[0] = ClassUtil.nameOf(clazz);
            objectArray5[1] = string;
            return objectArray4.reportBadDefinition(clazz, String.format("Cannot construct instance of %s: %s", objectArray));
        }
        if (!valueInstantiator.canInstantiate()) {
            Object[] objectArray6 = objectArray;
            Object[] objectArray7 = new Object[2];
            objectArray = objectArray7;
            objectArray7[0] = ClassUtil.nameOf(clazz);
            objectArray7[1] = string;
            return objectArray6.reportBadDefinition(clazz, String.format("Cannot construct instance of %s (no Creators, like default constructor, exist): %s", objectArray));
        }
        Object[] objectArray8 = objectArray;
        Object[] objectArray9 = new Object[2];
        objectArray = objectArray9;
        objectArray9[0] = ClassUtil.nameOf(clazz);
        objectArray9[1] = string;
        return objectArray8.reportInputMismatch(clazz, String.format("Cannot construct instance of %s (although at least one Creator exists): %s", objectArray), new Object[0]);
    }

    public Object handleInstantiationProblem(Class<?> clazz, Object object, Throwable throwable) {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            Object object2 = linkedNode.value().handleInstantiationProblem(this, clazz, object, throwable);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (this._isCompatible(clazz, object2)) {
                return object2;
            }
            DeserializationContext deserializationContext = this;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = ClassUtil.getClassDescription(clazz);
            objectArray[1] = ClassUtil.classNameOf(object2);
            deserializationContext.reportBadDefinition(deserializationContext.constructType(clazz), String.format("DeserializationProblemHandler.handleInstantiationProblem() for type %s returned value of type %s", objectArray2));
        }
        ClassUtil.throwIfIOE(throwable);
        if (!this.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        throw this.instantiationException(clazz, throwable);
    }

    public Object handleUnexpectedToken(Class<?> object, JsonParser jsonParser) {
        DeserializationContext deserializationContext = objectArray;
        Object[] objectArray = objectArray.constructType((Class<?>)object);
        object = jsonParser.currentToken();
        Serializable serializable = objectArray;
        objectArray = new Object[]{};
        return deserializationContext.handleUnexpectedToken((JavaType)serializable, (JsonToken)((Object)object), jsonParser, null, objectArray);
    }

    public Object handleUnexpectedToken(Class<?> clazz, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = this;
        return deserializationContext.handleUnexpectedToken(deserializationContext.constructType(clazz), jsonToken, jsonParser, string, objectArray);
    }

    public Object handleUnexpectedToken(JavaType objectArray, JsonParser jsonParser) {
        DeserializationContext deserializationContext = object;
        Object[] objectArray2 = objectArray;
        Object object = jsonParser.currentToken();
        objectArray = new Object[]{};
        return deserializationContext.handleUnexpectedToken((JavaType)objectArray2, (JsonToken)((Object)object), jsonParser, null, objectArray);
    }

    public Object handleUnexpectedToken(JavaType javaType, JsonToken jsonToken, JsonParser jsonParser, String string, Object ... object) {
        string = objectArray3._format(string, (Object[])object);
        for (object = objectArray3._config.getProblemHandlers(); object != null; object = ((LinkedNode)object).next()) {
            Object object2 = ((DeserializationProblemHandler)((LinkedNode)object).value()).handleUnexpectedToken((DeserializationContext)objectArray3, javaType, jsonToken, jsonParser, string);
            if (object2 == DeserializationProblemHandler.NOT_HANDLED) continue;
            if (objectArray3._isCompatible(javaType.getRawClass(), object2)) {
                return object2;
            }
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = ClassUtil.getTypeDescription(javaType);
            objectArray[1] = ClassUtil.classNameOf(object2);
            objectArray3.reportBadDefinition(javaType, String.format("DeserializationProblemHandler.handleUnexpectedToken() for type %s returned value of type %s", objectArray2));
        }
        if (string == null) {
            string = ClassUtil.getTypeDescription(javaType);
            if (jsonToken == null) {
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = string;
                string = String.format("Unexpected end-of-input when trying read value of type %s", (Object[])object);
            } else {
                Object[] objectArray = new Object[3];
                object = objectArray;
                object[0] = string;
                objectArray[1] = objectArray3._shapeForToken(jsonToken);
                objectArray[2] = jsonToken;
                string = String.format("Cannot deserialize value of type %s from %s (token `JsonToken.%s`)", (Object[])object);
            }
        }
        if (jsonToken != null && jsonToken.isScalarValue()) {
            jsonParser.getText();
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray3 = new Object[]{};
        objectArray.reportInputMismatch(javaType, string, objectArray3);
        return null;
    }

    public JavaType handleUnknownTypeId(JavaType javaType, String string, TypeIdResolver typeIdResolver, String string2) {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleUnknownTypeId(this, javaType, string, typeIdResolver, string2);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, string, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(javaType2));
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
            return null;
        }
        throw this.invalidTypeIdException(javaType, string, string2);
    }

    public JavaType handleMissingTypeId(JavaType javaType, TypeIdResolver typeIdResolver, String string) {
        for (LinkedNode<DeserializationProblemHandler> linkedNode = this._config.getProblemHandlers(); linkedNode != null; linkedNode = linkedNode.next()) {
            JavaType javaType2 = linkedNode.value().handleMissingTypeId(this, javaType, typeIdResolver, string);
            if (javaType2 == null) continue;
            if (javaType2.hasRawClass(Void.class)) {
                return null;
            }
            if (javaType2.isTypeOrSubTypeOf(javaType.getRawClass())) {
                return javaType2;
            }
            throw this.invalidTypeIdException(javaType, null, "problem handler tried to resolve into non-subtype: " + ClassUtil.getTypeDescription(javaType2));
        }
        throw this.missingTypeIdException(javaType, string);
    }

    public void handleBadMerge(JsonDeserializer<?> object) {
        if (serializable.isEnabled(MapperFeature.IGNORE_MERGE_FOR_UNMERGEABLE)) {
            return;
        }
        DeserializationContext deserializationContext = serializable;
        Serializable serializable = deserializationContext.constructType(object.handledType());
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = ClassUtil.getTypeDescription((JavaType)serializable);
        object = String.format("Invalid configuration: values of type %s cannot be merged", object);
        throw InvalidDefinitionException.from(deserializationContext.getParser(), (String)object, (JavaType)serializable);
    }

    public boolean _isCompatible(Class<?> clazz, Object object) {
        if (object != null && !clazz.isInstance(object)) {
            return clazz.isPrimitive() && ClassUtil.wrapperType(clazz).isInstance(object);
        }
        return true;
    }

    public void reportWrongTokenException(JsonDeserializer<?> object, JsonToken jsonToken, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        JsonDeserializer<?> jsonDeserializer = object;
        DeserializationContext deserializationContext2 = string2;
        String string2 = deserializationContext2._format(string, objectArray);
        object = deserializationContext2.getParser();
        throw deserializationContext.wrongTokenException((JsonParser)object, jsonDeserializer.handledType(), jsonToken, string2);
    }

    public void reportWrongTokenException(JavaType javaType, JsonToken jsonToken, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        String string2 = deserializationContext._format(string, objectArray);
        throw deserializationContext.wrongTokenException(deserializationContext.getParser(), javaType, jsonToken, string2);
    }

    public void reportWrongTokenException(Class<?> clazz, JsonToken jsonToken, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        String string2 = deserializationContext._format(string, objectArray);
        throw deserializationContext.wrongTokenException(deserializationContext.getParser(), clazz, jsonToken, string2);
    }

    public <T> T reportUnresolvedObjectId(ObjectIdReader objectIdReader, Object object) {
        Object[] objectArray = object2;
        Object[] objectArray2 = new Object[2];
        Object object2 = objectArray2;
        object2[0] = ClassUtil.classNameOf(object);
        objectArray2[1] = objectIdReader.propertyName;
        object2 = String.format("No Object Id found for an instance of %s, to assign to property '%s'", object2);
        return objectArray.reportInputMismatch(objectIdReader.idProperty, (String)object2, new Object[0]);
    }

    public <T> T reportInputMismatch(JsonDeserializer<?> jsonDeserializer, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        String string2 = deserializationContext._format(string, objectArray);
        throw MismatchedInputException.from(deserializationContext.getParser(), jsonDeserializer.handledType(), string2);
    }

    public <T> T reportInputMismatch(Class<?> clazz, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        String string2 = deserializationContext._format(string, objectArray);
        throw MismatchedInputException.from(deserializationContext.getParser(), clazz, string2);
    }

    public <T> T reportInputMismatch(JavaType javaType, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        String string2 = deserializationContext._format(string, objectArray);
        throw MismatchedInputException.from(deserializationContext.getParser(), javaType, string2);
    }

    public <T> T reportInputMismatch(BeanProperty object, String object2, Object ... object3) {
        object2 = ((DatabindContext)((Object)serializable))._format((String)object2, object3);
        object3 = object == null ? null : object.getType();
        Serializable serializable = MismatchedInputException.from(((DeserializationContext)serializable).getParser(), (JavaType)object3, (String)object2);
        if (object != null && (object2 = object.getMember()) != null) {
            BeanProperty beanProperty = object;
            object = ((AnnotatedMember)object2).getDeclaringClass();
            ((JsonMappingException)serializable).prependPath(object, beanProperty.getName());
        }
        throw serializable;
    }

    public <T> T reportPropertyInputMismatch(Class<?> clazz, String string, String string2, Object ... objectArray) {
        DeserializationContext deserializationContext = object;
        Object object = deserializationContext._format(string2, objectArray);
        object = MismatchedInputException.from(deserializationContext.getParser(), clazz, (String)object);
        if (string != null) {
            ((JsonMappingException)object).prependPath(clazz, string);
        }
        throw object;
    }

    public <T> T reportPropertyInputMismatch(JavaType javaType, String string, String string2, Object ... objectArray) {
        return this.reportPropertyInputMismatch(javaType.getRawClass(), string, string2, objectArray);
    }

    public <T> T reportBadCoercion(JsonDeserializer<?> jsonDeserializer, Class<?> clazz, Object object, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = string2;
        String string2 = deserializationContext._format(string, objectArray);
        throw InvalidFormatException.from(deserializationContext.getParser(), string2, object, clazz);
    }

    public <T> T reportTrailingTokens(Class<?> clazz, JsonParser jsonParser, JsonToken jsonToken) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = jsonToken;
        objectArray[1] = ClassUtil.nameOf(clazz);
        throw MismatchedInputException.from(jsonParser, clazz, String.format("Trailing token (of type %s) found after value (bound as %s): not allowed as per `DeserializationFeature.FAIL_ON_TRAILING_TOKENS`", objectArray2));
    }

    @Deprecated
    public void reportWrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string, Object ... objectArray) {
        throw this.wrongTokenException(jsonParser, jsonToken, this._format(string, objectArray));
    }

    @Deprecated
    public void reportUnknownProperty(Object object, String string, JsonDeserializer<?> object2) {
        if (this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            object2 = object2 == null ? null : ((JsonDeserializer)object2).getKnownPropertyNames();
            throw UnrecognizedPropertyException.from(this._parser, object, string, (Collection<Object>)object2);
        }
    }

    @Deprecated
    public void reportMissingContent(String string, Object ... objectArray) {
        throw MismatchedInputException.from(this.getParser(), null, "No content to map due to end-of-input");
    }

    public <T> T reportBadTypeDefinition(BeanDescription beanDescription, String string, Object ... objectArray) {
        DeserializationContext deserializationContext = object;
        Object object = ((DatabindContext)object)._format(string, objectArray);
        string = ClassUtil.nameOf(beanDescription.getBeanClass());
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = string;
        objectArray2[1] = object;
        object = String.format("Invalid type definition for type %s: %s", objectArray);
        throw InvalidDefinitionException.from(deserializationContext._parser, (String)object, beanDescription, null);
    }

    public <T> T reportBadPropertyDefinition(BeanDescription beanDescription, BeanPropertyDefinition beanPropertyDefinition, String string, Object ... object) {
        DeserializationContext deserializationContext = object2;
        Object object2 = ((DatabindContext)object2)._format(string, object);
        string = ClassUtil.nameOf(beanPropertyDefinition);
        object = ClassUtil.nameOf(beanDescription.getBeanClass());
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = object;
        objectArray[2] = object2;
        object2 = String.format("Invalid definition for property %s (of type %s): %s", objectArray2);
        throw InvalidDefinitionException.from(deserializationContext._parser, (String)object2, beanDescription, beanPropertyDefinition);
    }

    @Override
    public <T> T reportBadDefinition(JavaType javaType, String string) {
        throw InvalidDefinitionException.from(this._parser, string, javaType);
    }

    @Deprecated
    public <T> T reportBadMerge(JsonDeserializer<?> jsonDeserializer) {
        this.handleBadMerge(jsonDeserializer);
        return null;
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JavaType javaType, JsonToken jsonToken, String string) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = jsonParser.currentToken();
        objectArray2[1] = jsonToken;
        return MismatchedInputException.from(jsonParser, javaType, objectArray._colonConcat(String.format("Unexpected token (%s), expected %s", objectArray3), string));
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, Class<?> clazz, JsonToken jsonToken, String string) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[2];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = jsonParser.currentToken();
        objectArray2[1] = jsonToken;
        return MismatchedInputException.from(jsonParser, clazz, objectArray._colonConcat(String.format("Unexpected token (%s), expected %s", objectArray3), string));
    }

    @Deprecated
    public JsonMappingException wrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string) {
        return this.wrongTokenException(jsonParser, (JavaType)null, jsonToken, string);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ClassUtil.nameOf(clazz);
        objectArray[1] = this._quotedString(string);
        objectArray[2] = string2;
        return InvalidFormatException.from(this._parser, String.format("Cannot deserialize Map key of type %s from String %s: %s", objectArray2), string, clazz);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        DeserializationContext deserializationContext = string3;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ClassUtil.nameOf(clazz);
        objectArray[1] = ((DatabindContext)((Object)string3))._quotedString(string);
        objectArray[2] = string2;
        String string3 = String.format("Cannot deserialize value of type %s from String %s: %s", objectArray2);
        return InvalidFormatException.from(deserializationContext._parser, string3, string, clazz);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ClassUtil.nameOf(clazz);
        objectArray[1] = String.valueOf(number);
        objectArray[2] = string;
        return InvalidFormatException.from(objectArray2._parser, String.format("Cannot deserialize value of type %s from number %s: %s", objectArray2), number, clazz);
    }

    public JsonMappingException weirdNativeValueException(Object object, Class<?> clazz) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ClassUtil.nameOf(clazz);
        objectArray[1] = ClassUtil.classNameOf(object);
        return InvalidFormatException.from(objectArray2._parser, String.format("Cannot deserialize value of type %s from native value (`JsonToken.VALUE_EMBEDDED_OBJECT`) of type %s: incompatible types", objectArray2), object, clazz);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        String string;
        if (throwable == null) {
            string = "N/A";
        } else {
            string = ClassUtil.exceptionMessage(throwable);
            if (string == null) {
                string = ClassUtil.nameOf(throwable.getClass());
            }
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ClassUtil.nameOf(clazz);
        objectArray[1] = string;
        string = String.format("Cannot construct instance of %s, problem: %s", objectArray2);
        return ValueInstantiationException.from(this._parser, string, this.constructType(clazz), throwable);
    }

    public JsonMappingException instantiationException(Class<?> clazz, String string) {
        Object[] objectArray = object;
        Object[] objectArray2 = new Object[2];
        Object object = objectArray2;
        objectArray2[0] = ClassUtil.nameOf(clazz);
        objectArray2[1] = string;
        object = String.format("Cannot construct instance of %s: %s", object);
        return ValueInstantiationException.from(object._parser, (String)object, objectArray.constructType(clazz));
    }

    @Override
    public JsonMappingException invalidTypeIdException(JavaType javaType, String string, String string2) {
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = string;
        objectArray[1] = ClassUtil.getTypeDescription(javaType);
        object = String.format("Could not resolve type id '%s' as a subtype of %s", object);
        return InvalidTypeIdException.from(this._parser, this._colonConcat((String)object, string2), javaType, string);
    }

    public JsonMappingException missingTypeIdException(JavaType javaType, String string) {
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = javaType;
        object = String.format("Could not resolve subtype of %s", object);
        return InvalidTypeIdException.from(this._parser, this._colonConcat((String)object, string), javaType, null);
    }

    @Deprecated
    public JsonMappingException unknownTypeException(JavaType javaType, String string, String string2) {
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = string;
        objectArray[1] = ClassUtil.getTypeDescription(javaType);
        object = object._colonConcat(String.format("Could not resolve type id '%s' into a subtype of %s", object), string2);
        return MismatchedInputException.from(object._parser, javaType, (String)object);
    }

    @Deprecated
    public JsonMappingException endOfInputException(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        return MismatchedInputException.from(this._parser, clazz2, "Unexpected end-of-input when trying to deserialize a ".concat(clazz2.getName()));
    }

    @Deprecated
    public void reportMappingException(String string, Object ... objectArray) {
        throw JsonMappingException.from(this.getParser(), this._format(string, objectArray));
    }

    @Deprecated
    public JsonMappingException mappingException(String string) {
        return JsonMappingException.from(this.getParser(), string);
    }

    @Deprecated
    public JsonMappingException mappingException(String string, Object ... objectArray) {
        return JsonMappingException.from(this.getParser(), this._format(string, objectArray));
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> clazz) {
        return this.mappingException(clazz, this._parser.currentToken());
    }

    @Deprecated
    public JsonMappingException mappingException(Class<?> clazz, JsonToken jsonToken) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = ClassUtil.nameOf(clazz);
        objectArray[1] = jsonToken;
        return JsonMappingException.from(objectArray2._parser, String.format("Cannot deserialize instance of %s out of %s token", objectArray2));
    }

    @Deprecated
    public DateFormat getDateFormat() {
        return this._getDateFormat();
    }

    public DateFormat _getDateFormat() {
        DateFormat dateFormat = this._dateFormat;
        if (dateFormat != null) {
            return dateFormat;
        }
        this._dateFormat = (DateFormat)this._config.getDateFormat().clone();
        return this._dateFormat;
    }

    public String _shapeForToken(JsonToken jsonToken) {
        if (jsonToken != null) {
            switch (a.a[jsonToken.ordinal()]) {
                default: {
                    return "[Unavailable value]";
                }
                case 12: {
                    return "Null value";
                }
                case 11: {
                    return "String value";
                }
                case 10: {
                    return "Integer value";
                }
                case 9: {
                    return "Floating-point value";
                }
                case 8: {
                    return "Embedded Object";
                }
                case 6: 
                case 7: {
                    return "Boolean value";
                }
                case 4: 
                case 5: {
                    return "Array value";
                }
                case 1: 
                case 2: 
                case 3: 
            }
            return "Object value";
        }
        return "<end of input>";
    }
}

