/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.core.type.ResolvedType;
import com.privatefasterxml.jackson.databind.type.TypeBindings;
import com.privatefasterxml.jackson.databind.type.TypeFactory;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;

public abstract class JavaType
extends ResolvedType
implements Serializable,
Type {
    private static final long serialVersionUID = 1L;
    protected final Class<?> _class;
    protected final int _hash;
    protected final Object _valueHandler;
    protected final Object _typeHandler;
    protected final boolean _asStatic;

    public JavaType(Class<?> clazz, int n2, Object object, Object object2, boolean bl) {
        this._class = clazz;
        this._hash = clazz.getName().hashCode() + n2;
        this._valueHandler = object;
        this._typeHandler = object2;
        this._asStatic = bl;
    }

    public JavaType(JavaType javaType) {
        this._class = javaType._class;
        this._hash = javaType._hash;
        this._valueHandler = javaType._valueHandler;
        this._typeHandler = javaType._typeHandler;
        this._asStatic = javaType._asStatic;
    }

    public abstract JavaType withContentType(JavaType var1);

    public abstract JavaType withStaticTyping();

    public abstract JavaType withTypeHandler(Object var1);

    public abstract JavaType withContentTypeHandler(Object var1);

    public abstract JavaType withValueHandler(Object var1);

    public abstract JavaType withContentValueHandler(Object var1);

    public JavaType withHandlersFrom(JavaType javaType) {
        Object object = javaType.getTypeHandler();
        object = object != this._typeHandler ? this.withTypeHandler(object) : this;
        if ((javaType = javaType.getValueHandler()) != this._valueHandler) {
            object = ((JavaType)object).withValueHandler(javaType);
        }
        return object;
    }

    public abstract JavaType refine(Class<?> var1, TypeBindings var2, JavaType var3, JavaType[] var4);

    @Deprecated
    public JavaType forcedNarrowBy(Class<?> clazz) {
        if (clazz == this._class) {
            return this;
        }
        return this._narrow(clazz);
    }

    @Deprecated
    public abstract JavaType _narrow(Class<?> var1);

    @Override
    public final Class<?> getRawClass() {
        return this._class;
    }

    @Override
    public final boolean hasRawClass(Class<?> clazz) {
        return this._class == clazz;
    }

    public boolean hasContentType() {
        return true;
    }

    public final boolean isTypeOrSubTypeOf(Class<?> clazz) {
        Type type = type._class;
        return type == clazz || clazz.isAssignableFrom((Class<?>)type);
    }

    public final boolean isTypeOrSuperTypeOf(Class<?> clazz) {
        Type type = ((JavaType)type)._class;
        return type == clazz || ((Class)type).isAssignableFrom(clazz);
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    @Override
    public boolean isConcrete() {
        if ((this._class.getModifiers() & 0x600) == 0) {
            return true;
        }
        return this._class.isPrimitive();
    }

    @Override
    public boolean isThrowable() {
        return Throwable.class.isAssignableFrom(this._class);
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public final boolean isEnumType() {
        return ClassUtil.isEnumType(this._class);
    }

    public final boolean isEnumImplType() {
        return ClassUtil.isEnumType(this._class) && this._class != Enum.class;
    }

    public final boolean isRecordType() {
        return ClassUtil.isRecordType(this._class);
    }

    @Override
    public final boolean isInterface() {
        return this._class.isInterface();
    }

    @Override
    public final boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    @Override
    public final boolean isFinal() {
        return Modifier.isFinal(this._class.getModifiers());
    }

    @Override
    public abstract boolean isContainerType();

    @Override
    public boolean isCollectionLikeType() {
        return false;
    }

    @Override
    public boolean isMapLikeType() {
        return false;
    }

    public final boolean isJavaLangObject() {
        return this._class == Object.class;
    }

    public final boolean useStaticType() {
        return this._asStatic;
    }

    @Override
    public boolean hasGenericTypes() {
        return this.containedTypeCount() > 0;
    }

    @Override
    public JavaType getKeyType() {
        return null;
    }

    @Override
    public JavaType getContentType() {
        return null;
    }

    @Override
    public JavaType getReferencedType() {
        return null;
    }

    @Override
    public abstract int containedTypeCount();

    @Override
    public abstract JavaType containedType(int var1);

    @Override
    @Deprecated
    public abstract String containedTypeName(int var1);

    @Override
    @Deprecated
    public Class<?> getParameterSource() {
        return null;
    }

    public JavaType containedTypeOrUnknown(int n2) {
        if ((javaType = javaType.containedType(n2)) == null) {
            JavaType javaType = TypeFactory.unknownType();
        }
        return javaType;
    }

    public abstract TypeBindings getBindings();

    public abstract JavaType findSuperType(Class<?> var1);

    public abstract JavaType getSuperClass();

    public abstract List<JavaType> getInterfaces();

    public abstract JavaType[] findTypeParameters(Class<?> var1);

    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    public Object getContentValueHandler() {
        return null;
    }

    public Object getContentTypeHandler() {
        return null;
    }

    public boolean hasValueHandler() {
        return this._valueHandler != null;
    }

    public boolean hasHandlers() {
        return this._typeHandler != null || this._valueHandler != null;
    }

    public String getGenericSignature() {
        StringBuilder stringBuilder;
        JavaType javaType = serializable;
        Serializable serializable = stringBuilder;
        javaType.getGenericSignature(new StringBuilder(40));
        return ((StringBuilder)serializable).toString();
    }

    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    public String getErasedSignature() {
        StringBuilder stringBuilder;
        JavaType javaType = serializable;
        Serializable serializable = stringBuilder;
        javaType.getErasedSignature(new StringBuilder(40));
        return ((StringBuilder)serializable).toString();
    }

    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hash;
    }
}

