/*
 * Decompiled with CFR 0.152.
 */
package com.privatefasterxml.jackson.databind;

import com.privatefasterxml.jackson.annotation.JsonIgnore;
import com.privatefasterxml.jackson.core.JacksonException;
import com.privatefasterxml.jackson.core.JsonGenerator;
import com.privatefasterxml.jackson.core.JsonLocation;
import com.privatefasterxml.jackson.core.JsonParser;
import com.privatefasterxml.jackson.databind.DatabindException;
import com.privatefasterxml.jackson.databind.DeserializationContext;
import com.privatefasterxml.jackson.databind.SerializerProvider;
import com.privatefasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class JsonMappingException
extends DatabindException {
    private static final long serialVersionUID = 3L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<Reference> _path;
    protected transient Closeable _processor;

    @Deprecated
    public JsonMappingException(String string) {
        super(string);
    }

    @Deprecated
    public JsonMappingException(String string, Throwable throwable) {
        super(string, throwable);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public JsonMappingException(Closeable closeable, String string) {
        super(string);
        this._processor = closeable;
        if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).getTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, Throwable throwable) {
        super(string, throwable);
        this._processor = closeable;
        if (throwable instanceof JacksonException) {
            this._location = ((JacksonException)throwable).getLocation();
        } else if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).getTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
        this._processor = closeable;
    }

    public static JsonMappingException from(JsonParser jsonParser, String string) {
        return new JsonMappingException(jsonParser, string);
    }

    public static JsonMappingException from(JsonParser jsonParser, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonParser, string, throwable);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string) {
        return new JsonMappingException((Closeable)jsonGenerator, string, null);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonGenerator, string, throwable);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string) {
        return new JsonMappingException(JsonMappingException._parser(deserializationContext), string);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)JsonMappingException._parser(deserializationContext), string, throwable);
    }

    private static JsonParser _parser(DeserializationContext deserializationContext) {
        return deserializationContext == null ? null : deserializationContext.getParser();
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string) {
        return new JsonMappingException(JsonMappingException._generator(serializerProvider), string);
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)JsonMappingException._generator(serializerProvider), string, throwable);
    }

    private static JsonGenerator _generator(SerializerProvider serializerProvider) {
        return serializerProvider == null ? null : serializerProvider.getGenerator();
    }

    public static JsonMappingException fromUnexpectedIOE(IOException iOException) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = iOException.getClass().getName();
        objectArray[1] = ClassUtil.exceptionMessage(iOException);
        return new JsonMappingException(null, String.format("Unexpected IOException (of type %s): %s", objectArray2));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, String string) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, string));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, int n2) {
        return JsonMappingException.wrapWithPath(throwable, new Reference(object, n2));
    }

    public static JsonMappingException wrapWithPath(Throwable object, Reference reference) {
        if (object instanceof JsonMappingException) {
            object = (JsonMappingException)object;
        } else {
            JsonMappingException jsonMappingException;
            Object object2;
            String string = ClassUtil.exceptionMessage((Throwable)object);
            if (string == null || string.isEmpty()) {
                string = "(was " + object.getClass().getName() + ")";
            }
            Closeable closeable = null;
            if (object instanceof JacksonException && (object2 = ((JacksonException)object).getProcessor()) instanceof Closeable) {
                closeable = (Closeable)object2;
            }
            object2 = jsonMappingException;
            jsonMappingException = new JsonMappingException(closeable, string, (Throwable)object);
            object = object2;
        }
        Throwable throwable = object;
        ((JsonMappingException)throwable).prependPath(reference);
        return throwable;
    }

    public JsonMappingException withCause(Throwable throwable) {
        JsonMappingException jsonMappingException = this;
        jsonMappingException.initCause(throwable);
        return jsonMappingException;
    }

    public List<Reference> getPath() {
        Serializable serializable = serializable._path;
        if (serializable == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(serializable);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    @Override
    public void prependPath(Object object, String string) {
        Reference reference;
        JsonMappingException jsonMappingException = serializable;
        Serializable serializable = reference;
        reference = new Reference(object, string);
        jsonMappingException.prependPath((Reference)serializable);
    }

    @Override
    public void prependPath(Object object, int n2) {
        Reference reference;
        JsonMappingException jsonMappingException = serializable;
        Serializable serializable = reference;
        reference = new Reference(object, n2);
        jsonMappingException.prependPath((Reference)serializable);
    }

    public void prependPath(Reference reference) {
        if (this._path == null) {
            LinkedList linkedList;
            LinkedList linkedList2 = linkedList;
            linkedList = new LinkedList();
            this._path = linkedList2;
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(reference);
        }
    }

    @Override
    @JsonIgnore
    public Object getProcessor() {
        return this._processor;
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    public String _buildMessage() {
        JsonMappingException jsonMappingException = this;
        CharSequence charSequence = super.getMessage();
        if (jsonMappingException._path == null) {
            return charSequence;
        }
        if (charSequence == null) {
            StringBuilder stringBuilder;
            charSequence = stringBuilder;
            stringBuilder = new StringBuilder();
        } else {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder((String)charSequence);
            charSequence = stringBuilder2;
        }
        CharSequence charSequence2 = charSequence;
        ((StringBuilder)charSequence2).append(" (through reference chain: ");
        StringBuilder stringBuilder = this.getPathReference((StringBuilder)charSequence2);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    public void _appendPathDesc(StringBuilder stringBuilder) {
        LinkedList<Reference> linkedList = ((JsonMappingException)((Object)linkedList))._path;
        if (linkedList == null) {
            return;
        }
        linkedList = ((AbstractCollection)linkedList).iterator();
        while (linkedList.hasNext()) {
            stringBuilder.append(((Reference)linkedList.next()).toString());
            if (!linkedList.hasNext()) continue;
            stringBuilder.append("->");
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 2L;
        protected transient Object _from;
        protected String _fieldName;
        protected int _index;
        protected String _desc;

        public Reference() {
            this._index = -1;
        }

        public Reference(Object object) {
            this._index = -1;
            this._from = object;
        }

        public Reference(Object object, String string) {
            this._index = -1;
            this._from = object;
            if (string != null) {
                this._fieldName = string;
                return;
            }
            throw new NullPointerException("Cannot pass null fieldName");
        }

        public Reference(Object object, int n2) {
            this._from = object;
            this._index = n2;
        }

        public void setFieldName(String string) {
            this._fieldName = string;
        }

        public void setIndex(int n2) {
            this._index = n2;
        }

        public void setDescription(String string) {
            this._desc = string;
        }

        @JsonIgnore
        public Object getFrom() {
            return this._from;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public int getIndex() {
            return this._index;
        }

        public String getDescription() {
            if (this._desc == null) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder();
                Class<Object> clazz = this._from;
                if (clazz == null) {
                    stringBuilder2.append("UNKNOWN");
                } else {
                    clazz = clazz instanceof Class ? (Class)clazz : clazz.getClass();
                    int n2 = 0;
                    while (clazz.isArray()) {
                        clazz = clazz.getComponentType();
                        ++n2;
                    }
                    stringBuilder2.append(clazz.getName());
                    while ((n2 += -1) >= 0) {
                        stringBuilder2.append("[]");
                    }
                }
                stringBuilder2.append('[');
                if (this._fieldName != null) {
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder2.append('\"');
                    stringBuilder3.append(this._fieldName);
                    stringBuilder3.append('\"');
                } else {
                    int n3 = this._index;
                    if (n3 >= 0) {
                        stringBuilder2.append(n3);
                    } else {
                        stringBuilder2.append('?');
                    }
                }
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.append(']');
                this._desc = stringBuilder4.toString();
            }
            return this._desc;
        }

        public String toString() {
            return this.getDescription();
        }

        public Object writeReplace() {
            Reference reference = this;
            reference.getDescription();
            return reference;
        }
    }
}

